#!/usr/bin/perl

package eBay::API::XML::DataType::ListingEnhancementDurationReferenceType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ListingEnhancementDurationReferenceType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ListingEnhancementDurationReferenceType

=head1 DESCRIPTION

A container node for a set of durations that apply to a certain listing enhancements.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ListingEnhancementDurationReferenceType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'Duration', 'xs:token', '1', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDuration()

Specifies a length of time that a listing enhancement can be used for a listing. 
The value Lifetime means the listing enhancment occurs for the lifetime of the listing.
Instances of durations other than Lifetime can be purchased multiple times
while the listing is active.

#    Argument: reference to an array  
                      of 'xs:token'

=cut

sub setDuration {
  my $self = shift;
  $self->{'Duration'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getDuration()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: reference to an array  
                      of 'xs:token'

=cut

sub getDuration {
  my $self = shift;
  return $self->_getDataTypeArray('Duration');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
