#!/usr/bin/perl

package eBay::API::XML::Call::LeaveFeedback::LeaveFeedbackRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. LeaveFeedbackRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::LeaveFeedback::LeaveFeedbackRequestType

=head1 DESCRIPTION

Enables a user to leave feedback about another user. Both users (the
sender  and the recipient) must have a transactional relationship.
That is, they must have both been participants in a successfully
concluded item sale transaction that took place no more than 90 days
prior. Also, the sending user cannot have already left feedback for
the recipient for the transaction.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::LeaveFeedback::LeaveFeedbackRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::ItemRatingDetailArrayType;
use eBay::API::XML::DataType::UserIDType;
use eBay::API::XML::DataType::Enum::CommentTypeCodeType;


my @gaProperties = ( [ 'CommentText', 'xs:string', '', '', '' ]
	, [ 'CommentType', 'ns:CommentTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CommentTypeCodeType', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'SellerItemRatingDetailArray', 'ns:ItemRatingDetailArrayType', ''
	     ,'eBay::API::XML::DataType::ItemRatingDetailArrayType', '1' ]
	, [ 'TargetUser', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCommentText()

Textual comment that explains, clarifies, or justifies the feedback
score specified in CommentType.

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut

sub setCommentText {
  my $self = shift;
  $self->{'CommentText'} = shift
}

=head2 getCommentText()

#    Returns: 'xs:string'

=cut

sub getCommentText {
  my $self = shift;
  return $self->{'CommentText'};
}


=head2 setCommentType()

Score for the feedback being left. May be Positive, Neutral, or
Negative.
<br><br>
<span class="tablenote"><b>Note:</b>
Beginning in May 2008, sellers can no longer leave neutral or negative
feedback for buyers. Buyers can no longer leave neutral or negative feedback
within 7 days from the end of the transaction for active PowerSellers who
have been on eBay for 12 months.
</span>

  RequiredInput: Yes
  AllValuesExcept: Withdrawn, IndependentlyWithdrawn
#    Argument: 'ns:CommentTypeCodeType'

=cut

sub setCommentType {
  my $self = shift;
  $self->{'CommentType'} = shift
}

=head2 getCommentType()

#    Returns: 'ns:CommentTypeCodeType'

=cut

sub getCommentType {
  my $self = shift;
  return $self->{'CommentType'};
}


=head2 setItemID()

The ID of an item. Specify the ID for the item of
the transaction of the users. The transaction must not have been
created more than 90 days before your attempt to leave feedback.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setSellerItemRatingDetailArray()

Container for detailed seller ratings (DSRs).
If a buyer is providing DSRs, they are specified in this container.
Sellers have access to the number of ratings they've received, as well as
to the averages of the DSRs they've received in each
DSR area (i.e., to the average of ratings in the item-description area, etc.).
By March 2007, the DSR feature will be available on the United Kingdom site
and on the following other sites: AU (site ID 15), BEFR (site ID 23),
BENL (site ID 123), FR (site ID 71), IE (site ID 205), IN (site ID 203),
IT (site ID 101), and PL (site ID 212).
In Summer 2007, the DSR feature will be available on the other
API-enabled country sites, including the US site (site ID 0).

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=DetailedSellerRatings
Title: Detailed Seller Ratings

  RequiredInput: No
#    Argument: 'ns:ItemRatingDetailArrayType'

=cut

sub setSellerItemRatingDetailArray {
  my $self = shift;
  $self->{'SellerItemRatingDetailArray'} = shift
}

=head2 getSellerItemRatingDetailArray()

#    Returns: 'ns:ItemRatingDetailArrayType'

=cut

sub getSellerItemRatingDetailArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerItemRatingDetailArray'
		,'eBay::API::XML::DataType::ItemRatingDetailArrayType');
}


=head2 setTargetUser()

Specifies the recipient user about whom the feedback is being left.

  RequiredInput: Yes
#    Argument: 'ns:UserIDType'

=cut

sub setTargetUser {
  my $self = shift;
  $self->{'TargetUser'} = shift
}

=head2 getTargetUser()

#    Returns: 'ns:UserIDType'

=cut

sub getTargetUser {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TargetUser'
		,'eBay::API::XML::DataType::UserIDType');
}


=head2 setTransactionID()

The item purchase transaction from the listing specified in ItemID for
which the feedback is being left. Required if the listing identified in
ItemID was a multi-item listing (Dutch auction or multi-item fixed-price
listing).

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
