use ExtUtils::MakeMaker;

WriteMakefile(
    NAME         => 'ExtUtils::ModuleMaker',
    VERSION_FROM => 'lib/ExtUtils/ModuleMaker.pm', # finds $VERSION
#    AUTHOR       => 'R. Geoffrey Avery (modulemaker@PlatypiVentures.com)',
    AUTHOR       => 'James E Keenan (jkeenan@cpan.org)',
    ABSTRACT     => 'A simple replacement for h2xs -XA',
    EXE_FILES    => [
                        'scripts/modulemaker',
                    ],
    PREREQ_PM    => {
                        Test::More      => 0.44,
                        Getopt::Std     => 0, # in the Perl core
                        File::Basename  => 0, # in the Perl core
                        File::Path      => 0, # in the Perl core
                        File::Temp      => 0, # in the Perl core since 5.6
                    },
);


__END__

use ExtUtils::MakeMaker;

# This makefile generator is customized for testing purposes.  It
# allows us to place the scripts and all the modules into a place local
# place where they can be used as if they were really installed in a
# place in our path.

my $where = `pwd`;

if ($^O eq "MSWin32") {
    my @parts = split (/\\/, $where);
    pop (@parts);
    $where = join ('\\', @parts, 'testplace');
} else {
    my @parts = split ("/", $where);
    pop (@parts);
    $where = join ('/', @parts, 'testplace');
}

WriteMakefile(
    NAME         => 'ExtUtils::ModuleMaker',
    VERSION_FROM => 'lib/ExtUtils/ModuleMaker.pm', # finds $VERSION
    AUTHOR       => 'R. Geoffrey Avery (modulemaker@PlatypiVentures.com)',
    ABSTRACT     => 'A simple replacement for h2xs -XA',
    EXE_FILES    => [
                        'scripts/modulemaker',
                    ],
    PREREQ_PM    => {
                        Test::More      => 0.44,
                        Getopt::Std        => 0, # in the Perl core
                        Getopt::Long    => 0, # in the Perl core
                        File::Basename    => 0, # in the Perl core
                        File::Path        => 0, # in the Perl core
                    },

    (map { $_ => $where } qw (PREFIX INSTALLSITELIB INSTALLSCRIPT)),

);
