# Generated by default/object.tt
package Paws::SMS::SSMValidationParameters;
  use Moose;
  has Command => (is => 'ro', isa => 'Str', request_name => 'command', traits => ['NameInRequest']);
  has ExecutionTimeoutSeconds => (is => 'ro', isa => 'Int', request_name => 'executionTimeoutSeconds', traits => ['NameInRequest']);
  has InstanceId => (is => 'ro', isa => 'Str', request_name => 'instanceId', traits => ['NameInRequest']);
  has OutputS3BucketName => (is => 'ro', isa => 'Str', request_name => 'outputS3BucketName', traits => ['NameInRequest']);
  has ScriptType => (is => 'ro', isa => 'Str', request_name => 'scriptType', traits => ['NameInRequest']);
  has Source => (is => 'ro', isa => 'Paws::SMS::Source', request_name => 'source', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SMS::SSMValidationParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SMS::SSMValidationParameters object:

  $service_obj->Method(Att1 => { Command => $value, ..., Source => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SMS::SSMValidationParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->Command

=head1 DESCRIPTION

Contains validation parameters.

=head1 ATTRIBUTES


=head2 Command => Str

The command to run the validation script


=head2 ExecutionTimeoutSeconds => Int

The timeout interval, in seconds.


=head2 InstanceId => Str

The ID of the instance. The instance must have the following tag:
UserForSMSApplicationValidation=true.


=head2 OutputS3BucketName => Str

The name of the S3 bucket for output.


=head2 ScriptType => Str

The type of validation script.


=head2 Source => L<Paws::SMS::Source>

The location of the validation script.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

