# $Id: TestUtils.pm 4100 2009-02-25 22:20:47Z andrew $

package TestUtils;

use strict;
use vars qw(@EXPORT);

use base 'Exporter';

use File::Slurp;
use YAML::Any;

@EXPORT = qw(get_tests normalize);


sub get_tests {
    (my $testcasedir = $0) =~ s{([^/]+)\.t}{testcases/$1};
    my (@tests, $testno);

    foreach my $podfile (sort <$testcasedir/*.pod>) {
	$testno++;
	(my $basepath = $podfile) =~ s/\.pod$//;
        (my $basename = $basepath) =~ s{.*/}{};
	next unless -f "${basepath}.xml";
	my ($desc, $options);
	my $podtext = read_file($podfile);
	my $xmltext = read_file("${basepath}.xml");
	if (my $ymltext = -f "${basepath}.yml" && read_file("${basepath}.yml")) {
	    my $data = Load $ymltext;
	    $desc    = $data->{desc};
	    $options = $data->{viewoptions};
	}

        
        push @tests, PkgTest->new( { input       => $podtext,
                                     viewoptions => $options || {},
                                     expect      => $xmltext,
                                     description => $desc || $basename } );

    }

    return @tests;
}

sub normalize {
    my ($xml) = @_;
    $xml =~ s{(<!-- Generated by Pod::POM::View::DocBook) \d+\.\d+ (using Pod:::POM) \d+\.\d+ (-->)}{$1 X.XX $2 Y.YY $3};
    return $xml;
}

1;

package PkgTest;
use strict;
use base 'Class::Accessor';

__PACKAGE__->mk_accessors( qw(input viewoptions expect description) );

1;
