# Generated by default/object.tt
package Paws::MediaLive::VpcOutputSettingsDescription;
  use Moose;
  has AvailabilityZones => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'availabilityZones', traits => ['NameInRequest']);
  has NetworkInterfaceIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'networkInterfaceIds', traits => ['NameInRequest']);
  has SecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'securityGroupIds', traits => ['NameInRequest']);
  has SubnetIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'subnetIds', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::VpcOutputSettingsDescription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::VpcOutputSettingsDescription object:

  $service_obj->Method(Att1 => { AvailabilityZones => $value, ..., SubnetIds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::VpcOutputSettingsDescription object:

  $result = $service_obj->Method(...);
  $result->Att1->AvailabilityZones

=head1 DESCRIPTION

The properties for a private VPC Output

=head1 ATTRIBUTES


=head2 AvailabilityZones => ArrayRef[Str|Undef]

The Availability Zones where the vpc subnets are located. The first
Availability Zone applies to the first subnet in the list of subnets.
The second Availability Zone applies to the second subnet.


=head2 NetworkInterfaceIds => ArrayRef[Str|Undef]

A list of Elastic Network Interfaces created by MediaLive in the
customer's VPC


=head2 SecurityGroupIds => ArrayRef[Str|Undef]

A list of up EC2 VPC security group IDs attached to the Output VPC
network interfaces.


=head2 SubnetIds => ArrayRef[Str|Undef]

A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet
IDs must be mapped to two unique availability zones (AZ).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

