package Padre::Plugin::WxWidgets;

use warnings;
use strict;

our $VERSION = '0.05';

use base 'Padre::Plugin';

use Padre::Wx ();

#######
# Define Plugin Name required
#######
sub plugin_name {
	return Wx::gettext('wxWidgets Support');
}

sub padre_interfaces {
	'Padre::Plugin' => '0.91',;
}

sub menu_plugins_simple {
	my $self = shift;

	return (
		Wx::gettext('wxWidgets Support') => [
			Wx::gettext('About'), sub { $self->show_about },
		]
	);
}

sub show_about {
	my $about = Wx::AboutDialogInfo->new;
	$about->SetName("Padre::Plugin::WxWidgets");
	$about->SetDescription( Wx::gettext('wxWidgets support for Padre') );
	$about->SetVersion($Padre::Plugin::WxWidgets::VERSION);
	Wx::AboutBox($about);
	return;
}


1;
__END__

=head1 NAME

Padre::Plugin::WxWidgets - wxWidgets support for Padre

=head1 SYNOPSIS

	$>padre
	Plugins -> wxWidgets Support -> *

=head1 DESCRIPTION

This provides basic development and documentation support for wxWidgets in L<Padre>. Once installed,
Padre will be able to provide help search support for Wx classes.

=head1 wxWidgets.pod

C<wxWidgets.pod> was generated by C<private/bin/parse_wxwidgets_docs.pl>. The original wxWidgets HTML documentation
L<http://downloads.sourceforge.net/project/wxwindows/2.8.12/wxWidgets-2.8.12-HTML.zip>
is copyrighted as the following:

    Copyright (c) 1992-2006 by Julian Smart, Robert Roebling, Vadim Zeitlin
    and other members of the wxWidgets team. Portions (c) 1996 Artificial
    Intelligence Applications Institute.

    The original wxWidgets HTML documentation is licensed under:
      wxWindows Library License version 3.1, http://docs.wxwidgets.org/2.8.10/wx_wxlicense.html
      GNU Library General Public License version 2, http://docs.wxwidgets.org/2.8.10/wx_gnulicense.html
