/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.harakiri;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Observable;
import java.util.concurrent.Callable;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.control.MockCommandDispatcher;

public class HarakiriMonitor
extends Observable
implements Runnable {
    private final MockCommandDispatcher dispatcher;
    private Callable onTerminate = null;
    private BufferedReader input = null;
    private OutputStream output;
    private Thread thread;

    public HarakiriMonitor(MockCommandDispatcher dispatcher) throws IOException {
        this.dispatcher = dispatcher;
    }

    public void connect(String host, int port) throws IOException {
        if (this.input != null) {
            throw new IOException("Already have socket");
        }
        Socket sock = new Socket(host, port);
        this.input = new BufferedReader(new InputStreamReader(sock.getInputStream()));
        this.output = sock.getOutputStream();
    }

    public void start() {
        if (this.input == null) {
            throw new IllegalStateException("Not bound yet");
        }
        this.thread = new Thread((Runnable)this, "HarakiriMonitor");
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
    }

    public void setTemrinateAction(Callable action) {
        this.onTerminate = action;
    }

    @Override
    public void run() {
        boolean closed = false;
        CouchbaseMock mock = this.dispatcher.getMock();
        try {
            mock.waitForStartup();
            String http = "" + mock.getHttpPort() + '\u0000';
            this.output.write(http.getBytes());
            this.output.flush();
        }
        catch (InterruptedException ex) {
            closed = true;
        }
        catch (IOException ex) {
            closed = true;
        }
        while (!closed) {
            try {
                String packet = this.input.readLine();
                if (packet == null) {
                    closed = true;
                    continue;
                }
                String response = this.dispatcher.processInput(packet);
                this.setChanged();
                this.notifyObservers();
                if (response == null) continue;
                this.output.write((response + "\n").getBytes());
                this.output.flush();
            }
            catch (IOException e) {
                closed = true;
            }
        }
        if (this.onTerminate != null) {
            try {
                this.onTerminate.call();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

