# Generated by default/object.tt
package Paws::ServerlessRepo::ParameterValue;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has Value => (is => 'ro', isa => 'Str', request_name => 'value', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ServerlessRepo::ParameterValue

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ServerlessRepo::ParameterValue object:

  $service_obj->Method(Att1 => { Name => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ServerlessRepo::ParameterValue object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Parameter value of the application.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Name => Str

The key associated with the parameter. If you don't specify a key and
value for a particular parameter, AWS CloudFormation uses the default
value that is specified in your template.


=head2 B<REQUIRED> Value => Str

The input value associated with the parameter.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ServerlessRepo>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

