
package Paws::IoTData::ListNamedShadowsForThingResponse;
  use Moose;
  has NextToken => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'nextToken');
  has Results => (is => 'ro', isa => 'ArrayRef[Str|Undef]', traits => ['NameInRequest'], request_name => 'results');
  has Timestamp => (is => 'ro', isa => 'Int', traits => ['NameInRequest'], request_name => 'timestamp');

  has _request_id => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTData::ListNamedShadowsForThingResponse

=head1 ATTRIBUTES


=head2 NextToken => Str

The token for the next set of results, or null if there are no
additional results.


=head2 Results => ArrayRef[Str|Undef]

The list of shadows for the specified thing.


=head2 Timestamp => Int

The Epoch date and time the response was generated by AWS IoT.


=head2 _request_id => Str


=cut

