# Generated by default/object.tt
package Paws::AmplifyBackend::UpdateBackendAuthUserPoolConfig;
  use Moose;
  has ForgotPassword => (is => 'ro', isa => 'Paws::AmplifyBackend::UpdateBackendAuthForgotPasswordConfig', request_name => 'forgotPassword', traits => ['NameInRequest']);
  has Mfa => (is => 'ro', isa => 'Paws::AmplifyBackend::UpdateBackendAuthMFAConfig', request_name => 'mfa', traits => ['NameInRequest']);
  has OAuth => (is => 'ro', isa => 'Paws::AmplifyBackend::UpdateBackendAuthOAuthConfig', request_name => 'oAuth', traits => ['NameInRequest']);
  has PasswordPolicy => (is => 'ro', isa => 'Paws::AmplifyBackend::UpdateBackendAuthPasswordPolicyConfig', request_name => 'passwordPolicy', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::UpdateBackendAuthUserPoolConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::UpdateBackendAuthUserPoolConfig object:

  $service_obj->Method(Att1 => { ForgotPassword => $value, ..., PasswordPolicy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::UpdateBackendAuthUserPoolConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ForgotPassword

=head1 DESCRIPTION

Describes the Amazon Cognito user pool configuration for the
authorization resource to be configured for your Amplify project on an
update.

=head1 ATTRIBUTES


=head2 ForgotPassword => L<Paws::AmplifyBackend::UpdateBackendAuthForgotPasswordConfig>

Describes the forgot password policy for your Amazon Cognito user pool,
configured as a part of your Amplify project.


=head2 Mfa => L<Paws::AmplifyBackend::UpdateBackendAuthMFAConfig>

Describes whether multi-factor authentication policies should be
applied for your Amazon Cognito user pool configured as a part of your
Amplify project.


=head2 OAuth => L<Paws::AmplifyBackend::UpdateBackendAuthOAuthConfig>

Describes the OAuth policy and rules for your Amazon Cognito user pool,
configured as a part of your Amplify project.


=head2 PasswordPolicy => L<Paws::AmplifyBackend::UpdateBackendAuthPasswordPolicyConfig>

Describes the password policy for your Amazon Cognito user pool,
configured as a part of your Amplify project.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

