# Annotation: Demonstrates a cluster.

use strict;
use warnings;
use File::Spec;
use GraphViz2;

my $graph = GraphViz2->new(
 edge   => {color => 'grey'},
 global => {directed => 1},
 graph  => {clusterrank => 'local', compound => 1, rankdir => 'TB'},
 node   => {shape => 'oval'},
);

$graph -> push_subgraph(name => 'cluster_Europe', graph => {
  bgcolor => 'grey', label => 'Europe'
});
$graph -> add_node(name => 'London', color => 'blue');
$graph -> add_node(
  name => 'Paris', color => 'green', label => 'City of\nlurve',
);
$graph -> add_edge(from => 'London', to => 'Paris');
$graph -> add_edge(from => 'Paris', to => 'London');
$graph -> pop_subgraph;

$graph -> add_node(name => 'New York', color => 'yellow');
$graph -> add_edge(from => 'London', to => 'New York', label => 'Far');

$graph -> push_subgraph(name => 'cluster_Australia', graph => {
  bgcolor => 'grey', label => 'Australia',
});
$graph -> add_node(name => 'Victoria', color => 'blue');
$graph -> add_node(name => 'New South Wales', color => 'green');
$graph -> add_node(name => 'Tasmania', color => 'red');
$graph -> add_edge(from => 'Victoria', to => 'New South Wales');
$graph -> add_edge(from => 'Victoria', to => 'Tasmania');
$graph -> pop_subgraph;

$graph -> add_edge(
  from => 'Victoria',
  to => 'London',
  ltail => 'cluster_Australia',
  lhead => 'cluster_Europe',
);

if (@ARGV) {
  my($format)      = shift || 'svg';
  my($output_file) = shift || File::Spec -> catfile('html', "cluster.$format");
  $graph -> run(format => $format, output_file => $output_file);
} else {
  # run as a test
  require Test::More;
  require Test::Snapshot;
  Test::Snapshot::is_deeply_snapshot($graph->dot_input, 'dot file');
  Test::More::done_testing();
}
