#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util qw/is_omega_prime/;
#my $usegmp = Math::Prime::Util::prime_get_config->{'gmp'};

plan tests => 1+6+4;

my @fn7 = (10000019, 10000000, 10000005, 10000002, 10000012, 10000080, 10002930, 11741730, 223092870);
my @listo = (
  [10007,10009,10037,10039,10061,10067,10069,10079,10091,10093,10099],
  [10000,10001,10003,10006,10012,10015,10016,10018,10019,10021,10022,10025,10027,10029,10031,10033,10041,10042,10043,10046,10048,10049,10051,10053,10055,10057,10063,10071,10072,10073,10077,10078,10081,10082,10083,10084,10085,10096,10097],
  [10002,10004,10008,10011,10013,10014,10017,10023,10024,10026,10028,10034,10035,10036,10040,10044,10045,10047,10052,10054,10056,10058,10059,10060,10064,10066,10068,10075,10076,10086,10087,10088,10089,10090,10092,10094,10095,10100],
  [10005,10020,10030,10032,10038,10050,10062,10065,10070,10074,10080,10098],
  [10010],
  [],
);

{
  is_deeply( [map { is_omega_prime($_+1,$fn7[$_]) } 0..$#fn7],
             [(1) x scalar(@fn7)],
             "some omega primes correctly calculated" );
  for my $k (1..6) {
    is_deeply( [grep { is_omega_prime($k, $_) } 10000..10100],
               $listo[$k-1],
               "$k-omega primes 10000 .. 10100" );
  }

  # mpu 'say vecprod(map { random_prime(1000) } 1..18)'
  # mpu '@x=vecuniq map{random_prime(1000,5000)}1..10 until @x==10; say "@x"; say vecprod(@x)'

  is(is_omega_prime(10,"24705358214159761813058494125740243"), 1, "is_omega_prime(10,24705358214159761813058494125740243)");
  is(is_omega_prime(14,"264161530428233522652629658999365"), 1, "is_omega_prime(14,264161530428233522652629658999365)");
  # 18 factors, but one is repeated
  is(is_omega_prime(18,"32271228927564477576537111610496905348679567"), 0, "is_omega_prime(18,32271228927564477576537111610496905348679567) = 0");
  is(is_omega_prime(17,"32271228927564477576537111610496905348679567"), 1, "is_omega_prime(17,32271228927564477576537111610496905348679567)");
#  }
}
