## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::code_from_str;

our $DATE = '2024-06-10'; # DATE
our $VERSION = '0.004'; # VERSION

our $rschema = do{my$var={base=>"code",clsets_after_base=>[{description=>"\nThis schema accepts coderef or string which will be eval'ed to coderef. Note\nthat this means allowing your user to provide arbitrary Perl code for you to\nexecute! Make sure first and foremost that security-wise this is acceptable in\nyour case.\n\nBy default `eval()` is performed in the `main` namespace and without stricture\nor warnings. See the parameterized version <pm:Sah::PSchema::code_from_str> if\nyou want to customize the `eval()`.\n\nWhat's the difference between this schema and `str_or_code` (from\n<pm:Sah::Schemas::Str>)? Both this schema and `str_or_code` accept string, but\nthis schema will directly compile any input string while `str_or_code` will only\nconvert string to code if it is in the form of `sub { ... }`. In other words,\nthis schema will always produce coderef, while `str_or_code` can produce strings\nalso.\n\n",examples=>[],prefilters=>[["Code::eval",{}]],summary=>"Coderef from eval\\`ed string"}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["code"],type=>"code",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Coderef from eval\`ed string

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::code_from_str - Coderef from eval\`ed string

=head1 VERSION

This document describes version 0.004 of Sah::SchemaR::code_from_str (from Perl distribution Sah-SchemaBundle-Code), released on 2024-06-10.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::SchemaBundle during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-SchemaBundle-Code>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-SchemaBundle-Code>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-SchemaBundle-Code>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
