/*	$OpenBSD: mib.h,v 1.1.1.1 2022/09/01 14:20:34 martijn Exp $	*/

/*
 * Copyright (c) 2022 Martijn van Duren <martijn@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <agentx.h>

/* HOST-RESOURCES-MIB */
#define HOST				AGENTX_MIB2, 25
#define HRSYSTEM			HOST, 1
#define HRSTORAGE			HOST, 2
#define HRDEVICE			HOST, 3
#define HRSWRUN				HOST, 4
#define HRSWRUNPERF			HOST, 5
#define HRSWINSTALLED			HOST, 6
#define HRMIBADMININFO			HOST, 7
#define HRSYSTEMUPTIME			HRSYSTEM, 1
#define HRSYSTEMDATE			HRSYSTEM, 2
#define HRSYSTEMINITIALLOADDEVICE	HRSYSTEM, 3
#define HRSYSTEMINITIALLOADPARAMETERS	HRSYSTEM, 4
#define HRSYSTEMNUMUSERS		HRSYSTEM, 5
#define HRSYSTEMPROCESSES		HRSYSTEM, 6
#define HRSYSTEMMAXPROCESSES		HRSYSTEM, 7
#define HRSTORAGETYPES			HRSTORAGE, 1
#define HRMEMORYSIZE			HRSTORAGE, 2
#define HRSTORAGETABLE			HRSTORAGE, 3
#define HRSTORAGEENTRY			HRSTORAGETABLE, 1
#define HRSTORAGEINDEX			HRSTORAGEENTRY, 1
#define HRSTORAGETYPE			HRSTORAGEENTRY, 2
#define HRSTORAGEDESCR			HRSTORAGEENTRY, 3
#define HRSTORAGEALLOCATIONUNITS	HRSTORAGEENTRY, 4
#define HRSTORAGESIZE			HRSTORAGEENTRY, 5
#define HRSTORAGEUSED			HRSTORAGEENTRY, 6
#define HRSTORAGEALLOCATIONFAILURES	HRSTORAGEENTRY, 7
#define HRDEVICETYPES			HRDEVICE, 1
#define HRDEVICETABLE			HRDEVICE, 2
#define HRDEVICEENTRY			HRDEVICETABLE, 1
#define HRDEVICEINDEX			HRDEVICEENTRY, 1
#define HRDEVICETYPE			HRDEVICEENTRY, 2
#define HRDEVICEDESCR			HRDEVICEENTRY, 3
#define HRDEVICEID			HRDEVICEENTRY, 4
#define HRDEVICESTATUS			HRDEVICEENTRY, 5
#define HRDEVICEERRORS			HRDEVICEENTRY, 6
#define HRPROCESSORTABLE		HRDEVICE, 3
#define HRPROCESSORENTRY		HRPROCESSORTABLE, 1
#define HRPROCESSORFRWID		HRPROCESSORENTRY, 1
#define HRPROCESSORLOAD			HRPROCESSORENTRY, 2
#define HRNETWORKTABLE			HRDEVICE, 4
#define HRNETWORKENTRY			HRNETWORKTABLE, 1
#define HRNETWORKIFINDEX		HRNETWORKENTRY, 1
#define HRPRINTERTABLE			HRDEVICE, 5
#define HRPRINTERENTRY			HRPRINTERTABLE, 1
#define HRPRINTERSTATUS			HRPRINTERENTRY, 1
#define HRPRINTERDETECTEDERRORSTATE	HRPRINTERENTRY, 2
#define HRDISKSTORAGETABLE		HRDEVICE, 6
#define HRDISKSTORAGEENTRY		HRDISKSTORAGETABLE, 1
#define HRDISKSTORAGEACCESS		HRDISKSTORAGEENTRY, 1
#define HRDISKSTORAGEMEDIA		HRDISKSTORAGEENTRY, 2
#define HRDISKSTORAGEREMOVEBLE		HRDISKSTORAGEENTRY, 3
#define HRDISKSTORAGECAPACITY		HRDISKSTORAGEENTRY, 4
#define HRPARTITIONTABLE		HRDEVICE, 7
#define HRPARTITIONENTRY		HRPARTITIONTABLE, 1
#define HRPARTITIONINDEX		HRPARTITIONENTRY, 1
#define HRPARTITIONLABEL		HRPARTITIONENTRY, 2
#define HRPARTITIONID			HRPARTITIONENTRY, 3
#define HRPARTITIONSIZE			HRPARTITIONENTRY, 4
#define HRPARTITIONFSINDEX		HRPARTITIONENTRY, 5
#define HRFSTYPES			HRDEVICE, 9
#define HRFSTABLE			HRDEVICE, 8
#define HRFSENTRY			HRFSTABLE, 1
#define HRFSINDEX			HRFSENTRY, 1
#define HRFSMOUNTPOINT			HRFSENTRY, 2
#define HRFSREMOTEMOUNTPOINT		HRFSENTRY, 3
#define HRFSTYPE			HRFSENTRY, 4
#define HRFSACCESS			HRFSENTRY, 5
#define HRFSBOOTABLE			HRFSENTRY, 6
#define HRFSSTORAGEINDEX		HRFSENTRY, 7
#define HRFSLASTFULLBACKUPDATE		HRFSENTRY, 8
#define HRFSLASTPARTIALBACKUPDATE	HRFSENTRY, 9
#define HRSWOSINDEX			HRSWRUN, 1
#define HRSWRUNTABLE			HRSWRUN, 2
#define HRSWRUNENTRY			HRSWRUNTABLE, 1
#define HRSWRUNINDEX			HRSWRUNENTRY, 1
#define HRSWRUNNAME			HRSWRUNENTRY, 2
#define HRSWRUNID			HRSWRUNENTRY, 3
#define HRSWRUNPATH			HRSWRUNENTRY, 4
#define HRSWRUNPARAMETERS		HRSWRUNENTRY, 5
#define HRSWRUNTYPE			HRSWRUNENTRY, 6
#define HRSWRUNSTATUS			HRSWRUNENTRY, 7
#define HRSWRUNPERFTABLE		HRSWRUNPERF, 1
#define HRSWRUNPERFENTRY		HRSWRUNPERFTABLE, 1
#define HRSWRUNPERFCPU			HRSWRUNPERFENTRY, 1
#define HRSWRUNPERFMEM			HRSWRUNPERFENTRY, 2
#define HRSWINSTALLEDLASTCHANGE		HRSWINSTALLED, 1
#define HRSWINSTALLEDLASTUPDATETIME	HRSWINSTALLED, 2
#define HRSWINSTALLEDTABLE		HRSWINSTALLED, 3
#define HRSWINSTALLEDENTRY		HRSWINSTALLEDTABLE, 1
#define HRSWINSTALLEDINDEX		HRSWINSTALLEDENTRY, 1
#define HRSWINSTALLEDNAME		HRSWINSTALLEDENTRY, 2
#define HRSWINSTALLEDID			HRSWINSTALLEDENTRY, 3
#define HRSWINSTALLEDTYPE		HRSWINSTALLEDENTRY, 4
#define HRSWINSTALLEDDATE		HRSWINSTALLEDENTRY, 5

/* HOST-RESOURCES-TYPES */
#define HRSTORAGEOTHER			HRSTORAGETYPES, 1
#define HRSTORAGERAM			HRSTORAGETYPES, 2
#define HRSTORAGEVIRTUALMEMORY		HRSTORAGETYPES, 3
#define HRSTORAGEFIXEDDISK		HRSTORAGETYPES, 4
#define HRSTORAGEREMOVABLEDISK		HRSTORAGETYPES, 5
#define HRSTORAGEFLOPPYDISK		HRSTORAGETYPES, 6
#define HRSTORAGECOMPACTDISC		HRSTORAGETYPES, 7
#define HRSTORAGERAMDISK		HRSTORAGETYPES, 8
#define HRSTORAGEFLASHMEMORY		HRSTORAGETYPES, 9
#define HRSTORAGENETWORKDISK		HRSTORAGETYPES, 10
#define HRDEVICEOTHER			HRDEVICETYPES, 1
#define HRDEVICEUNKNOWN			HRDEVICETYPES, 2
#define HRDEVICEPROCESSOR		HRDEVICETYPES, 3
#define HRDEVICENETWORK			HRDEVICETYPES, 4
#define HRDEVICEPRINTER			HRDEVICETYPES, 5
#define HRDEVICEDISKSTORAGE		HRDEVICETYPES, 6
#define HRDEVICEVIDEO			HRDEVICETYPES, 10
#define HRDEVICEAUDIO			HRDEVICETYPES, 11
#define HRDEVICECOPROCESSOR		HRDEVICETYPES, 12
#define HRDEVICEKEYBOARD		HRDEVICETYPES, 13
#define HRDEVICEMODEM			HRDEVICETYPES, 14
#define HRDEVICEPARALLELPORT		HRDEVICETYPES, 15
#define HRDEVICEPOINTING		HRDEVICETYPES, 16
#define HRDEVICESERIALPORT		HRDEVICETYPES, 17
#define HRDEVICETAPE			HRDEVICETYPES, 18
#define HRDEVICECLOCK			HRDEVICETYPES, 19
#define HRDEVICEVOLATILEMEMORY		HRDEVICETYPES, 20
#define HRDEVICENONVOLATILEMEMORY	HRDEVICETYPES, 21
#define HRFSOTHER			HRFSTYPES, 1
#define HRFSUNKNOWN			HRFSTYPES, 2
#define HRFSBERKELEYFFS			HRFSTYPES, 3
#define HRFSSYS5FS			HRFSTYPES, 4
#define HRFSFAT				HRFSTYPES, 5
#define HRFSHPFS			HRFSTYPES, 6
#define HRFSHFS				HRFSTYPES, 7
#define HRFSMFS				HRFSTYPES, 8
#define HRFSNTFS			HRFSTYPES, 9
#define HRFSVNODE			HRFSTYPES, 10
#define HRFSJOURNALED			HRFSTYPES, 11
#define HRFSISO9660			HRFSTYPES, 12
#define HRFSROCKRIDGE			HRFSTYPES, 13
#define HRFSNFS				HRFSTYPES, 14
#define HRFSNETWARE			HRFSTYPES, 15
#define HRFSAFS				HRFSTYPES, 16
#define HRFSDFS				HRFSTYPES, 17
#define HRfSAPPLESHARE			HRFSTYPES, 18
#define HRFSRFS				HRFSTYPES, 19
#define HRFSDGCFS			HRFSTYPES, 20
#define HRFSBFS				HRFSTYPES, 21
#define HRFSFAT32			HRFSTYPES, 22
#define HRFSLINUXEXT2			HRFSTYPES, 23

/* IF-MIB */
#define IFMIB				AGENTX_MIB2, 31
#define IFMIBOBJECTS			IFMIB, 1
#define INTERFACES			AGENTX_MIB2, 2
#define IFNUMBER			INTERFACES, 1
#define IFTABLELASTCHANGE		IFMIBOBJECTS, 5
#define IFTABLE				INTERFACES, 2
#define IFENTRY				IFTABLE, 1
#define IFINDEX				IFENTRY, 1
#define IFDESCR				IFENTRY, 2
#define IFTYPE				IFENTRY, 3
#define IFMTU				IFENTRY, 4
#define IFSPEED				IFENTRY, 5
#define IFPHYSADDRESS			IFENTRY, 6
#define IFADMINSTATUS			IFENTRY, 7
#define IFOPERSTATUS			IFENTRY, 8
#define IFLASTCHANGE			IFENTRY, 9
#define IFINOCTETS			IFENTRY, 10
#define IFINUCASTPKTS			IFENTRY, 11
#define IFINNUCASTPKTS			IFENTRY, 12
#define IFINDISCARDS			IFENTRY, 13
#define IFINERRORS			IFENTRY, 14
#define IFINUNKNOWNPROTOS		IFENTRY, 15
#define IFOUTOCTETS			IFENTRY, 16
#define IFOUTUCASTPKTS			IFENTRY, 17
#define IFOUTNUCASTPKTS			IFENTRY, 18
#define IFOUTDISCARDS			IFENTRY, 19
#define IFOUTERRORS			IFENTRY, 20
#define IFOUTQLEN			IFENTRY, 21
#define IFSPECIFIC			IFENTRY, 22
#define IFXTABLE			IFMIBOBJECTS, 1
#define IFXENTRY			IFXTABLE, 1
#define IFNAME				IFXENTRY, 1
#define IFINMULTICASTPKTS		IFXENTRY, 2
#define IFINBROADCASTPKTS		IFXENTRY, 3
#define IFOUTMULTICASTPKTS		IFXENTRY, 4
#define IFOUTBROADCASTPKTS		IFXENTRY, 5
#define IFHCINOCTETS			IFXENTRY, 6
#define IFHCINUCASTPKTS			IFXENTRY, 7
#define IFHCINMULTICASTPKTS		IFXENTRY, 8
#define IFHCINBROADCASTPKTS		IFXENTRY, 9
#define IFHCOUTOCTETS			IFXENTRY, 10
#define IFHCOUTUCASTPKTS		IFXENTRY, 11
#define IFHCOUTMULTICASTPKTS		IFXENTRY, 12
#define IFHCOUTBROADCASTPKTS		IFXENTRY, 13
#define IFLINKUPDOWNTRAPENABLE		IFXENTRY, 14
#define IFHIGHSPEED			IFXENTRY, 15
#define IFPROMISCUOUSMODE		IFXENTRY, 16
#define IFCONNECTORPRESENT		IFXENTRY, 17
#define IFALIAS				IFXENTRY, 18
#define IFCOUNTERDISCONTINUITYTIME	IFXENTRY, 19
#define IFSTACKTABLE			IFMIBOBJECTS, 2
#define IFSTACKENTRY			IFSTACKTABLE, 1
#define IFSTACKHIGHERLAYER		IFSTACKENTRY, 1
#define IFSTACKLOWERLAYER		IFSTACKENTRY, 2
#define IFSTACKSTATUS			IFSTACKENTRY, 3
#define IFRCVADDRESSTABLE		IFMIBOBJECTS, 4
#define IFRCVADDRESSENTRY		IFRCVADDRESSTABLE, 1
#define IFRCVADDRESSADDRESS		IFRCVADDRESSENTRY, 1
#define IFRCVADDRESSSTATUS		IFRCVADDRESSENTRY, 2
#define IFRCVADDRESSTYPE		IFRCVADDRESSENTRY, 3
#define IFSTACKLASTCHANGE		IFMIBOBJECTS, 6

/* OPENBSD-BASE-MIB */
#define OPENBSD				AGENTX_ENTERPRISES, 30155
#define PFMIBOBJECTS			OPENBSD, 1
#define SENSORSMIBOBJECTS		OPENBSD, 2
#define RELAYDMIBOBJECTS		OPENBSD, 3
#define MEMMIBOBJECTS			OPENBSD, 5
#define CARPMIBOBJECTS			OPENBSD, 6
#define LOCALSYSTEM			OPENBSD, 23
#define OPENBSDDEFAULTOBJECTID		LOCALSYSTEM, 1
#define LOCALTEST			OPENBSD, 42

/* OPENBSD-PF-MIB */
#define PFINFO				PFMIBOBJECTS, 1
#define PFCOUNTERS			PFMIBOBJECTS, 2
#define PFSTATETABLE			PFMIBOBJECTS, 3
#define PFLOGINTERFACE			PFMIBOBJECTS, 4
#define PFSRCTRACKING			PFMIBOBJECTS, 5
#define PFLIMITS			PFMIBOBJECTS, 6
#define PFTIMEOUTS			PFMIBOBJECTS, 7
#define PFINTERFACES			PFMIBOBJECTS, 8
#define PFTABLES			PFMIBOBJECTS, 9
#define PFLABELS			PFMIBOBJECTS, 10
#define PFSYNCSTATS			PFMIBOBJECTS, 11
#define PFRUNNING			PFINFO, 1
#define PFRUNTIME			PFINFO, 2
#define PFDEBUG				PFINFO, 3
#define PFHOSTID			PFINFO, 4
#define PFCNTMATCH			PFCOUNTERS, 1
#define PFCNTBADOFFSET			PFCOUNTERS, 2
#define PFCNTFRAGMENT			PFCOUNTERS, 3
#define PFCNTSHORT			PFCOUNTERS, 4
#define PFCNTNORMALIZE			PFCOUNTERS, 5
#define PFCNTMEMORY			PFCOUNTERS, 6
#define PFCNTTIMESTAMP			PFCOUNTERS, 7
#define PFCNTCONGESTION			PFCOUNTERS, 8
#define PFCNTIPOPTION			PFCOUNTERS, 9
#define PFCNTPROTOCKSUM			PFCOUNTERS, 10
#define PFCNTSTATEMISMATCH		PFCOUNTERS, 11
#define PFCNTSTATEINSERT		PFCOUNTERS, 12
#define PFCNTSTATELIMIT			PFCOUNTERS, 13
#define PFCNTSRCLIMIT			PFCOUNTERS, 14
#define PFCNTSYNPROXY			PFCOUNTERS, 15
#define PFCNTTRANSLATE			PFCOUNTERS, 16
#define PFCNTNOROUTE			PFCOUNTERS, 17
#define PFSTATECOUNT			PFSTATETABLE, 1
#define PFSTATESEARCHES			PFSTATETABLE, 2
#define PFSTATEINSERTS			PFSTATETABLE, 3
#define PFSTATEREMOVALS			PFSTATETABLE, 4
#define PFLOGIFNAME			PFLOGINTERFACE, 1
#define PFLOGIFIPBYTESIN		PFLOGINTERFACE, 2
#define PFLOGIFIPBYTESOUT		PFLOGINTERFACE, 3
#define PFLOGIFIPPKTSINPASS		PFLOGINTERFACE, 4
#define PFLOGIFIPPKTSINDROP		PFLOGINTERFACE, 5
#define PFLOGIFIPPKTSOUTPASS		PFLOGINTERFACE, 6
#define PFLOGIFIPPKTSOUTDROP		PFLOGINTERFACE, 7
#define PFLOGIFIP6BYTESIN		PFLOGINTERFACE, 8
#define PFLOGIFIP6BYTESOUT		PFLOGINTERFACE, 9
#define PFLOGIFIP6PKTSINPASS		PFLOGINTERFACE, 10
#define PFLOGIFIP6PKTSINDROP		PFLOGINTERFACE, 11
#define PFLOGIFIP6PKTSOUTPASS		PFLOGINTERFACE, 12
#define PFLOGIFIP6PKTSOUTDROP		PFLOGINTERFACE, 13
#define PFSRCTRACKCOUNT			PFSRCTRACKING, 1
#define PFSRCTRACKSEARCHES		PFSRCTRACKING, 2
#define PFSRCTRACKINSERTS		PFSRCTRACKING, 3
#define PFSRCTRACKREMOVALS		PFSRCTRACKING, 4
#define PFLIMITSTATES			PFLIMITS, 1
#define PFLIMITSOURCENODES		PFLIMITS, 2
#define PFLIMITFRAGMENTS		PFLIMITS, 3
#define PFLIMITMAXTABLES		PFLIMITS, 4
#define PFLIMITMAXTABLEENTRIES		PFLIMITS, 5
#define PFTIMEOUTTCPFIRST		PFTIMEOUTS, 1
#define PFTIMEOUTTCPOPENING		PFTIMEOUTS, 2
#define PFTIMEOUTTCPESTABLISHED		PFTIMEOUTS, 3
#define PFTIMEOUTTCPCLOSING		PFTIMEOUTS, 4
#define PFTIMEOUTTCPFINWAIT		PFTIMEOUTS, 5
#define PFTIMEOUTTCPCLOSED		PFTIMEOUTS, 6
#define PFTIMEOUTUDPFIRST		PFTIMEOUTS, 7
#define PFTIMEOUTUDPSINGLE		PFTIMEOUTS, 8
#define PFTIMEOUTUDPMULTIPLE		PFTIMEOUTS, 9
#define PFTIMEOUTICMPFIRST		PFTIMEOUTS, 10
#define PFTIMEOUTICMPERROR		PFTIMEOUTS, 11
#define PFTIMEOUTOTHERFIRST		PFTIMEOUTS, 12
#define PFTIMEOUTOTHERSINGLE		PFTIMEOUTS, 13
#define PFTIMEOUTOTHERMULTIPLE		PFTIMEOUTS, 14
#define PFTIMEOUTFRAGMENT		PFTIMEOUTS, 15
#define PFTIMEOUTINTERVAL		PFTIMEOUTS, 16
#define PFTIMEOUTADAPTIVESTART		PFTIMEOUTS, 17
#define PFTIMEOUTADAPTIVEEND		PFTIMEOUTS, 18
#define PFTIMEOUTSRCTRACK		PFTIMEOUTS, 19
#define PFIFNUMBER			PFINTERFACES, 1
#define PFIFTABLE			PFINTERFACES, 128
#define PFIFENTRY			PFIFTABLE, 1
#define PFIFINDEX			PFIFENTRY, 1
#define PFIFDESCR			PFIFENTRY, 2
#define PFIFTYPE			PFIFENTRY, 3
#define PFIFREFS			PFIFENTRY, 4
#define PFIFRULES			PFIFENTRY, 5
#define PFIFIN4PASSPKTS			PFIFENTRY, 6
#define PFIFIN4PASSBYTES		PFIFENTRY, 7
#define PFIFIN4BLOCKPKTS		PFIFENTRY, 8
#define PFIFIN4BLOCKBYTES		PFIFENTRY, 9
#define PFIFOUT4PASSPKTS		PFIFENTRY, 10
#define PFIFOUT4PASSBYTES		PFIFENTRY, 11
#define PFIFOUT4BLOCKPKTS		PFIFENTRY, 12
#define PFIFOUT4BLOCKBYTES		PFIFENTRY, 13
#define PFIFIN6PASSPKTS			PFIFENTRY, 14
#define PFIFIN6PASSBYTES		PFIFENTRY, 15
#define PFIFIN6BLOCKPKTS		PFIFENTRY, 16
#define PFIFIN6BLOCKBYTES		PFIFENTRY, 17
#define PFIFOUT6PASSPKTS		PFIFENTRY, 18
#define PFIFOUT6PASSBYTES		PFIFENTRY, 19
#define PFIFOUT6BLOCKPKTS		PFIFENTRY, 20
#define PFIFOUT6BLOCKBYTES		PFIFENTRY, 21
#define PFTBLNUMBER			PFTABLES, 1
#define PFTBLTABLE			PFTABLES, 128
#define PFTBLENTRY			PFTBLTABLE, 1
#define PFTBLINDEX			PFTBLENTRY, 1
#define PFTBLNAME			PFTBLENTRY, 2
#define PFTBLADDRESSES			PFTBLENTRY, 3
#define PFTBLANCHORREFS			PFTBLENTRY, 4
#define PFTBLRULEREFS			PFTBLENTRY, 5
#define PFTBLEVALSMATCH			PFTBLENTRY, 6
#define PFTBLEVALSNOMATCH		PFTBLENTRY, 7
#define PFTBLINPASSPKTS			PFTBLENTRY, 8
#define PFTBLINPASSBYTES		PFTBLENTRY, 9
#define PFTBLINBLOCKPKTS		PFTBLENTRY, 10
#define PFTBLINBLOCKBYTES		PFTBLENTRY, 11
#define PFTBLINXPASSPKTS		PFTBLENTRY, 12
#define PFTBLINXPASSBYTES		PFTBLENTRY, 13
#define PFTBLOUTPASSPKTS		PFTBLENTRY, 14
#define PFTBLOUTPASSBYTES		PFTBLENTRY, 15
#define PFTBLOUTBLOCKPKTS		PFTBLENTRY, 16
#define PFTBLOUTBLOCKBYTES		PFTBLENTRY, 17
#define PFTBLOUTXPASSPKTS		PFTBLENTRY, 18
#define PFTBLOUTXPASSBYTES		PFTBLENTRY, 19
#define PFTBLSTATSCLEARED		PFTBLENTRY, 20
#define PFTBLINMATCHPKTS		PFTBLENTRY, 21
#define PFTBLINMATCHBYTES		PFTBLENTRY, 22
#define PFTBLOUTMATCHPKTS		PFTBLENTRY, 23
#define PFTBLOUTMATCHBYTES		PFTBLENTRY, 24
#define PFTBLADDRTABLE			PFTABLES, 129
#define PFTBLADDRENTRY			PFTBLADDRTABLE, 1
#define PFTBLADDRTBLINDEX		PFTBLADDRENTRY, 1
#define PFTBLADDRNET			PFTBLADDRENTRY, 2
#define PFTBLADDRMASK			PFTBLADDRENTRY, 3
#define PFTBLADDRCLEARED		PFTBLADDRENTRY, 4
#define PFTBLADDRINBLOCKPKTS		PFTBLADDRENTRY, 5
#define PFTBLADDRINBLOCKBYTES		PFTBLADDRENTRY, 6
#define PFTBLADDRINPASSPKTS		PFTBLADDRENTRY, 7
#define PFTBLADDRINPASSBYTES		PFTBLADDRENTRY, 8
#define PFTBLADDROUTBLOCKPKTS		PFTBLADDRENTRY, 9
#define PFTBLADDROUTBLOCKBYTES		PFTBLADDRENTRY, 10
#define PFTBLADDROUTPASSPKTS		PFTBLADDRENTRY, 11
#define PFTBLADDROUTPASSBYTES		PFTBLADDRENTRY, 12
#define PFTBLADDRINMATCHPKTS		PFTBLADDRENTRY, 13
#define PFTBLADDRINMATCHBYTES		PFTBLADDRENTRY, 14
#define PFTBLADDROUTMATCHPKTS		PFTBLADDRENTRY, 15
#define PFTBLADDROUTMATCHBYTES		PFTBLADDRENTRY, 16
#define PFLABELNUMBER			PFLABELS, 1
#define PFLABELTABLE			PFLABELS, 128
#define PFLABELENTRY			PFLABELTABLE, 1
#define PFLABELINDEX			PFLABELENTRY, 1
#define PFLABELNAME			PFLABELENTRY, 2
#define PFLABELEVALS			PFLABELENTRY, 3
#define PFLABELPKTS			PFLABELENTRY, 4
#define PFLABELBYTES			PFLABELENTRY, 5
#define PFLABELINPKTS			PFLABELENTRY, 6
#define PFLABELINBYTES			PFLABELENTRY, 7
#define PFLABELOUTPKTS			PFLABELENTRY, 8
#define PFLABELOUTBYTES			PFLABELENTRY, 9
#define PFLABELTOTALSTATES		PFLABELENTRY, 10
#define PFSYNCIPPKTSRECV		PFSYNCSTATS, 1
#define PFSYNCIP6PKTSRECV		PFSYNCSTATS, 2
#define PFSYNCPKTDISCARDSFORBADINTERFACE PFSYNCSTATS, 3
#define PFSYNCPKTDISCARDSFORBADTTL	PFSYNCSTATS, 4
#define PFSYNCPKTSHORTERTHANHEADER	PFSYNCSTATS, 5
#define PFSYNCPKTDISCARDSFORBADVERSION	PFSYNCSTATS, 6
#define PFSYNCPKTDISCARDSFORBADACTION	PFSYNCSTATS, 7
#define PFSYNCPKTDISCARDSFORBADLENGTH	PFSYNCSTATS, 8
#define PFSYNCPKTDISCARDSFORBADAUTH	PFSYNCSTATS, 9
#define PFSYNCPKTDISCARDSFORSTALESTATE	PFSYNCSTATS, 10
#define PFSYNCPKTDISCARDSFORBADVALUES	PFSYNCSTATS, 11
#define PFSYNCPKTDISCARDSFORBADSTATE	PFSYNCSTATS, 12
#define PFSYNCIPPKTSSENT		PFSYNCSTATS, 13
#define PFSYNCIP6PKTSSENT		PFSYNCSTATS, 14
#define PFSYNCNOMEMORY			PFSYNCSTATS, 15
#define PFSYNCOUTPUTERRORS		PFSYNCSTATS, 16

/* OPENBSD-SENSORS-MIB */
#define SENSORSMIBOBJECTS		OPENBSD, 2
#define SENSORS				SENSORSMIBOBJECTS, 1
#define SENSORNUMBER			SENSORS, 1
#define SENSORTABLE			SENSORS, 2
#define SENSORENTRY			SENSORTABLE, 1
#define SENSORINDEX			SENSORENTRY, 1
#define SENSORDESCR			SENSORENTRY, 2
#define SENSORTYPE			SENSORENTRY, 3
#define SENSORDEVICE			SENSORENTRY, 4
#define SENSORVALUE			SENSORENTRY, 5
#define SENSORUNITS			SENSORENTRY, 6
#define SENSORSTATUS			SENSORENTRY, 7

/* OPENBSD-CARP-MIB */
#define CARPSYSCTL			CARPMIBOBJECTS, 1
#define CARPIF				CARPMIBOBJECTS, 2
#define CARPSTATS			CARPMIBOBJECTS, 3
#define CARPALLOW			CARPSYSCTL, 1
#define CARPPREEMPT			CARPSYSCTL, 2
#define CARPLOG				CARPSYSCTL, 3
#define CARPIFNUMBER			CARPIF, 1
#define CARPIFTABLE			CARPIF, 2
#define CARPIFENTRY			CARPIFTABLE, 1
#define CARPIFINDEX			CARPIFENTRY, 1
#define CARPIFDESCR			CARPIFENTRY, 2
#define CARPIFVHID			CARPIFENTRY, 3
#define CARPIFDEV			CARPIFENTRY, 4
#define CARPIFADVBASE			CARPIFENTRY, 5
#define CARPIFADVSKEW			CARPIFENTRY, 6
#define CARPIFSTATE			CARPIFENTRY, 7
#define CARPGROUPTABLE			CARPMIBOBJECTS, 4
#define CARPGROUPENTRY			CARPGROUPTABLE, 1
#define CARPGROUPINDEX			CARPGROUPENTRY, 1
#define CARPGROUPNAME			CARPGROUPENTRY, 2
#define CARPGROUPDEMOTE			CARPGROUPENTRY, 3
#define CARPIPPKTSRECV			CARPSTATS, 1
#define CARPIP6PKTSRECV			CARPSTATS, 2
#define CARPPKTDISCARDSFORBADINTERFACE	CARPSTATS, 3
#define CARPPKTDISCARDSFORWRONGTTL	CARPSTATS, 4
#define CARPPKTSHORTERTHANHEADER	CARPSTATS, 5
#define CARPPKTDISCARDSFORBADCHECKSUM	CARPSTATS, 6
#define CARPPKTDISCARDSFORBADVERSION	CARPSTATS, 7
#define CARPPKTDISCARDSFORTOOSHORT	CARPSTATS, 8
#define CARPPKTDISCARDSFORBADAUTH	CARPSTATS, 9
#define CARPPKTDISCARDSFORBADVHID	CARPSTATS, 10
#define CARPPKTDISCARDSFORBADADDRESSLIST CARPSTATS, 11
#define CARPIPPKTSSENT			CARPSTATS, 12
#define CARPIP6PKTSSENT			CARPSTATS, 13
#define CARPNOMEMORY			CARPSTATS, 14
#define CARPTRANSITIONSTOMASTER		CARPSTATS, 15

/* OPENBSD-MEM-MIB */
#define MEMMIBVERSION			MEMMIBOBJECTS, 1
#define MEMIFTABLE			MEMMIBOBJECTS, 2
#define MEMIFENTRY			MEMIFTABLE, 1
#define MEMIFNAME			MEMIFENTRY, 1
#define MEMIFLIVELOCKS			MEMIFENTRY, 2

/* IP-MIB */
#define IPMIB				AGENTX_MIB2, 48
#define IP				AGENTX_MIB2, 4
#define IPFORWARDING			IP, 1
#define IPDEFAULTTTL			IP, 2
#define IPREASMTIMEOUT			IP, 13
#define IPV6IPFORWARDING		IP, 25
#define IPV6IPDEFAULTHOPLIMIT		IP, 26
#define IPV4INTERFACETABLELASTCHANGE	IP, 27
#define IPV4INTERFACETABLE		IP, 28
#define IPV4INTERFACEENTRY		IPV4INTERFACETABLE, 1
#define IPV4INTERFACEIFINDEX		IPV4INTERFACEENTRY, 1
#define IPV4INTERFACEREASMMAXSIZE	IPV4INTERFACEENTRY, 2
#define IPV4INTERFACEENABLESTATUS	IPV4INTERFACEENTRY, 3
#define IPV4INTERFACERETRANSMITTIME	IPV4INTERFACEENTRY, 4
#define IPV6INTERFACETABLELASTCHANGE	IP, 29
#define IPV6INTERFACETABLE		IP, 30
#define IPV6INTERFACEENTRY		IPV6INTERFACETABLE, 1
#define IPV6INTERFACEIFINDEX		IPV6INTERFACEENTRY, 1
#define IPV6INTERFACEREASMMAXSIZE	IPV6INTERFACEENTRY, 2
#define IPV6INTERFACEIDENTIFIER		IPV6INTERFACEENTRY, 3
#define IPV6INTERFACEENABLESTATUS	IPV6INTERFACEENTRY, 5
#define IPV6INTERFACEREACHABLETIME	IPV6INTERFACEENTRY, 6
#define IPV6INTERFACERETRANSMITTIME	IPV6INTERFACEENTRY, 7
#define IPV6INTERFACEFORWARDING		IPV6INTERFACEENTRY, 8
#define IPTRAFFICSTATS			IP, 31
#define IPSYSTEMSTATSTABLE		IPTRAFFICSTATS, 1
#define IPSYSTEMSTATSENTRY		IPSYSTEMSTATSTABLE, 1
#define IPSYSTEMSTATSIPVERSION		IPSYSTEMSTATSENTRY, 1
#define IPSYSTEMSTATSINRECEIVES		IPSYSTEMSTATSENTRY, 3
#define IPSYSTEMSTATSHCINRECEIVES	IPSYSTEMSTATSENTRY, 4
#define IPSYSTEMSTATSINOCTETS		IPSYSTEMSTATSENTRY, 5
#define IPSYSTEMSTATSHCINOCTETS		IPSYSTEMSTATSENTRY, 6
#define IPSYSTEMSTATSINHDRERRORS	IPSYSTEMSTATSENTRY, 7
#define IPSYSTEMSTATSINNOROUTES		IPSYSTEMSTATSENTRY, 8
#define IPSYSTEMSTATSINADDRERRORS	IPSYSTEMSTATSENTRY, 9
#define IPSYSTEMSTATSINUNKNOWNPROTOS	IPSYSTEMSTATSENTRY, 10
#define IPSYSTEMSTATSINTRUNCATEDPKTS	IPSYSTEMSTATSENTRY, 11
#define IPSYSTEMSTATSINFORWDATAGRAMS	IPSYSTEMSTATSENTRY, 12
#define IPSYSTEMSTATSHCINFORWDATAGRAMS	IPSYSTEMSTATSENTRY, 13
#define IPSYSTEMSTATSREASMREQDS		IPSYSTEMSTATSENTRY, 14
#define IPSYSTEMSTATSREASMOKS		IPSYSTEMSTATSENTRY, 15
#define IPSYSTEMSTATSREASMFAILS		IPSYSTEMSTATSENTRY, 16
#define IPSYSTEMSTATSINDISCARDS		IPSYSTEMSTATSENTRY, 17
#define IPSYSTEMSTATSINDELIVERS		IPSYSTEMSTATSENTRY, 18
#define IPSYSTEMSTATSHCINDELIVERS	IPSYSTEMSTATSENTRY, 19
#define IPSYSTEMSTATSOUTREQUESTS	IPSYSTEMSTATSENTRY, 20
#define IPSYSTEMSTATSHCOUTREQUESTS	IPSYSTEMSTATSENTRY, 21
#define IPSYSTEMSTATSOUTNOROUTES	IPSYSTEMSTATSENTRY, 22
#define IPSYSTEMSTATSOUTFORWDATAGRAMS	IPSYSTEMSTATSENTRY, 23
#define IPSYSTEMSTATSHCOUTfORWDATAGRAMS	IPSYSTEMSTATSENTRY, 24
#define IPSYSTEMSTATSOUTDISCARDS	IPSYSTEMSTATSENTRY, 25
#define IPSYSTEMSTATSOUTFRAGREQDS	IPSYSTEMSTATSENTRY, 26
#define IPSYSTEMSTATSOUTFRAGOKS		IPSYSTEMSTATSENTRY, 27
#define IPSYSTEMSTATSOUTFRAGFAILS	IPSYSTEMSTATSENTRY, 28
#define IPSYSTEMSTATSOUTFRAGCREATES	IPSYSTEMSTATSENTRY, 29
#define IPSYSTEMSTATSOUTTRANSMITS	IPSYSTEMSTATSENTRY, 30
#define IPSYSTEMSTATSHCOUTTRANSMITS	IPSYSTEMSTATSENTRY, 31
#define IPSYSTEMSTATSOUTOCTETS		IPSYSTEMSTATSENTRY, 32
#define IPSYSTEMSTATSHCOUTOCTETS	IPSYSTEMSTATSENTRY, 33
#define IPSYSTEMSTATSINMCASTPKTS	IPSYSTEMSTATSENTRY, 34
#define IPSYSTEMSTATSHCINMCASTPKTS	IPSYSTEMSTATSENTRY, 35
#define IPSYSTEMSTATSINMCASTOCTETS	IPSYSTEMSTATSENTRY, 36
#define IPSYSTEMSTATSHCINMCASTOCTETS	IPSYSTEMSTATSENTRY, 37
#define IPSYSTEMSTATSOUTMCASTPKTS	IPSYSTEMSTATSENTRY, 38
#define IPSYSTEMSTATSHCOUTMCASTPKTS	IPSYSTEMSTATSENTRY, 39
#define IPSYSTEMSTATSOUTMCASTOCTETS	IPSYSTEMSTATSENTRY, 40
#define IPSYSTEMSTATSHCOUTMCASTOCTETS	IPSYSTEMSTATSENTRY, 41
#define IPSYSTEMSTATSINBCASTPKTS	IPSYSTEMSTATSENTRY, 42
#define IPSYSTEMSTATSHCINBCASTPKTS	IPSYSTEMSTATSENTRY, 43
#define IPSYSTEMSTATSOUTBCASTPKTS	IPSYSTEMSTATSENTRY, 44
#define IPSYSTEMSTATSHCOUTBCASTPKTS	IPSYSTEMSTATSENTRY, 45
#define IPSYSTEMSTATSDISCONTINUITYTIME	IPSYSTEMSTATSENTRY, 46
#define IPSYSTEMSTATSREFRESHRATE	IPSYSTEMSTATSENTRY, 47
#define IPIFSTATSTABLELASTCHANGE	IPTRAFFICSTATS, 2
#define IPIFSTATSTABLE			IPTRAFFICSTATS, 3
#define IPIFSTATSENTRY			IPIFSTATSTABLE, 1
#define IPIFSTATSIPVERSION		IPIFSTATSENTRY, 1
#define IPIFSTATSIFINDEX		IPIFSTATSENTRY, 2
#define IPIFSTATSINRECEIVES		IPIFSTATSENTRY, 3
#define IPIFSTATSHCINRECEIVES		IPIFSTATSENTRY, 4
#define IPIFSTATSINOCTETS		IPIFSTATSENTRY, 5
#define IPIFSTATSHCINOCTETS		IPIFSTATSENTRY, 6
#define IPIFSTATSINHDRERRORS		IPIFSTATSENTRY, 7
#define IPIFSTATSINNOROUTES		IPIFSTATSENTRY, 8
#define IPIFSTATSINADDRERRORS		IPIFSTATSENTRY, 9
#define IPIFSTATSINUNKNOWNPROTOS	IPIFSTATSENTRY, 10
#define IPIFSTATSINTRUNCATEDPKTS	IPIFSTATSENTRY, 11
#define IPIFSTATSINFORWDATAGRAMS	IPIFSTATSENTRY, 12
#define IPIFSTATSHCINFORWDATAGRAMS	IPIFSTATSENTRY, 13
#define IPIFSTATSREASMREQDS		IPIFSTATSENTRY, 14
#define IPIFSTATSREASMOKS		IPIFSTATSENTRY, 15
#define IPIFSTATSREASMFAILS		IPIFSTATSENTRY, 16
#define IPIFSTATSINDISCARDS		IPIFSTATSENTRY, 17
#define IPIFSTATSINDELIVERS		IPIFSTATSENTRY, 18
#define IPIFSTATSHCINDELIVERS		IPIFSTATSENTRY, 19
#define IPIFSTATSOUTREQUESTS		IPIFSTATSENTRY, 20
#define IPIFSTATSHCOUTREQUESTS		IPIFSTATSENTRY, 21
#define IPIFSTATSOUTFORWDATAGRAMS	IPIFSTATSENTRY, 23
#define IPIFSTATSHCOUTFORWDATAGRAMS	IPIFSTATSENTRY, 24
#define IPIFSTATSOUTDISCARDS		IPIFSTATSENTRY, 25
#define iPIFSTATSOUTFRAGREQDS		IPIFSTATSENTRY, 26
#define IPIFSTATSOUTFRAGOKS		IPIFSTATSENTRY, 27
#define IPIFSTATSOUTFRAGFAILS		IPIFSTATSENTRY, 28
#define IPIFSTATSOUTFRAGCREATES		IPIFSTATSENTRY, 29
#define IPIFSTATSOUTTRANSMITS		IPIFSTATSENTRY, 30
#define IPIFSTATSHCOUTTRANSMITS		IPIFSTATSENTRY, 31
#define IPIFSTATSOUTOCTETS		IPIFSTATSENTRY, 32
#define IPIFSTATSHCOUTOCTETS		IPIFSTATSENTRY, 33
#define IPIFSTATSINMCASTPKTS		IPIFSTATSENTRY, 34
#define IPIFSTATSHCINMCASTPKTS		IPIFSTATSENTRY, 35
#define IPIFSTATSINMCASTOCTETS		IPIFSTATSENTRY, 36
#define IPIFSTATSHCINMCASTOCTETS	IPIFSTATSENTRY, 37
#define IPIFSTATSOUTMCASTPKTS		IPIFSTATSENTRY, 38
#define IPIFSTATSHCOUTMCASTPKTS		IPIFSTATSENTRY, 39
#define IPIFSTATSOUTMCASTOCTETS		IPIFSTATSENTRY, 40
#define IPIFSTATSHCOUTMCASTOCTETS	IPIFSTATSENTRY, 41
#define IPIFSTATSINBCASTPKTS		IPIFSTATSENTRY, 42
#define IPIFSTATSHCINBCASTPKTS		IPIFSTATSENTRY, 43
#define IPIFSTATSOUTBCASTPKTS		IPIFSTATSENTRY, 44
#define IPIFSTATSHCOUTBCASTPKTS		IPIFSTATSENTRY, 45
#define IPIFSTATSDISCONTINUITYTIME	IPIFSTATSENTRY, 46
#define IPIFSTATSREFRESHRATE		IPIFSTATSENTRY, 47
#define IPADDRESSPREFIXTABLE		IP, 32
#define IPADDRESSPREFIXENTRY		IPADDRESSPREFIXTABLE, 1
#define IPADDRESSPREFIXIFINDEX		IPADDRESSPREFIXENTRY, 1
#define IPADDRESSPREFIXTYPE		IPADDRESSPREFIXENTRY, 2
#define IPADDRESSPREFIXPREFIX		IPADDRESSPREFIXENTRY, 3
#define IPADDRESSPREFIXLENGTH		IPADDRESSPREFIXENTRY, 4
#define IPADDRESSPREFIXORIGIN		IPADDRESSPREFIXENTRY, 5
#define IPADDRESSPREFIXONLINKFLAG	IPADDRESSPREFIXENTRY, 6
#define IPADDRESSPREFIXAUTONOMOUSFLAG	IPADDRESSPREFIXENTRY, 7
#define IPADDRESSPREFIXADVPREFERREDLIFETIME IPADDRESSPREFIXENTRY, 8
#define IPADDRESSPREFIXADVVALIDLIFETIME	IPADDRESSPREFIXENTRY, 9
#define IPADDRESSSPINLOCK		IP, 33
#define IPADDRESSTABLE			IP, 34
#define IPADDRESSENTRY			IPADDRESSTABLE, 1
#define IPADDRESSADDRTYPE		IPADDRESSENTRY, 1
#define IPADDRESSADDR			IPADDRESSENTRY, 2
#define IPADDRESSIFINDEX		IPADDRESSENTRY, 3
#define IPADDRESSTYPE			IPADDRESSENTRY, 4
#define IPADDRESSPREFIX			IPADDRESSENTRY, 5
#define IPADDRESSORIGIN			IPADDRESSENTRY, 6
#define IPADDRESSSTATUS			IPADDRESSENTRY, 7
#define IPADDRESSCREATED		IPADDRESSENTRY, 8
#define IPADDRESSLASTCHANGED		IPADDRESSENTRY, 9
#define IPADDRESSROWSTATUS		IPADDRESSENTRY, 10
#define IPADDRESSSTORAGETYPE		IPADDRESSENTRY, 11
#define IPNETTOPHYSICALTABLE		IP, 35
#define IPNETTOPHYSICALENTRY		IPNETTOPHYSICALTABLE, 1
#define IPNETTOPHYSICALIFINDEX		IPNETTOPHYSICALENTRY, 1
#define IPNETTOPHYSICALNETADDRESSTYPE	IPNETTOPHYSICALENTRY, 2
#define IPNETTOPHYSICALNETADDRESS	IPNETTOPHYSICALENTRY, 3
#define IPNETTOPHYSICALPHYSADDRESS	IPNETTOPHYSICALENTRY, 4
#define IPNETTOPHYSICALLASTUPDATED	IPNETTOPHYSICALENTRY, 5
#define IPNETTOPHYSICALTYPE		IPNETTOPHYSICALENTRY, 6
#define IPNETTOPHYSICALSTATE		IPNETTOPHYSICALENTRY, 7
#define IPNETTOPHYSICALROWSTATUS	IPNETTOPHYSICALENTRY, 8
#define IPV6SCOPEZONEINDEXTABLE		IP, 36
#define IPV6SCOPEZONEINDEXENTRY		IPV6SCOPEZONEINDEXTABLE, 1
#define IPV6SCOPEZONEINDEXIFINDEX	IPV6SCOPEZONEINDEXENTRY, 1
#define IPV6SCOPEZONEINDEXLINKLOCAL	IPV6SCOPEZONEINDEXENTRY, 2
#define IPV6SCOPEZONEINDEX3		IPV6SCOPEZONEINDEXENTRY, 3
#define IPV6SCOPEZONEINDEXADMINLOCAL	IPV6SCOPEZONEINDEXENTRY, 4
#define IPV6SCOPEZONEINDEXSITELOCAL	IPV6SCOPEZONEINDEXENTRY, 5
#define IPV6SCOPEZONEINDEX6		IPV6SCOPEZONEINDEXENTRY, 6
#define IPV6SCOPEZONEINDEX7		IPV6SCOPEZONEINDEXENTRY, 7
#define IPV6SCOPEZONEINDEXORGANIZATIONLOCAL IPV6SCOPEZONEINDEXENTRY, 8
#define IPV6SCOPEZONEINDEX9		IPV6SCOPEZONEINDEXENTRY, 9
#define IPV6SCOPEZONEINDEXA		IPV6SCOPEZONEINDEXENTRY, 10
#define IPV6SCOPEZONEINDEXB		IPV6SCOPEZONEINDEXENTRY, 11
#define IPV6SCOPEZONEINDEXC		IPV6SCOPEZONEINDEXENTRY, 12
#define IPV6SCOPEZONEINDEXD		IPV6SCOPEZONEINDEXENTRY, 13
#define IPDEFAULTROUTERTABLE		IP, 37
#define IPDEFAULTROUTERENTRY		IPDEFAULTROUTERTABLE, 1
#define IPDEFAULTROUTERADDRESSTYPE	IPDEFAULTROUTERENTRY, 1
#define IPDEFAULTROUTERADDRESS		IPDEFAULTROUTERENTRY, 2
#define IPDEFAULTROUTERIFINDEX		IPDEFAULTROUTERENTRY, 3
#define IPDEFAULTROUTERLIFETIME		IPDEFAULTROUTERENTRY, 4
#define IPDEFAULTROUTERPREFERENCE	IPDEFAULTROUTERENTRY, 5
#define IPV6ROUTERADVERTSPINLOCK	IP, 38
#define IPV6ROUTERADVERTTABLE		IP, 39
#define IPV6ROUTERADVERTENTRY		IPV6ROUTERADVERTTABLE, 1
#define IPV6ROUTERADVERTIFINDEX		IPV6ROUTERADVERTENTRY, 1
#define IPV6ROUTERADVERTSENDADVERTS	IPV6ROUTERADVERTENTRY, 2
#define IPV6ROUTERADVERTMAXINTERVAL	IPV6ROUTERADVERTENTRY, 3
#define IPV6ROUTERADVERTMININTERVAL	IPV6ROUTERADVERTENTRY, 4
#define IPV6ROUTERADVERTMANAGEDFLAG	IPV6ROUTERADVERTENTRY, 5
#define IPV6ROUTERADVERTOTHERCONFIGFLAG	IPV6ROUTERADVERTENTRY, 6
#define IPV6ROUTERADVERTLINKMTU		IPV6ROUTERADVERTENTRY, 7
#define IPV6ROUTERADVERTREACHABLETIME	IPV6ROUTERADVERTENTRY, 8
#define IPV6ROUTERADVERTRETRANSMITTIME	IPV6ROUTERADVERTENTRY, 9
#define IPV6ROUTERADVERTCURHOPLIMIT	IPV6ROUTERADVERTENTRY, 10
#define IPV6ROUTERADVERTDEFAULTLIFETIME	IPV6ROUTERADVERTENTRY, 11
#define IPV6ROUTERADVERTROWSTATUS	IPV6ROUTERADVERTENTRY, 12
#define ICMP				AGENTX_MIB2, 5
#define ICMPSTATSTABLE			ICMP, 29
#define ICMPSTATSENTRY			ICMPSTATSTABLE, 1
#define ICMPSTATSIPVERSION		ICMPSTATSENTRY, 1
#define ICMPSTATSINMSGS			ICMPSTATSENTRY, 2
#define ICMPSTATSINERRORS		ICMPSTATSENTRY, 3
#define ICMPSTATSOUTMSGS		ICMPSTATSENTRY, 4
#define ICMPSTATSOUTERRORS		ICMPSTATSENTRY, 5
#define ICMPMSGSTATSTABLE		ICMP, 30
#define ICMPMSGSTATSENTRY		ICMPMSGSTATSTABLE, 1
#define ICMPMSGSTATSIPVERSION		ICMPMSGSTATSENTRY, 1
#define ICMPMSGSTATSTYPE		ICMPMSGSTATSENTRY, 2
#define ICMPMSGSTATSINPKTS		ICMPMSGSTATSENTRY, 3
#define ICMPMSGSTATSOUTPKTS		ICMPMSGSTATSENTRY, 4
#define IPINRECEIVES			IP, 3
#define IPINHDRERRORS			IP, 4
#define IPINADDRERRORS			IP, 5
#define IPFORWDATAGRAMS			IP, 6
#define IPINUNKNOWNPROTOS		IP, 7
#define IPINDISCARDS			IP, 8
#define IPINDELIVERS			IP, 9
#define IPOUTREQUESTS			IP, 10
#define IPOUTDISCARDS			IP, 11
#define IPOUTNOROUTES			IP, 12
#define IPREASMREQDS			IP, 14
#define IPREASMOKS			IP, 15
#define IPREASMFAILS			IP, 16
#define IPFRAGOKS			IP, 17
#define IPFRAGFAILS			IP, 18
#define IPFRAGCREATES			IP, 19
#define IPROUTINGDISCARDS		IP, 23
#define IPADDRTABLE			IP, 20
#define IPADDRENTRY			IPADDRTABLE, 1
#define IPADENTADDR			IPADDRENTRY, 1
#define IPADENTIFINDEX			IPADDRENTRY, 2
#define IPADENTNETMASK			IPADDRENTRY, 3
#define IPADENTBCASTADDR		IPADDRENTRY, 4
#define IPADENTREASMMAXSIZE		IPADDRENTRY, 5
#define IPNETTOMEDIATABLE		IP, 22
#define IPNETTOMEDIAENTRY		IPNETTOMEDIATABLE, 1
#define IPNETTOMEDIAIFINDEX		IPNETTOMEDIAENTRY, 1
#define IPNETTOMEDIAPHYSADDRESS		IPNETTOMEDIAENTRY, 2
#define IPNETTOMEDIANETADDRESS		IPNETTOMEDIAENTRY, 3
#define IPNETTOMEDIATYPE		IPNETTOMEDIAENTRY, 4
#define ICMPINMSGS			ICMP, 1
#define ICMPINERRORS			ICMP, 2
#define ICMPINDESTUNREACHS		ICMP, 3
#define ICMPINTIMEEXCDS			ICMP, 4
#define ICMPINPARMPROBS			ICMP, 5
#define ICMPINSRCQUENCHS		ICMP, 6
#define ICMPINREDIRECTS			ICMP, 7
#define ICMPINECHOS			ICMP, 8
#define ICMPINECHOREPS			ICMP, 9
#define ICMPINTIMESTAMPS		ICMP, 10
#define ICMPINTIMESTAMPREPS		ICMP, 11
#define ICMPINADDRMASKS			ICMP, 12
#define ICMPINADDRMASKREPS		ICMP, 13
#define ICMPOUTMSGS			ICMP, 14
#define ICMPOUTERRORS			ICMP, 15
#define ICMPOUTDESTUNREACHS		ICMP, 16
#define ICMPOUTTIMEEXCDS		ICMP, 17
#define ICMPOUTPARMPROBS		ICMP, 18
#define ICMPOUTSRCQUENCHS		ICMP, 19
#define ICMPOUTREDIRECTS		ICMP, 20
#define ICMPOUTECHOS			ICMP, 21
#define ICMPOUTECHOREPS			ICMP, 22
#define ICMPOUTTIMESTAMPS		ICMP, 23
#define ICMPOUTTIMESTAMPREPS		ICMP, 24
#define ICMPOUTADDRMASKS		ICMP, 25
#define ICMPOUTADDRMASKREPS		ICMP, 26

/* IP-FORWARD-MIB */
#define IPFORWARD			IP, 24
#define INETCIDRROUTENUMBER		IPFORWARD, 6
#define INETCIDRROUTEDISCARDS		IPFORWARD, 8
#define INETCIDRROUTETABLE		IPFORWARD, 7
#define INETCIDRROUTEENTRY		INETCIDRROUTETABLE, 1
#define INETCIDRROUTEDESTTYPE		INETCIDRROUTEENTRY, 1
#define INETCIDRROUTEDEST		INETCIDRROUTEENTRY, 2
#define INETCIDRROUTEPFXLEN		INETCIDRROUTEENTRY, 3
#define INETCIDRROUTEPOLICY		INETCIDRROUTEENTRY, 4
#define INETCIDRROUTENEXTHOPTYPE	INETCIDRROUTEENTRY, 5
#define INETCIDRROUTENEXTHOP		INETCIDRROUTEENTRY, 6
#define INETCIDRROUTEIFINDEX		INETCIDRROUTEENTRY, 7
#define INETCIDRROUTETYPE		INETCIDRROUTEENTRY, 8
#define INETCIDRROUTEPROTO		INETCIDRROUTEENTRY, 9
#define INETCIDRROUTEAGE		INETCIDRROUTEENTRY, 10
#define INETCIDRROUTENEXTHOPAS		INETCIDRROUTEENTRY, 11
#define INETCIDRROUTEMETRIC1		INETCIDRROUTEENTRY, 12
#define INETCIDRROUTEMETRIC2		INETCIDRROUTEENTRY, 13
#define INETCIDRROUTEMETRIC3		INETCIDRROUTEENTRY, 14
#define INETCIDRROUTEMETRIC4		INETCIDRROUTEENTRY, 15
#define INETCIDRROUTEMETRIC5		INETCIDRROUTEENTRY, 16
#define INETCIDRROUTESTATUS		INETCIDRROUTEENTRY, 17
/* Deprecated */
#define IPCIDRROUTENUMBER		IPFORWARD, 3
#define IPCIDRROUTETABLE		IPFORWARD, 4
#define IPCIDRROUTEENTRY		IPCIDRROUTETABLE, 1
#define IPCIDRROUTEDEST			IPCIDRROUTEENTRY, 1
#define IPCIDRROUTEMASK			IPCIDRROUTEENTRY, 2
#define IPCIDRROUTETOS			IPCIDRROUTEENTRY, 3
#define IPCIDRROUTENEXTHOP		IPCIDRROUTEENTRY, 4
#define IPCIDRROUTEIFINDEX		IPCIDRROUTEENTRY, 5
#define IPCIDRROUTETYPE			IPCIDRROUTEENTRY, 6
#define IPCIDRROUTEPROTO		IPCIDRROUTEENTRY, 7
#define IPCIDRROUTEAGE			IPCIDRROUTEENTRY, 8
#define IPCIDRROUTEINFO			IPCIDRROUTEENTRY, 9
#define IPCIDRROUTENEXTHOPAS		IPCIDRROUTEENTRY, 10
#define IPCIDRROUTEMETRIC1		IPCIDRROUTEENTRY, 11
#define IPCIDRROUTEMETRIC2		IPCIDRROUTEENTRY, 12
#define IPCIDRROUTEMETRIC3		IPCIDRROUTEENTRY, 13
#define IPCIDRROUTEMETRIC4		IPCIDRROUTEENTRY, 14
#define IPCIDRROUTEMETRIC5		IPCIDRROUTEENTRY, 15
#define IPCIDRROUTESTATUS		IPCIDRROUTEENTRY, 16
/* Obsolete */
#define IPFORWARDNUMBER			IPFORWARD, 1
#define IPFORWARDTABLE			IPFORWARD, 2
#define IPFORWARDENTRY			IPFORWARDTABLE, 1
#define IPFORWARDDEST			IPFORWARDENTRY, 1
#define IPFORWARDMASK			IPFORWARDENTRY, 2
#define IPFORWARDPOLICY			IPFORWARDENTRY, 3
#define IPFORWARDNEXTHOP		IPFORWARDENTRY, 4
#define IPFORWARDIFINDEX		IPFORWARDENTRY, 5
#define IPFORWARDTYPE			IPFORWARDENTRY, 6
#define IPFORWARDPROTO			IPFORWARDENTRY, 7
#define IPFORWARDAGE			IPFORWARDENTRY, 8
#define IPFORWARDINFO			IPFORWARDENTRY, 9
#define IPFORWARDNEXTHOPAS		IPFORWARDENTRY, 10
#define IPFORWARDMETRIC1		IPFORWARDENTRY, 11
#define IPFORWARDMETRIC2		IPFORWARDENTRY, 12
#define IPFORWARDMETRIC3		IPFORWARDENTRY, 13
#define IPFORWARDMETRIC4		IPFORWARDENTRY, 13
#define IPFORWARDMETRIC5		IPFORWARDENTRY, 13

/* UCD-SNMP-MIB */
#define UCDAVIS				AGENTX_ENTERPRISES, 2021
#define UCDEXPERIMENTAL			UCDAVIS, 13

/* UCD-DISKIO-MIB */
#define UCDDISKIOMIB			UCDEXPERIMENTAL, 15
#define DISKIOTABLE			UCDDISKIOMIB, 1
#define DISKIOENTRY			DISKIOTABLE, 1
#define DISKIOINDEX			DISKIOENTRY, 1
#define DISKIODEVICE			DISKIOENTRY, 2
#define DISKIONREAD			DISKIOENTRY, 3
#define DISKIONWRITTEN			DISKIOENTRY, 4
#define DISKIOREADS			DISKIOENTRY, 5
#define DISKIOWRITES			DISKIOENTRY, 6
#define DISKIOLA1			DISKIOENTRY, 9
#define DISKIOLA5			DISKIOENTRY, 10
#define DISKIOLA15			DISKIOENTRY, 11
#define DISKIONREADX			DISKIOENTRY, 12
#define DISKIONWRITTENX			DISKIOENTRY, 13
#define DISKIOBUSYTIME			DISKIOENTRY, 14

/* BRIDGE-MIB */
#define DOT1DBRIDGE			AGENTX_MIB2, 17
#define DOT1DNOTIFICATIONS		DOT1DBRIDGE, 0
#define DOT1DBASE			DOT1DBRIDGE, 1
#define DOT1DSTP			DOT1DBRIDGE, 2
#define DOT1DSR				DOT1DBRIDGE, 3
#define DOT1DTP				DOT1DBRIDGE, 4
#define DOT1DSTATIC			DOT1DBRIDGE, 5
#define DOT1DBASEBRIDGEADDRESS		DOT1DBASE, 1
#define DOT1DBASENUMPORTS		DOT1DBASE, 2
#define DOT1DBASETYPE			DOT1DBASE, 3
#define DOT1DBASEPORTTABLE		DOT1DBASE, 4
#define DOT1DBASEPORTENTRY		DOT1DBASEPORTTABLE, 1
#define DOT1DBASEPORT			DOT1DBASEPORTENTRY, 1
#define DOT1DBASEPORTIFINDEX		DOT1DBASEPORTENTRY, 2
#define DOT1DBASEPORTCIRCUIT		DOT1DBASEPORTENTRY, 3
#define DOT1DBASEPORTDELAYEXCEEDEDDISCARDS DOT1DBASEPORTENTRY, 4
#define DOT1DBASEPORTMTUEXCEEDEDDISCARDS DOT1DBASEPORTENTRY, 5
#define DOT1DSTPPROTOCOLSPECIFICATION	DOT1DSTP, 1
#define DOT1DSTPPRIORITY		DOT1DSTP, 2
#define DOT1DSTPTIMESINCETOPOLOGYCHANGE	DOT1DSTP, 3
#define DOT1DSTPTOPCHANGES		DOT1DSTP, 4
#define DOT1DSTPDESIGNATEDROOT		DOT1DSTP, 5
#define DOT1DSTPROOTCOST		DOT1DSTP, 6
#define DOT1DSTPROOTPORT		DOT1DSTP, 7
#define DOT1DSTPMAXAGE			DOT1DSTP, 8
#define DOT1DSTPHELLOTIME		DOT1DSTP, 9
#define DOT1DSTPHOLDTIME		DOT1DSTP, 10
#define DOT1DSTPFORWARDDELAY		DOT1DSTP, 11
#define DOT1DSTPBRIDGEMAXAGE		DOT1DSTP, 12
#define DOT1DSTPBRIDGEHELLOTIME		DOT1DSTP, 13
#define DOT1DSTPBRIDGEFORWARDDELAY	DOT1DSTP, 14
#define DOT1DSTPPORTTABLE		DOT1DSTP, 15
#define DOT1DSTPPORTENTRY		DOT1DSTPPORTTABLE, 1
#define DOT1DSTPPORT			DOT1DSTPPORTENTRY, 1
#define DOT1DSTPPORTPRIORITY		DOT1DSTPPORTENTRY, 2
#define DOT1DSTPPORTSTATE		DOT1DSTPPORTENTRY, 3
#define DOT1DSTPPORTENABLE		DOT1DSTPPORTENTRY, 4
#define DOT1DSTPPORTPATHCOST		DOT1DSTPPORTENTRY, 5
#define DOT1DSTPPORTDESIGNATEDROOT	DOT1DSTPPORTENTRY, 6
#define DOT1DSTPPORTDESIGNATEDCOST	DOT1DSTPPORTENTRY, 7
#define DOT1DSTPPORTDESIGNATEDBRIDGE	DOT1DSTPPORTENTRY, 8
#define DOT1DSTPPORTDESIGNATEDPORT	DOT1DSTPPORTENTRY, 9
#define DOT1DSTPPORTFORWARDTRANSITIONS	DOT1DSTPPORTENTRY, 10
#define DOT1DSTPPORTPATHCOST32		DOT1DSTPPORTENTRY, 11
#define DOT1DTPLEARNEDENTRYDISCARDS	DOT1DTP, 1
#define DOT1DTPAGINGTIME		DOT1DTP, 2
#define DOT1DTPFDBTABLE			DOT1DTP, 3
#define DOT1DTPFDBENTRY			DOT1DTPFDBTABLE, 1
#define DOT1DTPFDBADDRESS		DOT1DTPFDBENTRY, 1
#define DOT1DTPFDBPORT			DOT1DTPFDBENTRY, 2
#define DOT1DTPFDBSTATUS		DOT1DTPFDBENTRY, 3
#define DOT1DTPPORTTABLE		DOT1DTP, 4
#define DOT1DTPPORTENTRY		DOT1DTPPORTTABLE, 1
#define DOT1DTPPORT			DOT1DTPPORTENTRY, 1
#define DOT1DTPPORTMAXINFO		DOT1DTPPORTENTRY, 2
#define DOT1DTPPORTINFRAMES		DOT1DTPPORTENTRY, 3
#define DOT1DTPPORTOUTFRAMES		DOT1DTPPORTENTRY, 4
#define DOT1DTPPORTINDISCARDS		DOT1DTPPORTENTRY, 5
#define DOT1DSTATICTABLE		DOT1DSTATIC, 1
#define DOT1DSTATICENTRY		DOT1DSTATICTABLE, 1
#define DOT1DSTATICADDRESS		DOT1DSTATICENTRY, 1
#define DOT1DSTATICRECEIVEPORT		DOT1DSTATICENTRY, 2
#define DOT1DSTATICALLOWEDTOGOTO	DOT1DSTATICENTRY, 3
#define DOT1DSTATICSTATUS		DOT1DSTATICENTRY, 4
#define NEWROOT				DOT1DNOTIFICATIONS, 1
#define TOPOLOGYCHANGE			DOT1DNOTIFICATIONS, 2
