/* $NetBSD: linux_syscalls.c,v 1.13 2024/09/28 19:36:19 christos Exp $ */

/*
 * System call names.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.14 2024/09/28 19:35:55 christos Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: linux_syscalls.c,v 1.13 2024/09/28 19:36:19 christos Exp $");

#if defined(_KERNEL_OPT)
#if defined(_KERNEL_OPT)
#include "opt_sysv.h"
#include "opt_compat_43.h"
#include "opt_compat_netbsd.h"
#endif
#include <sys/param.h>
#include <sys/poll.h>
#include <sys/systm.h>
#include <sys/signal.h>
#include <sys/mount.h>
#include <sys/syscallargs.h>
#include <sys/time.h>
#include <compat/sys/time.h>
#include <compat/linux/common/linux_types.h>
#include <compat/linux/common/linux_ipc.h>
#include <compat/linux/common/linux_machdep.h>
#include <compat/linux/common/linux_misc.h>
#include <compat/linux/common/linux_mmap.h>
#include <compat/linux/common/linux_msg.h>
#include <compat/linux/common/linux_sched.h>
#include <compat/linux/common/linux_sem.h>
#include <compat/linux/common/linux_shm.h>
#include <compat/linux/common/linux_siginfo.h>
#include <compat/linux/common/linux_signal.h>
#include <compat/linux/common/linux_mqueue.h>
#include <compat/linux/linux_syscallargs.h>
#else /* _KERNEL_OPT */
#include <sys/null.h>
#endif /* _KERNEL_OPT */

const char *const linux_syscallnames[] = {
	/*   0 */	"#0 (unimplemented io_setup)",
	/*   1 */	"#1 (unimplemented io_destroy)",
	/*   2 */	"#2 (unimplemented io_submit)",
	/*   3 */	"#3 (unimplemented io_cancel)",
	/*   4 */	"#4 (unimplemented io_getevents)",
	/*   5 */	"setxattr",
	/*   6 */	"lsetxattr",
	/*   7 */	"fsetxattr",
	/*   8 */	"getxattr",
	/*   9 */	"lgetxattr",
	/*  10 */	"fgetxattr",
	/*  11 */	"listxattr",
	/*  12 */	"llistxattr",
	/*  13 */	"flistxattr",
	/*  14 */	"removexattr",
	/*  15 */	"lremovexattr",
	/*  16 */	"fremovexattr",
	/*  17 */	"__getcwd",
	/*  18 */	"#18 (unimplemented lookup_dcookie)",
	/*  19 */	"eventfd2",
	/*  20 */	"epoll_create1",
	/*  21 */	"epoll_ctl",
	/*  22 */	"epoll_pwait",
	/*  23 */	"dup",
	/*  24 */	"dup3",
	/*  25 */	"fcntl",
	/*  26 */	"inotify_init1",
	/*  27 */	"inotify_add_watch",
	/*  28 */	"inotify_rm_watch",
	/*  29 */	"ioctl",
	/*  30 */	"#30 (unimplemented ioprio_set)",
	/*  31 */	"#31 (unimplemented ioprio_get)",
	/*  32 */	"flock",
	/*  33 */	"mknodat",
	/*  34 */	"mkdirat",
	/*  35 */	"unlinkat",
	/*  36 */	"symlinkat",
	/*  37 */	"linkat",
	/*  38 */	"renameat",
	/*  39 */	"#39 (unimplemented umount2)",
	/*  40 */	"#40 (unimplemented mount)",
	/*  41 */	"#41 (unimplemented pivot_root)",
	/*  42 */	"#42 (unimplemented nfsservctl)",
	/*  43 */	"statfs",
	/*  44 */	"fstatfs",
	/*  45 */	"truncate64",
	/*  46 */	"ftruncate64",
	/*  47 */	"fallocate",
	/*  48 */	"faccessat",
	/*  49 */	"chdir",
	/*  50 */	"fchdir",
	/*  51 */	"chroot",
	/*  52 */	"fchmod",
	/*  53 */	"fchmodat",
	/*  54 */	"fchownat",
	/*  55 */	"__posix_fchown",
	/*  56 */	"openat",
	/*  57 */	"close",
	/*  58 */	"#58 (unimplemented vhangup)",
	/*  59 */	"pipe2",
	/*  60 */	"#60 (unimplemented quotactl)",
	/*  61 */	"getdents64",
	/*  62 */	"lseek",
	/*  63 */	"read",
	/*  64 */	"write",
	/*  65 */	"readv",
	/*  66 */	"writev",
	/*  67 */	"pread",
	/*  68 */	"pwrite",
	/*  69 */	"preadv",
	/*  70 */	"pwritev",
	/*  71 */	"#71 (unimplemented sendfile)",
	/*  72 */	"pselect6",
	/*  73 */	"ppoll",
	/*  74 */	"#74 (unimplemented signalfd4)",
	/*  75 */	"#75 (unimplemented vmsplice)",
	/*  76 */	"#76 (unimplemented splice)",
	/*  77 */	"#77 (unimplemented tee)",
	/*  78 */	"readlinkat",
	/*  79 */	"fstatat64",
	/*  80 */	"fstat64",
	/*  81 */	"sync",
	/*  82 */	"fsync",
	/*  83 */	"fdatasync",
	/*  84 */	"sync_file_range",
	/*  85 */	"timerfd_create",
	/*  86 */	"timerfd_settime",
	/*  87 */	"timerfd_gettime",
	/*  88 */	"utimensat",
	/*  89 */	"acct",
	/*  90 */	"#90 (unimplemented capget)",
	/*  91 */	"#91 (unimplemented capset)",
	/*  92 */	"personality",
	/*  93 */	"exit",
	/*  94 */	"exit_group",
	/*  95 */	"waitid",
	/*  96 */	"set_tid_address",
	/*  97 */	"#97 (unimplemented unshare)",
	/*  98 */	"futex",
	/*  99 */	"__futex_set_robust_list",
	/* 100 */	"__futex_get_robust_list",
	/* 101 */	"nanosleep",
	/* 102 */	"getitimer",
	/* 103 */	"setitimer",
	/* 104 */	"#104 (unimplemented kexec_load)",
	/* 105 */	"#105 (unimplemented init_module)",
	/* 106 */	"#106 (unimplemented delete_module)",
	/* 107 */	"timer_create",
	/* 108 */	"timer_gettime",
	/* 109 */	"timer_getoverrun",
	/* 110 */	"timer_settime",
	/* 111 */	"timer_delete",
	/* 112 */	"clock_settime",
	/* 113 */	"clock_gettime",
	/* 114 */	"clock_getres",
	/* 115 */	"clock_nanosleep",
	/* 116 */	"#116 (unimplemented syslog)",
	/* 117 */	"ptrace",
	/* 118 */	"sched_setparam",
	/* 119 */	"sched_setscheduler",
	/* 120 */	"sched_getscheduler",
	/* 121 */	"sched_getparam",
	/* 122 */	"sched_setaffinity",
	/* 123 */	"sched_getaffinity",
	/* 124 */	"sched_yield",
	/* 125 */	"sched_get_priority_max",
	/* 126 */	"sched_get_priority_min",
	/* 127 */	"#127 (unimplemented sys_sched_rr_get_interval)",
	/* 128 */	"#128 (unimplemented restart_syscall)",
	/* 129 */	"kill",
	/* 130 */	"tkill",
	/* 131 */	"tgkill",
	/* 132 */	"sigaltstack",
	/* 133 */	"rt_sigsuspend",
	/* 134 */	"rt_sigaction",
	/* 135 */	"rt_sigprocmask",
	/* 136 */	"rt_sigpending",
	/* 137 */	"rt_sigtimedwait",
	/* 138 */	"#138 (unimplemented rt_sigqueueinfo)",
	/* 139 */	"rt_sigreturn",
	/* 140 */	"setpriority",
	/* 141 */	"getpriority",
	/* 142 */	"reboot",
	/* 143 */	"setregid",
	/* 144 */	"setgid",
	/* 145 */	"setreuid",
	/* 146 */	"setuid",
	/* 147 */	"setresuid",
	/* 148 */	"getresuid",
	/* 149 */	"setresgid",
	/* 150 */	"getresgid",
	/* 151 */	"setfsuid",
	/* 152 */	"setfsgid",
	/* 153 */	"times",
	/* 154 */	"setpgid",
	/* 155 */	"getpgid",
	/* 156 */	"getsid",
	/* 157 */	"setsid",
	/* 158 */	"getgroups",
	/* 159 */	"setgroups",
	/* 160 */	"uname",
	/* 161 */	"sethostname",
	/* 162 */	"setdomainname",
	/* 163 */	"getrlimit",
	/* 164 */	"setrlimit",
	/* 165 */	"getrusage",
	/* 166 */	"umask",
	/* 167 */	"#167 (unimplemented prctl)",
	/* 168 */	"getcpu",
	/* 169 */	"gettimeofday",
	/* 170 */	"settimeofday",
	/* 171 */	"#171 (unimplemented adjtimex)",
	/* 172 */	"getpid",
	/* 173 */	"getppid",
	/* 174 */	"getuid",
	/* 175 */	"geteuid",
	/* 176 */	"getgid",
	/* 177 */	"getegid",
	/* 178 */	"gettid",
	/* 179 */	"sysinfo",
	/* 180 */	"mq_open",
	/* 181 */	"mq_unlink",
	/* 182 */	"mq_timedsend",
	/* 183 */	"mq_timedreceive",
	/* 184 */	"mq_notify",
	/* 185 */	"mq_getsetattr",
#ifdef SYSVMSG
	/* 186 */	"msgget",
	/* 187 */	"msgctl",
	/* 188 */	"msgrcv",
	/* 189 */	"msgsnd",
#else
	/* 186 */	"#186 (unimplemented msgget)",
	/* 187 */	"#187 (unimplemented msgctl)",
	/* 188 */	"#188 (unimplemented msgrcv)",
	/* 189 */	"#189 (unimplemented msgsnd)",
#endif
#ifdef SYSVSEM
	/* 190 */	"semget",
	/* 191 */	"semctl",
	/* 192 */	"#192 (unimplemented semtimedop)",
	/* 193 */	"semop",
#else
	/* 190 */	"#190 (unimplemented semget)",
	/* 191 */	"#191 (unimplemented semctl)",
	/* 192 */	"#192 (unimplemented semtimedop)",
	/* 193 */	"#193 (unimplemented semop)",
#endif
#ifdef SYSVSEM
	/* 194 */	"shmget",
	/* 195 */	"shmctl",
	/* 196 */	"shmat",
	/* 197 */	"shmdt",
#else
	/* 194 */	"#194 (unimplemented shmget)",
	/* 195 */	"#195 (unimplemented shmctl)",
	/* 196 */	"#196 (unimplemented shmat)",
	/* 197 */	"#197 (unimplemented shmdt)",
#endif
	/* 198 */	"socket",
	/* 199 */	"socketpair",
	/* 200 */	"bind",
	/* 201 */	"listen",
	/* 202 */	"oaccept",
	/* 203 */	"connect",
	/* 204 */	"getsockname",
	/* 205 */	"getpeername",
	/* 206 */	"sendto",
	/* 207 */	"recvfrom",
	/* 208 */	"setsockopt",
	/* 209 */	"getsockopt",
	/* 210 */	"shutdown",
	/* 211 */	"sendmsg",
	/* 212 */	"recvmsg",
	/* 213 */	"readahead",
	/* 214 */	"brk",
	/* 215 */	"munmap",
	/* 216 */	"mremap",
	/* 217 */	"#217 (unimplemented add_key)",
	/* 218 */	"#218 (unimplemented request_key)",
	/* 219 */	"#219 (unimplemented keyctl)",
	/* 220 */	"clone",
	/* 221 */	"execve",
	/* 222 */	"mmap",
	/* 223 */	"fadvise64",
	/* 224 */	"swapon",
	/* 225 */	"swapoff",
	/* 226 */	"mprotect",
	/* 227 */	"__msync13",
	/* 228 */	"mlock",
	/* 229 */	"munlock",
	/* 230 */	"mlockall",
	/* 231 */	"munlockall",
	/* 232 */	"mincore",
	/* 233 */	"madvise",
	/* 234 */	"#234 (unimplemented remap_file_pages)",
	/* 235 */	"#235 (unimplemented mbind)",
	/* 236 */	"#236 (unimplemented get_mempolicy)",
	/* 237 */	"#237 (unimplemented set_mempolicy)",
	/* 238 */	"#238 (unimplemented migrate_pages)",
	/* 239 */	"#239 (unimplemented move_pages)",
	/* 240 */	"#240 (unimplemented rt_tgsigqueueinfo)",
	/* 241 */	"#241 (unimplemented perf_event_open)",
	/* 242 */	"accept4",
	/* 243 */	"recvmmsg",
	/* 244 */	"#244 (unimplemented arch_specific_syscall)",
	/* 245 */	"#245 (unimplemented)",
	/* 246 */	"#246 (unimplemented)",
	/* 247 */	"#247 (unimplemented)",
	/* 248 */	"#248 (unimplemented)",
	/* 249 */	"#249 (unimplemented)",
	/* 250 */	"#250 (unimplemented)",
	/* 251 */	"#251 (unimplemented)",
	/* 252 */	"#252 (unimplemented)",
	/* 253 */	"#253 (unimplemented)",
	/* 254 */	"#254 (unimplemented)",
	/* 255 */	"#255 (unimplemented)",
	/* 256 */	"#256 (unimplemented)",
	/* 257 */	"#257 (unimplemented)",
	/* 258 */	"#258 (unimplemented)",
	/* 259 */	"#259 (unimplemented)",
	/* 260 */	"wait4",
	/* 261 */	"prlimit64",
	/* 262 */	"#262 (unimplemented fanotify_init)",
	/* 263 */	"#263 (unimplemented fanotify_mark)",
	/* 264 */	"#264 (unimplemented name_to_handle_at)",
	/* 265 */	"#265 (unimplemented open_by_handle_at)",
	/* 266 */	"#266 (unimplemented clock_adjtime)",
	/* 267 */	"syncfs",
	/* 268 */	"#268 (unimplemented setns)",
	/* 269 */	"sendmmsg",
	/* 270 */	"#270 (unimplemented process_vm_readv)",
	/* 271 */	"#271 (unimplemented process_vm_writev)",
	/* 272 */	"#272 (unimplemented kcmp)",
	/* 273 */	"#273 (unimplemented finit_module)",
	/* 274 */	"#274 (unimplemented sched_setattr)",
	/* 275 */	"#275 (unimplemented sched_getattr)",
	/* 276 */	"renameat2",
	/* 277 */	"#277 (unimplemented seccomp)",
	/* 278 */	"getrandom",
	/* 279 */	"memfd_create",
	/* 280 */	"#280 (unimplemented bpf)",
	/* 281 */	"#281 (unimplemented execveat)",
	/* 282 */	"#282 (unimplemented userfaultfd)",
	/* 283 */	"#283 (unimplemented membarrier)",
	/* 284 */	"#284 (unimplemented mlock2)",
	/* 285 */	"copy_file_range",
	/* 286 */	"#286 (unimplemented preadv2)",
	/* 287 */	"#287 (unimplemented pwritev2)",
	/* 288 */	"#288 (unimplemented pkey_mprotect)",
	/* 289 */	"#289 (unimplemented pkey_alloc)",
	/* 290 */	"#290 (unimplemented pkey_free)",
	/* 291 */	"statx",
	/* 292 */	"#292 (unimplemented io_pgetevents)",
	/* 293 */	"#293 (unimplemented rseq)",
	/* 294 */	"#294 (unimplemented kexec_file_load)",
	/* 295 */	"#295 (unimplemented)",
	/* 296 */	"#296 (unimplemented)",
	/* 297 */	"#297 (unimplemented)",
	/* 298 */	"#298 (unimplemented)",
	/* 299 */	"#299 (unimplemented)",
	/* 300 */	"#300 (unimplemented)",
	/* 301 */	"#301 (unimplemented)",
	/* 302 */	"#302 (unimplemented)",
	/* 303 */	"#303 (unimplemented)",
	/* 304 */	"#304 (unimplemented)",
	/* 305 */	"#305 (unimplemented)",
	/* 306 */	"#306 (unimplemented)",
	/* 307 */	"#307 (unimplemented)",
	/* 308 */	"#308 (unimplemented)",
	/* 309 */	"#309 (unimplemented)",
	/* 310 */	"#310 (unimplemented)",
	/* 311 */	"#311 (unimplemented)",
	/* 312 */	"#312 (unimplemented)",
	/* 313 */	"#313 (unimplemented)",
	/* 314 */	"#314 (unimplemented)",
	/* 315 */	"#315 (unimplemented)",
	/* 316 */	"#316 (unimplemented)",
	/* 317 */	"#317 (unimplemented)",
	/* 318 */	"#318 (unimplemented)",
	/* 319 */	"#319 (unimplemented)",
	/* 320 */	"#320 (unimplemented)",
	/* 321 */	"#321 (unimplemented)",
	/* 322 */	"#322 (unimplemented)",
	/* 323 */	"#323 (unimplemented)",
	/* 324 */	"#324 (unimplemented)",
	/* 325 */	"#325 (unimplemented)",
	/* 326 */	"#326 (unimplemented)",
	/* 327 */	"#327 (unimplemented)",
	/* 328 */	"#328 (unimplemented)",
	/* 329 */	"#329 (unimplemented)",
	/* 330 */	"#330 (unimplemented)",
	/* 331 */	"#331 (unimplemented)",
	/* 332 */	"#332 (unimplemented)",
	/* 333 */	"#333 (unimplemented)",
	/* 334 */	"#334 (unimplemented)",
	/* 335 */	"#335 (unimplemented)",
	/* 336 */	"#336 (unimplemented)",
	/* 337 */	"#337 (unimplemented)",
	/* 338 */	"#338 (unimplemented)",
	/* 339 */	"#339 (unimplemented)",
	/* 340 */	"#340 (unimplemented)",
	/* 341 */	"#341 (unimplemented)",
	/* 342 */	"#342 (unimplemented)",
	/* 343 */	"#343 (unimplemented)",
	/* 344 */	"#344 (unimplemented)",
	/* 345 */	"#345 (unimplemented)",
	/* 346 */	"#346 (unimplemented)",
	/* 347 */	"#347 (unimplemented)",
	/* 348 */	"#348 (unimplemented)",
	/* 349 */	"#349 (unimplemented)",
	/* 350 */	"#350 (unimplemented)",
	/* 351 */	"#351 (unimplemented)",
	/* 352 */	"#352 (unimplemented)",
	/* 353 */	"#353 (unimplemented)",
	/* 354 */	"#354 (unimplemented)",
	/* 355 */	"#355 (unimplemented)",
	/* 356 */	"#356 (unimplemented)",
	/* 357 */	"#357 (unimplemented)",
	/* 358 */	"#358 (unimplemented)",
	/* 359 */	"#359 (unimplemented)",
	/* 360 */	"#360 (unimplemented)",
	/* 361 */	"#361 (unimplemented)",
	/* 362 */	"#362 (unimplemented)",
	/* 363 */	"#363 (unimplemented)",
	/* 364 */	"#364 (unimplemented)",
	/* 365 */	"#365 (unimplemented)",
	/* 366 */	"#366 (unimplemented)",
	/* 367 */	"#367 (unimplemented)",
	/* 368 */	"#368 (unimplemented)",
	/* 369 */	"#369 (unimplemented)",
	/* 370 */	"#370 (unimplemented)",
	/* 371 */	"#371 (unimplemented)",
	/* 372 */	"#372 (unimplemented)",
	/* 373 */	"#373 (unimplemented)",
	/* 374 */	"#374 (unimplemented)",
	/* 375 */	"#375 (unimplemented)",
	/* 376 */	"#376 (unimplemented)",
	/* 377 */	"#377 (unimplemented)",
	/* 378 */	"#378 (unimplemented)",
	/* 379 */	"#379 (unimplemented)",
	/* 380 */	"#380 (unimplemented)",
	/* 381 */	"#381 (unimplemented)",
	/* 382 */	"#382 (unimplemented)",
	/* 383 */	"#383 (unimplemented)",
	/* 384 */	"#384 (unimplemented)",
	/* 385 */	"#385 (unimplemented)",
	/* 386 */	"#386 (unimplemented)",
	/* 387 */	"#387 (unimplemented)",
	/* 388 */	"#388 (unimplemented)",
	/* 389 */	"#389 (unimplemented)",
	/* 390 */	"#390 (unimplemented)",
	/* 391 */	"#391 (unimplemented)",
	/* 392 */	"#392 (unimplemented)",
	/* 393 */	"#393 (unimplemented)",
	/* 394 */	"#394 (unimplemented)",
	/* 395 */	"#395 (unimplemented)",
	/* 396 */	"#396 (unimplemented)",
	/* 397 */	"#397 (unimplemented)",
	/* 398 */	"#398 (unimplemented)",
	/* 399 */	"#399 (unimplemented)",
	/* 400 */	"#400 (unimplemented)",
	/* 401 */	"#401 (unimplemented)",
	/* 402 */	"#402 (unimplemented)",
	/* 403 */	"#403 (unimplemented)",
	/* 404 */	"#404 (unimplemented)",
	/* 405 */	"#405 (unimplemented)",
	/* 406 */	"#406 (unimplemented)",
	/* 407 */	"#407 (unimplemented)",
	/* 408 */	"#408 (unimplemented)",
	/* 409 */	"#409 (unimplemented)",
	/* 410 */	"#410 (unimplemented)",
	/* 411 */	"#411 (unimplemented)",
	/* 412 */	"#412 (unimplemented)",
	/* 413 */	"#413 (unimplemented)",
	/* 414 */	"#414 (unimplemented)",
	/* 415 */	"#415 (unimplemented)",
	/* 416 */	"#416 (unimplemented)",
	/* 417 */	"#417 (unimplemented)",
	/* 418 */	"#418 (unimplemented)",
	/* 419 */	"#419 (unimplemented)",
	/* 420 */	"#420 (unimplemented)",
	/* 421 */	"#421 (unimplemented)",
	/* 422 */	"#422 (unimplemented)",
	/* 423 */	"#423 (unimplemented)",
	/* 424 */	"#424 (unimplemented pidfd_send_signal)",
	/* 425 */	"#425 (unimplemented io_uring_setup)",
	/* 426 */	"#426 (unimplemented io_uring_enter)",
	/* 427 */	"#427 (unimplemented io_uring_register)",
	/* 428 */	"#428 (unimplemented open_tree)",
	/* 429 */	"#429 (unimplemented move_mount)",
	/* 430 */	"#430 (unimplemented fsopen)",
	/* 431 */	"#431 (unimplemented fsconfig)",
	/* 432 */	"#432 (unimplemented fsmount)",
	/* 433 */	"#433 (unimplemented fspick)",
	/* 434 */	"#434 (unimplemented pidfd_open)",
	/* 435 */	"clone3",
	/* 436 */	"close_range",
	/* 437 */	"#437 (unimplemented openat2)",
	/* 438 */	"#438 (unimplemented pidfd_getfd)",
	/* 439 */	"faccessat2",
	/* 440 */	"nosys",
	/* 441 */	"epoll_pwait2",
	/* 442 */	"# filler",
	/* 443 */	"# filler",
	/* 444 */	"# filler",
	/* 445 */	"# filler",
	/* 446 */	"# filler",
	/* 447 */	"# filler",
	/* 448 */	"# filler",
	/* 449 */	"# filler",
	/* 450 */	"# filler",
	/* 451 */	"# filler",
	/* 452 */	"# filler",
	/* 453 */	"# filler",
	/* 454 */	"# filler",
	/* 455 */	"# filler",
	/* 456 */	"# filler",
	/* 457 */	"# filler",
	/* 458 */	"# filler",
	/* 459 */	"# filler",
	/* 460 */	"# filler",
	/* 461 */	"# filler",
	/* 462 */	"# filler",
	/* 463 */	"# filler",
	/* 464 */	"# filler",
	/* 465 */	"# filler",
	/* 466 */	"# filler",
	/* 467 */	"# filler",
	/* 468 */	"# filler",
	/* 469 */	"# filler",
	/* 470 */	"# filler",
	/* 471 */	"# filler",
	/* 472 */	"# filler",
	/* 473 */	"# filler",
	/* 474 */	"# filler",
	/* 475 */	"# filler",
	/* 476 */	"# filler",
	/* 477 */	"# filler",
	/* 478 */	"# filler",
	/* 479 */	"# filler",
	/* 480 */	"# filler",
	/* 481 */	"# filler",
	/* 482 */	"# filler",
	/* 483 */	"# filler",
	/* 484 */	"# filler",
	/* 485 */	"# filler",
	/* 486 */	"# filler",
	/* 487 */	"# filler",
	/* 488 */	"# filler",
	/* 489 */	"# filler",
	/* 490 */	"# filler",
	/* 491 */	"# filler",
	/* 492 */	"# filler",
	/* 493 */	"# filler",
	/* 494 */	"# filler",
	/* 495 */	"# filler",
	/* 496 */	"# filler",
	/* 497 */	"# filler",
	/* 498 */	"# filler",
	/* 499 */	"# filler",
	/* 500 */	"# filler",
	/* 501 */	"# filler",
	/* 502 */	"# filler",
	/* 503 */	"# filler",
	/* 504 */	"# filler",
	/* 505 */	"# filler",
	/* 506 */	"# filler",
	/* 507 */	"# filler",
	/* 508 */	"# filler",
	/* 509 */	"# filler",
	/* 510 */	"# filler",
	/* 511 */	"# filler",
};


/* libc style syscall names */
const char *const altlinux_syscallnames[] = {
	/*   0 */	NULL, /* unimplemented io_setup */
	/*   1 */	NULL, /* unimplemented io_destroy */
	/*   2 */	NULL, /* unimplemented io_submit */
	/*   3 */	NULL, /* unimplemented io_cancel */
	/*   4 */	NULL, /* unimplemented io_getevents */
	/*   5 */	NULL, /* setxattr */
	/*   6 */	NULL, /* lsetxattr */
	/*   7 */	NULL, /* fsetxattr */
	/*   8 */	NULL, /* getxattr */
	/*   9 */	NULL, /* lgetxattr */
	/*  10 */	NULL, /* fgetxattr */
	/*  11 */	NULL, /* listxattr */
	/*  12 */	NULL, /* llistxattr */
	/*  13 */	NULL, /* flistxattr */
	/*  14 */	NULL, /* removexattr */
	/*  15 */	NULL, /* lremovexattr */
	/*  16 */	NULL, /* fremovexattr */
	/*  17 */	NULL, /* __getcwd */
	/*  18 */	NULL, /* unimplemented lookup_dcookie */
	/*  19 */	NULL, /* eventfd2 */
	/*  20 */	NULL, /* epoll_create1 */
	/*  21 */	NULL, /* epoll_ctl */
	/*  22 */	NULL, /* epoll_pwait */
	/*  23 */	NULL, /* dup */
	/*  24 */	NULL, /* dup3 */
	/*  25 */	NULL, /* fcntl */
	/*  26 */	NULL, /* inotify_init1 */
	/*  27 */	NULL, /* inotify_add_watch */
	/*  28 */	NULL, /* inotify_rm_watch */
	/*  29 */	NULL, /* ioctl */
	/*  30 */	NULL, /* unimplemented ioprio_set */
	/*  31 */	NULL, /* unimplemented ioprio_get */
	/*  32 */	NULL, /* flock */
	/*  33 */	NULL, /* mknodat */
	/*  34 */	NULL, /* mkdirat */
	/*  35 */	NULL, /* unlinkat */
	/*  36 */	NULL, /* symlinkat */
	/*  37 */	NULL, /* linkat */
	/*  38 */	NULL, /* renameat */
	/*  39 */	NULL, /* unimplemented umount2 */
	/*  40 */	NULL, /* unimplemented mount */
	/*  41 */	NULL, /* unimplemented pivot_root */
	/*  42 */	NULL, /* unimplemented nfsservctl */
	/*  43 */	NULL, /* statfs */
	/*  44 */	NULL, /* fstatfs */
	/*  45 */	NULL, /* truncate64 */
	/*  46 */	NULL, /* ftruncate64 */
	/*  47 */	NULL, /* fallocate */
	/*  48 */	NULL, /* faccessat */
	/*  49 */	NULL, /* chdir */
	/*  50 */	NULL, /* fchdir */
	/*  51 */	NULL, /* chroot */
	/*  52 */	NULL, /* fchmod */
	/*  53 */	NULL, /* fchmodat */
	/*  54 */	NULL, /* fchownat */
	/*  55 */	NULL, /* __posix_fchown */
	/*  56 */	NULL, /* openat */
	/*  57 */	NULL, /* close */
	/*  58 */	NULL, /* unimplemented vhangup */
	/*  59 */	NULL, /* pipe2 */
	/*  60 */	NULL, /* unimplemented quotactl */
	/*  61 */	NULL, /* getdents64 */
	/*  62 */	NULL, /* lseek */
	/*  63 */	NULL, /* read */
	/*  64 */	NULL, /* write */
	/*  65 */	NULL, /* readv */
	/*  66 */	NULL, /* writev */
	/*  67 */	NULL, /* pread */
	/*  68 */	NULL, /* pwrite */
	/*  69 */	NULL, /* preadv */
	/*  70 */	NULL, /* pwritev */
	/*  71 */	NULL, /* unimplemented sendfile */
	/*  72 */	NULL, /* pselect6 */
	/*  73 */	NULL, /* ppoll */
	/*  74 */	NULL, /* unimplemented signalfd4 */
	/*  75 */	NULL, /* unimplemented vmsplice */
	/*  76 */	NULL, /* unimplemented splice */
	/*  77 */	NULL, /* unimplemented tee */
	/*  78 */	NULL, /* readlinkat */
	/*  79 */	NULL, /* fstatat64 */
	/*  80 */	NULL, /* fstat64 */
	/*  81 */	NULL, /* sync */
	/*  82 */	NULL, /* fsync */
	/*  83 */	NULL, /* fdatasync */
	/*  84 */	NULL, /* sync_file_range */
	/*  85 */	NULL, /* timerfd_create */
	/*  86 */	NULL, /* timerfd_settime */
	/*  87 */	NULL, /* timerfd_gettime */
	/*  88 */	NULL, /* utimensat */
	/*  89 */	NULL, /* acct */
	/*  90 */	NULL, /* unimplemented capget */
	/*  91 */	NULL, /* unimplemented capset */
	/*  92 */	NULL, /* personality */
	/*  93 */	NULL, /* exit */
	/*  94 */	NULL, /* exit_group */
	/*  95 */	NULL, /* waitid */
	/*  96 */	NULL, /* set_tid_address */
	/*  97 */	NULL, /* unimplemented unshare */
	/*  98 */	NULL, /* futex */
	/*  99 */	NULL, /* __futex_set_robust_list */
	/* 100 */	NULL, /* __futex_get_robust_list */
	/* 101 */	NULL, /* nanosleep */
	/* 102 */	NULL, /* getitimer */
	/* 103 */	NULL, /* setitimer */
	/* 104 */	NULL, /* unimplemented kexec_load */
	/* 105 */	NULL, /* unimplemented init_module */
	/* 106 */	NULL, /* unimplemented delete_module */
	/* 107 */	NULL, /* timer_create */
	/* 108 */	NULL, /* timer_gettime */
	/* 109 */	NULL, /* timer_getoverrun */
	/* 110 */	NULL, /* timer_settime */
	/* 111 */	NULL, /* timer_delete */
	/* 112 */	NULL, /* clock_settime */
	/* 113 */	NULL, /* clock_gettime */
	/* 114 */	NULL, /* clock_getres */
	/* 115 */	NULL, /* clock_nanosleep */
	/* 116 */	NULL, /* unimplemented syslog */
	/* 117 */	NULL, /* ptrace */
	/* 118 */	NULL, /* sched_setparam */
	/* 119 */	NULL, /* sched_setscheduler */
	/* 120 */	NULL, /* sched_getscheduler */
	/* 121 */	NULL, /* sched_getparam */
	/* 122 */	NULL, /* sched_setaffinity */
	/* 123 */	NULL, /* sched_getaffinity */
	/* 124 */	NULL, /* sched_yield */
	/* 125 */	NULL, /* sched_get_priority_max */
	/* 126 */	NULL, /* sched_get_priority_min */
	/* 127 */	NULL, /* unimplemented sys_sched_rr_get_interval */
	/* 128 */	NULL, /* unimplemented restart_syscall */
	/* 129 */	NULL, /* kill */
	/* 130 */	NULL, /* tkill */
	/* 131 */	NULL, /* tgkill */
	/* 132 */	NULL, /* sigaltstack */
	/* 133 */	NULL, /* rt_sigsuspend */
	/* 134 */	NULL, /* rt_sigaction */
	/* 135 */	NULL, /* rt_sigprocmask */
	/* 136 */	NULL, /* rt_sigpending */
	/* 137 */	NULL, /* rt_sigtimedwait */
	/* 138 */	NULL, /* unimplemented rt_sigqueueinfo */
	/* 139 */	NULL, /* rt_sigreturn */
	/* 140 */	NULL, /* setpriority */
	/* 141 */	NULL, /* getpriority */
	/* 142 */	NULL, /* reboot */
	/* 143 */	NULL, /* setregid */
	/* 144 */	NULL, /* setgid */
	/* 145 */	NULL, /* setreuid */
	/* 146 */	NULL, /* setuid */
	/* 147 */	NULL, /* setresuid */
	/* 148 */	NULL, /* getresuid */
	/* 149 */	NULL, /* setresgid */
	/* 150 */	NULL, /* getresgid */
	/* 151 */	NULL, /* setfsuid */
	/* 152 */	NULL, /* setfsgid */
	/* 153 */	NULL, /* times */
	/* 154 */	NULL, /* setpgid */
	/* 155 */	NULL, /* getpgid */
	/* 156 */	NULL, /* getsid */
	/* 157 */	NULL, /* setsid */
	/* 158 */	NULL, /* getgroups */
	/* 159 */	NULL, /* setgroups */
	/* 160 */	NULL, /* uname */
	/* 161 */	NULL, /* sethostname */
	/* 162 */	NULL, /* setdomainname */
	/* 163 */	NULL, /* getrlimit */
	/* 164 */	NULL, /* setrlimit */
	/* 165 */	NULL, /* getrusage */
	/* 166 */	NULL, /* umask */
	/* 167 */	NULL, /* unimplemented prctl */
	/* 168 */	NULL, /* getcpu */
	/* 169 */	NULL, /* gettimeofday */
	/* 170 */	NULL, /* settimeofday */
	/* 171 */	NULL, /* unimplemented adjtimex */
	/* 172 */	NULL, /* getpid */
	/* 173 */	NULL, /* getppid */
	/* 174 */	NULL, /* getuid */
	/* 175 */	NULL, /* geteuid */
	/* 176 */	NULL, /* getgid */
	/* 177 */	NULL, /* getegid */
	/* 178 */	NULL, /* gettid */
	/* 179 */	NULL, /* sysinfo */
	/* 180 */	NULL, /* mq_open */
	/* 181 */	NULL, /* mq_unlink */
	/* 182 */	NULL, /* mq_timedsend */
	/* 183 */	NULL, /* mq_timedreceive */
	/* 184 */	NULL, /* mq_notify */
	/* 185 */	NULL, /* mq_getsetattr */
#ifdef SYSVMSG
	/* 186 */	NULL, /* msgget */
	/* 187 */	NULL, /* msgctl */
	/* 188 */	NULL, /* msgrcv */
	/* 189 */	NULL, /* msgsnd */
#else
	/* 186 */	NULL, /* unimplemented msgget */
	/* 187 */	NULL, /* unimplemented msgctl */
	/* 188 */	NULL, /* unimplemented msgrcv */
	/* 189 */	NULL, /* unimplemented msgsnd */
#endif
#ifdef SYSVSEM
	/* 190 */	NULL, /* semget */
	/* 191 */	NULL, /* semctl */
	/* 192 */	NULL, /* unimplemented semtimedop */
	/* 193 */	NULL, /* semop */
#else
	/* 190 */	NULL, /* unimplemented semget */
	/* 191 */	NULL, /* unimplemented semctl */
	/* 192 */	NULL, /* unimplemented semtimedop */
	/* 193 */	NULL, /* unimplemented semop */
#endif
#ifdef SYSVSEM
	/* 194 */	NULL, /* shmget */
	/* 195 */	NULL, /* shmctl */
	/* 196 */	NULL, /* shmat */
	/* 197 */	NULL, /* shmdt */
#else
	/* 194 */	NULL, /* unimplemented shmget */
	/* 195 */	NULL, /* unimplemented shmctl */
	/* 196 */	NULL, /* unimplemented shmat */
	/* 197 */	NULL, /* unimplemented shmdt */
#endif
	/* 198 */	NULL, /* socket */
	/* 199 */	NULL, /* socketpair */
	/* 200 */	NULL, /* bind */
	/* 201 */	NULL, /* listen */
	/* 202 */	"accept",
	/* 203 */	NULL, /* connect */
	/* 204 */	NULL, /* getsockname */
	/* 205 */	NULL, /* getpeername */
	/* 206 */	NULL, /* sendto */
	/* 207 */	NULL, /* recvfrom */
	/* 208 */	NULL, /* setsockopt */
	/* 209 */	NULL, /* getsockopt */
	/* 210 */	NULL, /* shutdown */
	/* 211 */	NULL, /* sendmsg */
	/* 212 */	NULL, /* recvmsg */
	/* 213 */	NULL, /* readahead */
	/* 214 */	NULL, /* brk */
	/* 215 */	NULL, /* munmap */
	/* 216 */	NULL, /* mremap */
	/* 217 */	NULL, /* unimplemented add_key */
	/* 218 */	NULL, /* unimplemented request_key */
	/* 219 */	NULL, /* unimplemented keyctl */
	/* 220 */	NULL, /* clone */
	/* 221 */	NULL, /* execve */
	/* 222 */	NULL, /* mmap */
	/* 223 */	NULL, /* fadvise64 */
	/* 224 */	NULL, /* swapon */
	/* 225 */	NULL, /* swapoff */
	/* 226 */	NULL, /* mprotect */
	/* 227 */	"msync",
	/* 228 */	NULL, /* mlock */
	/* 229 */	NULL, /* munlock */
	/* 230 */	NULL, /* mlockall */
	/* 231 */	NULL, /* munlockall */
	/* 232 */	NULL, /* mincore */
	/* 233 */	NULL, /* madvise */
	/* 234 */	NULL, /* unimplemented remap_file_pages */
	/* 235 */	NULL, /* unimplemented mbind */
	/* 236 */	NULL, /* unimplemented get_mempolicy */
	/* 237 */	NULL, /* unimplemented set_mempolicy */
	/* 238 */	NULL, /* unimplemented migrate_pages */
	/* 239 */	NULL, /* unimplemented move_pages */
	/* 240 */	NULL, /* unimplemented rt_tgsigqueueinfo */
	/* 241 */	NULL, /* unimplemented perf_event_open */
	/* 242 */	NULL, /* accept4 */
	/* 243 */	NULL, /* recvmmsg */
	/* 244 */	NULL, /* unimplemented arch_specific_syscall */
	/* 245 */	NULL, /* unimplemented */
	/* 246 */	NULL, /* unimplemented */
	/* 247 */	NULL, /* unimplemented */
	/* 248 */	NULL, /* unimplemented */
	/* 249 */	NULL, /* unimplemented */
	/* 250 */	NULL, /* unimplemented */
	/* 251 */	NULL, /* unimplemented */
	/* 252 */	NULL, /* unimplemented */
	/* 253 */	NULL, /* unimplemented */
	/* 254 */	NULL, /* unimplemented */
	/* 255 */	NULL, /* unimplemented */
	/* 256 */	NULL, /* unimplemented */
	/* 257 */	NULL, /* unimplemented */
	/* 258 */	NULL, /* unimplemented */
	/* 259 */	NULL, /* unimplemented */
	/* 260 */	NULL, /* wait4 */
	/* 261 */	NULL, /* prlimit64 */
	/* 262 */	NULL, /* unimplemented fanotify_init */
	/* 263 */	NULL, /* unimplemented fanotify_mark */
	/* 264 */	NULL, /* unimplemented name_to_handle_at */
	/* 265 */	NULL, /* unimplemented open_by_handle_at */
	/* 266 */	NULL, /* unimplemented clock_adjtime */
	/* 267 */	NULL, /* syncfs */
	/* 268 */	NULL, /* unimplemented setns */
	/* 269 */	NULL, /* sendmmsg */
	/* 270 */	NULL, /* unimplemented process_vm_readv */
	/* 271 */	NULL, /* unimplemented process_vm_writev */
	/* 272 */	NULL, /* unimplemented kcmp */
	/* 273 */	NULL, /* unimplemented finit_module */
	/* 274 */	NULL, /* unimplemented sched_setattr */
	/* 275 */	NULL, /* unimplemented sched_getattr */
	/* 276 */	NULL, /* renameat2 */
	/* 277 */	NULL, /* unimplemented seccomp */
	/* 278 */	NULL, /* getrandom */
	/* 279 */	NULL, /* memfd_create */
	/* 280 */	NULL, /* unimplemented bpf */
	/* 281 */	NULL, /* unimplemented execveat */
	/* 282 */	NULL, /* unimplemented userfaultfd */
	/* 283 */	NULL, /* unimplemented membarrier */
	/* 284 */	NULL, /* unimplemented mlock2 */
	/* 285 */	NULL, /* copy_file_range */
	/* 286 */	NULL, /* unimplemented preadv2 */
	/* 287 */	NULL, /* unimplemented pwritev2 */
	/* 288 */	NULL, /* unimplemented pkey_mprotect */
	/* 289 */	NULL, /* unimplemented pkey_alloc */
	/* 290 */	NULL, /* unimplemented pkey_free */
	/* 291 */	NULL, /* statx */
	/* 292 */	NULL, /* unimplemented io_pgetevents */
	/* 293 */	NULL, /* unimplemented rseq */
	/* 294 */	NULL, /* unimplemented kexec_file_load */
	/* 295 */	NULL, /* unimplemented */
	/* 296 */	NULL, /* unimplemented */
	/* 297 */	NULL, /* unimplemented */
	/* 298 */	NULL, /* unimplemented */
	/* 299 */	NULL, /* unimplemented */
	/* 300 */	NULL, /* unimplemented */
	/* 301 */	NULL, /* unimplemented */
	/* 302 */	NULL, /* unimplemented */
	/* 303 */	NULL, /* unimplemented */
	/* 304 */	NULL, /* unimplemented */
	/* 305 */	NULL, /* unimplemented */
	/* 306 */	NULL, /* unimplemented */
	/* 307 */	NULL, /* unimplemented */
	/* 308 */	NULL, /* unimplemented */
	/* 309 */	NULL, /* unimplemented */
	/* 310 */	NULL, /* unimplemented */
	/* 311 */	NULL, /* unimplemented */
	/* 312 */	NULL, /* unimplemented */
	/* 313 */	NULL, /* unimplemented */
	/* 314 */	NULL, /* unimplemented */
	/* 315 */	NULL, /* unimplemented */
	/* 316 */	NULL, /* unimplemented */
	/* 317 */	NULL, /* unimplemented */
	/* 318 */	NULL, /* unimplemented */
	/* 319 */	NULL, /* unimplemented */
	/* 320 */	NULL, /* unimplemented */
	/* 321 */	NULL, /* unimplemented */
	/* 322 */	NULL, /* unimplemented */
	/* 323 */	NULL, /* unimplemented */
	/* 324 */	NULL, /* unimplemented */
	/* 325 */	NULL, /* unimplemented */
	/* 326 */	NULL, /* unimplemented */
	/* 327 */	NULL, /* unimplemented */
	/* 328 */	NULL, /* unimplemented */
	/* 329 */	NULL, /* unimplemented */
	/* 330 */	NULL, /* unimplemented */
	/* 331 */	NULL, /* unimplemented */
	/* 332 */	NULL, /* unimplemented */
	/* 333 */	NULL, /* unimplemented */
	/* 334 */	NULL, /* unimplemented */
	/* 335 */	NULL, /* unimplemented */
	/* 336 */	NULL, /* unimplemented */
	/* 337 */	NULL, /* unimplemented */
	/* 338 */	NULL, /* unimplemented */
	/* 339 */	NULL, /* unimplemented */
	/* 340 */	NULL, /* unimplemented */
	/* 341 */	NULL, /* unimplemented */
	/* 342 */	NULL, /* unimplemented */
	/* 343 */	NULL, /* unimplemented */
	/* 344 */	NULL, /* unimplemented */
	/* 345 */	NULL, /* unimplemented */
	/* 346 */	NULL, /* unimplemented */
	/* 347 */	NULL, /* unimplemented */
	/* 348 */	NULL, /* unimplemented */
	/* 349 */	NULL, /* unimplemented */
	/* 350 */	NULL, /* unimplemented */
	/* 351 */	NULL, /* unimplemented */
	/* 352 */	NULL, /* unimplemented */
	/* 353 */	NULL, /* unimplemented */
	/* 354 */	NULL, /* unimplemented */
	/* 355 */	NULL, /* unimplemented */
	/* 356 */	NULL, /* unimplemented */
	/* 357 */	NULL, /* unimplemented */
	/* 358 */	NULL, /* unimplemented */
	/* 359 */	NULL, /* unimplemented */
	/* 360 */	NULL, /* unimplemented */
	/* 361 */	NULL, /* unimplemented */
	/* 362 */	NULL, /* unimplemented */
	/* 363 */	NULL, /* unimplemented */
	/* 364 */	NULL, /* unimplemented */
	/* 365 */	NULL, /* unimplemented */
	/* 366 */	NULL, /* unimplemented */
	/* 367 */	NULL, /* unimplemented */
	/* 368 */	NULL, /* unimplemented */
	/* 369 */	NULL, /* unimplemented */
	/* 370 */	NULL, /* unimplemented */
	/* 371 */	NULL, /* unimplemented */
	/* 372 */	NULL, /* unimplemented */
	/* 373 */	NULL, /* unimplemented */
	/* 374 */	NULL, /* unimplemented */
	/* 375 */	NULL, /* unimplemented */
	/* 376 */	NULL, /* unimplemented */
	/* 377 */	NULL, /* unimplemented */
	/* 378 */	NULL, /* unimplemented */
	/* 379 */	NULL, /* unimplemented */
	/* 380 */	NULL, /* unimplemented */
	/* 381 */	NULL, /* unimplemented */
	/* 382 */	NULL, /* unimplemented */
	/* 383 */	NULL, /* unimplemented */
	/* 384 */	NULL, /* unimplemented */
	/* 385 */	NULL, /* unimplemented */
	/* 386 */	NULL, /* unimplemented */
	/* 387 */	NULL, /* unimplemented */
	/* 388 */	NULL, /* unimplemented */
	/* 389 */	NULL, /* unimplemented */
	/* 390 */	NULL, /* unimplemented */
	/* 391 */	NULL, /* unimplemented */
	/* 392 */	NULL, /* unimplemented */
	/* 393 */	NULL, /* unimplemented */
	/* 394 */	NULL, /* unimplemented */
	/* 395 */	NULL, /* unimplemented */
	/* 396 */	NULL, /* unimplemented */
	/* 397 */	NULL, /* unimplemented */
	/* 398 */	NULL, /* unimplemented */
	/* 399 */	NULL, /* unimplemented */
	/* 400 */	NULL, /* unimplemented */
	/* 401 */	NULL, /* unimplemented */
	/* 402 */	NULL, /* unimplemented */
	/* 403 */	NULL, /* unimplemented */
	/* 404 */	NULL, /* unimplemented */
	/* 405 */	NULL, /* unimplemented */
	/* 406 */	NULL, /* unimplemented */
	/* 407 */	NULL, /* unimplemented */
	/* 408 */	NULL, /* unimplemented */
	/* 409 */	NULL, /* unimplemented */
	/* 410 */	NULL, /* unimplemented */
	/* 411 */	NULL, /* unimplemented */
	/* 412 */	NULL, /* unimplemented */
	/* 413 */	NULL, /* unimplemented */
	/* 414 */	NULL, /* unimplemented */
	/* 415 */	NULL, /* unimplemented */
	/* 416 */	NULL, /* unimplemented */
	/* 417 */	NULL, /* unimplemented */
	/* 418 */	NULL, /* unimplemented */
	/* 419 */	NULL, /* unimplemented */
	/* 420 */	NULL, /* unimplemented */
	/* 421 */	NULL, /* unimplemented */
	/* 422 */	NULL, /* unimplemented */
	/* 423 */	NULL, /* unimplemented */
	/* 424 */	NULL, /* unimplemented pidfd_send_signal */
	/* 425 */	NULL, /* unimplemented io_uring_setup */
	/* 426 */	NULL, /* unimplemented io_uring_enter */
	/* 427 */	NULL, /* unimplemented io_uring_register */
	/* 428 */	NULL, /* unimplemented open_tree */
	/* 429 */	NULL, /* unimplemented move_mount */
	/* 430 */	NULL, /* unimplemented fsopen */
	/* 431 */	NULL, /* unimplemented fsconfig */
	/* 432 */	NULL, /* unimplemented fsmount */
	/* 433 */	NULL, /* unimplemented fspick */
	/* 434 */	NULL, /* unimplemented pidfd_open */
	/* 435 */	NULL, /* clone3 */
	/* 436 */	NULL, /* close_range */
	/* 437 */	NULL, /* unimplemented openat2 */
	/* 438 */	NULL, /* unimplemented pidfd_getfd */
	/* 439 */	NULL, /* faccessat2 */
	/* 440 */	NULL, /* nosys */
	/* 441 */	NULL, /* epoll_pwait2 */
	/* 442 */	NULL, /* filler */
	/* 443 */	NULL, /* filler */
	/* 444 */	NULL, /* filler */
	/* 445 */	NULL, /* filler */
	/* 446 */	NULL, /* filler */
	/* 447 */	NULL, /* filler */
	/* 448 */	NULL, /* filler */
	/* 449 */	NULL, /* filler */
	/* 450 */	NULL, /* filler */
	/* 451 */	NULL, /* filler */
	/* 452 */	NULL, /* filler */
	/* 453 */	NULL, /* filler */
	/* 454 */	NULL, /* filler */
	/* 455 */	NULL, /* filler */
	/* 456 */	NULL, /* filler */
	/* 457 */	NULL, /* filler */
	/* 458 */	NULL, /* filler */
	/* 459 */	NULL, /* filler */
	/* 460 */	NULL, /* filler */
	/* 461 */	NULL, /* filler */
	/* 462 */	NULL, /* filler */
	/* 463 */	NULL, /* filler */
	/* 464 */	NULL, /* filler */
	/* 465 */	NULL, /* filler */
	/* 466 */	NULL, /* filler */
	/* 467 */	NULL, /* filler */
	/* 468 */	NULL, /* filler */
	/* 469 */	NULL, /* filler */
	/* 470 */	NULL, /* filler */
	/* 471 */	NULL, /* filler */
	/* 472 */	NULL, /* filler */
	/* 473 */	NULL, /* filler */
	/* 474 */	NULL, /* filler */
	/* 475 */	NULL, /* filler */
	/* 476 */	NULL, /* filler */
	/* 477 */	NULL, /* filler */
	/* 478 */	NULL, /* filler */
	/* 479 */	NULL, /* filler */
	/* 480 */	NULL, /* filler */
	/* 481 */	NULL, /* filler */
	/* 482 */	NULL, /* filler */
	/* 483 */	NULL, /* filler */
	/* 484 */	NULL, /* filler */
	/* 485 */	NULL, /* filler */
	/* 486 */	NULL, /* filler */
	/* 487 */	NULL, /* filler */
	/* 488 */	NULL, /* filler */
	/* 489 */	NULL, /* filler */
	/* 490 */	NULL, /* filler */
	/* 491 */	NULL, /* filler */
	/* 492 */	NULL, /* filler */
	/* 493 */	NULL, /* filler */
	/* 494 */	NULL, /* filler */
	/* 495 */	NULL, /* filler */
	/* 496 */	NULL, /* filler */
	/* 497 */	NULL, /* filler */
	/* 498 */	NULL, /* filler */
	/* 499 */	NULL, /* filler */
	/* 500 */	NULL, /* filler */
	/* 501 */	NULL, /* filler */
	/* 502 */	NULL, /* filler */
	/* 503 */	NULL, /* filler */
	/* 504 */	NULL, /* filler */
	/* 505 */	NULL, /* filler */
	/* 506 */	NULL, /* filler */
	/* 507 */	NULL, /* filler */
	/* 508 */	NULL, /* filler */
	/* 509 */	NULL, /* filler */
	/* 510 */	NULL, /* filler */
	/* 511 */	NULL, /* filler */
};
