/*	$NetBSD: elf_cntl.c,v 1.5 2024/03/03 17:37:33 christos Exp $	*/

/*-
 * Copyright (c) 2006,2008 Joseph Koshy
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>

#include <libelf.h>

#include "_libelf.h"

__RCSID("$NetBSD: elf_cntl.c,v 1.5 2024/03/03 17:37:33 christos Exp $");
ELFTC_VCSID("Id: elf_cntl.c 3977 2022-05-01 06:45:34Z jkoshy");

int
elf_cntl(Elf *e, Elf_Cmd c)
{
	if (e == NULL ||
	    (c != ELF_C_FDDONE && c != ELF_C_FDREAD)) {
		LIBELF_SET_ERROR(ARGUMENT, 0);
		return (-1);
	}

	if (e->e_parent) {
		LIBELF_SET_ERROR(ARCHIVE, 0);
		return (-1);
	}

	if (c == ELF_C_FDREAD) {
		if (e->e_cmd == ELF_C_WRITE) {
			LIBELF_SET_ERROR(MODE, 0);
			return (-1);
		}
		else
			return (0);
	}

	e->e_fd = -1;
	return 0;
}
