#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <ctype.h>

extern int errno;

#define countof(x) (sizeof(x)/sizeof(x[0]))

void fail(char *txt, ...);
FILE *fopen_(char *file, char *access);
int getline(FILE *src);
int process(FILE *outbox,int lnth, int doapprove);
void work(FILE *outbox, FILE *posted, FILE *approved);
int gline(FILE *src, char *bufr, int buflen);

char *tname = "temp.mbx";

char *(skip[]) = {
	"cc:",
	"to:",
	"approved:",
	"path:",
	"received:",
	"date:",
	"message-id:",
	"nntp-posting-host:",
	"nntp-posting-date:",
	"xref:",
	"x-nntp-posting-host:",
	"x-complaints-to:",
	"x-trace:",
	"x-no-archive:",
	"x-mozilla-news-host:" };

char bufr[60000];

char *modname, *modout, *modcandir, *modgroup;

int errflag = 0;
int flags;
#define f_newsgroups 1
#define f_status 2
#define f_subject 4
#define f_thisapprove 8
#define f_organization 16

void main(void) 
{
	FILE *approved;
	FILE *outbox;
	FILE *posted;

/* load the moderator name and the name of the outbox */

	modname = getenv("MODNAME");
	modout	= getenv("MODOUT");
	modcandir = getenv("MODCANNED");
	modgroup = getenv("MODGROUP");
	if (!modout || !modname || !modgroup)
		fail("please set the MODOUT and MODNAME and MODGROUP environment vars\n");


	/* first we need to process the outbox
	 * to deal with self-approved messages and canned responses
	*/
	if (
	rename(modout,tname)
	) fail("Error %d renaming %s to %s\n",errno,modout,tname);

	approved = fopen_(tname, "rb");

	outbox = fopen_(modout, "w");

	work(outbox,0,approved);

	fclose(approved);
	unlink("temp.mbx");

	/* I needed to do this in binary because some posts end with
		 an EOF within the approved file and that should not end
		 the reading of the approved file.
	*/
	approved = fopen_("approved", "rb");
printf("Opened approved\n");
	posted = fopen_("posted", "a");
	work(outbox,posted,approved);

	fclose(approved);
	fclose(outbox);
	fclose(posted);
	/* Once we are done we need to recreate approved as a zero length
		 file so we can drag future messages to it.
	*/
	approved = fopen_("approved", "w");
	fclose(approved);

	/* then we hang on if any errors
	*/
	if (errflag)
		getch();
}

void work(FILE *outbox, FILE *posted, FILE *approved) {

	/* loop though all the lines of "approved" */

	for (;;) {
		int lnth;
		char canname[100];
		FILE * canfil;

		/* Do this loop, copying without changes, until we have copied
			 the line that marks the start of a block of header lines
		*/
		do {
			lnth = gline(approved, bufr, sizeof(bufr));
			if (lnth<0)
				return;

			/* check for a canned file name and read it in if so 
				 we do this on both the outbox and the approved file!
			*/
			if (modcandir && !strncmp(bufr,"\\\\",2)) {
				strcpy(canname,modcandir);
				strcat(canname,bufr+2);
				if (canname[strlen(canname)-1] < 32)
					canname[strlen(canname)-1] = 0;
				if ((canfil = fopen(canname,"r")) != 0) {

					/* this loop copies the canned file to the 
						 destination files
					*/
					do {
						lnth = gline(canfil,bufr,sizeof(bufr));
						if (lnth < 0)
							break;
						if (posted)
							fwrite(bufr,lnth, 1, posted);
						fwrite(bufr,lnth,1, outbox);
					} while (1);
					/* put blank lines after canned message
					*/
					if (posted)
						fprintf(posted,"\n\n");
					fprintf(outbox,"\n\n");
				}
				else {
					printf("warning: missing canned message\n");
					errflag = 1;
				}
			}

			else {
				if (posted)
					fwrite(bufr, lnth, 1, posted);
				fwrite(bufr, lnth, 1, outbox);
			}
		} while (memicmp(bufr, "from - ", 7));

		/* Do this loop, copying with changes, until we have copied a
			 line which is not a header line.	Hopefully, that is the
			 blank line that MUST follow a block of header lines.	I
			 don't bother checking that it is blank
		*/
		flags = 0;
		do {
			lnth = getline(approved);
			if (lnth < 0)
				break;
			if (posted)
				fwrite(bufr, lnth, 1, posted);
		} while (process(outbox,lnth, posted != 0)); 
	}
}

/* Here we process a line which is either a header line or the
	 first line after a header block.	We modify it if appropriate
	 and we copy it if appropriate.
	 We return true if it was a header line.
*/
int process(FILE *outbox,int lnth, int autoapprove) {
	int ndx;
	int rslt = 1;

	/* First we have a bunch of header lines that are always discarded
	*/
	for (ndx = autoapprove ? 0 : 2; ndx<countof(skip); ndx++)
		if (!memicmp(bufr, skip[ndx], strlen(skip[ndx]))) {
			if (ndx==2 && autoapprove) {
				printf("Warning: already %s\n",skip[ndx]);
				errflag = 1;
			}
			return (rslt); 
		}

	/* Change mozilla-status to 801 and remember we saw it
	*/
	if (!memicmp(bufr, "x-mozilla-status:", 17)) {
		flags |= f_status;
		if (autoapprove)
			memcpy(bufr+18, "0801", 4); 
	}

	/* Remember that we saw a newsgroups header
		 and flag if it had our group in it
	*/
	if (!memicmp(bufr, "newsgroups:", 11)) {
		flags |= f_newsgroups;
		if (strstr(bufr,modgroup))
			flags |= f_thisapprove;
	}

	/* Check if there is an 'organization' line and remember it */
	if (!memicmp(bufr, "organization:",13))
		flags |= f_organization;

	/* If this is not a header line then it is the end of the block of
		 header lines.	Do some cleanup.
	*/
	if (!strchr(bufr, ':')) {

		/* Warn the human if the message is bad.	We also set a
			 flag, so after all processing we can wait for a keystroke if
			 there were any errors.	(So the whole program can run in an
			 otherwise self closing window).
		*/
		if ( ~flags & f_subject) {
			printf("Error: No Subject:\n");
			errflag = 1;
		}

		/* only add newsgroups line on the approved file pass 
			 and if it isn't there
		*/
		if ( (~flags & f_newsgroups) && autoapprove)
			fprintf(outbox, "Newsgroups: %s\n",modgroup);

		/* on the outbox pass, we only approve if there was a newsgroup line
		   with our group as the destination.
		   on the approved pass, it is all out of the approval folder so
			 we approve everything.
		*/
		if (autoapprove || (flags & f_thisapprove) )
			fprintf(outbox, "Approved: <%s>\n",modname); 

		/* Patch in an organization of unknown to keep the ISP and NETSCAPE
			 from using the moderator's defaults.
			 Only do this if there is no organization line and we are dealing
			 with posts from the 'approved' file
		*/
		if (autoapprove && !(flags & f_organization))
			fprintf(outbox,"Organization: Unknown\n");

		/* If the status line is missing, something really strange is going
			 on.	I forget why I needed to add this step.
		*/
		if ( ~flags & f_status)
			fprintf(outbox, "X-Mozilla-Status: 0801\n");

		/* Once all that is done, tell the outer loop that headers are over
		*/
		rslt = 0; 
	}

	/* Write the line we are working on
	*/
	fwrite(bufr, lnth, 1, outbox);

	if (!memicmp(bufr, "subject:", 8)) 
		flags |= f_subject;
	
	return (rslt);
}

/* This kludge reads in a line that might be a header line.
	 A header line may be multiple physical lines.	The first
	 physical line of a header line must include a ":".
	 The first physical line must not start with ' ' or '\t'.
	 Every later physical line must start with ' ' or '\t'.
	 We merge them together as one string because we process
	 them that way, but we keep the embedded '\n's so that
	 they turn back into the same multiple physical lines
	 when written
*/
int getline(FILE *src)	{
	static char next[5000];
	static int flag=0;
	int lnth;

	/* If we read more than we could use last time around, use it now
 	*/
	if (flag) {
		lnth = flag;
		memcpy(bufr, next, lnth+1);
		flag = 0; }
	else {
		lnth = gline(src, bufr, sizeof(bufr));
		if (lnth<0)
			return (-1); }

	/* If this might be the start of a header line
 	*/
	if (bufr[0]>' ') {
		/* Why didn't I check for ":" here?
		*/
		for (;;) {
			int ln2;

			/* Get another physical line
			*/
			ln2 = gline(src, next, sizeof(next));
			if (ln2<0)
				return (lnth);

			/* If it isn't a continuation, save it for later
			*/
			if (next[0] != ' ' && next[0] != '\t') {
				flag = ln2;
				return (lnth); }

			/* Otherwise try to concatenate it on
			*/
			if ( ln2+lnth >= sizeof(bufr))
				fail("Compound line too long");
			memcpy(bufr+lnth, next, ln2);
			lnth += ln2; 
		} 
	}

	return (lnth);
}

	
FILE *fopen_(char *file, char *access)
{
	FILE *handle;
	handle = fopen(file, access);
	if (!handle)
		fail("Could not open %s mode %s\n",file,access);
	return (handle);
}

void fail(char *txt, ...)
{
	vprintf(txt, (&txt)+1);
	getch();
	exit(-1);
}


/* Get a physical line.	Discard '\r' and EOF chars.
	 Return the length.
*/
int gline(FILE *src, char *bufr, int buflen) {
	int lnth;
	if (!fgets(bufr, buflen, src))
		return (-1);
	lnth = strlen(bufr);
	if (lnth>1 && bufr[lnth-2]=='\r') {
		lnth--;
		bufr[lnth-1] = bufr[lnth];
		bufr[lnth] = 0; }
	if (bufr[0] == 26) {
		memcpy(bufr, bufr+1, lnth);
		lnth--; }
	return (lnth);
}