//
// MODTOOL
//
// Copyright (c) !998 David Lindauer (LADSOFT)
//
// see license.txt for licensing info
//
// ==============================================================
//
// PROPERTY.CPP
//
// property sheet handling
//
// each page in a property sheet is a rather boring dialog box
// which hooks WM_NOTIFY messages for the activity.
//
// I'm not commenting the dialog box internals as they are all straightforward
//
#define STRICT
#include <windows.h>
#include <stdio.h>
#include "profile.h"
#include "winconst.h"
#include "dialog.h"
#include "modlist.h"
#include "mthi.h"
#include "help.h"

HWND hWndAnalyze;

// ==============================================================
//
// property sheet constant names
//
#define PROPERTY_SHEET_COUNT 6
#define GROUPPROP 0
#define ANALYZEPROP 1
#define LISTPROP 2
#define MAILPROP 2
#define ARCHIVEPROP 3
#define REJECTPROP 4
#define SERVERPROP 5

static PROPSHEETPAGE pages[PROPERTY_SHEET_COUNT]; // the page structures
static PROPSHEETHEADER header;	// the header structure

// ==============================================================
//
// routine to set the result from the killactive notify message

static void SetResult(HWND hWnd,int value)
{
	SetWindowLong(hWnd,DWL_MSGRESULT,value);
}
// ==============================================================
//
// server properties
int FAR PASCAL ServerProc (HWND hWnd,UINT wmsg,WPARAM wparam,LPARAM lparam)

{
	NMHDR * nmhead;
	switch (wmsg) {
		case WM_INITDIALOG:
			return TRUE;
		case WM_NOTIFY:
			nmhead = (NMHDR *)lparam;
			switch (nmhead->code) {
				case PSN_SETACTIVE:
					/* page startup */
					NewFocus(hWnd,IDC_SPEDITPOP3);
					SetCBField(hWnd,IDC_SPCBUSEPOP3,usesmtp);
					SetCBField(hWnd,IDC_SPCBUSEPOST,usenntp);
					SetEditField(hWnd,IDC_SPEDITSMTP,smtpserver);
					SetEditField(hWnd,IDC_SPEDITARCHIVE,nntparchiveserver);
					SetEditField(hWnd,IDC_SPEDITPASSWD,pop3password);
					SetEditField(hWnd,IDC_SPEDITPOP3,pop3server);
					SetEditField(hWnd,IDC_SPEDITPOST,nntppostserver);
					SetEditField(hWnd,IDC_SPEDITALTERNATE,nntpalternateserver);
					SetEditField(hWnd,IDC_SPEDITUSERNAME,pop3username);
					break;
				case PSN_KILLACTIVE:
					/* verify ok always */
					usesmtp = GetCBField(hWnd,IDC_SPCBUSEPOP3);
					usenntp = GetCBField(hWnd,IDC_SPCBUSEPOST);
					GetEditField(hWnd,IDC_SPEDITPOP3,pop3server);
					GetEditField(hWnd,IDC_SPEDITPASSWD,pop3password);
					GetEditField(hWnd,IDC_SPEDITSMTP,smtpserver);
					GetEditField(hWnd,IDC_SPEDITPOST,nntppostserver);
					GetEditField(hWnd,IDC_SPEDITARCHIVE,nntparchiveserver);
					GetEditField(hWnd,IDC_SPEDITALTERNATE,nntpalternateserver);
					GetEditField(hWnd,IDC_SPEDITUSERNAME,pop3username);
					SetResult(hWnd,FALSE);
					break;
				case PSN_APPLY:
					/* Page application */
					break;
				case PSN_HELP:
					Help(hWnd,HIDP_SERVER);
					break;
			}
			break;
	}
	return FALSE;
}
// ==============================================================
//
// archive properties
//
int FAR PASCAL ArchiveProc (HWND hWnd,UINT wmsg,WPARAM wparam,LPARAM lparam)

{
	NMHDR * nmhead;
	
	switch (wmsg) {
		case WM_INITDIALOG:
			return TRUE;
		case WM_NOTIFY:
			nmhead = (NMHDR *)lparam;
			switch (nmhead->code) {
				case PSN_SETACTIVE:
					/* page startup */
					NewFocus(hWnd,IDC_ARPEDITFOLDER);
					SetEditField(hWnd,IDC_ARPEDITDIRECTORY,archivedirectory);
					SetEditField(hWnd,IDC_ARPEDITFOLDER,archivefolder);
					SetEditField(hWnd,IDC_ARPREJECTARCHIVEFOLDER,rejectarchivefolder);
					SetEditFieldValue(hWnd,IDC_ARPEDITLAST,ReadArchiveCountProfile());
					SetCBField(hWnd,IDC_ARPDATEDARCHIVE,datedarchive);
					SetCBField(hWnd,IDC_ARPCBREADFROMSERVER,archivefromserver);
					break;
				case PSN_KILLACTIVE:
					/* verify ok always */
					GetEditField(hWnd,IDC_ARPEDITDIRECTORY,archivedirectory);
					GetEditField(hWnd,IDC_ARPEDITFOLDER,archivefolder);
					GetEditField(hWnd,IDC_ARPREJECTARCHIVEFOLDER,rejectarchivefolder);
					datedarchive = GetCBField(hWnd,IDC_ARPDATEDARCHIVE);
					WriteArchiveCountProfile(GetEditFieldValue(hWnd,IDC_ARPEDITLAST));
					archivefromserver= GetCBField(hWnd,IDC_ARPCBREADFROMSERVER);
					SetResult(hWnd,FALSE);
					break;
				case PSN_APPLY:
					/* Page application */
					break;
				case PSN_HELP:
					Help(hWnd,HIDP_ARCHIVE);
					break;
			}
			break;
        
	}
	return FALSE;
}
// ==============================================================
//
// list properties
//
int FAR PASCAL ListProc (HWND hWnd,UINT wmsg,WPARAM wparam,LPARAM lparam)

{
	NMHDR * nmhead;
	
	switch (wmsg) {
		case WM_INITDIALOG:
			return TRUE;
		case WM_NOTIFY:
			nmhead = (NMHDR *)lparam;
			switch (nmhead->code) {
				case PSN_SETACTIVE:
					/* page startup */
					NewFocus(hWnd,IDC_ARPEDITFOLDER);
					break;
				case PSN_KILLACTIVE:
					/* verify ok always */
					SetResult(hWnd,FALSE);
					break;
				case PSN_APPLY:
					/* Page application */
					break;
				case PSN_HELP:
					Help(hWnd,HIDP_LIST);
					break;
			}
			break;
        
	}
	return FALSE;
}
// ==============================================================
//
// reject properties
//
int FAR PASCAL RejectProc (HWND hWnd,UINT wmsg,WPARAM wparam,LPARAM lparam)

{
	NMHDR * nmhead;
	
	switch (wmsg) {
		case WM_INITDIALOG:
			return TRUE;
		case WM_NOTIFY:
			nmhead = (NMHDR *)lparam;
			switch (nmhead->code) {
				case PSN_SETACTIVE:
					/* page startup */
					NewFocus(hWnd,IDC_ARPEDITFOLDER);
					SetEditField(hWnd,IDC_RJPEDITFOLDER,rejectfolder);
					SetEditField(hWnd,IDC_RJPMESSAGEDIR,rejectmessagedir);
					break;
				case PSN_KILLACTIVE:
					/* verify ok always */
					GetEditField(hWnd,IDC_RJPEDITFOLDER,rejectfolder);
					GetEditField(hWnd,IDC_RJPMESSAGEDIR,rejectmessagedir);
					SetResult(hWnd,FALSE);
					break;
				case PSN_APPLY:
					/* Page application */
					break;
				case PSN_HELP:
					Help(hWnd,HIDP_REJECT);
					break;
			}
			break;
	}
	return FALSE;
}
// ==============================================================
//
// mailer properties
//
int FAR PASCAL MailProc (HWND hWnd,UINT wmsg,WPARAM wparam,LPARAM lparam)

{
	NMHDR * nmhead;

	switch (wmsg) {
		case WM_INITDIALOG:
			return TRUE;
		case WM_NOTIFY:
			nmhead = (NMHDR *)lparam;
			switch (nmhead->code) {
				case PSN_SETACTIVE:
					/* page startup */
					NewFocus(hWnd,IDC_MAILPEDITFOLDER);
					SetEditField(hWnd,IDC_MAILPINBOX,inbox);
					SetCBField(hWnd,IDC_MAILPSORT,sortmail);
					SetCBField(hWnd,IDC_MAILCBDELETE,pop3dele);
					SetEditField(hWnd,IDC_MAILPEDITFOLDER,mailfolder);
					break;
				case PSN_KILLACTIVE:
					/* verify ok always */
					pop3dele= GetCBField(hWnd,IDC_MAILCBDELETE);
					sortmail = GetCBField(hWnd,IDC_MAILPSORT);
					GetEditField(hWnd,IDC_MAILPINBOX,inbox);
					GetEditField(hWnd,IDC_MAILPEDITFOLDER,mailfolder);
					SetResult(hWnd,FALSE);
					break;
				case PSN_APPLY:
					/* Page application */
					break;
				case PSN_HELP:
					Help(hWnd,HIDP_MAIL);
					break;
			}
			break;
        
	}
	return FALSE;
}
// ==============================================================
//
// analyzer properties
//
int FAR PASCAL AnalyzeProc (HWND hWnd,UINT wmsg,WPARAM wparam,LPARAM lparam)

{
	NMHDR * nmhead;

	switch (wmsg) {
		case WM_INITDIALOG:
			hWndAnalyze = hWnd;
			return TRUE;
		case WM_NOTIFY:
			nmhead = (NMHDR *)lparam;
			switch (nmhead->code) {
				case PSN_SETACTIVE:
					/* page startup */
					NewFocus(hWnd,IDC_ANPOUTBOX);
					SetCBField(hWnd,IDC_ANPPARTIALAPPROVE,partialapprove);
					SetCBField(hWnd,IDC_ANPTOPOSTED,topostedfolder);
					SetEditField(hWnd,IDC_ANPOUTBOX,outbox);
					SetEditField(hWnd,IDC_ANPAPPROVALBOX,approvalfolder);
					SetEditField(hWnd,IDC_ANPPOSTEDFOLDER,postedfolder);
					ModListCreate();
					break;
				case PSN_KILLACTIVE:
					/* verify ok always */
					partialapprove = GetCBField(hWnd,IDC_ANPPARTIALAPPROVE);
					topostedfolder = GetCBField(hWnd,IDC_ANPTOPOSTED);
					GetEditField(hWnd,IDC_ANPOUTBOX,outbox);
					GetEditField(hWnd,IDC_ANPPOSTEDFOLDER,postedfolder);
					GetEditField(hWnd,IDC_ANPAPPROVALBOX,approvalfolder);
					SetResult(hWnd,FALSE);
					break;
				case PSN_APPLY:
					/* Page application */
					ModListDestroy(TRUE);
					break;
				case PSN_RESET:
					ModListDestroy(FALSE);
					break;
				case PSN_HELP:
					Help(hWnd,HIDP_ANALYZE);
					break;
			}
			break;
		case WM_COMMAND:
			switch (LOWORD(wparam)) {
				case IDC_ANPBTMOD:
					ModListNew();
					return TRUE;
				case IDC_COBMODLIST:
					if (HIWORD(wparam) == CBN_SELCHANGE)
						ModListSelect();
					return TRUE;
			}
			break;
        
	}
	return FALSE;
}
// ==============================================================
//
// group properties
//
int FAR PASCAL GroupProc (HWND hWnd,UINT wmsg,WPARAM wparam,LPARAM lparam)

{
	NMHDR * nmhead;
	
	switch (wmsg) {
		case WM_INITDIALOG:
			return TRUE;
		case WM_NOTIFY:
			nmhead = (NMHDR *)lparam;
			switch (nmhead->code) {
				case PSN_SETACTIVE:
					/* page startup */
					NewFocus(hWnd,IDC_DGPEDITGROUP);
					SetEditField(hWnd,IDC_DGPEDITGROUP,groupid);
					SetEditField(hWnd,IDC_DGPEDITHOST,smtpsourcehost);
					SetEditField(hWnd,IDC_DGPEDITPATH,smtpsourcepath);
					SetEditField(hWnd,IDC_DGPEDITAPPROVALBOX,approvalmailbox);
					break;
				case PSN_KILLACTIVE:
					/* verify ok always */
					SetFolders();
					SetNetworkServers();
					GetEditField(hWnd,IDC_DGPEDITGROUP,groupid);
					GetEditField(hWnd,IDC_DGPEDITHOST,smtpsourcehost);
					GetEditField(hWnd,IDC_DGPEDITPATH,smtpsourcepath);
					GetEditField(hWnd,IDC_DGPEDITAPPROVALBOX,approvalmailbox);
					WriteDefaultGroup();
					SetGroupProperties();
					GetFolders();
					GetListProperties();
					GetNetworkServers();
					SetResult(hWnd,FALSE);
					break;
				case PSN_APPLY:
					/* Page application */
					SetListProperties();
					SetFolders();
					SetNetworkServers();
					break;
				case PSN_RESET:
/* cancel does not affect archive count, groups other than current, or
 * group changes
 */
					ModListDestroy(FALSE);
					ReadDefaultGroup();
					GetListProperties();
					GetGroupProperties();
					GetNetworkServers();
					GetFolders();
					break;
				case PSN_HELP:
					Help(hWnd,HIDP_GROUP);
					break;
			}
        
	}
	return FALSE;
}
// ==============================================================
//
// display the property sheet and return to caller
//
void DisplayProperties(HINSTANCE hInst, HWND hWnd)
{
	// struct for server page
	pages[SERVERPROP].dwSize = sizeof(PROPSHEETPAGE);
	pages[SERVERPROP].dwFlags = PSP_HASHELP;
	pages[SERVERPROP].hInstance = hInst;
	pages[SERVERPROP].pszTemplate = "DLG_SERVERPROPERTIES";
	pages[SERVERPROP].pfnDlgProc = ServerProc;

	// struct for mail page
	pages[MAILPROP].dwSize = sizeof(PROPSHEETPAGE);
	pages[MAILPROP].dwFlags = PSP_HASHELP;
	pages[MAILPROP].hInstance = hInst;
	pages[MAILPROP].pszTemplate = "DLG_MAILPROPERTIES";
	pages[MAILPROP].pfnDlgProc = MailProc;

	// struct for archive page
	pages[ARCHIVEPROP].dwSize = sizeof(PROPSHEETPAGE);
	pages[ARCHIVEPROP].dwFlags = PSP_HASHELP;
	pages[ARCHIVEPROP].hInstance = hInst;
	pages[ARCHIVEPROP].pszTemplate = "DLG_ARCHIVEPROPERTIES";
	pages[ARCHIVEPROP].pfnDlgProc = ArchiveProc;

	// struct for archive page
	pages[REJECTPROP].dwSize = sizeof(PROPSHEETPAGE);
	pages[REJECTPROP].dwFlags = PSP_HASHELP;
	pages[REJECTPROP].hInstance = hInst;
	pages[REJECTPROP].pszTemplate = "DLG_REJECTPROPERTIES";
	pages[REJECTPROP].pfnDlgProc = RejectProc;

	// struct for archive page
	pages[ANALYZEPROP].dwSize = sizeof(PROPSHEETPAGE);
	pages[ANALYZEPROP].dwFlags = PSP_HASHELP;
	pages[ANALYZEPROP].hInstance = hInst;
	pages[ANALYZEPROP].pszTemplate = "DLG_ANALYZEPROPERTIES";
	pages[ANALYZEPROP].pfnDlgProc = AnalyzeProc;

	// struct for listbox page
/*	pages[LISTPROP].dwSize = sizeof(PROPSHEETPAGE);
	pages[LISTPROP].dwFlags = PSP_HASHELP;
	pages[LISTPROP].hInstance = hInst;
	pages[LISTPROP].pszTemplate = "DLG_LISTPROPERTIES";
	pages[LISTPROP].pfnDlgProc = ListProc;
*/
	// struct for moderate page
	pages[GROUPPROP].dwSize = sizeof(PROPSHEETPAGE);
	pages[GROUPPROP].dwFlags = PSP_HASHELP;
	pages[GROUPPROP].hInstance = hInst;
	pages[GROUPPROP].pszTemplate = "DLG_GROUPPROPERTIES";
	pages[GROUPPROP].pfnDlgProc = GroupProc;

	// struct for property sheet header
	header.dwSize = sizeof(PROPSHEETHEADER);
	header.dwFlags = PSH_PROPSHEETPAGE | PSH_PROPTITLE | PSH_NOAPPLYNOW | PSH_HASHELP;
	header.hwndParent = hWnd;
	header.pszCaption = "modtool";
	header.nPages = PROPERTY_SHEET_COUNT;
	header.nStartPage = 0;
	header.ppsp = &pages[0];

	// make the property sheet and exit
	PropertySheet(&header);
}