// BEGIN FLOCK TRI-LICENSE
//
// Version: MPL 1.1/GPL 2.0/LGPL 2.1
//
// The contents of this file are subject to the Mozilla Public License Version
// 1.1 (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// The Original Code is Netscape 9 to Firefox/Flock migrator extension code.
//
// The Initial Developer of the Original Code is
// Flock Inc.
// Portions created by the Initial Developer are Copyright (C) 2005-2008
// the Initial Developer. All Rights Reserved.
//
// Contributor(s):
//
// Alternatively, the contents of this file may be used under the terms of
// either of the GNU General Public License Version 2 or later (the "GPL"),
// or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
// in which case the provisions of the GPL or the LGPL are applicable instead
// of those above. If you wish to allow use of your version of this file only
// under the terms of either the GPL or the LGPL, and not to allow others to
// use your version of this file under the terms of the MPL, indicate your
// decision by deleting the provisions above and replace them with the notice
// and other provisions required by the GPL or the LGPL. If you do not delete
// the provisions above, a recipient may use your version of this file under
// the terms of any one of the MPL, the GPL or the LGPL.
//
// END FLOCK TRI-LICENSE

const CC = Components.classes;
const CI = Components.interfaces;

const PREF_FIRSTRUN = "ns9migrator.firstrun";
const PREF_HIDDEN = "ns9migrator.hidden";
const MIGRATE_FLOCK_DIALOG = "chrome://ns9migrator/content/dialog.xul";
const GENERIC_DIALOG = "chrome://ns9migrator/content/genericDialog.xul";
const FLOCK_FILENAME_PREFIX = "flock-ns";
const METRICS_HTTP_URL = "http://metrics.flock.com/flock-ns?";
const MIGRATE_FLOCK_GUID = "flock.first_run.bigDate";

// Data object
var gFlockNUTSObject = {
  mPromptService: CC["@mozilla.org/embedcomp/prompt-service;1"]
                  .getService(CI.nsIPromptService),

  // Are we initialized already
  mInitialized: false,

  mDownloadFile: null,
  mDownloadFileMD5: null,
  mMD5URL: null,
  mDownloadFilePersistentDescriptor: null,
  mMD5Req: null,
  mDownloadObserver: null,
  mLaunched: false,

  // Operating system object - remains the same for every instance
  mOSFileData: [],

  // GUID to tie install
  mGUID: 0,

  mDontShowMeAgain: false,
  mRemindMeLater: false,
  mMD5Override: false,

  // Did the user choose Flock?
  mChoseFlock: false,

  // For failing retries on payload (installer)
  mPayloadTries: 0,
  mPayloadTriesTotal: 0,

  // Random time between 1 second and 30 seconds
  mPayloadDelayTime: Math.random() * (30000 - 1000) + 1000,
  // Random time between 30 seconds and 5 minutes
  mPayloadDelayTimeFailover: Math.random() * (300000 - 30000) + 30000,

  mPayloadURLArray: ["http://downloads-ns.flock.com/flockinc/downloads/",
                     "http://downloads-ns1.flock.com/flockinc/downloads/",
                     "http://downloads-ns2.flockstar.net/flockinc/downloads/",
                     "http://s3.amazonaws.com/flockinc/downloads/"],

  // For failing retries on MD5
  mMD5Tries: 0,
  mMD5TriesTotal: 0,
  // Random time between 1 second and 30 seconds
  mMD5DelayTime: Math.random() * (30000 - 1000) + 1000,
  mMD5URLArray: ["https://secure.flock.com/flockinc/downloads/md5sum/",
                 "https://s3.amazonaws.com/flockinc/downloads/md5sum/",
                 "https://login.flock.com/flockinc/downloads/md5sum/"]

};

var migrateFlock = {
  _init: function initFunction(aForceOpen) {

    gFlockNUTSObject.mMD5Override = false;

    var prefService = CC["@mozilla.org/preferences-service;1"]
                      .getService(CI.nsIPrefBranch);

    if (!prefService.getPrefType(MIGRATE_FLOCK_GUID)) {
      var uuidGen = CC["@mozilla.org/uuid-generator;1"]
                    .createInstance(CI.nsIUUIDGenerator);
      var uuid;
      try {
        uuid = uuidGen.generateUUID();
      } catch (ex) {
        uuid = 0;
      }

      gFlockNUTSObject.mGUID = String(uuid).replace(/[{}]/g, "");
      prefService.setCharPref(MIGRATE_FLOCK_GUID, gFlockNUTSObject.mGUID);
    } else {
      gFlockNUTSObject.mGUID = prefService.getCharPref(MIGRATE_FLOCK_GUID);
    }

    // If we're already initialized, just launch the dialog
    if (gFlockNUTSObject.mInitialized) {
      launchDialog();
      return;
    }

    gFlockNUTSObject.mInitialized = true;

    // Detect which os we're running and setup the file data
    setupFileParams();

    // Observes for any download completed event.  If it's the same download
    // event that we started (either Firefox or Flock) then do the MD5 check
    // before we launch the installer.
    gFlockNUTSObject.mDownloadObserver = {
      observe: function downloadObserver(aSubject, aTopic, aState) {

        if (aTopic == "dl-cancel") {
          var dl = aSubject.QueryInterface(CI.nsIDownload);
          if (dl == gFlockNUTSObject.mDownloadFile) {
            var dlm = CC["@mozilla.org/download-manager;1"]
                      .getService(CI.nsIDownloadManager);
            dlm.removeDownload(gFlockNUTSObject
                                 .mDownloadFilePersistentDescriptor);
          }
        } else if (aTopic == "dl-done") {
          if (gFlockNUTSObject.mDownloadFile.percentComplete == "100") {
            // Check to see if file exists.  If it does not exist we have
            // serious problems (DNS possibly).  Try downloading again.
            if (!gFlockNUTSObject.mDownloadFile.targetFile.exists()) {
              var dlm = CC["@mozilla.org/download-manager;1"]
                        .getService(CI.nsIDownloadManager);
              dlm.removeDownload(gFlockNUTSObject
                                 .mDownloadFilePersistentDescriptor);

              retryPayload();

              return;
            }

            // Generate MD5 and see if all the bits are ok.
            var md5 = generateMD5(gFlockNUTSObject.mDownloadFile.targetFile);
            var md5Match = false;

            // If override is set, don't bother checking.
            if (gFlockNUTSObject.mMD5Override) {
              md5Match = true;
            } else {
              md5Match = doesMD5Match(md5, gFlockNUTSObject.mDownloadFileMD5);
            }

            var dialogParams = {
              choseFlock: gFlockNUTSObject.mChoseFlock
            };

            if (md5Match) {
              sendMetrics(false);
              // Show Launching Dialog
              var dialogParams = {
                choseFlock: gFlockNUTSObject.mChoseFlock
              };
              var retVals = {
                stayWithNetscape: null
              };
              window.openDialog(GENERIC_DIALOG,
                                "Generic Dialog",
                                "modal,centerscreen,close=no",
                                dialogParams,
                                retVals);

              // Launch the installer!
              var prefService = CC["@mozilla.org/preferences-service;1"]
                                .getService(CI.nsIPrefBranch);
              try {
                // Tie this to a specific install
                // flock.first_run.bigDate (charpref)
                gFlockNUTSObject.mLaunched = true;
                gFlockNUTSObject.mDownloadFile.targetFile.launch();

                // Don't bug them again about installing a browser.
                prefService.setBoolPref(PREF_HIDDEN, true);

                var statusBar
                  = document.getElementById("flockUpdatesAvailableID");
                statusBar.setAttribute("hidden", "true");

                CC["@mozilla.org/toolkit/app-startup;1"]
                  .getService(CI.nsIAppStartup)
                  .quit(CI.nsIAppStartup.eAttemptQuit);
              } catch (ex) {
                // Try again next startup - either user cancelled the process
                // or something else happened.  Just fail silently in this
                // case.  Prompt for install on next run as well.
                prefService.setBoolPref(PREF_HIDDEN, false);
              }
            } else {
              // Something bad with the hash.
              if (gFlockNUTSObject.mChoseFlock) {
                retryPayload();
              } else {
                var sb = CC["@mozilla.org/intl/stringbundle;1"]
                         .getService(CI.nsIStringBundleService)
                         .createBundle("chrome://ns9migrator/locale/migrator.properties");

                gFlockNUTSObject.mPromptService
                                .alert(window,
                                       sb.GetStringFromName("md5FailTitle"),
                                       sb.GetStringFromName("md5FailDescription"));

                launchDialog();
              }
            }
          }
        }
      }
    };

    var observerService = CC["@mozilla.org/observer-service;1"]
                          .getService(CI.nsIObserverService);
    observerService.addObserver(gFlockNUTSObject.mDownloadObserver,
                                "dl-done",
                                false);
    observerService.addObserver(gFlockNUTSObject.mDownloadObserver,
                                "dl-cancel",
                                false);

    // Make sure we're the only instance
    var hiddenWindow = CC["@mozilla.org/appshell/appShellService;1"]
                       .getService(CI.nsIAppShellService)
                       .hiddenDOMWindow;

    if (hiddenWindow.migrateFlockStatus) {
      return;
    }
    hiddenWindow.migrateFlockStatus = "ready";

    var prefService = CC["@mozilla.org/preferences-service;1"]
                      .getService(CI.nsIPrefBranch);

    if (!aForceOpen &&
        prefService.getPrefType(PREF_HIDDEN) &&
        prefService.getBoolPref(PREF_HIDDEN))
    {
      return;
    }

    launchDialog();
  },
  _uninit: function uninitFunction() {
    var observerService = CC["@mozilla.org/observer-service;1"]
                          .getService(CI.nsIObserverService);
    observerService.removeObserver(gFlockNUTSObject.mDownloadObserver,
                                   "dl-done");
    observerService.removeObserver(gFlockNUTSObject.mDownloadObserver,
                                   "dl-cancel");
  }
};

// Tries to download again.
function retryPayload() {
  // Increment our trying index to key the next URL in the array.
  gFlockNUTSObject.mPayloadTries++;
  gFlockNUTSObject.mPayloadTriesTotal++;
  if (gFlockNUTSObject.mPayloadTries >= gFlockNUTSObject.mPayloadURLArray
                                                        .length)
  {
    gFlockNUTSObject.mPayloadTries = 0;
    gFlockNUTSObject.mPayloadDelayTime
      = gFlockNUTSObject.mPayloadDelayTimeFailover;
  }

  function retryDownload() {
    initiateDownload(false);
  }
  setTimeout(retryDownload, gFlockNUTSObject.mPayloadDelayTime);
}

// Launches the main End of Support Dialog
function launchDialog() {
  var prefService = CC["@mozilla.org/preferences-service;1"]
                    .getService(CI.nsIPrefBranch);

  var showHideOption = false;
  if (prefService.getPrefType(PREF_FIRSTRUN)) {
    // Subsequent runs
    showHideOption = true;
  } else {
    // First run
    prefService.setBoolPref(PREF_FIRSTRUN, true);
  }

  // Open the dialog
  function launchDialogCB() {
    var retVals = {
      choseFlock: false,
      remindMeLater: true,
      dontShowAgain: false
    };

    var win = window.openDialog(MIGRATE_FLOCK_DIALOG,
                                "End of Support",
                                "modal,centerscreen",
                                showHideOption,
                                retVals);

    if (retVals.remindMeLater) {
      gFlockNUTSObject.mRemindMeLater = true;
      sendMetrics(true);
      return;
    } else if (retVals.dontShowMeAgain) {
      gFlockNUTSObject.mDontShowMeAgain = true;
      sendMetrics(true);
      return;
    }

    gFlockNUTSObject.mChoseFlock = retVals.choseFlock;

    initiateDownload(true);
  }

  // Required in order to make dialog modal
  setTimeout(launchDialogCB, 500);
}

// Detect which operating system we're in
function setupFileParams() {
  var xulRuntime = CC["@mozilla.org/xre/app-info;1"]
                   .getService(CI.nsIXULRuntime);

  switch (xulRuntime.OS) {
    case "WINNT":
      gFlockNUTSObject.mOSFileData.osLabel = "win";
      gFlockNUTSObject.mOSFileData.osFileSuffix = ".exe";
      gFlockNUTSObject.mOSFileData.specialFolder = "Pers";
      break;
    case "Darwin":
      gFlockNUTSObject.mOSFileData.osLabel = "mac";
      gFlockNUTSObject.mOSFileData.osFileSuffix = ".dmg";
      gFlockNUTSObject.mOSFileData.specialFolder = "UsrDocs";
      break;
    case "Linux":
      gFlockNUTSObject.mOSFileData.osLabel = "linux";
      gFlockNUTSObject.mOSFileData.osFileSuffix = ".tar.gz";
      gFlockNUTSObject.mOSFileData.specialFolder = "Home";
      break;
    default:
      gFlockNUTSObject.mPromptService
                      .alert(window,
                             "OS not detected",
                             "Sorry, we had a problem detecting your Operating System.");
      return;
  }
}

/**
 * Initiates a payload download
 *
 * @param aGrabMD5: true if we are supposed to grab the MD5 first.
 *                  false if we should just go for the payload, this means we
 *                  have already successfully download the MD5.
 */
function initiateDownload(aGrabMD5) {
  var sourceUri = CC["@mozilla.org/network/standard-url;1"]
                  .createInstance(CI.nsIURI);

  var filename;
  if (gFlockNUTSObject.mChoseFlock) {
    // Choose Flock
    // Need to make sure we're setting up the right label - we're not in sync
    // with what MoCo uses.
    gFlockNUTSObject.mOSFileData.osLabel
      = gFlockNUTSObject.mOSFileData.osLabel.replace("osx", "mac");

    sourceUri.spec
      = gFlockNUTSObject.mPayloadURLArray[gFlockNUTSObject.mPayloadTries]
        + gFlockNUTSObject.mOSFileData.osLabel + "/"
        + FLOCK_FILENAME_PREFIX
        + gFlockNUTSObject.mOSFileData.osFileSuffix;
    filename
      = FLOCK_FILENAME_PREFIX + gFlockNUTSObject.mOSFileData.osFileSuffix;
  } else {
    // Choose Firefox
    // We don't use the same name for mac as Mozilla does.
    gFlockNUTSObject.mOSFileData.osLabel
      = gFlockNUTSObject.mOSFileData.osLabel.replace("mac", "osx");

    sourceUri.spec = "http://download.mozilla.org/?product=netscape9-firefox"
                     + "&os="
                     + gFlockNUTSObject.mOSFileData.osLabel
                     + "&lang=en-US";

    // Hack the following because we want to preserve any datatracking.
    var url = "http://www.mozilla.com/en-US/products/download.html"
              + "?product=netscape9-firefox&os="
              + gFlockNUTSObject.mOSFileData.osLabel
              + "&lang=en-US"; 
    var urlReq = CC["@mozilla.org/xmlextras/xmlhttprequest;1"]
                 .createInstance(CI.nsIXMLHttpRequest);
    urlReq.QueryInterface(CI.nsIJSXMLHttpRequest);
    urlReq.open("GET", url, true);
    urlReq.send(null);
 
    filename = "firefox-installer" + gFlockNUTSObject.mOSFileData.osFileSuffix;
  }

  if (aGrabMD5) {
    sendMD5Request(sourceUri.spec, filename);
  } else {
    startDownload(sourceUri.spec, filename);
  }
}

/**
 * Responsible for downloading the MD5
 *
 * @param aURI: The URL of the MD5.
 * @param aFilename: The filename which the payload will be saved as.
 */
function sendMD5Request(aURI, aFilename) {
  // If we are in choseFlock mode, we check the bouncy urls because we'll be
  // iterating through them.  With Firefox, we don't care so if it fails we
  // will bail anyways.
  if (gFlockNUTSObject.mChoseFlock) {
    if (gFlockNUTSObject.mMD5Tries >= gFlockNUTSObject.mMD5URLArray.length) {
      // Start at the first mirror again increment the delay count.
      gFlockNUTSObject.mMD5Tries = 0;
    }

    gFlockNUTSObject.mMD5URL
      = gFlockNUTSObject.mMD5URLArray[gFlockNUTSObject.mMD5Tries]
        + gFlockNUTSObject.mOSFileData.osLabel + "/"
        + FLOCK_FILENAME_PREFIX + ".txt";
  } else {
    gFlockNUTSObject.mMD5URL =
      "http://releases.mozilla.org/pub/mozilla.org/firefox/releases/2.0.0.12/MD5SUMS";
  }

  var listener = {
    onSuccess: function onSuccessFunc(aResponseText) {
      gFlockNUTSObject.mDownloadFileMD5 = aResponseText;

      // Success!  Ok, let's start the download.
      startDownload(aURI, aFilename);
    },
    onError: function onError(aStatus, aErrorData) {
      if (gFlockNUTSObject.mChoseFlock) {
        gFlockNUTSObject.mMD5Tries++;
        gFlockNUTSObject.mMD5TriesTotal++;

        // If we fail too may times, let the user know to try again later.
        if (gFlockNUTSObject.mMD5TriesTotal > gFlockNUTSObject.mMD5URLArray
                                                              .length * 5)
        {
          gFlockNUTSObject.mMD5Override = true;

          startDownload(aURI, aFilename);
          return;
        }

        function timeoutFunc() {
          sendMD5Request(aURI, aFilename);
        }
        setTimeout(timeoutFunc, gFlockNUTSObject.mMD5DelayTime);
      } else {
        // They chose Firefox.  We only have one URL to check.. doh.
        gFlockNUTSObject.mPromptService
                        .alert(window,
                               "Connection Error",
                               "We couldn't verify the integrity of the Firefox download.");
        return;
      }
    }
  }
  listener.listener = listener;

  getMD5(listener, gFlockNUTSObject.mMD5URL);
}

/**
 * Generates an MD5 based on the incoming file
 * 
 * @param aFile: File to generate MD5 from
 */
function generateMD5(aFile) {
  var fileStream = CC["@mozilla.org/network/file-input-stream;1"]
                   .createInstance(CI.nsIFileInputStream);
  fileStream.init(aFile, 0x01, 0444, 0);

  var cryptoHash = CC["@mozilla.org/security/hash;1"]
                   .createInstance(CI.nsICryptoHash);
  cryptoHash.init(cryptoHash.MD5);
  cryptoHash.updateFromStream(fileStream, 0xffffffff);

  var hash = cryptoHash.finish(false);

  function toHexString(charCode) {
    return ("0" + charCode.toString(16)).slice(-2);
  }

  // convert the binary hash data to a hex string.
  var hexHash = [toHexString(hash.charCodeAt(i)) for (i in hash)].join("");

  return hexHash;
}

/**
 * Initiates a download by adding it to the download manager.  Uses a basic
 * transfer window to show progress.
 *
 * @param aURL: The url to download
 * @param aDestFile: The destination filename (does not contain path)
 */
function startDownload(aURL, aDestFile) {
  // convert string filepath to an nsIFile
  var file = CC["@mozilla.org/file/directory_service;1"]
             .getService(CI.nsIProperties)
             .get(gFlockNUTSObject.mOSFileData.specialFolder, CI.nsILocalFile);
  file.append(aDestFile);

  var io = CC["@mozilla.org/network/io-service;1"]
           .getService(CI.nsIIOService);
  var source = io.newURI(aURL, null, null);
  var target = io.newFileURI(file)

  var persist = CC["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"]
                .createInstance(CI.nsIWebBrowserPersist);

  persist.persistFlags = CI.nsIWebBrowserPersist
                           .PERSIST_FLAGS_REPLACE_EXISTING_FILES;

  var xfer = CC["@mozilla.org/transfer;1"]
             .createInstance(CI.nsITransfer);
  xfer.init(source, target, "", null, null, null, persist);
  persist.progressListener = xfer;

  persist.saveURI(source, null, null, null, null, file);
  try {
    var dlm = CC["@mozilla.org/download-manager;1"]
              .getService(CI.nsIDownloadManager);
    gFlockNUTSObject.mDownloadFile
      = dlm.getDownload(file.path).QueryInterface(CI.nsIDownload);

    gFlockNUTSObject.mDownloadFilePersistentDescriptor = file.path;
  } catch (ex) {
    // Try again next startup
    alert(ex);
  }
}

/**
 * Requests the MD5 and stores it in a global variable
 *
 * @param aListener: callback function for handling error/success
 * @param aURL: The URL where the MD5 is located
 */
function getMD5(aListener, aURL) {
  gFlockNUTSObject.mMD5Req = CC["@mozilla.org/xmlextras/xmlhttprequest;1"]
                             .createInstance(CI.nsIXMLHttpRequest);
  gFlockNUTSObject.mMD5Req.QueryInterface(CI.nsIJSXMLHttpRequest);
  gFlockNUTSObject.mMD5Req.open("GET", aURL, true);
  var req = gFlockNUTSObject.mMD5Req;
  gFlockNUTSObject.mMD5Req.onreadystatechange = function orstFunction(aEvent) {
    if (req.readyState == 4) {
      try {
        if (req.status/100 == 2) {
          try {
            //gDownloadFileMD5 = req.responseText;
            aListener.onSuccess(req.responseText);
          } catch (e) {
            // error parsing response
            aListener.onError(req.status, e);
          }
        } else {
          // HTTP Errors
          aListener.onError(req.status, gFlockNUTSObject.mMD5URL);
        }
      } catch (ex) {
        // XMLHTTPRequest Error (connection)
        aListener.onError(req.status, ex);
      }
    }
  };
 
  gFlockNUTSObject.mMD5Req.send(null);
}

/**
 * Send metrics to the metrics server
 * @param aStartupMetrics: true if we only want to send startup metrics,
 *                         false if we want everything.
 */
function sendMetrics(aStartupMetrics) {
  var url = METRICS_HTTP_URL;

  if (aStartupMetrics) {
    url += "g=" + gFlockNUTSObject.mGUID
           + "&h=" + gFlockNUTSObject.mDontShowMeAgain
           + "&i=" + gFlockNUTSObject.mRemindMeLater;
  } else {
    url += "a=" + gFlockNUTSObject.mChoseFlock
           + "&b=" + gFlockNUTSObject.mLaunched
           + "&c=" + gFlockNUTSObject.mPayloadTries
           + "&d=" + gFlockNUTSObject.mPayloadTriesTotal
           + "&e=" + gFlockNUTSObject.mMD5Tries
           + "&f=" + gFlockNUTSObject.mMD5TriesTotal
           + "&g=" + gFlockNUTSObject.mGUID;
  }

  var urlReq = CC["@mozilla.org/xmlextras/xmlhttprequest;1"]
               .createInstance(CI.nsIXMLHttpRequest);
  urlReq.QueryInterface(CI.nsIJSXMLHttpRequest);
  urlReq.open("GET", url , true);
  urlReq.send(null);
}

/**
 * Determines whether the MD5 hash exists somewhere in the contents of the
 * MD5 list.
 *
 * @param aMD5: MD5 hash to look for
 * @param aMD5List: Contains a list of MD5s to check aMD5 against
 */
function doesMD5Match(aMD5, aMD5List) {
  // Check for substring match on aMD5 in aMD5List
  return (aMD5List.indexOf(aMD5) != -1);
}

function setupDelayedLoading() {
  migrateFlock._init(false);
  window.addEventListener("unload",
                          function(e) { migrateFlock._uninit() }, false);
}

// Don't let everyone launch all at the same time.  The time span is randomized
// between 1 second and 1 hour
var randomEventTime = Math.random() * (3600000 - 1000) + 1000;
setTimeout(setupDelayedLoading, randomEventTime);
