// BEGIN FLOCK TRI-LICENSE
//
// Version: MPL 1.1/GPL 2.0/LGPL 2.1
//
// The contents of this file are subject to the Mozilla Public License Version
// 1.1 (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// The Original Code is Netscape 9 to Firefox/Flock migrator extension code.
//
// The Initial Developer of the Original Code is
// Flock Inc.
// Portions created by the Initial Developer are Copyright (C) 2005-2008
// the Initial Developer. All Rights Reserved.
//
// Contributor(s):
//
// Alternatively, the contents of this file may be used under the terms of
// either of the GNU General Public License Version 2 or later (the "GPL"),
// or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
// in which case the provisions of the GPL or the LGPL are applicable instead
// of those above. If you wish to allow use of your version of this file only
// under the terms of either the GPL or the LGPL, and not to allow others to
// use your version of this file under the terms of the MPL, indicate your
// decision by deleting the provisions above and replace them with the notice
// and other provisions required by the GPL or the LGPL. If you do not delete
// the provisions above, a recipient may use your version of this file under
// the terms of any one of the MPL, the GPL or the LGPL.
//
// END FLOCK TRI-LICENSE

const CC = Components.classes;
const CI = Components.interfaces;

const MIGRATE_FLOCK_HIDDEN = "ns9migrator.hidden";
const MIGRATE_FLOCK_GENERIC_DIALOG = "chrome://ns9migrator/content/genericDialog.xul";

function onLoad() {
  var showHideOption = window.arguments[0];

  if (!showHideOption) {
    document.getElementById("dontShowID").setAttribute("hidden", true);
  }

  window.sizeToContent();
}

function dontShowAgain() {
  var retVals = {
    stayWithNetscape: null
  };

  window.openDialog(MIGRATE_FLOCK_GENERIC_DIALOG,
                    "Migrate Netscape",
                    "modal,centerscreen,close=no",
                    "dontShow",
                    retVals);

  if (retVals.stayWithNetscape) {
    var returnVals = window.arguments[1];
    returnVals.dontShowMeAgain = true;
    var prefService = CC["@mozilla.org/preferences-service;1"]
                      .getService(CI.nsIPrefBranch);

    prefService.setBoolPref(MIGRATE_FLOCK_HIDDEN, true);
    window.close();
  }
}

function remindMeLater() {
  var retVals = window.arguments[1];
  retVals.remindMeLater = true;
  window.close();
}

function startDownload(aChoseFlock) {
  var retVals = window.arguments[1];
  retVals.choseFlock = aChoseFlock;
  retVals.remindMeLater = false;
  window.close();
}

window.onload = onLoad;
