// BEGIN FLOCK TRI-LICENSE
//
// Version: MPL 1.1/GPL 2.0/LGPL 2.1
//
// The contents of this file are subject to the Mozilla Public License Version
// 1.1 (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// The Original Code is Netscape 9 to Firefox/Flock migrator extension code.
//
// The Initial Developer of the Original Code is
// Flock Inc.
// Portions created by the Initial Developer are Copyright (C) 2005-2008
// the Initial Developer. All Rights Reserved.
//
// Contributor(s):
//
// Alternatively, the contents of this file may be used under the terms of
// either of the GNU General Public License Version 2 or later (the "GPL"),
// or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
// in which case the provisions of the GPL or the LGPL are applicable instead
// of those above. If you wish to allow use of your version of this file only
// under the terms of either the GPL or the LGPL, and not to allow others to
// use your version of this file under the terms of the MPL, indicate your
// decision by deleting the provisions above and replace them with the notice
// and other provisions required by the GPL or the LGPL. If you do not delete
// the provisions above, a recipient may use your version of this file under
// the terms of any one of the MPL, the GPL or the LGPL.
//
// END FLOCK TRI-LICENSE

const CC = Components.classes;
const CI = Components.interfaces;

function onLoad() {
  var sb = CC["@mozilla.org/intl/stringbundle;1"]
           .getService(CI.nsIStringBundleService)
           .createBundle("chrome://ns9migrator/locale/migrator.properties");

  var stayWithNS = sb.GetStringFromName("stayWithNS");
  var upgrade = sb.GetStringFromName("upgrade");
  var downloadComplete;
  var xulRuntime = CC["@mozilla.org/xre/app-info;1"]
                   .getService(CI.nsIXULRuntime);
  if (xulRuntime.OS == "Darwin") {
    downloadComplete = sb.GetStringFromName("downloadComplete.mac");
  } else {
    downloadComplete = sb.GetStringFromName("downloadComplete");
  }
  var dontShowDescription = sb.GetStringFromName("dontShowDescription");
  var okLabel = sb.GetStringFromName("okLabel");

  var dialogType = window.arguments[0];
  if (dialogType == "dontShow") {
    var desc = document.getElementById("descriptionID");
    var textNode = document.createTextNode(dontShowDescription);
    desc.appendChild(textNode);
    document.getElementById("firstButtonID")
            .setAttribute("label", stayWithNS);
    document.getElementById("secondButtonID")
            .setAttribute("label", upgrade);
  } else {
    // Download has completed
    var params = window.arguments[0];
    if (!params.choseFlock) {
      // Hack to use the same localization string to replace the Product Name.
      downloadComplete = downloadComplete.replace(/%product%/g, "Firefox");
    } else {
      downloadComplete = downloadComplete.replace(/%product%/g, "Flock");
    }

    var desc = document.getElementById("descriptionID");
    var textNode = document.createTextNode(downloadComplete);
    desc.appendChild(textNode);
    document.getElementById("firstButtonID")
            .setAttribute("hidden", true);
    document.getElementById("secondButtonID")
            .setAttribute("label", okLabel);
  }

  window.sizeToContent();
}

function buttonOneClicked() {
  var retVals = window.arguments[1];
  retVals.stayWithNetscape = true;
  window.close();
}

function buttonTwoClicked() {
  var retVals = window.arguments[1];
  retVals.stayWithNetscape = false;
  window.close();
}
