/*****************************************************************************
 * sapserver.cpp : SAP discovery service mini-server
 ****************************************************************************
 * Copyright (C) 1998-2002 VideoLAN
 * $Id: sapserver.cpp,v 1.5 2003/05/18 11:58:59 zorglub Exp $ 
 *
 * Authors: Fabrice Ollivier <cif@via.ecp.fr>
 *          Arnaud Schauly <gitan@via.ecp.fr>
 *          Clment Stenac <zorglub@via.ecp.fr>
 *	    
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <stdio.h>
#include <pthread.h>

#define PROGRAM_NAME "mini-SAP-Server"
#define VERSION "0.1.2"

#define DELAY 1 /* wait DELAY seconds before each sending */

#define HELLO_PORT 9875
#define HELLO_GROUP "224.2.127.254"
#define MSGBUFSIZE 256

#define DEFAULT_CONF "/etc/sap.cfg" 

unsigned int ttl=10;  /* Default TTL */

struct prog
{
    char name[128];
    char user[128];
    char machine[128];
    char site[128];
    char address[128];
    prog *Next;
    prog *Prev;
};


class itemlist {
    protected :
        unsigned long nbr;
        prog *firstitem;
        prog *lastitem;
    public :
        itemlist();
        ~itemlist();
        void add(prog *itemp);
        unsigned long count() { return nbr; };
        prog* getfirst() {return firstitem; };
};

itemlist::itemlist()
{
    nbr=0;
    firstitem=NULL;
    lastitem=NULL;
}

itemlist::~itemlist()
{
}

void itemlist::add(prog *itemp)
{
    if(lastitem == NULL)
    {
        itemp->Next = NULL;itemp->Prev = NULL;
        firstitem = itemp;
    }
    else
    {
    lastitem->Next = itemp;itemp->Prev=lastitem;
    itemp->Next = NULL;
    }
    lastitem=itemp;
    nbr++;
}

/**********************************************************
 * Gets what is before delim in source. Puts it into dest *
 **********************************************************/
void strgetb(char *source,char *dest,char delim) 
{
        unsigned long i = 0;
        while(source[i] != delim && i < strlen(source))
        {
                dest[i]=source[i];
                i++;
        }
        dest[i]=0;
}

/********************************************************** 
 * Gets what is before delim in source. Puts it into dest * 
 **********************************************************/ 
void strgeta(char *source,char *dest,char delim) 
{
    unsigned long i=0,j=0;
    dest[0]=0;
    while(source[i] != delim && i < strlen(source))
    {
        i++;
    }
    i++;
    if(i>=strlen(source))
    {
        return;
    }
    while(i < strlen(source))
    {
        if(source[i]!='\n') dest[j]=source[i];
        else dest[j]=0;
        j++;i++;
    }
    dest[j]=0;
}


/********************************************************************
  Reads the configuration file and fills the program list
*********************************************************************/
int parse(char *path,itemlist *progs)
{
    FILE *fichier;
    char ligne[1024];
    char tligne[1024];
    prog * pp=new prog;
    unsigned int something=0;

    fichier=fopen(path,"r");
    if(!fichier)
    {
        printf("Unable to open %s\n",path);
        return(-1);
    }

    while(!feof(fichier))
    {
        memset(ligne,'0',1024);
        fgets(ligne,1024,fichier);
        if(!strlen(ligne)) 
        {
            break;
        }

	strgetb(ligne,ligne,'#'); /* Handle the comments */

        if(strstr(ligne,"ttl=")) 
	{
		strgeta(ligne,tligne,'=');
		ttl=atoi(tligne);
	}
        if(strstr(ligne,"[program]")) 
        {
            if(something) /* We were in a program with at least one field filled */
            {
                progs->add(pp);
                pp=new prog;
                something=0;
            }
        }

        if(strstr(ligne,"name=")) 
        {
            strgeta(ligne,tligne,'=');
            something=1;
            strcpy(pp->name,tligne);
        }

        if(strstr(ligne,"user=")) 
        {
            strgeta(ligne,tligne,'=');
            something=1;
            strcpy(pp->user,tligne);
        }

        if(strstr(ligne,"machine=")) 
        {
            strgeta(ligne,tligne,'=');
            something=1;
            strcpy(pp->machine,tligne);
        }
 
        if(strstr(ligne,"site=")) 
        {
            strgeta(ligne,tligne,'=');
            something=1;
            strcpy(pp->site,tligne);
        }

        if(strstr(ligne,"address=")) 
        {
            strgeta(ligne,tligne,'=');
            something=1;
	    strcpy(pp->address,tligne);
        }
    }

    if(something) progs->add(pp);
    return(0);
}

/*************************************************
 * Display the help
 *************************************************/
void help(void)
{
  printf("Options:
  -d : Use this to daemonize the process (run in the background)
  -f or -c: Use this to give a configuration file (default is %s)
  -h: Display this help\n"   ,DEFAULT_CONF);
}
/*************************************************
 * The main function
 *************************************************/
int main(int argc, char *argv[])
{
   struct sockaddr_in addr;
   int fd;
   int result;
   char getopt_string[128];
   char conffile[256];
   char message[4096];
   bool godaemon;

   itemlist *progs=new itemlist;
   printf("%s Version %s\n",PROGRAM_NAME,VERSION);
   sprintf(conffile,DEFAULT_CONF);

   /* Parse the command line */
   sprintf(getopt_string,"dhf:c:");
   while(result !=-1)
    {
        result=getopt(argc,argv,getopt_string);
	if(result=='c' || result=='f') 
	{
		sprintf(conffile,optarg);
	}
	if(result=='d') 
	{
	   godaemon=1;
        }
	if(result=='h')
	{
	   help();return(0);
	}
    }
    /* Get the programs */
    printf("Parsing configuration file\n");
    if(parse(conffile,progs)) 
	return(-1);
    printf("%ld programs loaded\n",progs->count());
    printf("Packet TTL set to %i\n",ttl);
    prog *pp;

    /* Prepare the socket */
    printf("Setting up the socket\n");
    if ((fd=socket(AF_INET,SOCK_DGRAM,0)) < 0) 
    {
      	perror("socket");
	exit(1);
    }

    /* set up destination address */
    memset(&addr,0,sizeof(addr));
    addr.sin_family=AF_INET;
    addr.sin_addr.s_addr=inet_addr(HELLO_GROUP);
    addr.sin_port=htons(HELLO_PORT);
    setsockopt( fd, IPPROTO_IP, IP_MULTICAST_TTL, &ttl, sizeof(ttl) );

    /* Begin sending */
    printf("Socket ready, sending started\n");
    if(godaemon) 
    {
	printf("Forking\n");daemon(0,0);
    }
    while(1)
    {	
        pp=progs->getfirst();
        /* Navigate through program-list */
        while(pp!=NULL)
        {	
            if(!strlen(pp->name) || !strlen(pp->address))
            {
                printf("Error, incomplete program info (no name or no address)\n");
                pp=pp->Next;
                exit(1);
            }
            /* Build the message */
            sprintf(message,"    ***øv=0 \n\
            o=%s 3247692199 3247895918 IN IP4 %s \n\
            s=%s\n\
            u=%s \n\
            t=3247691400 3250117800 \n\
            a=type:test   \n\
            m=audio 1234 udp 14 \n\
            c=IN IP4 %s/15  \n\
            xxxxxxxxxxxxxxxxxxxxx \n ",pp->user,pp->machine,pp->name, \
                pp->site,pp->address); 

            /* Send it through the socket */
            if (sendto(fd,message,strlen(message),0, \
                          (struct sockaddr *) &addr,sizeof(addr)) < 0) 
            {
                perror("sendto");
                return(-1);
            }
            pp=pp->Next;
        }
    sleep(DELAY); /* Wait DELAY second between each sending */
    }
}
