#!/usr/bin/perl

package eBay::API::XML::DataType::ItemSpecificDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ItemSpecificDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ItemSpecificDetailsType

=head1 DESCRIPTION

Details about custom Item Specifics validation rules.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ItemSpecificDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'MaxCharactersPerName', 'xs:int', '', '', '' ]
	, [ 'MaxCharactersPerValue', 'xs:int', '', '', '' ]
	, [ 'MaxItemSpecificsPerItem', 'xs:int', '', '', '' ]
	, [ 'MaxValuesPerName', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setMaxCharactersPerName()

The maximum number of characters the site supports per custom
Item Specific name.<br>
<br>
Related fields:<br>
Item.ItemSpecifics in AddItem<br>
ItemSpecifics in GetCategorySpecifics<br>
ItemSpecifics in GetItemRecommendations<br>

#    Argument: 'xs:int'

=cut

sub setMaxCharactersPerName {
  my $self = shift;
  $self->{'MaxCharactersPerName'} = shift
}

=head2 getMaxCharactersPerName()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getMaxCharactersPerName {
  my $self = shift;
  return $self->{'MaxCharactersPerName'};
}


=head2 setMaxCharactersPerValue()

The maximum number of characters the site supports per custom
Item Specific value.<br>
<br>
Related fields:<br>
Item.ItemSpecifics in AddItem<br>
ItemSpecifics in GetCategorySpecifics<br>
ItemSpecifics in GetItemRecommendations<br>

#    Argument: 'xs:int'

=cut

sub setMaxCharactersPerValue {
  my $self = shift;
  $self->{'MaxCharactersPerValue'} = shift
}

=head2 getMaxCharactersPerValue()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getMaxCharactersPerValue {
  my $self = shift;
  return $self->{'MaxCharactersPerValue'};
}


=head2 setMaxItemSpecificsPerItem()

The maximum number of custom Item Specifics allowed
when you list an item. Also the maximum returned per category in
GetCategorySpecifics and GetItemRecommendations. <br>
<br>
Related fields:<br>
Item.ItemSpecifics in AddItem<br>
ItemSpecifics in GetCategorySpecifics<br>
ItemSpecifics in GetItemRecommendations<br>

#    Argument: 'xs:int'

=cut

sub setMaxItemSpecificsPerItem {
  my $self = shift;
  $self->{'MaxItemSpecificsPerItem'} = shift
}

=head2 getMaxItemSpecificsPerItem()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getMaxItemSpecificsPerItem {
  my $self = shift;
  return $self->{'MaxItemSpecificsPerItem'};
}


=head2 setMaxValuesPerName()

The maximum number of values returned for each custom Item Specific
in GetCategorySpecifics and GetItemRecommendations.<br>
<br>
Related fields:<br>
ItemSpecifics in GetCategorySpecifics<br>
ItemSpecifics in GetItemRecommendations<br>

#    Argument: 'xs:int'

=cut

sub setMaxValuesPerName {
  my $self = shift;
  $self->{'MaxValuesPerName'} = shift
}

=head2 getMaxValuesPerName()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getMaxValuesPerName {
  my $self = shift;
  return $self->{'MaxValuesPerName'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
