/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  int limit;    /* The LIMIT value.  -1 if there is no limit */
  int offset;   /* The OFFSET.  0 if there is none */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };


#line 34 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqliteParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqliteParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqliteParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqliteParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqliteParserARG_STORE     Code to store %extra_argument into yypParser
**    sqliteParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 221
#define YYACTIONTYPE unsigned short int
#define sqliteParserTOKENTYPE Token
typedef union {
  sqliteParserTOKENTYPE yy0;
  TriggerStep * yy19;
  struct LimitVal yy124;
  Select* yy179;
  Expr * yy182;
  Expr* yy242;
  struct TrigEvent yy290;
  Token yy298;
  SrcList* yy307;
  IdList* yy320;
  ExprList* yy322;
  int yy372;
  struct {int value; int mask;} yy407;
  int yy441;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqliteParserARG_SDECL Parse *pParse;
#define sqliteParserARG_PDECL ,Parse *pParse
#define sqliteParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqliteParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 563
#define YYNRULE 293
#define YYERRORSYMBOL 131
#define YYERRSYMDT yy441
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */   264,  106,  262,  119,  123,  117,  121,  129,  131,  133,
 /*    10 */   135,  144,  146,  148,  150,  152,  154,  844,  426,  174,
 /*    20 */   143,  425,    2,    3,  839,  142,  129,  131,  133,  135,
 /*    30 */   144,  146,  148,  150,  152,  154,  247,  837,  427,  115,
 /*    40 */   104,  139,  127,  125,  156,  161,  157,  162,  166,  119,
 /*    50 */   123,  117,  121,  129,  131,  133,  135,  144,  146,  148,
 /*    60 */   150,  152,  154,  448,  361,  218,  263,  143,  363,  369,
 /*    70 */   374,  137,  142,  144,  146,  148,  150,  152,  154,  377,
 /*    80 */   857,    1,  562,    3,  396,  327,  115,  104,  139,  127,
 /*    90 */   125,  156,  161,  157,  162,  166,  119,  123,  117,  121,
 /*   100 */   129,  131,  133,  135,  144,  146,  148,  150,  152,  154,
 /*   110 */   482,  454,  444,  106,  143,  169,   20,  171,  172,  142,
 /*   120 */   310,   73,    4,    6,  402,   68,  398,   29,  248,   64,
 /*   130 */    46,  174,  497,  115,  104,  139,  127,  125,  156,  161,
 /*   140 */   157,  162,  166,  119,  123,  117,  121,  129,  131,  133,
 /*   150 */   135,  144,  146,  148,  150,  152,  154,   69,  193,   65,
 /*   160 */   101,   44,   54,   60,   62,  308,  331,  244,  175,  106,
 /*   170 */    20,  357,  333,  173,  640,   70,  359,  219,   36,   37,
 /*   180 */    21,   22,  510,  143,  181,  179,  303,  299,  142,   31,
 /*   190 */    20,  392,  177,   66,   67,  111,  358,  390,  112,  105,
 /*   200 */    69,  191,  115,  104,  139,  127,  125,  156,  161,  157,
 /*   210 */   162,  166,  119,  123,  117,  121,  129,  131,  133,  135,
 /*   220 */   144,  146,  148,  150,  152,  154,  388,  312,   73,  688,
 /*   230 */   306,  113,  183,  387,   21,   22,  230,  361,   52,  106,
 /*   240 */    20,  363,  369,  374,  361,  544,  542,   53,  363,  369,
 /*   250 */   374,  143,  377,  591,   21,   22,  142,  212,  338,  377,
 /*   260 */   169,   38,  171,  172,  356,  348,  535,   46,  534,  792,
 /*   270 */   115,  104,  139,  127,  125,  156,  161,  157,  162,  166,
 /*   280 */   119,  123,  117,  121,  129,  131,  133,  135,  144,  146,
 /*   290 */   148,  150,  152,  154,  790,   41,  336,  298,   44,   54,
 /*   300 */    60,   62,  308,  331,   21,   22,  197,  167,   20,  333,
 /*   310 */    58,   20,  395,  340,  343,  201,  169,  809,  171,  172,
 /*   320 */    59,  143,  337,  311,  339,  281,  142,  346,  347,   20,
 /*   330 */   205,   20,  639,  195,   35,  536,  537,  538,  842,   45,
 /*   340 */   115,  104,  139,  127,  125,  156,  161,  157,  162,  166,
 /*   350 */   119,  123,  117,  121,  129,  131,  133,  135,  144,  146,
 /*   360 */   148,  150,  152,  154,  300,  276,  148,  150,  152,  154,
 /*   370 */    71,  106,   21,   22,  430,   21,   22,   20,  443,  791,
 /*   380 */   441,  106,   40,  335,  169,  143,  171,  172,  330,  305,
 /*   390 */   142,   84,   86,   21,   22,   21,   22,   10,  572,  174,
 /*   400 */   254,   18,   83,   69,  115,  104,  139,  127,  125,  156,
 /*   410 */   161,  157,  162,  166,  119,  123,  117,  121,  129,  131,
 /*   420 */   133,  135,  144,  146,  148,  150,  152,  154,  467,  106,
 /*   430 */   661,  275,  143,  720,  295,  301,  169,  142,  171,  172,
 /*   440 */   539,   21,   22,  487,  449,  219,  459,  103,  232,  451,
 /*   450 */   282,  115,  104,  139,  127,  125,  156,  161,  157,  162,
 /*   460 */   166,  119,  123,  117,  121,  129,  131,  133,  135,  144,
 /*   470 */   146,  148,  150,  152,  154,   69,  417,  419,  418,  143,
 /*   480 */    95,  237,  312,  494,  142,  489,   47,  283,  259,   75,
 /*   490 */    10,   68,  189,  284,  209,   64,  289,   49,  115,  104,
 /*   500 */   139,  127,  125,  156,  161,  157,  162,  166,  119,  123,
 /*   510 */   117,  121,  129,  131,  133,  135,  144,  146,  148,  150,
 /*   520 */   152,  154,  196,  297,  193,  357,  429,  296,  169,   32,
 /*   530 */   171,  172,  391,   37,  175,  169,  276,  171,  172,  313,
 /*   540 */   316,  323,  325,  663,  106,  689,  245,  251,  143,  651,
 /*   550 */   181,  179,  292,  142,  386,  583,  491,  690,  177,   66,
 /*   560 */    67,  111,  184,  437,  112,  105,  213,  115,  164,  139,
 /*   570 */   127,  125,  156,  161,  157,  162,  166,  119,  123,  117,
 /*   580 */   121,  129,  131,  133,  135,  144,  146,  148,  150,  152,
 /*   590 */   154,  315,  726,   20,  106,  143,  333,  113,  183,  563,
 /*   600 */   142,   43,  278,  440,  170,  185,  330,  666,  560,  561,
 /*   610 */   249,  259,  103,  253,  115,  104,  139,  127,  125,  156,
 /*   620 */   161,  157,  162,  166,  119,  123,  117,  121,  129,  131,
 /*   630 */   133,  135,  144,  146,  148,  150,  152,  154,  800,   10,
 /*   640 */   252,  169,  143,  171,  172,  445,   97,  142,  560,  561,
 /*   650 */   216,  221,  217,  169,  313,  171,  172,   21,   22,   42,
 /*   660 */   159,  115,  227,  139,  127,  125,  156,  161,  157,  162,
 /*   670 */   166,  119,  123,  117,  121,  129,  131,  133,  135,  144,
 /*   680 */   146,  148,  150,  152,  154,  256,   73,  106,  816,  143,
 /*   690 */   169,  158,  171,  172,  142,  234,  397,  217,  545,  475,
 /*   700 */   273,  302,  274,  217,  266,  481,  315,   96,  653,  104,
 /*   710 */   139,  127,  125,  156,  161,  157,  162,  166,  119,  123,
 /*   720 */   117,  121,  129,  131,  133,  135,  144,  146,  148,  150,
 /*   730 */   152,  154,  106,  349,  291,  262,  143,  262,  264,   74,
 /*   740 */   262,  142,  533,  464,  320,  477,  319,  329,  341,  274,
 /*   750 */   481,  342,  137,  415,  416,  321,  266,  139,  127,  125,
 /*   760 */   156,  161,  157,  162,  166,  119,  123,  117,  121,  129,
 /*   770 */   131,  133,  135,  144,  146,  148,  150,  152,  154,    7,
 /*   780 */   322,   23,   25,   27,  394,   68,  267,   13,  393,   64,
 /*   790 */   518,  251,  106,  836,  344,  548,   14,  345,  458,  263,
 /*   800 */   520,  263,  106,   91,  263,  557,  266,  314,  168,  106,
 /*   810 */   462,   15,  443,   69,   16,  231,  276,  106,  193,  531,
 /*   820 */   174,  448,  276,  106,  276,   17,  529,  174,  175,  318,
 /*   830 */   106,   89,  106,   69,  276,  114,  286,   69,   68,  399,
 /*   840 */    69,  116,   64,  328,  181,  179,  106,  106,  118,  366,
 /*   850 */   163,  272,  177,   66,   67,  111,  215,  253,  112,  105,
 /*   860 */   276,  371,  467,  233,  120,  375,  219,  143,  498,  503,
 /*   870 */   444,  193,  142,  219,  486,  720,  401,   73,  453,   73,
 /*   880 */   420,  175,  278,  451,  252,  400,  106,  380,  278,   68,
 /*   890 */   278,  113,  183,   64,  225,  229,  106,  181,  179,  106,
 /*   900 */   278,   69,  106,  106,  122,  177,   66,   67,  111,  411,
 /*   910 */   106,  112,  105,  106,  124,  106,  106,  126,  106,  224,
 /*   920 */   128,  130,  193,  106,  106,  106,  278,  351,  132,  352,
 /*   930 */   831,  134,  175,  136,  138,  422,  141,  106,  367,  376,
 /*   940 */   274,  145,  147,  149,  113,  183,  793,  690,  181,  179,
 /*   950 */   106,  424,  106,  106,  424,  151,  177,   66,   67,  111,
 /*   960 */   106,  106,  112,  105,  106,  106,  808,  106,  153,  106,
 /*   970 */   155,  165,  106,  106,  106,  106,  106,  464,  176,  178,
 /*   980 */   852,  106,  180,  182,  106,  190,  293,  192,  245,  106,
 /*   990 */   210,  214,  226,  228,  241,  113,  183,  106,  474,  246,
 /*  1000 */   137,  690,  280,  372,  290,  274,  381,  412,  274,  106,
 /*  1010 */   471,  221,  832,  421,  438,  466,  274,  472,  480,  422,
 /*  1020 */   478,   73,  515,   69,  519,  255,  478,  479,  221,  690,
 /*  1030 */   540,  527,  508,  541,  516,   85,   39,  403,  406,  257,
 /*  1040 */   317,  404,  198,  407,  405,  221,  408,   69,  413,    5,
 /*  1050 */   824,  221,  211,  409,  817,  410,  546,  582,  258,  414,
 /*  1060 */    90,  547,  199,  260,  223,  829,  830,  261,  324,  200,
 /*  1070 */   815,   72,   34,  526,  222,  186,  423,  326,   94,   57,
 /*  1080 */   428,   56,  187,  188,  265,  202,  431,  554,  332,   88,
 /*  1090 */    33,  432,  433,  434,  279,  268,  436,  556,  435,   51,
 /*  1100 */   578,   30,  549,  270,  439,  798,  334,  269,  799,  203,
 /*  1110 */   442,  577,  204,  271,   28,  550,  447,  812,  446,   98,
 /*  1120 */   532,  450,  727,  728,  823,  452,  819,  576,   26,   81,
 /*  1130 */    82,  445,  235,  838,   80,  457,  575,  463,  461,  455,
 /*  1140 */    24,  456,  551,   93,  813,  460,  277,  840,  465,  528,
 /*  1150 */    79,  206,  807,  468,  469,  593,  470,   55,  552,  473,
 /*  1160 */   350,  820,  355,  850,  592,  476,  250,   19,  207,  553,
 /*  1170 */   353,  354,  841,  285,  236,  814,  484,  555,  287,  483,
 /*  1180 */   843,  208,  660,  485,  488,  389,   63,  490,  662,  360,
 /*  1190 */   492,  288,  851,  100,  806,  849,  495,  493,  362,  496,
 /*  1200 */    92,  499,  719,  364,  240,  238,  500,  365,  501,  502,
 /*  1210 */   239,  294,  504,  505,  507,  506,  568,   61,   11,  722,
 /*  1220 */   108,  368,  571,  511,   12,  517,  512,    9,    8,  559,
 /*  1230 */   370,  514,  725,  509,   50,  558,  373,   78,  243,  217,
 /*  1240 */    18,  242,  818,  521,   77,  513,  110,  543,  855,  109,
 /*  1250 */   522,  154,  245,  524,  107,  379,  378,  160,  523,   87,
 /*  1260 */   194,  385,   48,  304,  530,  383,  382,  140,   76,  811,
 /*  1270 */    99,  384,  525,  220,  810,  515,   49,  102,  515,  307,
 /*  1280 */   515,  515,  309,  515,  515,  667,  668,  669,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */    21,  140,   23,   70,   71,   72,   73,   74,   75,   76,
 /*    10 */    77,   78,   79,   80,   81,   82,   83,    9,   25,  158,
 /*    20 */    41,   28,  134,  135,   14,   46,   74,   75,   76,   77,
 /*    30 */    78,   79,   80,   81,   82,   83,   22,   11,   45,   60,
 /*    40 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    50 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*    60 */    81,   82,   83,   53,   90,  204,   87,   41,   94,   95,
 /*    70 */    96,  200,   46,   78,   79,   80,   81,   82,   83,  105,
 /*    80 */   132,  133,  134,  135,   17,   19,   60,   61,   62,   63,
 /*    90 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   100 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   110 */   100,  101,  102,  140,   41,  107,   23,  109,  110,   46,
 /*   120 */   159,  111,  136,  137,   57,   19,   59,  141,  114,   23,
 /*   130 */    62,  158,  146,   60,   61,   62,   63,   64,   65,   66,
 /*   140 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   150 */    77,   78,   79,   80,   81,   82,   83,  171,   52,   19,
 /*   160 */    23,   93,   94,   95,   96,   97,   98,  194,   62,  140,
 /*   170 */    23,  140,  104,   20,   20,  146,   22,  204,  147,  148,
 /*   180 */    87,   88,  196,   41,   78,   79,   80,  158,   46,   19,
 /*   190 */    23,   21,   86,   87,   88,   89,  165,  166,   92,   93,
 /*   200 */   171,  128,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   210 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   220 */    78,   79,   80,   81,   82,   83,  161,  162,  111,   20,
 /*   230 */    20,  125,  126,  168,   87,   88,   19,   90,   34,  140,
 /*   240 */    23,   94,   95,   96,   90,   78,   79,   43,   94,   95,
 /*   250 */    96,   41,  105,  113,   87,   88,   46,  158,   23,  105,
 /*   260 */   107,  149,  109,  110,  152,  153,   99,   62,  140,  127,
 /*   270 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   280 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   290 */    80,   81,   82,   83,   14,   90,   91,   20,   93,   94,
 /*   300 */    95,   96,   97,   98,   87,   88,   15,   19,   23,  104,
 /*   310 */    26,   23,  143,   78,   79,   24,  107,    9,  109,  110,
 /*   320 */    36,   41,   87,  160,   89,   19,   46,   92,   93,   23,
 /*   330 */    39,   23,   20,   42,   22,  207,  208,  209,    9,  139,
 /*   340 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   350 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   360 */    80,   81,   82,   83,   20,  140,   80,   81,   82,   83,
 /*   370 */   172,  140,   87,   88,  205,   87,   88,   23,  146,   14,
 /*   380 */   211,  140,  155,  156,  107,   41,  109,  110,  161,  158,
 /*   390 */    46,   78,   79,   87,   88,   87,   88,   99,    9,  158,
 /*   400 */   115,   12,   89,  171,   60,   61,   62,   63,   64,   65,
 /*   410 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   420 */    76,   77,   78,   79,   80,   81,   82,   83,  196,  140,
 /*   430 */     9,  206,   41,    9,   80,  194,  107,   46,  109,  110,
 /*   440 */   210,   87,   88,   17,  212,  204,   22,  158,   20,  217,
 /*   450 */   146,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   460 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   470 */    79,   80,   81,   82,   83,  171,  100,  101,  102,   41,
 /*   480 */   191,  192,  162,   57,   46,   59,   93,  183,  184,  174,
 /*   490 */    99,   19,  127,  189,  129,   23,  181,  104,   60,   61,
 /*   500 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   510 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   520 */    82,   83,   20,  108,   52,  140,   18,  112,  107,  144,
 /*   530 */   109,  110,  147,  148,   62,  107,  140,  109,  110,   47,
 /*   540 */   100,  101,  102,    9,  140,   20,  122,   22,   41,    9,
 /*   550 */    78,   79,   80,   46,   62,    9,  130,   19,   86,   87,
 /*   560 */    88,   89,  158,  167,   92,   93,  128,   60,   61,   62,
 /*   570 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   580 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   590 */    83,   99,    9,   23,  140,   41,  104,  125,  126,    0,
 /*   600 */    46,  156,  206,   95,  108,  201,  161,  111,    9,   10,
 /*   610 */   183,  184,  158,   88,   60,   61,   62,   63,   64,   65,
 /*   620 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   630 */    76,   77,   78,   79,   80,   81,   82,   83,  130,   99,
 /*   640 */   115,  107,   41,  109,  110,   60,  192,   46,    9,   10,
 /*   650 */    20,  113,   22,  107,   47,  109,  110,   87,   88,  140,
 /*   660 */    62,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   670 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   680 */    79,   80,   81,   82,   83,  115,  111,  140,    9,   41,
 /*   690 */   107,   93,  109,  110,   46,   20,  140,   22,   19,  124,
 /*   700 */    20,   20,   22,   22,  152,  158,   99,   22,  123,   61,
 /*   710 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   720 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   730 */    82,   83,  140,   19,  182,   23,   41,   23,   21,  173,
 /*   740 */    23,   46,   63,  140,   91,  198,   93,   20,   89,   22,
 /*   750 */   158,   92,  200,   55,   56,   29,  152,   62,   63,   64,
 /*   760 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   770 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   11,
 /*   780 */    54,   13,   14,   15,   16,   19,  182,   15,  146,   23,
 /*   790 */   198,   22,  140,   11,   89,   27,   24,   92,  195,   87,
 /*   800 */    32,   87,  140,   22,   87,   37,  152,  140,  146,  140,
 /*   810 */   158,   39,  146,  171,   42,  146,  140,  140,   52,   51,
 /*   820 */   158,   53,  140,  140,  140,   53,   58,  158,   62,  103,
 /*   830 */   140,   50,  140,  171,  140,  158,  182,  171,   19,  140,
 /*   840 */   171,  158,   23,  167,   78,   79,  140,  140,  158,  167,
 /*   850 */   158,  167,   86,   87,   88,   89,  194,   88,   92,   93,
 /*   860 */   140,  167,  196,  194,  158,  158,  204,   41,  100,  101,
 /*   870 */   102,   52,   46,  204,  106,    9,  146,  111,  212,  111,
 /*   880 */    49,   62,  206,  217,  115,   21,  140,  167,  206,   19,
 /*   890 */   206,  125,  126,   23,   68,   69,  140,   78,   79,  140,
 /*   900 */   206,  171,  140,  140,  158,   86,   87,   88,   89,  127,
 /*   910 */   140,   92,   93,  140,  158,  140,  140,  158,  140,   93,
 /*   920 */   158,  158,   52,  140,  140,  140,  206,   20,  158,   22,
 /*   930 */    99,  158,   62,  158,  158,   22,  158,  140,   20,  139,
 /*   940 */    22,  158,  158,  158,  125,  126,  127,    9,   78,   79,
 /*   950 */   140,  140,  140,  140,  140,  158,   86,   87,   88,   89,
 /*   960 */   140,  140,   92,   93,  140,  140,    9,  140,  158,  140,
 /*   970 */   158,  158,  140,  140,  140,  140,  140,  140,  158,  158,
 /*   980 */     9,  140,  158,  158,  140,  158,  140,  158,  122,  140,
 /*   990 */   158,  158,  158,  158,  158,  125,  126,  140,  146,  158,
 /*  1000 */   200,  103,  158,   20,  158,   22,   20,  158,   22,  140,
 /*  1010 */   199,  113,   99,  199,   20,  158,   22,   20,   20,   22,
 /*  1020 */    22,  111,  146,  171,   20,  140,   22,  158,  113,  114,
 /*  1030 */    89,   35,  195,   92,  124,   89,  150,  140,   99,  140,
 /*  1040 */   163,  213,   22,  140,  214,  113,  186,  171,   40,    9,
 /*  1050 */    11,  113,  127,  215,    9,  216,  140,    9,  115,   38,
 /*  1060 */   154,   20,  140,  140,  186,   99,   99,  186,  163,   20,
 /*  1070 */     9,  171,   20,  116,  140,  202,  140,  163,  118,  139,
 /*  1080 */    49,  157,  203,   14,  140,   22,  130,  116,  151,  154,
 /*  1090 */   145,  140,   99,  140,   99,  187,   19,   33,  186,   44,
 /*  1100 */     9,  142,  218,  116,  139,    9,  164,  188,  130,  140,
 /*  1110 */    11,    9,   20,   19,  138,  152,  169,    9,  170,  193,
 /*  1120 */   152,   14,  123,  123,    9,    9,    9,    9,  138,  180,
 /*  1130 */   121,   60,  140,   14,  179,  103,    9,  176,   63,  169,
 /*  1140 */   138,  140,   21,  117,    9,  140,  157,    9,   63,   87,
 /*  1150 */   178,   22,    9,  123,  140,  113,   19,   48,  140,  197,
 /*  1160 */   154,    9,  152,    9,  113,   19,  185,  140,  140,  219,
 /*  1170 */   154,   20,    9,   20,  186,    9,  140,  152,  187,  114,
 /*  1180 */     9,   20,    9,  176,  140,  166,   19,  140,    9,  166,
 /*  1190 */   140,  188,    9,   98,    9,    9,  140,  186,  140,  186,
 /*  1200 */   154,  114,    9,   48,  120,  193,  140,   19,  186,  176,
 /*  1210 */   157,  113,  169,  140,  103,  186,    9,  139,   31,    9,
 /*  1220 */   140,  139,    9,  123,  170,   19,  140,  139,  138,  140,
 /*  1230 */    19,  197,    9,  176,  164,  218,  139,  177,  118,   22,
 /*  1240 */    12,  119,    9,  169,  176,  186,  140,  210,    9,  113,
 /*  1250 */   140,   83,  122,  114,  113,   19,   48,   93,  186,   89,
 /*  1260 */    19,  160,  139,   20,  140,  140,   97,  200,  175,    9,
 /*  1270 */   157,  159,  140,  140,    9,  220,  104,  151,  220,  139,
 /*  1280 */   220,  220,  140,  220,  220,  111,  111,  111,
};
#define YY_SHIFT_USE_DFLT (-68)
static short yy_shift_ofst[] = {
 /*     0 */   639,  599,  -68,  768, 1040,  -68, 1207, 1228,  540, 1213,
 /*    10 */  1187,  772,  -68,  -68,  -68,  -68,  -68,  -68,   93,  -68,
 /*    20 */   -68,  -68,  -68,  389, 1127,  389, 1118,  389, 1102,  170,
 /*    30 */  1091,   93,  312, 1052, 1048,  147,  -68,  712,  -68,  205,
 /*    40 */   -68,   93,   68,  -68,  298,  -68,  393,  298,  -68, 1055,
 /*    50 */   -68,  204,  -68,  -68, 1109,  284,  298,  -68,  -68,  -68,
 /*    60 */   298,  -68, 1167,  870,  140,  106, 1051, 1042,  766,  -68,
 /*    70 */   277,  117,  -68,  415,  -68,   14, 1130, 1122, 1084, 1026,
 /*    80 */  1009,  -68,  313,  -68,  946,  -68, 1170,  -68,  781,  313,
 /*    90 */   -68,  313,  -68,  960,  870,  685,  870, 1095,  284,  -68,
 /*   100 */   137,  -68,  -68,  554,  870,  -68, 1141,   93, 1136,   93,
 /*   110 */   -68,  -68,  -68,  -68,  695,  870,  648,  870,  -48,  870,
 /*   120 */   -48,  870,  -48,  870,  -48,  870,  -67,  870,  -67,  870,
 /*   130 */    -5,  870,   -5,  870,   -5,  870,   -5,  870,  -67,  826,
 /*   140 */   870,  -67,  -68,  -68,  870,  286,  870,  286,  870, 1168,
 /*   150 */   870, 1168,  870, 1168,  870,  -68,  -68,  598,  -68, 1164,
 /*   160 */   -68,  -68,  870,  507,  870,  -67,  288,  766,  153,  496,
 /*   170 */  1174, 1175, 1176,  -68,  554,  870,  695,  870,  -68,  870,
 /*   180 */   -68,  870,  -68,  819,  142,  925,  365, 1069,  -68,  870,
 /*   190 */    73,  870,  554, 1241,  291,  502,  -68, 1020,   93, 1049,
 /*   200 */   -68, 1063,   93, 1092,  -68, 1129,   93, 1161,  -68,  870,
 /*   210 */   280,  870,  438,  870,  554,  630,  -68,  870,  -68,  -68,
 /*   220 */   932,   93,  -68,  -68,  -68,  870,  601,  870,  695,  217,
 /*   230 */   766,  428,  -68,  675,  -68,  932,  -68, 1095,  284,  -68,
 /*   240 */   870,  554, 1120,  870, 1217,  870,  554,  -68,  -68,  769,
 /*   250 */   -68,  -68,  -68,  285,  -68,  570,  -68,  943,  -68,  306,
 /*   260 */   932,  717,  -68,  -68,   93,  -68,  -68,  995,  987,  -68,
 /*   270 */  1094,   93,  680,  -68,   93,  -68,  284,  -68,  -68,  870,
 /*   280 */   554,  117,  209,  525, 1153,  717,  995,  987,  -68,  472,
 /*   290 */   -21,  -68,  -68, 1098,  354,  -68,  -68,  -68,  -68,  344,
 /*   300 */   -68,  681,  -68, 1243,  -68,  210,  298,  -68,   93,   66,
 /*   310 */   -68,  607,  -68,   93,  -68,  440,  726,  -68,  653,  -68,
 /*   320 */   -68,  -68,  -68,  726,  -68,  726,  -68,   93,  727,  -68,
 /*   330 */   -68,  137,  -68, 1055,  -68,  -68,  235,  -68,  -68,  -68,
 /*   340 */   659,  -68,  -68,  705,  -68,  -68,  -68,  -68,  714,  313,
 /*   350 */   907,  -68,  313, 1151,  -68,  -68,  -68,  -68,  154,  -26,
 /*   360 */   -68,   93,  -68, 1155, 1188,   93,  918,  298,  -68, 1211,
 /*   370 */    93,  983,  298,  -68,  870,  391,  -68, 1208, 1236,   93,
 /*   380 */   986, 1169,   93,   66,  -68,  492, 1172,  -68,  -68,  -68,
 /*   390 */   -68,  -68,  117,  546,  508,   67,   93,  -68,   93,  864,
 /*   400 */   117,  421,   93,   -7,  376,  939,   93,  932, 1008,  782,
 /*   410 */  1039,  870,   26, 1021,  698,  -68,  -68,  966,  967,  831,
 /*   420 */    93,  913,   93,  -68,  -68,  -68,  -68, 1031,  -68,  -68,
 /*   430 */   956,   93,  993,   93,  538, 1077,   93,  994,  540, 1096,
 /*   440 */   978, 1099,   10,    8,  585,  772,  -68,  999, 1000, 1107,
 /*   450 */  1115, 1116,   10, 1119, 1071,   93, 1032,   93,  424,   93,
 /*   460 */  1075,  870,  554, 1138, 1085,  870,  554, 1030,   93, 1137,
 /*   470 */    93,  997,  -68,  575,  329, 1146,  870,  998,  870,  554,
 /*   480 */  1163,  554, 1065,   93,  866, 1171,  426,   93, 1173,   93,
 /*   490 */  1179,   93,  938, 1185,   93,  938, 1186,  534, 1087,   93,
 /*   500 */   932,  866, 1193, 1071,   93,  898, 1111,   93,  424, 1210,
 /*   510 */  1100,   93,  932, 1137,  910,  583, 1206,  870, 1004, 1223,
 /*   520 */  1071,   93,  915, 1139,   93,  957,  996, 1062, 1143,  308,
 /*   530 */  1265,  712,  679,  167, 1260, 1108, 1135, 1166,  941, 1045,
 /*   540 */  1117, 1152,  941, 1233,  -68,   93, 1041, 1061, 1064,  712,
 /*   550 */  1121,   93,  971, 1154,  712, 1183,  -68, 1064,   93, 1239,
 /*   560 */   -68,  -68,  -68,
};
#define YY_REDUCE_USE_DFLT (-140)
static short yy_reduce_ofst[] = {
 /*     0 */   -52, -112, -140,  -14, -140, -140, -140, 1090, 1088, -140,
 /*    10 */  -140, 1054, -140, -140, -140, -140, -140, -140, 1027, -140,
 /*    20 */  -140, -140, -140, 1002, -140,  990, -140,  976, -140,  959,
 /*    30 */  -140,  385,  945, -140, -140,   31, -140,  112,  886,  227,
 /*    40 */  -140,  519,  445, -140,  200, -140, -140, 1123, -140, 1070,
 /*    50 */  -140, -140, -140, -140, -140,  924,  940, -140, -140, -140,
 /*    60 */  1078, -140, -140,  231, -140,  241, -140, -140,   29, -140,
 /*    70 */   198,  900, -140,  566,  315, 1093, 1068, 1060,  972,  955,
 /*    80 */   949, -140,  935, -140, -140, -140, -140, -140, -140,  906,
 /*    90 */  -140, 1046, -140, -140,  289, -140,  454,  926, 1113, -140,
 /*   100 */  1126, -140, -140, -129,  677, -140, -140, 1080, -140, 1106,
 /*   110 */  -140, -140, -140, -140, -129,  683, -129,  690, -129,  706,
 /*   120 */  -129,  746, -129,  756, -129,  759, -129,  762, -129,  763,
 /*   130 */  -129,  770, -129,  773, -129,  775, -129,  776, -129, 1067,
 /*   140 */   778, -129, -140, -140,  783, -129,  784, -129,  785, -129,
 /*   150 */   797, -129,  810, -129,  812, -129, -140, -140, -140, -140,
 /*   160 */  -140, -140,  692, -129,  813, -129, 1133,  662,  198, -140,
 /*   170 */  -140, -140, -140, -140, -129,  820, -129,  821, -129,  824,
 /*   180 */  -129,  825, -129,  404, -129,  873,  879, -140, -140,  827,
 /*   190 */  -129,  829, -129, -140, -140, -140, -140, -140,  922, -140,
 /*   200 */  -140, -140,  969, -140, -140, -140, 1028, -140, -140,  832,
 /*   210 */  -129,   99, -129,  833, -129, -140, -140, -139, -140, -140,
 /*   220 */   878,  934, -140, -140, -140,  834, -129,  835, -129,  992,
 /*   230 */   669,  198, -140, -140, -140,  988, -140, 1012, 1053, -140,
 /*   240 */   836, -129, -140,  -27, -140,  841, -129, -140,  427,  981,
 /*   250 */  -140, -140, -140,  885, -140,  899, -140, -140, -140,  923,
 /*   260 */   881,  604, -140, -140,  944, -140, -140,  908,  919, -140,
 /*   270 */  -140,  684, -140, -140,  225, -140,  989, -140, -140,  844,
 /*   280 */  -129,  304,  198,  981, -140,  654,  991, 1003, -140,  846,
 /*   290 */   552, -140, -140, -140, 1080, -140, -140, -140, -140, -129,
 /*   300 */  -140, -140, -140, -140, -140, -129, 1140, -140, 1142,  -39,
 /*   310 */   163,  320, -140,  667, -140, -140,  877, -140, -140, -140,
 /*   320 */  -140, -140, -140,  905, -140,  914, -140,  676, -140, -140,
 /*   330 */  -140,  937, -140,  942, -140, -140, -140, -140, -140, -140,
 /*   340 */  -140, -140, -140, -140, -140, -140, -140, -140, 1010, 1006,
 /*   350 */  -140, -140, 1016, -140, -140, -140, -140, -140, 1019, 1023,
 /*   360 */  -140, 1058, -140, -140, -140,  682, -140, 1082, -140, -140,
 /*   370 */   694, -140, 1097, -140,  707,  800, -140, -140, -140,  720,
 /*   380 */  -140, -140, 1125, 1112, 1101,   65, -140, -140, -140, -140,
 /*   390 */  -140, -140,  642,  198,  169, -140,  556, -140,  699, -140,
 /*   400 */   730,  198,  897,  828,  830, -140,  903,  860,  838,  839,
 /*   410 */  -140,  849, -129, -140, -140, -140, -140, -140, -140, -140,
 /*   420 */   814, -140,  936, -140, -140, -140, -140, -140, -140, -140,
 /*   430 */  -140,  951, -140,  953,  912, -140,  396, -140,  965, -140,
 /*   440 */  -140, -140,  232,  198,  947,  948, -140, -140, -140, -140,
 /*   450 */  -140, -140,  666, -140,  970, 1001, -140,  603,  961, 1005,
 /*   460 */  -140,  652, -129, -140, -140,  857, -129, -140, 1014,  962,
 /*   470 */   811, -140, -140,  852,  198, -140,  547, -140,  869, -129,
 /*   480 */  -140, -129, -140, 1036, 1007, -140, -140, 1044, -140, 1047,
 /*   490 */  -140, 1050, 1011, -140, 1056, 1013, -140,  198, -140, 1066,
 /*   500 */  1022, 1033, -140, 1043, 1073, 1029, -140,  837, 1057, -140,
 /*   510 */  -140, 1086, 1059, 1034,  876,  198, -140,  592, -140, -140,
 /*   520 */  1074, 1110, 1072, -140, 1132, -140, -140, -140, -140, 1124,
 /*   530 */  -140,  968, -140,  128, -140, -140, -140, -140,  230, -140,
 /*   540 */  -140, -140, 1037, -140, -140,  916, -140, -140,  884,  963,
 /*   550 */  -140, 1018,  950, -140, 1025, -140, -140, 1017, 1089, -140,
 /*   560 */  -140, -140, -140,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */   570,  570,  564,  856,  856,  566,  856,  572,  856,  856,
 /*    10 */   856,  856,  652,  655,  656,  657,  658,  659,  573,  574,
 /*    20 */   591,  592,  593,  856,  856,  856,  856,  856,  856,  856,
 /*    30 */   856,  856,  856,  856,  856,  856,  584,  594,  604,  586,
 /*    40 */   603,  856,  856,  605,  651,  616,  856,  651,  617,  636,
 /*    50 */   634,  856,  637,  638,  856,  708,  651,  618,  706,  707,
 /*    60 */   651,  619,  856,  856,  737,  797,  743,  738,  856,  664,
 /*    70 */   856,  856,  665,  673,  675,  682,  720,  711,  713,  701,
 /*    80 */   715,  670,  856,  600,  856,  601,  856,  602,  716,  856,
 /*    90 */   717,  856,  718,  856,  856,  702,  856,  709,  708,  703,
 /*   100 */   856,  588,  710,  705,  856,  736,  856,  856,  739,  856,
 /*   110 */   740,  741,  742,  744,  747,  856,  748,  856,  749,  856,
 /*   120 */   750,  856,  751,  856,  752,  856,  753,  856,  754,  856,
 /*   130 */   755,  856,  756,  856,  757,  856,  758,  856,  759,  856,
 /*   140 */   856,  760,  761,  762,  856,  763,  856,  764,  856,  765,
 /*   150 */   856,  766,  856,  767,  856,  768,  769,  856,  770,  856,
 /*   160 */   773,  771,  856,  856,  856,  779,  856,  797,  856,  856,
 /*   170 */   856,  856,  856,  782,  796,  856,  774,  856,  775,  856,
 /*   180 */   776,  856,  777,  856,  856,  856,  856,  856,  787,  856,
 /*   190 */   856,  856,  788,  856,  856,  856,  845,  856,  856,  856,
 /*   200 */   846,  856,  856,  856,  847,  856,  856,  856,  848,  856,
 /*   210 */   856,  856,  856,  856,  789,  856,  781,  797,  794,  795,
 /*   220 */   690,  856,  691,  785,  772,  856,  856,  856,  780,  856,
 /*   230 */   797,  856,  784,  856,  783,  690,  786,  709,  708,  704,
 /*   240 */   856,  714,  856,  797,  712,  856,  721,  674,  685,  683,
 /*   250 */   684,  692,  693,  856,  694,  856,  695,  856,  696,  856,
 /*   260 */   690,  681,  589,  590,  856,  679,  680,  698,  700,  686,
 /*   270 */   856,  856,  856,  699,  856,  803,  708,  805,  804,  856,
 /*   280 */   697,  685,  856,  856,  856,  681,  698,  700,  687,  856,
 /*   290 */   681,  676,  677,  856,  856,  678,  671,  672,  778,  856,
 /*   300 */   735,  856,  745,  856,  746,  856,  651,  620,  856,  801,
 /*   310 */   624,  621,  625,  856,  626,  856,  856,  627,  856,  630,
 /*   320 */   631,  632,  633,  856,  628,  856,  629,  856,  856,  802,
 /*   330 */   622,  856,  623,  636,  635,  606,  856,  607,  608,  609,
 /*   340 */   856,  610,  613,  856,  611,  614,  612,  615,  595,  856,
 /*   350 */   856,  596,  856,  856,  597,  599,  598,  587,  856,  856,
 /*   360 */   641,  856,  644,  856,  856,  856,  856,  651,  645,  856,
 /*   370 */   856,  856,  651,  646,  856,  651,  647,  856,  856,  856,
 /*   380 */   856,  856,  856,  801,  624,  649,  856,  648,  650,  642,
 /*   390 */   643,  585,  856,  856,  581,  856,  856,  579,  856,  856,
 /*   400 */   856,  856,  856,  828,  856,  856,  856,  690,  833,  856,
 /*   410 */   856,  856,  856,  856,  856,  834,  835,  856,  856,  856,
 /*   420 */   856,  856,  856,  733,  734,  825,  826,  856,  827,  580,
 /*   430 */   856,  856,  856,  856,  856,  856,  856,  856,  856,  856,
 /*   440 */   856,  856,  856,  856,  856,  856,  654,  856,  856,  856,
 /*   450 */   856,  856,  856,  856,  653,  856,  856,  856,  856,  856,
 /*   460 */   856,  856,  723,  856,  856,  856,  724,  856,  856,  731,
 /*   470 */   856,  856,  732,  856,  856,  856,  856,  856,  856,  729,
 /*   480 */   856,  730,  856,  856,  856,  856,  856,  856,  856,  856,
 /*   490 */   856,  856,  856,  856,  856,  856,  856,  856,  856,  856,
 /*   500 */   690,  856,  856,  653,  856,  856,  856,  856,  856,  856,
 /*   510 */   856,  856,  690,  731,  856,  856,  856,  856,  856,  856,
 /*   520 */   653,  856,  856,  856,  856,  856,  856,  856,  856,  856,
 /*   530 */   856,  856,  856,  822,  856,  856,  856,  856,  856,  856,
 /*   540 */   856,  856,  856,  856,  821,  856,  856,  856,  854,  856,
 /*   550 */   856,  856,  856,  856,  856,  856,  853,  854,  856,  856,
 /*   560 */   567,  569,  565,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*    CLUSTER => ID */
   23,  /*   CONFLICT => ID */
   23,  /*       COPY => ID */
   23,  /*   DATABASE => ID */
   23,  /*   DEFERRED => ID */
   23,  /* DELIMITERS => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*       GLOB => ID */
   23,  /*     IGNORE => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*       LIKE => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         EQ => nothing */
    0,  /*         NE => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*         GT => nothing */
    0,  /*         GE => nothing */
    0,  /*         LT => nothing */
    0,  /*         LE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /*    INTEGER => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqliteParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "SEMI",          "EXPLAIN",       "BEGIN",       
  "TRANSACTION",   "COMMIT",        "END",           "ROLLBACK",    
  "CREATE",        "TABLE",         "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ASC",           "ATTACH",      
  "BEFORE",        "CASCADE",       "CLUSTER",       "CONFLICT",    
  "COPY",          "DATABASE",      "DEFERRED",      "DELIMITERS",  
  "DESC",          "DETACH",        "EACH",          "FAIL",        
  "FOR",           "GLOB",          "IGNORE",        "IMMEDIATE",   
  "INITIALLY",     "INSTEAD",       "LIKE",          "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "OR",            "AND",           "NOT",           "EQ",          
  "NE",            "ISNULL",        "NOTNULL",       "IS",          
  "BETWEEN",       "IN",            "GT",            "GE",          
  "LT",            "LE",            "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "UMINUS",        "UPLUS",         "BITNOT",        "STRING",      
  "JOIN_KW",       "INTEGER",       "CONSTRAINT",    "DEFAULT",     
  "FLOAT",         "NULL",          "PRIMARY",       "UNIQUE",      
  "CHECK",         "REFERENCES",    "COLLATE",       "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "INTERSECT",     "EXCEPT",        "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "error",       
  "input",         "cmdlist",       "ecmd",          "explain",     
  "cmdx",          "cmd",           "trans_opt",     "onconf",      
  "nm",            "create_table",  "create_table_args",  "temp",        
  "columnlist",    "conslist_opt",  "select",        "column",      
  "columnid",      "type",          "carglist",      "id",          
  "ids",           "typename",      "signed",        "carg",        
  "ccons",         "sortorder",     "expr",          "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "oneselect",   
  "multiselect_op",  "distinct",      "selcollist",    "from",        
  "where_opt",     "groupby_opt",   "having_opt",    "orderby_opt", 
  "limit_opt",     "sclp",          "as",            "seltablist",  
  "stl_prefix",    "joinop",        "dbnm",          "on_opt",      
  "using_opt",     "seltablist_paren",  "joinop2",       "sortlist",    
  "sortitem",      "collate",       "exprlist",      "setlist",     
  "insert_cmd",    "inscollist_opt",  "itemlist",      "inscollist",  
  "likeop",        "case_operand",  "case_exprlist",  "case_else",   
  "expritem",      "uniqueflag",    "idxitem",       "plus_num",    
  "minus_num",     "plus_opt",      "number",        "trigger_decl",
  "trigger_cmd_list",  "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd",   "database_kw_opt",  "key_opt",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= explain cmdx SEMI",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "cmdx ::= cmd",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::=",
 /*   8 */ "cmd ::= BEGIN trans_opt onconf",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "cmd ::= COMMIT trans_opt",
 /*  13 */ "cmd ::= END trans_opt",
 /*  14 */ "cmd ::= ROLLBACK trans_opt",
 /*  15 */ "cmd ::= create_table create_table_args",
 /*  16 */ "create_table ::= CREATE temp TABLE nm",
 /*  17 */ "temp ::= TEMP",
 /*  18 */ "temp ::=",
 /*  19 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  20 */ "create_table_args ::= AS select",
 /*  21 */ "columnlist ::= columnlist COMMA column",
 /*  22 */ "columnlist ::= column",
 /*  23 */ "column ::= columnid type carglist",
 /*  24 */ "columnid ::= nm",
 /*  25 */ "id ::= ID",
 /*  26 */ "ids ::= ID",
 /*  27 */ "ids ::= STRING",
 /*  28 */ "nm ::= ID",
 /*  29 */ "nm ::= STRING",
 /*  30 */ "nm ::= JOIN_KW",
 /*  31 */ "type ::=",
 /*  32 */ "type ::= typename",
 /*  33 */ "type ::= typename LP signed RP",
 /*  34 */ "type ::= typename LP signed COMMA signed RP",
 /*  35 */ "typename ::= ids",
 /*  36 */ "typename ::= typename ids",
 /*  37 */ "signed ::= INTEGER",
 /*  38 */ "signed ::= PLUS INTEGER",
 /*  39 */ "signed ::= MINUS INTEGER",
 /*  40 */ "carglist ::= carglist carg",
 /*  41 */ "carglist ::=",
 /*  42 */ "carg ::= CONSTRAINT nm ccons",
 /*  43 */ "carg ::= ccons",
 /*  44 */ "carg ::= DEFAULT STRING",
 /*  45 */ "carg ::= DEFAULT ID",
 /*  46 */ "carg ::= DEFAULT INTEGER",
 /*  47 */ "carg ::= DEFAULT PLUS INTEGER",
 /*  48 */ "carg ::= DEFAULT MINUS INTEGER",
 /*  49 */ "carg ::= DEFAULT FLOAT",
 /*  50 */ "carg ::= DEFAULT PLUS FLOAT",
 /*  51 */ "carg ::= DEFAULT MINUS FLOAT",
 /*  52 */ "carg ::= DEFAULT NULL",
 /*  53 */ "ccons ::= NULL onconf",
 /*  54 */ "ccons ::= NOT NULL onconf",
 /*  55 */ "ccons ::= PRIMARY KEY sortorder onconf",
 /*  56 */ "ccons ::= UNIQUE onconf",
 /*  57 */ "ccons ::= CHECK LP expr RP onconf",
 /*  58 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  59 */ "ccons ::= defer_subclause",
 /*  60 */ "ccons ::= COLLATE id",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= ROLLBACK",
 /*  93 */ "resolvetype ::= ABORT",
 /*  94 */ "resolvetype ::= FAIL",
 /*  95 */ "resolvetype ::= IGNORE",
 /*  96 */ "resolvetype ::= REPLACE",
 /*  97 */ "cmd ::= DROP TABLE nm",
 /*  98 */ "cmd ::= CREATE temp VIEW nm AS select",
 /*  99 */ "cmd ::= DROP VIEW nm",
 /* 100 */ "cmd ::= select",
 /* 101 */ "select ::= oneselect",
 /* 102 */ "select ::= select multiselect_op oneselect",
 /* 103 */ "multiselect_op ::= UNION",
 /* 104 */ "multiselect_op ::= UNION ALL",
 /* 105 */ "multiselect_op ::= INTERSECT",
 /* 106 */ "multiselect_op ::= EXCEPT",
 /* 107 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 108 */ "distinct ::= DISTINCT",
 /* 109 */ "distinct ::= ALL",
 /* 110 */ "distinct ::=",
 /* 111 */ "sclp ::= selcollist COMMA",
 /* 112 */ "sclp ::=",
 /* 113 */ "selcollist ::= sclp expr as",
 /* 114 */ "selcollist ::= sclp STAR",
 /* 115 */ "selcollist ::= sclp nm DOT STAR",
 /* 116 */ "as ::= AS nm",
 /* 117 */ "as ::= ids",
 /* 118 */ "as ::=",
 /* 119 */ "from ::=",
 /* 120 */ "from ::= FROM seltablist",
 /* 121 */ "stl_prefix ::= seltablist joinop",
 /* 122 */ "stl_prefix ::=",
 /* 123 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 124 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 125 */ "seltablist_paren ::= select",
 /* 126 */ "seltablist_paren ::= seltablist",
 /* 127 */ "dbnm ::=",
 /* 128 */ "dbnm ::= DOT nm",
 /* 129 */ "joinop ::= COMMA",
 /* 130 */ "joinop ::= JOIN",
 /* 131 */ "joinop ::= JOIN_KW JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm JOIN",
 /* 133 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 134 */ "on_opt ::= ON expr",
 /* 135 */ "on_opt ::=",
 /* 136 */ "using_opt ::= USING LP idxlist RP",
 /* 137 */ "using_opt ::=",
 /* 138 */ "orderby_opt ::=",
 /* 139 */ "orderby_opt ::= ORDER BY sortlist",
 /* 140 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 141 */ "sortlist ::= sortitem collate sortorder",
 /* 142 */ "sortitem ::= expr",
 /* 143 */ "sortorder ::= ASC",
 /* 144 */ "sortorder ::= DESC",
 /* 145 */ "sortorder ::=",
 /* 146 */ "collate ::=",
 /* 147 */ "collate ::= COLLATE id",
 /* 148 */ "groupby_opt ::=",
 /* 149 */ "groupby_opt ::= GROUP BY exprlist",
 /* 150 */ "having_opt ::=",
 /* 151 */ "having_opt ::= HAVING expr",
 /* 152 */ "limit_opt ::=",
 /* 153 */ "limit_opt ::= LIMIT signed",
 /* 154 */ "limit_opt ::= LIMIT signed OFFSET signed",
 /* 155 */ "limit_opt ::= LIMIT signed COMMA signed",
 /* 156 */ "cmd ::= DELETE FROM nm dbnm where_opt",
 /* 157 */ "where_opt ::=",
 /* 158 */ "where_opt ::= WHERE expr",
 /* 159 */ "cmd ::= UPDATE orconf nm dbnm SET setlist where_opt",
 /* 160 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 161 */ "setlist ::= nm EQ expr",
 /* 162 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt VALUES LP itemlist RP",
 /* 163 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt select",
 /* 164 */ "insert_cmd ::= INSERT orconf",
 /* 165 */ "insert_cmd ::= REPLACE",
 /* 166 */ "itemlist ::= itemlist COMMA expr",
 /* 167 */ "itemlist ::= expr",
 /* 168 */ "inscollist_opt ::=",
 /* 169 */ "inscollist_opt ::= LP inscollist RP",
 /* 170 */ "inscollist ::= inscollist COMMA nm",
 /* 171 */ "inscollist ::= nm",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "expr ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "expr ::= INTEGER",
 /* 179 */ "expr ::= FLOAT",
 /* 180 */ "expr ::= STRING",
 /* 181 */ "expr ::= VARIABLE",
 /* 182 */ "expr ::= ID LP exprlist RP",
 /* 183 */ "expr ::= ID LP STAR RP",
 /* 184 */ "expr ::= expr AND expr",
 /* 185 */ "expr ::= expr OR expr",
 /* 186 */ "expr ::= expr LT expr",
 /* 187 */ "expr ::= expr GT expr",
 /* 188 */ "expr ::= expr LE expr",
 /* 189 */ "expr ::= expr GE expr",
 /* 190 */ "expr ::= expr NE expr",
 /* 191 */ "expr ::= expr EQ expr",
 /* 192 */ "expr ::= expr BITAND expr",
 /* 193 */ "expr ::= expr BITOR expr",
 /* 194 */ "expr ::= expr LSHIFT expr",
 /* 195 */ "expr ::= expr RSHIFT expr",
 /* 196 */ "expr ::= expr likeop expr",
 /* 197 */ "expr ::= expr NOT likeop expr",
 /* 198 */ "likeop ::= LIKE",
 /* 199 */ "likeop ::= GLOB",
 /* 200 */ "expr ::= expr PLUS expr",
 /* 201 */ "expr ::= expr MINUS expr",
 /* 202 */ "expr ::= expr STAR expr",
 /* 203 */ "expr ::= expr SLASH expr",
 /* 204 */ "expr ::= expr REM expr",
 /* 205 */ "expr ::= expr CONCAT expr",
 /* 206 */ "expr ::= expr ISNULL",
 /* 207 */ "expr ::= expr IS NULL",
 /* 208 */ "expr ::= expr NOTNULL",
 /* 209 */ "expr ::= expr NOT NULL",
 /* 210 */ "expr ::= expr IS NOT NULL",
 /* 211 */ "expr ::= NOT expr",
 /* 212 */ "expr ::= BITNOT expr",
 /* 213 */ "expr ::= MINUS expr",
 /* 214 */ "expr ::= PLUS expr",
 /* 215 */ "expr ::= LP select RP",
 /* 216 */ "expr ::= expr BETWEEN expr AND expr",
 /* 217 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 218 */ "expr ::= expr IN LP exprlist RP",
 /* 219 */ "expr ::= expr IN LP select RP",
 /* 220 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 221 */ "expr ::= expr NOT IN LP select RP",
 /* 222 */ "expr ::= expr IN nm dbnm",
 /* 223 */ "expr ::= expr NOT IN nm dbnm",
 /* 224 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 225 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 226 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 227 */ "case_else ::= ELSE expr",
 /* 228 */ "case_else ::=",
 /* 229 */ "case_operand ::= expr",
 /* 230 */ "case_operand ::=",
 /* 231 */ "exprlist ::= exprlist COMMA expritem",
 /* 232 */ "exprlist ::= expritem",
 /* 233 */ "expritem ::= expr",
 /* 234 */ "expritem ::=",
 /* 235 */ "cmd ::= CREATE uniqueflag INDEX nm ON nm dbnm LP idxlist RP onconf",
 /* 236 */ "uniqueflag ::= UNIQUE",
 /* 237 */ "uniqueflag ::=",
 /* 238 */ "idxlist_opt ::=",
 /* 239 */ "idxlist_opt ::= LP idxlist RP",
 /* 240 */ "idxlist ::= idxlist COMMA idxitem",
 /* 241 */ "idxlist ::= idxitem",
 /* 242 */ "idxitem ::= nm sortorder",
 /* 243 */ "cmd ::= DROP INDEX nm dbnm",
 /* 244 */ "cmd ::= COPY orconf nm dbnm FROM nm USING DELIMITERS STRING",
 /* 245 */ "cmd ::= COPY orconf nm dbnm FROM nm",
 /* 246 */ "cmd ::= VACUUM",
 /* 247 */ "cmd ::= VACUUM nm",
 /* 248 */ "cmd ::= PRAGMA ids EQ nm",
 /* 249 */ "cmd ::= PRAGMA ids EQ ON",
 /* 250 */ "cmd ::= PRAGMA ids EQ plus_num",
 /* 251 */ "cmd ::= PRAGMA ids EQ minus_num",
 /* 252 */ "cmd ::= PRAGMA ids LP nm RP",
 /* 253 */ "cmd ::= PRAGMA ids",
 /* 254 */ "plus_num ::= plus_opt number",
 /* 255 */ "minus_num ::= MINUS number",
 /* 256 */ "number ::= INTEGER",
 /* 257 */ "number ::= FLOAT",
 /* 258 */ "plus_opt ::= PLUS",
 /* 259 */ "plus_opt ::=",
 /* 260 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 261 */ "trigger_decl ::= temp TRIGGER nm trigger_time trigger_event ON nm dbnm foreach_clause when_clause",
 /* 262 */ "trigger_time ::= BEFORE",
 /* 263 */ "trigger_time ::= AFTER",
 /* 264 */ "trigger_time ::= INSTEAD OF",
 /* 265 */ "trigger_time ::=",
 /* 266 */ "trigger_event ::= DELETE",
 /* 267 */ "trigger_event ::= INSERT",
 /* 268 */ "trigger_event ::= UPDATE",
 /* 269 */ "trigger_event ::= UPDATE OF inscollist",
 /* 270 */ "foreach_clause ::=",
 /* 271 */ "foreach_clause ::= FOR EACH ROW",
 /* 272 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 273 */ "when_clause ::=",
 /* 274 */ "when_clause ::= WHEN expr",
 /* 275 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 276 */ "trigger_cmd_list ::=",
 /* 277 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 278 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 279 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 280 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 281 */ "trigger_cmd ::= select",
 /* 282 */ "expr ::= RAISE LP IGNORE RP",
 /* 283 */ "expr ::= RAISE LP ROLLBACK COMMA nm RP",
 /* 284 */ "expr ::= RAISE LP ABORT COMMA nm RP",
 /* 285 */ "expr ::= RAISE LP FAIL COMMA nm RP",
 /* 286 */ "cmd ::= DROP TRIGGER nm dbnm",
 /* 287 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 288 */ "key_opt ::= USING ids",
 /* 289 */ "key_opt ::=",
 /* 290 */ "database_kw_opt ::= DATABASE",
 /* 291 */ "database_kw_opt ::=",
 /* 292 */ "cmd ::= DETACH database_kw_opt nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqliteParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqliteParser and sqliteParserFree.
*/
void *sqliteParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 146:
#line 286 "parse.y"
{sqliteSelectDelete((yypminor->yy179));}
#line 1235 "parse.c"
      break;
    case 158:
#line 533 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1240 "parse.c"
      break;
    case 159:
#line 746 "parse.y"
{sqliteIdListDelete((yypminor->yy320));}
#line 1245 "parse.c"
      break;
    case 167:
#line 744 "parse.y"
{sqliteIdListDelete((yypminor->yy320));}
#line 1250 "parse.c"
      break;
    case 171:
#line 288 "parse.y"
{sqliteSelectDelete((yypminor->yy179));}
#line 1255 "parse.c"
      break;
    case 174:
#line 322 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1260 "parse.c"
      break;
    case 175:
#line 353 "parse.y"
{sqliteSrcListDelete((yypminor->yy307));}
#line 1265 "parse.c"
      break;
    case 176:
#line 483 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1270 "parse.c"
      break;
    case 177:
#line 459 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1275 "parse.c"
      break;
    case 178:
#line 464 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1280 "parse.c"
      break;
    case 179:
#line 431 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1285 "parse.c"
      break;
    case 181:
#line 324 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1290 "parse.c"
      break;
    case 183:
#line 349 "parse.y"
{sqliteSrcListDelete((yypminor->yy307));}
#line 1295 "parse.c"
      break;
    case 184:
#line 351 "parse.y"
{sqliteSrcListDelete((yypminor->yy307));}
#line 1300 "parse.c"
      break;
    case 187:
#line 420 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1305 "parse.c"
      break;
    case 188:
#line 425 "parse.y"
{sqliteIdListDelete((yypminor->yy320));}
#line 1310 "parse.c"
      break;
    case 189:
#line 400 "parse.y"
{sqliteSelectDelete((yypminor->yy179));}
#line 1315 "parse.c"
      break;
    case 191:
#line 433 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1320 "parse.c"
      break;
    case 192:
#line 435 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1325 "parse.c"
      break;
    case 194:
#line 719 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1330 "parse.c"
      break;
    case 195:
#line 489 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1335 "parse.c"
      break;
    case 197:
#line 520 "parse.y"
{sqliteIdListDelete((yypminor->yy320));}
#line 1340 "parse.c"
      break;
    case 198:
#line 514 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1345 "parse.c"
      break;
    case 199:
#line 522 "parse.y"
{sqliteIdListDelete((yypminor->yy320));}
#line 1350 "parse.c"
      break;
    case 202:
#line 702 "parse.y"
{sqliteExprListDelete((yypminor->yy322));}
#line 1355 "parse.c"
      break;
    case 204:
#line 721 "parse.y"
{sqliteExprDelete((yypminor->yy242));}
#line 1360 "parse.c"
      break;
    case 212:
#line 828 "parse.y"
{sqliteDeleteTriggerStep((yypminor->yy19));}
#line 1365 "parse.c"
      break;
    case 214:
#line 812 "parse.y"
{sqliteIdListDelete((yypminor->yy290).b);}
#line 1370 "parse.c"
      break;
    case 217:
#line 836 "parse.y"
{sqliteDeleteTriggerStep((yypminor->yy19));}
#line 1375 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqliteParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqliteParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqliteParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 132, 1 },
  { 133, 2 },
  { 133, 1 },
  { 134, 3 },
  { 134, 1 },
  { 136, 1 },
  { 135, 1 },
  { 135, 0 },
  { 137, 3 },
  { 138, 0 },
  { 138, 1 },
  { 138, 2 },
  { 137, 2 },
  { 137, 2 },
  { 137, 2 },
  { 137, 2 },
  { 141, 4 },
  { 143, 1 },
  { 143, 0 },
  { 142, 4 },
  { 142, 2 },
  { 144, 3 },
  { 144, 1 },
  { 147, 3 },
  { 148, 1 },
  { 151, 1 },
  { 152, 1 },
  { 152, 1 },
  { 140, 1 },
  { 140, 1 },
  { 140, 1 },
  { 149, 0 },
  { 149, 1 },
  { 149, 4 },
  { 149, 6 },
  { 153, 1 },
  { 153, 2 },
  { 154, 1 },
  { 154, 2 },
  { 154, 2 },
  { 150, 2 },
  { 150, 0 },
  { 155, 3 },
  { 155, 1 },
  { 155, 2 },
  { 155, 2 },
  { 155, 2 },
  { 155, 3 },
  { 155, 3 },
  { 155, 2 },
  { 155, 3 },
  { 155, 3 },
  { 155, 2 },
  { 156, 2 },
  { 156, 3 },
  { 156, 4 },
  { 156, 2 },
  { 156, 5 },
  { 156, 4 },
  { 156, 1 },
  { 156, 2 },
  { 160, 0 },
  { 160, 2 },
  { 162, 2 },
  { 162, 3 },
  { 162, 3 },
  { 162, 3 },
  { 163, 2 },
  { 163, 2 },
  { 163, 1 },
  { 163, 1 },
  { 161, 3 },
  { 161, 2 },
  { 164, 0 },
  { 164, 2 },
  { 164, 2 },
  { 145, 0 },
  { 145, 2 },
  { 165, 3 },
  { 165, 2 },
  { 165, 1 },
  { 166, 2 },
  { 166, 6 },
  { 166, 5 },
  { 166, 3 },
  { 166, 10 },
  { 168, 0 },
  { 168, 1 },
  { 139, 0 },
  { 139, 3 },
  { 169, 0 },
  { 169, 2 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 137, 3 },
  { 137, 6 },
  { 137, 3 },
  { 137, 1 },
  { 146, 1 },
  { 146, 3 },
  { 172, 1 },
  { 172, 2 },
  { 172, 1 },
  { 172, 1 },
  { 171, 9 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 181, 2 },
  { 181, 0 },
  { 174, 3 },
  { 174, 2 },
  { 174, 4 },
  { 182, 2 },
  { 182, 1 },
  { 182, 0 },
  { 175, 0 },
  { 175, 2 },
  { 184, 2 },
  { 184, 0 },
  { 183, 6 },
  { 183, 7 },
  { 189, 1 },
  { 189, 1 },
  { 186, 0 },
  { 186, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 2 },
  { 185, 3 },
  { 185, 4 },
  { 187, 2 },
  { 187, 0 },
  { 188, 4 },
  { 188, 0 },
  { 179, 0 },
  { 179, 3 },
  { 191, 5 },
  { 191, 3 },
  { 192, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 0 },
  { 193, 0 },
  { 193, 2 },
  { 177, 0 },
  { 177, 3 },
  { 178, 0 },
  { 178, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 4 },
  { 180, 4 },
  { 137, 5 },
  { 176, 0 },
  { 176, 2 },
  { 137, 7 },
  { 195, 5 },
  { 195, 3 },
  { 137, 9 },
  { 137, 6 },
  { 196, 2 },
  { 196, 1 },
  { 198, 3 },
  { 198, 1 },
  { 197, 0 },
  { 197, 3 },
  { 199, 3 },
  { 199, 1 },
  { 158, 3 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 3 },
  { 158, 5 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 4 },
  { 158, 4 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 4 },
  { 200, 1 },
  { 200, 1 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 2 },
  { 158, 3 },
  { 158, 2 },
  { 158, 3 },
  { 158, 4 },
  { 158, 2 },
  { 158, 2 },
  { 158, 2 },
  { 158, 2 },
  { 158, 3 },
  { 158, 5 },
  { 158, 6 },
  { 158, 5 },
  { 158, 5 },
  { 158, 6 },
  { 158, 6 },
  { 158, 4 },
  { 158, 5 },
  { 158, 5 },
  { 202, 5 },
  { 202, 4 },
  { 203, 2 },
  { 203, 0 },
  { 201, 1 },
  { 201, 0 },
  { 194, 3 },
  { 194, 1 },
  { 204, 1 },
  { 204, 0 },
  { 137, 11 },
  { 205, 1 },
  { 205, 0 },
  { 159, 0 },
  { 159, 3 },
  { 167, 3 },
  { 167, 1 },
  { 206, 2 },
  { 137, 4 },
  { 137, 9 },
  { 137, 6 },
  { 137, 1 },
  { 137, 2 },
  { 137, 4 },
  { 137, 4 },
  { 137, 4 },
  { 137, 4 },
  { 137, 5 },
  { 137, 2 },
  { 207, 2 },
  { 208, 2 },
  { 210, 1 },
  { 210, 1 },
  { 209, 1 },
  { 209, 0 },
  { 137, 5 },
  { 211, 10 },
  { 213, 1 },
  { 213, 1 },
  { 213, 2 },
  { 213, 0 },
  { 214, 1 },
  { 214, 1 },
  { 214, 1 },
  { 214, 3 },
  { 215, 0 },
  { 215, 3 },
  { 215, 3 },
  { 216, 0 },
  { 216, 2 },
  { 212, 3 },
  { 212, 0 },
  { 217, 6 },
  { 217, 8 },
  { 217, 5 },
  { 217, 4 },
  { 217, 1 },
  { 158, 4 },
  { 158, 6 },
  { 158, 6 },
  { 158, 6 },
  { 137, 4 },
  { 137, 6 },
  { 219, 2 },
  { 219, 0 },
  { 218, 1 },
  { 218, 0 },
  { 137, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqliteParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        /* No destructor defined for cmdlist */
        break;
      case 1:
        /* No destructor defined for cmdlist */
        /* No destructor defined for ecmd */
        break;
      case 2:
        /* No destructor defined for ecmd */
        break;
      case 3:
        /* No destructor defined for explain */
        /* No destructor defined for cmdx */
        /* No destructor defined for SEMI */
        break;
      case 4:
        /* No destructor defined for SEMI */
        break;
      case 5:
#line 72 "parse.y"
{ sqliteExec(pParse); }
#line 1901 "parse.c"
        /* No destructor defined for cmd */
        break;
      case 6:
#line 73 "parse.y"
{ sqliteBeginParse(pParse, 1); }
#line 1907 "parse.c"
        /* No destructor defined for EXPLAIN */
        break;
      case 7:
#line 74 "parse.y"
{ sqliteBeginParse(pParse, 0); }
#line 1913 "parse.c"
        break;
      case 8:
#line 79 "parse.y"
{sqliteBeginTransaction(pParse,yymsp[0].minor.yy372);}
#line 1918 "parse.c"
        /* No destructor defined for BEGIN */
        /* No destructor defined for trans_opt */
        break;
      case 9:
        break;
      case 10:
        /* No destructor defined for TRANSACTION */
        break;
      case 11:
        /* No destructor defined for TRANSACTION */
        /* No destructor defined for nm */
        break;
      case 12:
#line 83 "parse.y"
{sqliteCommitTransaction(pParse);}
#line 1934 "parse.c"
        /* No destructor defined for COMMIT */
        /* No destructor defined for trans_opt */
        break;
      case 13:
#line 84 "parse.y"
{sqliteCommitTransaction(pParse);}
#line 1941 "parse.c"
        /* No destructor defined for END */
        /* No destructor defined for trans_opt */
        break;
      case 14:
#line 85 "parse.y"
{sqliteRollbackTransaction(pParse);}
#line 1948 "parse.c"
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for trans_opt */
        break;
      case 15:
        /* No destructor defined for create_table */
        /* No destructor defined for create_table_args */
        break;
      case 16:
#line 90 "parse.y"
{
   sqliteStartTable(pParse,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy298,yymsp[-2].minor.yy372,0);
}
#line 1961 "parse.c"
        /* No destructor defined for TABLE */
        break;
      case 17:
#line 94 "parse.y"
{yygotominor.yy372 = 1;}
#line 1967 "parse.c"
        /* No destructor defined for TEMP */
        break;
      case 18:
#line 95 "parse.y"
{yygotominor.yy372 = 0;}
#line 1973 "parse.c"
        break;
      case 19:
#line 96 "parse.y"
{
  sqliteEndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 1980 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for columnlist */
        /* No destructor defined for conslist_opt */
        break;
      case 20:
#line 99 "parse.y"
{
  sqliteEndTable(pParse,0,yymsp[0].minor.yy179);
  sqliteSelectDelete(yymsp[0].minor.yy179);
}
#line 1991 "parse.c"
        /* No destructor defined for AS */
        break;
      case 21:
        /* No destructor defined for columnlist */
        /* No destructor defined for COMMA */
        /* No destructor defined for column */
        break;
      case 22:
        /* No destructor defined for column */
        break;
      case 23:
        /* No destructor defined for columnid */
        /* No destructor defined for type */
        /* No destructor defined for carglist */
        break;
      case 24:
#line 111 "parse.y"
{sqliteAddColumn(pParse,&yymsp[0].minor.yy298);}
#line 2010 "parse.c"
        break;
      case 25:
#line 117 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2015 "parse.c"
        break;
      case 26:
#line 149 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2020 "parse.c"
        break;
      case 27:
#line 150 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2025 "parse.c"
        break;
      case 28:
#line 155 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2030 "parse.c"
        break;
      case 29:
#line 156 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2035 "parse.c"
        break;
      case 30:
#line 157 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 2040 "parse.c"
        break;
      case 31:
        break;
      case 32:
#line 160 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[0].minor.yy298,&yymsp[0].minor.yy298);}
#line 2047 "parse.c"
        break;
      case 33:
#line 161 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[-3].minor.yy298,&yymsp[0].minor.yy0);}
#line 2052 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        break;
      case 34:
#line 163 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[-5].minor.yy298,&yymsp[0].minor.yy0);}
#line 2059 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        /* No destructor defined for COMMA */
        /* No destructor defined for signed */
        break;
      case 35:
#line 165 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy298;}
#line 2068 "parse.c"
        break;
      case 36:
#line 166 "parse.y"
{yygotominor.yy298 = yymsp[-1].minor.yy298;}
#line 2073 "parse.c"
        /* No destructor defined for ids */
        break;
      case 37:
#line 168 "parse.y"
{ yygotominor.yy372 = atoi(yymsp[0].minor.yy0.z); }
#line 2079 "parse.c"
        break;
      case 38:
#line 169 "parse.y"
{ yygotominor.yy372 = atoi(yymsp[0].minor.yy0.z); }
#line 2084 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 39:
#line 170 "parse.y"
{ yygotominor.yy372 = -atoi(yymsp[0].minor.yy0.z); }
#line 2090 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 40:
        /* No destructor defined for carglist */
        /* No destructor defined for carg */
        break;
      case 41:
        break;
      case 42:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        /* No destructor defined for ccons */
        break;
      case 43:
        /* No destructor defined for ccons */
        break;
      case 44:
#line 175 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2110 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 45:
#line 176 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2116 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 46:
#line 177 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2122 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 47:
#line 178 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2128 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 48:
#line 179 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2135 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 49:
#line 180 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2142 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 50:
#line 181 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2148 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 51:
#line 182 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2155 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 52:
        /* No destructor defined for DEFAULT */
        /* No destructor defined for NULL */
        break;
      case 53:
        /* No destructor defined for NULL */
        /* No destructor defined for onconf */
        break;
      case 54:
#line 189 "parse.y"
{sqliteAddNotNull(pParse, yymsp[0].minor.yy372);}
#line 2170 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for NULL */
        break;
      case 55:
#line 190 "parse.y"
{sqliteAddPrimaryKey(pParse,0,yymsp[0].minor.yy372);}
#line 2177 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for sortorder */
        break;
      case 56:
#line 191 "parse.y"
{sqliteCreateIndex(pParse,0,0,0,yymsp[0].minor.yy372,0,0);}
#line 2185 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 57:
        /* No destructor defined for CHECK */
        /* No destructor defined for LP */
  yy_destructor(158,&yymsp[-2].minor);
        /* No destructor defined for RP */
        /* No destructor defined for onconf */
        break;
      case 58:
#line 194 "parse.y"
{sqliteCreateForeignKey(pParse,0,&yymsp[-2].minor.yy298,yymsp[-1].minor.yy320,yymsp[0].minor.yy372);}
#line 2198 "parse.c"
        /* No destructor defined for REFERENCES */
        break;
      case 59:
#line 195 "parse.y"
{sqliteDeferForeignKey(pParse,yymsp[0].minor.yy372);}
#line 2204 "parse.c"
        break;
      case 60:
#line 196 "parse.y"
{
   sqliteAddCollateType(pParse, sqliteCollateType(yymsp[0].minor.yy298.z, yymsp[0].minor.yy298.n));
}
#line 2211 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 61:
#line 206 "parse.y"
{ yygotominor.yy372 = OE_Restrict * 0x010101; }
#line 2217 "parse.c"
        break;
      case 62:
#line 207 "parse.y"
{ yygotominor.yy372 = (yymsp[-1].minor.yy372 & yymsp[0].minor.yy407.mask) | yymsp[0].minor.yy407.value; }
#line 2222 "parse.c"
        break;
      case 63:
#line 209 "parse.y"
{ yygotominor.yy407.value = 0;     yygotominor.yy407.mask = 0x000000; }
#line 2227 "parse.c"
        /* No destructor defined for MATCH */
        /* No destructor defined for nm */
        break;
      case 64:
#line 210 "parse.y"
{ yygotominor.yy407.value = yymsp[0].minor.yy372;     yygotominor.yy407.mask = 0x0000ff; }
#line 2234 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for DELETE */
        break;
      case 65:
#line 211 "parse.y"
{ yygotominor.yy407.value = yymsp[0].minor.yy372<<8;  yygotominor.yy407.mask = 0x00ff00; }
#line 2241 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for UPDATE */
        break;
      case 66:
#line 212 "parse.y"
{ yygotominor.yy407.value = yymsp[0].minor.yy372<<16; yygotominor.yy407.mask = 0xff0000; }
#line 2248 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for INSERT */
        break;
      case 67:
#line 214 "parse.y"
{ yygotominor.yy372 = OE_SetNull; }
#line 2255 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for NULL */
        break;
      case 68:
#line 215 "parse.y"
{ yygotominor.yy372 = OE_SetDflt; }
#line 2262 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for DEFAULT */
        break;
      case 69:
#line 216 "parse.y"
{ yygotominor.yy372 = OE_Cascade; }
#line 2269 "parse.c"
        /* No destructor defined for CASCADE */
        break;
      case 70:
#line 217 "parse.y"
{ yygotominor.yy372 = OE_Restrict; }
#line 2275 "parse.c"
        /* No destructor defined for RESTRICT */
        break;
      case 71:
#line 219 "parse.y"
{yygotominor.yy372 = yymsp[0].minor.yy372;}
#line 2281 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for DEFERRABLE */
        break;
      case 72:
#line 220 "parse.y"
{yygotominor.yy372 = yymsp[0].minor.yy372;}
#line 2288 "parse.c"
        /* No destructor defined for DEFERRABLE */
        break;
      case 73:
#line 222 "parse.y"
{yygotominor.yy372 = 0;}
#line 2294 "parse.c"
        break;
      case 74:
#line 223 "parse.y"
{yygotominor.yy372 = 1;}
#line 2299 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for DEFERRED */
        break;
      case 75:
#line 224 "parse.y"
{yygotominor.yy372 = 0;}
#line 2306 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for IMMEDIATE */
        break;
      case 76:
        break;
      case 77:
        /* No destructor defined for COMMA */
        /* No destructor defined for conslist */
        break;
      case 78:
        /* No destructor defined for conslist */
        /* No destructor defined for COMMA */
        /* No destructor defined for tcons */
        break;
      case 79:
        /* No destructor defined for conslist */
        /* No destructor defined for tcons */
        break;
      case 80:
        /* No destructor defined for tcons */
        break;
      case 81:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        break;
      case 82:
#line 236 "parse.y"
{sqliteAddPrimaryKey(pParse,yymsp[-2].minor.yy320,yymsp[0].minor.yy372);}
#line 2335 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 83:
#line 238 "parse.y"
{sqliteCreateIndex(pParse,0,0,yymsp[-2].minor.yy320,yymsp[0].minor.yy372,0,0);}
#line 2344 "parse.c"
        /* No destructor defined for UNIQUE */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 84:
        /* No destructor defined for CHECK */
  yy_destructor(158,&yymsp[-1].minor);
        /* No destructor defined for onconf */
        break;
      case 85:
#line 241 "parse.y"
{
    sqliteCreateForeignKey(pParse, yymsp[-6].minor.yy320, &yymsp[-3].minor.yy298, yymsp[-2].minor.yy320, yymsp[-1].minor.yy372);
    sqliteDeferForeignKey(pParse, yymsp[0].minor.yy372);
}
#line 2360 "parse.c"
        /* No destructor defined for FOREIGN */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        /* No destructor defined for REFERENCES */
        break;
      case 86:
#line 246 "parse.y"
{yygotominor.yy372 = 0;}
#line 2370 "parse.c"
        break;
      case 87:
#line 247 "parse.y"
{yygotominor.yy372 = yymsp[0].minor.yy372;}
#line 2375 "parse.c"
        break;
      case 88:
#line 255 "parse.y"
{ yygotominor.yy372 = OE_Default; }
#line 2380 "parse.c"
        break;
      case 89:
#line 256 "parse.y"
{ yygotominor.yy372 = yymsp[0].minor.yy372; }
#line 2385 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for CONFLICT */
        break;
      case 90:
#line 257 "parse.y"
{ yygotominor.yy372 = OE_Default; }
#line 2392 "parse.c"
        break;
      case 91:
#line 258 "parse.y"
{ yygotominor.yy372 = yymsp[0].minor.yy372; }
#line 2397 "parse.c"
        /* No destructor defined for OR */
        break;
      case 92:
#line 259 "parse.y"
{ yygotominor.yy372 = OE_Rollback; }
#line 2403 "parse.c"
        /* No destructor defined for ROLLBACK */
        break;
      case 93:
#line 260 "parse.y"
{ yygotominor.yy372 = OE_Abort; }
#line 2409 "parse.c"
        /* No destructor defined for ABORT */
        break;
      case 94:
#line 261 "parse.y"
{ yygotominor.yy372 = OE_Fail; }
#line 2415 "parse.c"
        /* No destructor defined for FAIL */
        break;
      case 95:
#line 262 "parse.y"
{ yygotominor.yy372 = OE_Ignore; }
#line 2421 "parse.c"
        /* No destructor defined for IGNORE */
        break;
      case 96:
#line 263 "parse.y"
{ yygotominor.yy372 = OE_Replace; }
#line 2427 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 97:
#line 267 "parse.y"
{sqliteDropTable(pParse,&yymsp[0].minor.yy298,0);}
#line 2433 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TABLE */
        break;
      case 98:
#line 271 "parse.y"
{
  sqliteCreateView(pParse, &yymsp[-5].minor.yy0, &yymsp[-2].minor.yy298, yymsp[0].minor.yy179, yymsp[-4].minor.yy372);
}
#line 2442 "parse.c"
        /* No destructor defined for VIEW */
        /* No destructor defined for AS */
        break;
      case 99:
#line 274 "parse.y"
{
  sqliteDropTable(pParse, &yymsp[0].minor.yy298, 1);
}
#line 2451 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for VIEW */
        break;
      case 100:
#line 280 "parse.y"
{
  sqliteSelect(pParse, yymsp[0].minor.yy179, SRT_Callback, 0, 0, 0, 0);
  sqliteSelectDelete(yymsp[0].minor.yy179);
}
#line 2461 "parse.c"
        break;
      case 101:
#line 290 "parse.y"
{yygotominor.yy179 = yymsp[0].minor.yy179;}
#line 2466 "parse.c"
        break;
      case 102:
#line 291 "parse.y"
{
  if( yymsp[0].minor.yy179 ){
    yymsp[0].minor.yy179->op = yymsp[-1].minor.yy372;
    yymsp[0].minor.yy179->pPrior = yymsp[-2].minor.yy179;
  }
  yygotominor.yy179 = yymsp[0].minor.yy179;
}
#line 2477 "parse.c"
        break;
      case 103:
#line 299 "parse.y"
{yygotominor.yy372 = TK_UNION;}
#line 2482 "parse.c"
        /* No destructor defined for UNION */
        break;
      case 104:
#line 300 "parse.y"
{yygotominor.yy372 = TK_ALL;}
#line 2488 "parse.c"
        /* No destructor defined for UNION */
        /* No destructor defined for ALL */
        break;
      case 105:
#line 301 "parse.y"
{yygotominor.yy372 = TK_INTERSECT;}
#line 2495 "parse.c"
        /* No destructor defined for INTERSECT */
        break;
      case 106:
#line 302 "parse.y"
{yygotominor.yy372 = TK_EXCEPT;}
#line 2501 "parse.c"
        /* No destructor defined for EXCEPT */
        break;
      case 107:
#line 304 "parse.y"
{
  yygotominor.yy179 = sqliteSelectNew(yymsp[-6].minor.yy322,yymsp[-5].minor.yy307,yymsp[-4].minor.yy242,yymsp[-3].minor.yy322,yymsp[-2].minor.yy242,yymsp[-1].minor.yy322,yymsp[-7].minor.yy372,yymsp[0].minor.yy124.limit,yymsp[0].minor.yy124.offset);
}
#line 2509 "parse.c"
        /* No destructor defined for SELECT */
        break;
      case 108:
#line 312 "parse.y"
{yygotominor.yy372 = 1;}
#line 2515 "parse.c"
        /* No destructor defined for DISTINCT */
        break;
      case 109:
#line 313 "parse.y"
{yygotominor.yy372 = 0;}
#line 2521 "parse.c"
        /* No destructor defined for ALL */
        break;
      case 110:
#line 314 "parse.y"
{yygotominor.yy372 = 0;}
#line 2527 "parse.c"
        break;
      case 111:
#line 325 "parse.y"
{yygotominor.yy322 = yymsp[-1].minor.yy322;}
#line 2532 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 112:
#line 326 "parse.y"
{yygotominor.yy322 = 0;}
#line 2538 "parse.c"
        break;
      case 113:
#line 327 "parse.y"
{
   yygotominor.yy322 = sqliteExprListAppend(yymsp[-2].minor.yy322,yymsp[-1].minor.yy242,yymsp[0].minor.yy298.n?&yymsp[0].minor.yy298:0);
}
#line 2545 "parse.c"
        break;
      case 114:
#line 330 "parse.y"
{
  yygotominor.yy322 = sqliteExprListAppend(yymsp[-1].minor.yy322, sqliteExpr(TK_ALL, 0, 0, 0), 0);
}
#line 2552 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 115:
#line 333 "parse.y"
{
  Expr *pRight = sqliteExpr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy298);
  yygotominor.yy322 = sqliteExprListAppend(yymsp[-3].minor.yy322, sqliteExpr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2562 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for STAR */
        break;
      case 116:
#line 343 "parse.y"
{ yygotominor.yy298 = yymsp[0].minor.yy298; }
#line 2569 "parse.c"
        /* No destructor defined for AS */
        break;
      case 117:
#line 344 "parse.y"
{ yygotominor.yy298 = yymsp[0].minor.yy298; }
#line 2575 "parse.c"
        break;
      case 118:
#line 345 "parse.y"
{ yygotominor.yy298.n = 0; }
#line 2580 "parse.c"
        break;
      case 119:
#line 357 "parse.y"
{yygotominor.yy307 = sqliteMalloc(sizeof(*yygotominor.yy307));}
#line 2585 "parse.c"
        break;
      case 120:
#line 358 "parse.y"
{yygotominor.yy307 = yymsp[0].minor.yy307;}
#line 2590 "parse.c"
        /* No destructor defined for FROM */
        break;
      case 121:
#line 363 "parse.y"
{
   yygotominor.yy307 = yymsp[-1].minor.yy307;
   if( yygotominor.yy307 && yygotominor.yy307->nSrc>0 ) yygotominor.yy307->a[yygotominor.yy307->nSrc-1].jointype = yymsp[0].minor.yy372;
}
#line 2599 "parse.c"
        break;
      case 122:
#line 367 "parse.y"
{yygotominor.yy307 = 0;}
#line 2604 "parse.c"
        break;
      case 123:
#line 368 "parse.y"
{
  yygotominor.yy307 = sqliteSrcListAppend(yymsp[-5].minor.yy307,&yymsp[-4].minor.yy298,&yymsp[-3].minor.yy298);
  if( yymsp[-2].minor.yy298.n ) sqliteSrcListAddAlias(yygotominor.yy307,&yymsp[-2].minor.yy298);
  if( yymsp[-1].minor.yy242 ){
    if( yygotominor.yy307 && yygotominor.yy307->nSrc>1 ){ yygotominor.yy307->a[yygotominor.yy307->nSrc-2].pOn = yymsp[-1].minor.yy242; }
    else { sqliteExprDelete(yymsp[-1].minor.yy242); }
  }
  if( yymsp[0].minor.yy320 ){
    if( yygotominor.yy307 && yygotominor.yy307->nSrc>1 ){ yygotominor.yy307->a[yygotominor.yy307->nSrc-2].pUsing = yymsp[0].minor.yy320; }
    else { sqliteIdListDelete(yymsp[0].minor.yy320); }
  }
}
#line 2620 "parse.c"
        break;
      case 124:
#line 381 "parse.y"
{
  yygotominor.yy307 = sqliteSrcListAppend(yymsp[-6].minor.yy307,0,0);
  yygotominor.yy307->a[yygotominor.yy307->nSrc-1].pSelect = yymsp[-4].minor.yy179;
  if( yymsp[-2].minor.yy298.n ) sqliteSrcListAddAlias(yygotominor.yy307,&yymsp[-2].minor.yy298);
  if( yymsp[-1].minor.yy242 ){
    if( yygotominor.yy307 && yygotominor.yy307->nSrc>1 ){ yygotominor.yy307->a[yygotominor.yy307->nSrc-2].pOn = yymsp[-1].minor.yy242; }
    else { sqliteExprDelete(yymsp[-1].minor.yy242); }
  }
  if( yymsp[0].minor.yy320 ){
    if( yygotominor.yy307 && yygotominor.yy307->nSrc>1 ){ yygotominor.yy307->a[yygotominor.yy307->nSrc-2].pUsing = yymsp[0].minor.yy320; }
    else { sqliteIdListDelete(yymsp[0].minor.yy320); }
  }
}
#line 2637 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 125:
#line 401 "parse.y"
{yygotominor.yy179 = yymsp[0].minor.yy179;}
#line 2644 "parse.c"
        break;
      case 126:
#line 402 "parse.y"
{
   yygotominor.yy179 = sqliteSelectNew(0,yymsp[0].minor.yy307,0,0,0,0,0,-1,0);
}
#line 2651 "parse.c"
        break;
      case 127:
#line 407 "parse.y"
{yygotominor.yy298.z=0; yygotominor.yy298.n=0;}
#line 2656 "parse.c"
        break;
      case 128:
#line 408 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy298;}
#line 2661 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 129:
#line 412 "parse.y"
{ yygotominor.yy372 = JT_INNER; }
#line 2667 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 130:
#line 413 "parse.y"
{ yygotominor.yy372 = JT_INNER; }
#line 2673 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 131:
#line 414 "parse.y"
{ yygotominor.yy372 = sqliteJoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2679 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 132:
#line 415 "parse.y"
{ yygotominor.yy372 = sqliteJoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy298,0); }
#line 2685 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 133:
#line 417 "parse.y"
{ yygotominor.yy372 = sqliteJoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy298,&yymsp[-1].minor.yy298); }
#line 2691 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 134:
#line 421 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 2697 "parse.c"
        /* No destructor defined for ON */
        break;
      case 135:
#line 422 "parse.y"
{yygotominor.yy242 = 0;}
#line 2703 "parse.c"
        break;
      case 136:
#line 426 "parse.y"
{yygotominor.yy320 = yymsp[-1].minor.yy320;}
#line 2708 "parse.c"
        /* No destructor defined for USING */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 137:
#line 427 "parse.y"
{yygotominor.yy320 = 0;}
#line 2716 "parse.c"
        break;
      case 138:
#line 437 "parse.y"
{yygotominor.yy322 = 0;}
#line 2721 "parse.c"
        break;
      case 139:
#line 438 "parse.y"
{yygotominor.yy322 = yymsp[0].minor.yy322;}
#line 2726 "parse.c"
        /* No destructor defined for ORDER */
        /* No destructor defined for BY */
        break;
      case 140:
#line 439 "parse.y"
{
  yygotominor.yy322 = sqliteExprListAppend(yymsp[-4].minor.yy322,yymsp[-2].minor.yy242,0);
  if( yygotominor.yy322 ) yygotominor.yy322->a[yygotominor.yy322->nExpr-1].sortOrder = yymsp[-1].minor.yy372+yymsp[0].minor.yy372;
}
#line 2736 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 141:
#line 443 "parse.y"
{
  yygotominor.yy322 = sqliteExprListAppend(0,yymsp[-2].minor.yy242,0);
  if( yygotominor.yy322 ) yygotominor.yy322->a[0].sortOrder = yymsp[-1].minor.yy372+yymsp[0].minor.yy372;
}
#line 2745 "parse.c"
        break;
      case 142:
#line 447 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 2750 "parse.c"
        break;
      case 143:
#line 452 "parse.y"
{yygotominor.yy372 = SQLITE_SO_ASC;}
#line 2755 "parse.c"
        /* No destructor defined for ASC */
        break;
      case 144:
#line 453 "parse.y"
{yygotominor.yy372 = SQLITE_SO_DESC;}
#line 2761 "parse.c"
        /* No destructor defined for DESC */
        break;
      case 145:
#line 454 "parse.y"
{yygotominor.yy372 = SQLITE_SO_ASC;}
#line 2767 "parse.c"
        break;
      case 146:
#line 455 "parse.y"
{yygotominor.yy372 = SQLITE_SO_UNK;}
#line 2772 "parse.c"
        break;
      case 147:
#line 456 "parse.y"
{yygotominor.yy372 = sqliteCollateType(yymsp[0].minor.yy298.z, yymsp[0].minor.yy298.n);}
#line 2777 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 148:
#line 460 "parse.y"
{yygotominor.yy322 = 0;}
#line 2783 "parse.c"
        break;
      case 149:
#line 461 "parse.y"
{yygotominor.yy322 = yymsp[0].minor.yy322;}
#line 2788 "parse.c"
        /* No destructor defined for GROUP */
        /* No destructor defined for BY */
        break;
      case 150:
#line 465 "parse.y"
{yygotominor.yy242 = 0;}
#line 2795 "parse.c"
        break;
      case 151:
#line 466 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 2800 "parse.c"
        /* No destructor defined for HAVING */
        break;
      case 152:
#line 469 "parse.y"
{yygotominor.yy124.limit = -1; yygotominor.yy124.offset = 0;}
#line 2806 "parse.c"
        break;
      case 153:
#line 470 "parse.y"
{yygotominor.yy124.limit = yymsp[0].minor.yy372; yygotominor.yy124.offset = 0;}
#line 2811 "parse.c"
        /* No destructor defined for LIMIT */
        break;
      case 154:
#line 472 "parse.y"
{yygotominor.yy124.limit = yymsp[-2].minor.yy372; yygotominor.yy124.offset = yymsp[0].minor.yy372;}
#line 2817 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for OFFSET */
        break;
      case 155:
#line 474 "parse.y"
{yygotominor.yy124.limit = yymsp[0].minor.yy372; yygotominor.yy124.offset = yymsp[-2].minor.yy372;}
#line 2824 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for COMMA */
        break;
      case 156:
#line 478 "parse.y"
{
   sqliteDeleteFrom(pParse, sqliteSrcListAppend(0,&yymsp[-2].minor.yy298,&yymsp[-1].minor.yy298), yymsp[0].minor.yy242);
}
#line 2833 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 157:
#line 485 "parse.y"
{yygotominor.yy242 = 0;}
#line 2840 "parse.c"
        break;
      case 158:
#line 486 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 2845 "parse.c"
        /* No destructor defined for WHERE */
        break;
      case 159:
#line 494 "parse.y"
{sqliteUpdate(pParse,sqliteSrcListAppend(0,&yymsp[-4].minor.yy298,&yymsp[-3].minor.yy298),yymsp[-1].minor.yy322,yymsp[0].minor.yy242,yymsp[-5].minor.yy372);}
#line 2851 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 160:
#line 497 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(yymsp[-4].minor.yy322,yymsp[0].minor.yy242,&yymsp[-2].minor.yy298);}
#line 2858 "parse.c"
        /* No destructor defined for COMMA */
        /* No destructor defined for EQ */
        break;
      case 161:
#line 498 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(0,yymsp[0].minor.yy242,&yymsp[-2].minor.yy298);}
#line 2865 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 162:
#line 504 "parse.y"
{sqliteInsert(pParse, sqliteSrcListAppend(0,&yymsp[-6].minor.yy298,&yymsp[-5].minor.yy298), yymsp[-1].minor.yy322, 0, yymsp[-4].minor.yy320, yymsp[-8].minor.yy372);}
#line 2871 "parse.c"
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 163:
#line 506 "parse.y"
{sqliteInsert(pParse, sqliteSrcListAppend(0,&yymsp[-3].minor.yy298,&yymsp[-2].minor.yy298), 0, yymsp[0].minor.yy179, yymsp[-1].minor.yy320, yymsp[-5].minor.yy372);}
#line 2880 "parse.c"
        /* No destructor defined for INTO */
        break;
      case 164:
#line 509 "parse.y"
{yygotominor.yy372 = yymsp[0].minor.yy372;}
#line 2886 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 165:
#line 510 "parse.y"
{yygotominor.yy372 = OE_Replace;}
#line 2892 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 166:
#line 516 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(yymsp[-2].minor.yy322,yymsp[0].minor.yy242,0);}
#line 2898 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 167:
#line 517 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(0,yymsp[0].minor.yy242,0);}
#line 2904 "parse.c"
        break;
      case 168:
#line 524 "parse.y"
{yygotominor.yy320 = 0;}
#line 2909 "parse.c"
        break;
      case 169:
#line 525 "parse.y"
{yygotominor.yy320 = yymsp[-1].minor.yy320;}
#line 2914 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 170:
#line 526 "parse.y"
{yygotominor.yy320 = sqliteIdListAppend(yymsp[-2].minor.yy320,&yymsp[0].minor.yy298);}
#line 2921 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 171:
#line 527 "parse.y"
{yygotominor.yy320 = sqliteIdListAppend(0,&yymsp[0].minor.yy298);}
#line 2927 "parse.c"
        break;
      case 172:
#line 535 "parse.y"
{yygotominor.yy242 = yymsp[-1].minor.yy242; sqliteExprSpan(yygotominor.yy242,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2932 "parse.c"
        break;
      case 173:
#line 536 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_NULL, 0, 0, &yymsp[0].minor.yy0);}
#line 2937 "parse.c"
        break;
      case 174:
#line 537 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2942 "parse.c"
        break;
      case 175:
#line 538 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2947 "parse.c"
        break;
      case 176:
#line 539 "parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy298);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy298);
  yygotominor.yy242 = sqliteExpr(TK_DOT, temp1, temp2, 0);
}
#line 2956 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 177:
#line 544 "parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-4].minor.yy298);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy298);
  Expr *temp3 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy298);
  Expr *temp4 = sqliteExpr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy242 = sqliteExpr(TK_DOT, temp1, temp4, 0);
}
#line 2968 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for DOT */
        break;
      case 178:
#line 551 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 2975 "parse.c"
        break;
      case 179:
#line 552 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 2980 "parse.c"
        break;
      case 180:
#line 553 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_STRING, 0, 0, &yymsp[0].minor.yy0);}
#line 2985 "parse.c"
        break;
      case 181:
#line 554 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_VARIABLE, 0, 0, &yymsp[0].minor.yy0);
  if( yygotominor.yy242 ) yygotominor.yy242->iTable = ++pParse->nVar;
}
#line 2993 "parse.c"
        break;
      case 182:
#line 558 "parse.y"
{
  yygotominor.yy242 = sqliteExprFunction(yymsp[-1].minor.yy322, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3001 "parse.c"
        /* No destructor defined for LP */
        break;
      case 183:
#line 562 "parse.y"
{
  yygotominor.yy242 = sqliteExprFunction(0, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3010 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for STAR */
        break;
      case 184:
#line 566 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_AND, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3017 "parse.c"
        /* No destructor defined for AND */
        break;
      case 185:
#line 567 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_OR, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3023 "parse.c"
        /* No destructor defined for OR */
        break;
      case 186:
#line 568 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_LT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3029 "parse.c"
        /* No destructor defined for LT */
        break;
      case 187:
#line 569 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_GT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3035 "parse.c"
        /* No destructor defined for GT */
        break;
      case 188:
#line 570 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_LE, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3041 "parse.c"
        /* No destructor defined for LE */
        break;
      case 189:
#line 571 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_GE, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3047 "parse.c"
        /* No destructor defined for GE */
        break;
      case 190:
#line 572 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_NE, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3053 "parse.c"
        /* No destructor defined for NE */
        break;
      case 191:
#line 573 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_EQ, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3059 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 192:
#line 574 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_BITAND, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3065 "parse.c"
        /* No destructor defined for BITAND */
        break;
      case 193:
#line 575 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_BITOR, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3071 "parse.c"
        /* No destructor defined for BITOR */
        break;
      case 194:
#line 576 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_LSHIFT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3077 "parse.c"
        /* No destructor defined for LSHIFT */
        break;
      case 195:
#line 577 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_RSHIFT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3083 "parse.c"
        /* No destructor defined for RSHIFT */
        break;
      case 196:
#line 578 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[0].minor.yy242, 0);
  pList = sqliteExprListAppend(pList, yymsp[-2].minor.yy242, 0);
  yygotominor.yy242 = sqliteExprFunction(pList, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->op = yymsp[-1].minor.yy372;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-2].minor.yy242->span, &yymsp[0].minor.yy242->span);
}
#line 3095 "parse.c"
        break;
      case 197:
#line 585 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[0].minor.yy242, 0);
  pList = sqliteExprListAppend(pList, yymsp[-3].minor.yy242, 0);
  yygotominor.yy242 = sqliteExprFunction(pList, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->op = yymsp[-1].minor.yy372;
  yygotominor.yy242 = sqliteExpr(TK_NOT, yygotominor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-3].minor.yy242->span,&yymsp[0].minor.yy242->span);
}
#line 3107 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 198:
#line 594 "parse.y"
{yygotominor.yy372 = TK_LIKE;}
#line 3113 "parse.c"
        /* No destructor defined for LIKE */
        break;
      case 199:
#line 595 "parse.y"
{yygotominor.yy372 = TK_GLOB;}
#line 3119 "parse.c"
        /* No destructor defined for GLOB */
        break;
      case 200:
#line 596 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_PLUS, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3125 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 201:
#line 597 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_MINUS, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3131 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 202:
#line 598 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_STAR, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3137 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 203:
#line 599 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_SLASH, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3143 "parse.c"
        /* No destructor defined for SLASH */
        break;
      case 204:
#line 600 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_REM, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3149 "parse.c"
        /* No destructor defined for REM */
        break;
      case 205:
#line 601 "parse.y"
{yygotominor.yy242 = sqliteExpr(TK_CONCAT, yymsp[-2].minor.yy242, yymsp[0].minor.yy242, 0);}
#line 3155 "parse.c"
        /* No destructor defined for CONCAT */
        break;
      case 206:
#line 602 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_ISNULL, yymsp[-1].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3164 "parse.c"
        break;
      case 207:
#line 606 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_ISNULL, yymsp[-2].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-2].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3172 "parse.c"
        /* No destructor defined for IS */
        break;
      case 208:
#line 610 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_NOTNULL, yymsp[-1].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3181 "parse.c"
        break;
      case 209:
#line 614 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_NOTNULL, yymsp[-2].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-2].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3189 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 210:
#line 618 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_NOTNULL, yymsp[-3].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-3].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3198 "parse.c"
        /* No destructor defined for IS */
        /* No destructor defined for NOT */
        break;
      case 211:
#line 622 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_NOT, yymsp[0].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy242->span);
}
#line 3208 "parse.c"
        break;
      case 212:
#line 626 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_BITNOT, yymsp[0].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy242->span);
}
#line 3216 "parse.c"
        break;
      case 213:
#line 630 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_UMINUS, yymsp[0].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy242->span);
}
#line 3224 "parse.c"
        break;
      case 214:
#line 634 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_UPLUS, yymsp[0].minor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy242->span);
}
#line 3232 "parse.c"
        break;
      case 215:
#line 638 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pSelect = yymsp[-1].minor.yy179;
  sqliteExprSpan(yygotominor.yy242,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3241 "parse.c"
        break;
      case 216:
#line 643 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy242, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy242, 0);
  yygotominor.yy242 = sqliteExpr(TK_BETWEEN, yymsp[-4].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pList = pList;
  sqliteExprSpan(yygotominor.yy242,&yymsp[-4].minor.yy242->span,&yymsp[0].minor.yy242->span);
}
#line 3252 "parse.c"
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 217:
#line 650 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy242, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy242, 0);
  yygotominor.yy242 = sqliteExpr(TK_BETWEEN, yymsp[-5].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pList = pList;
  yygotominor.yy242 = sqliteExpr(TK_NOT, yygotominor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-5].minor.yy242->span,&yymsp[0].minor.yy242->span);
}
#line 3266 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 218:
#line 658 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-4].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pList = yymsp[-1].minor.yy322;
  sqliteExprSpan(yygotominor.yy242,&yymsp[-4].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3278 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 219:
#line 663 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-4].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pSelect = yymsp[-1].minor.yy179;
  sqliteExprSpan(yygotominor.yy242,&yymsp[-4].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3289 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 220:
#line 668 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-5].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pList = yymsp[-1].minor.yy322;
  yygotominor.yy242 = sqliteExpr(TK_NOT, yygotominor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-5].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3301 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 221:
#line 674 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-5].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pSelect = yymsp[-1].minor.yy179;
  yygotominor.yy242 = sqliteExpr(TK_NOT, yygotominor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-5].minor.yy242->span,&yymsp[0].minor.yy0);
}
#line 3314 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 222:
#line 680 "parse.y"
{
  SrcList *pSrc = sqliteSrcListAppend(0, &yymsp[-1].minor.yy298, &yymsp[0].minor.yy298);
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-3].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pSelect = sqliteSelectNew(0,pSrc,0,0,0,0,0,-1,0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-3].minor.yy242->span,yymsp[0].minor.yy298.z?&yymsp[0].minor.yy298:&yymsp[-1].minor.yy298);
}
#line 3327 "parse.c"
        /* No destructor defined for IN */
        break;
      case 223:
#line 686 "parse.y"
{
  SrcList *pSrc = sqliteSrcListAppend(0, &yymsp[-1].minor.yy298, &yymsp[0].minor.yy298);
  yygotominor.yy242 = sqliteExpr(TK_IN, yymsp[-4].minor.yy242, 0, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pSelect = sqliteSelectNew(0,pSrc,0,0,0,0,0,-1,0);
  yygotominor.yy242 = sqliteExpr(TK_NOT, yygotominor.yy242, 0, 0);
  sqliteExprSpan(yygotominor.yy242,&yymsp[-4].minor.yy242->span,yymsp[0].minor.yy298.z?&yymsp[0].minor.yy298:&yymsp[-1].minor.yy298);
}
#line 3339 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        break;
      case 224:
#line 696 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_CASE, yymsp[-3].minor.yy242, yymsp[-1].minor.yy242, 0);
  if( yygotominor.yy242 ) yygotominor.yy242->pList = yymsp[-2].minor.yy322;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3350 "parse.c"
        break;
      case 225:
#line 703 "parse.y"
{
  yygotominor.yy322 = sqliteExprListAppend(yymsp[-4].minor.yy322, yymsp[-2].minor.yy242, 0);
  yygotominor.yy322 = sqliteExprListAppend(yygotominor.yy322, yymsp[0].minor.yy242, 0);
}
#line 3358 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 226:
#line 707 "parse.y"
{
  yygotominor.yy322 = sqliteExprListAppend(0, yymsp[-2].minor.yy242, 0);
  yygotominor.yy322 = sqliteExprListAppend(yygotominor.yy322, yymsp[0].minor.yy242, 0);
}
#line 3368 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 227:
#line 712 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 3375 "parse.c"
        /* No destructor defined for ELSE */
        break;
      case 228:
#line 713 "parse.y"
{yygotominor.yy242 = 0;}
#line 3381 "parse.c"
        break;
      case 229:
#line 715 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 3386 "parse.c"
        break;
      case 230:
#line 716 "parse.y"
{yygotominor.yy242 = 0;}
#line 3391 "parse.c"
        break;
      case 231:
#line 724 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(yymsp[-2].minor.yy322,yymsp[0].minor.yy242,0);}
#line 3396 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 232:
#line 725 "parse.y"
{yygotominor.yy322 = sqliteExprListAppend(0,yymsp[0].minor.yy242,0);}
#line 3402 "parse.c"
        break;
      case 233:
#line 726 "parse.y"
{yygotominor.yy242 = yymsp[0].minor.yy242;}
#line 3407 "parse.c"
        break;
      case 234:
#line 727 "parse.y"
{yygotominor.yy242 = 0;}
#line 3412 "parse.c"
        break;
      case 235:
#line 732 "parse.y"
{
  SrcList *pSrc = sqliteSrcListAppend(0, &yymsp[-5].minor.yy298, &yymsp[-4].minor.yy298);
  if( yymsp[-9].minor.yy372!=OE_None ) yymsp[-9].minor.yy372 = yymsp[0].minor.yy372;
  if( yymsp[-9].minor.yy372==OE_Default) yymsp[-9].minor.yy372 = OE_Abort;
  sqliteCreateIndex(pParse, &yymsp[-7].minor.yy298, pSrc, yymsp[-2].minor.yy320, yymsp[-9].minor.yy372, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 3422 "parse.c"
        /* No destructor defined for INDEX */
        /* No destructor defined for ON */
        /* No destructor defined for LP */
        break;
      case 236:
#line 740 "parse.y"
{ yygotominor.yy372 = OE_Abort; }
#line 3430 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 237:
#line 741 "parse.y"
{ yygotominor.yy372 = OE_None; }
#line 3436 "parse.c"
        break;
      case 238:
#line 749 "parse.y"
{yygotominor.yy320 = 0;}
#line 3441 "parse.c"
        break;
      case 239:
#line 750 "parse.y"
{yygotominor.yy320 = yymsp[-1].minor.yy320;}
#line 3446 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 240:
#line 751 "parse.y"
{yygotominor.yy320 = sqliteIdListAppend(yymsp[-2].minor.yy320,&yymsp[0].minor.yy298);}
#line 3453 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 241:
#line 752 "parse.y"
{yygotominor.yy320 = sqliteIdListAppend(0,&yymsp[0].minor.yy298);}
#line 3459 "parse.c"
        break;
      case 242:
#line 753 "parse.y"
{yygotominor.yy298 = yymsp[-1].minor.yy298;}
#line 3464 "parse.c"
        /* No destructor defined for sortorder */
        break;
      case 243:
#line 758 "parse.y"
{
  sqliteDropIndex(pParse, sqliteSrcListAppend(0,&yymsp[-1].minor.yy298,&yymsp[0].minor.yy298));
}
#line 3472 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for INDEX */
        break;
      case 244:
#line 766 "parse.y"
{sqliteCopy(pParse,sqliteSrcListAppend(0,&yymsp[-6].minor.yy298,&yymsp[-5].minor.yy298),&yymsp[-3].minor.yy298,&yymsp[0].minor.yy0,yymsp[-7].minor.yy372);}
#line 3479 "parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        /* No destructor defined for USING */
        /* No destructor defined for DELIMITERS */
        break;
      case 245:
#line 768 "parse.y"
{sqliteCopy(pParse,sqliteSrcListAppend(0,&yymsp[-3].minor.yy298,&yymsp[-2].minor.yy298),&yymsp[0].minor.yy298,0,yymsp[-4].minor.yy372);}
#line 3488 "parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        break;
      case 246:
#line 772 "parse.y"
{sqliteVacuum(pParse,0);}
#line 3495 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 247:
#line 773 "parse.y"
{sqliteVacuum(pParse,&yymsp[0].minor.yy298);}
#line 3501 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 248:
#line 777 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy298,&yymsp[0].minor.yy298,0);}
#line 3507 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 249:
#line 778 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy298,&yymsp[0].minor.yy0,0);}
#line 3514 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 250:
#line 779 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy298,&yymsp[0].minor.yy298,0);}
#line 3521 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 251:
#line 780 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy298,&yymsp[0].minor.yy298,1);}
#line 3528 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 252:
#line 781 "parse.y"
{sqlitePragma(pParse,&yymsp[-3].minor.yy298,&yymsp[-1].minor.yy298,0);}
#line 3535 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 253:
#line 782 "parse.y"
{sqlitePragma(pParse,&yymsp[0].minor.yy298,&yymsp[0].minor.yy298,0);}
#line 3543 "parse.c"
        /* No destructor defined for PRAGMA */
        break;
      case 254:
#line 783 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy298;}
#line 3549 "parse.c"
        /* No destructor defined for plus_opt */
        break;
      case 255:
#line 784 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy298;}
#line 3555 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 256:
#line 785 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 3561 "parse.c"
        break;
      case 257:
#line 786 "parse.y"
{yygotominor.yy298 = yymsp[0].minor.yy0;}
#line 3566 "parse.c"
        break;
      case 258:
        /* No destructor defined for PLUS */
        break;
      case 259:
        break;
      case 260:
#line 792 "parse.y"
{
  Token all;
  all.z = yymsp[-4].minor.yy0.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-4].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqliteFinishTrigger(pParse, yymsp[-1].minor.yy19, &all);
}
#line 3581 "parse.c"
        /* No destructor defined for trigger_decl */
        /* No destructor defined for BEGIN */
        break;
      case 261:
#line 800 "parse.y"
{
  SrcList *pTab = sqliteSrcListAppend(0, &yymsp[-3].minor.yy298, &yymsp[-2].minor.yy298);
  sqliteBeginTrigger(pParse, &yymsp[-7].minor.yy298, yymsp[-6].minor.yy372, yymsp[-5].minor.yy290.a, yymsp[-5].minor.yy290.b, pTab, yymsp[-1].minor.yy372, yymsp[0].minor.yy182, yymsp[-9].minor.yy372);
}
#line 3591 "parse.c"
        /* No destructor defined for TRIGGER */
        /* No destructor defined for ON */
        break;
      case 262:
#line 806 "parse.y"
{ yygotominor.yy372 = TK_BEFORE; }
#line 3598 "parse.c"
        /* No destructor defined for BEFORE */
        break;
      case 263:
#line 807 "parse.y"
{ yygotominor.yy372 = TK_AFTER;  }
#line 3604 "parse.c"
        /* No destructor defined for AFTER */
        break;
      case 264:
#line 808 "parse.y"
{ yygotominor.yy372 = TK_INSTEAD;}
#line 3610 "parse.c"
        /* No destructor defined for INSTEAD */
        /* No destructor defined for OF */
        break;
      case 265:
#line 809 "parse.y"
{ yygotominor.yy372 = TK_BEFORE; }
#line 3617 "parse.c"
        break;
      case 266:
#line 813 "parse.y"
{ yygotominor.yy290.a = TK_DELETE; yygotominor.yy290.b = 0; }
#line 3622 "parse.c"
        /* No destructor defined for DELETE */
        break;
      case 267:
#line 814 "parse.y"
{ yygotominor.yy290.a = TK_INSERT; yygotominor.yy290.b = 0; }
#line 3628 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 268:
#line 815 "parse.y"
{ yygotominor.yy290.a = TK_UPDATE; yygotominor.yy290.b = 0;}
#line 3634 "parse.c"
        /* No destructor defined for UPDATE */
        break;
      case 269:
#line 816 "parse.y"
{yygotominor.yy290.a = TK_UPDATE; yygotominor.yy290.b = yymsp[0].minor.yy320; }
#line 3640 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for OF */
        break;
      case 270:
#line 819 "parse.y"
{ yygotominor.yy372 = TK_ROW; }
#line 3647 "parse.c"
        break;
      case 271:
#line 820 "parse.y"
{ yygotominor.yy372 = TK_ROW; }
#line 3652 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for ROW */
        break;
      case 272:
#line 821 "parse.y"
{ yygotominor.yy372 = TK_STATEMENT; }
#line 3660 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for STATEMENT */
        break;
      case 273:
#line 824 "parse.y"
{ yygotominor.yy182 = 0; }
#line 3668 "parse.c"
        break;
      case 274:
#line 825 "parse.y"
{ yygotominor.yy182 = yymsp[0].minor.yy242; }
#line 3673 "parse.c"
        /* No destructor defined for WHEN */
        break;
      case 275:
#line 829 "parse.y"
{
  yymsp[-2].minor.yy19->pNext = yymsp[0].minor.yy19;
  yygotominor.yy19 = yymsp[-2].minor.yy19;
}
#line 3682 "parse.c"
        /* No destructor defined for SEMI */
        break;
      case 276:
#line 833 "parse.y"
{ yygotominor.yy19 = 0; }
#line 3688 "parse.c"
        break;
      case 277:
#line 839 "parse.y"
{ yygotominor.yy19 = sqliteTriggerUpdateStep(&yymsp[-3].minor.yy298, yymsp[-1].minor.yy322, yymsp[0].minor.yy242, yymsp[-4].minor.yy372); }
#line 3693 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 278:
#line 844 "parse.y"
{yygotominor.yy19 = sqliteTriggerInsertStep(&yymsp[-5].minor.yy298, yymsp[-4].minor.yy320, yymsp[-1].minor.yy322, 0, yymsp[-7].minor.yy372);}
#line 3700 "parse.c"
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 279:
#line 847 "parse.y"
{yygotominor.yy19 = sqliteTriggerInsertStep(&yymsp[-2].minor.yy298, yymsp[-1].minor.yy320, 0, yymsp[0].minor.yy179, yymsp[-4].minor.yy372);}
#line 3709 "parse.c"
        /* No destructor defined for INTO */
        break;
      case 280:
#line 851 "parse.y"
{yygotominor.yy19 = sqliteTriggerDeleteStep(&yymsp[-1].minor.yy298, yymsp[0].minor.yy242);}
#line 3715 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 281:
#line 854 "parse.y"
{yygotominor.yy19 = sqliteTriggerSelectStep(yymsp[0].minor.yy179); }
#line 3722 "parse.c"
        break;
      case 282:
#line 857 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy242->iColumn = OE_Ignore;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3731 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for IGNORE */
        break;
      case 283:
#line 862 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy298); 
  yygotominor.yy242->iColumn = OE_Rollback;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3742 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for COMMA */
        break;
      case 284:
#line 867 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy298); 
  yygotominor.yy242->iColumn = OE_Abort;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3754 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ABORT */
        /* No destructor defined for COMMA */
        break;
      case 285:
#line 872 "parse.y"
{
  yygotominor.yy242 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy298); 
  yygotominor.yy242->iColumn = OE_Fail;
  sqliteExprSpan(yygotominor.yy242, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3766 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for FAIL */
        /* No destructor defined for COMMA */
        break;
      case 286:
#line 879 "parse.y"
{
  sqliteDropTrigger(pParse,sqliteSrcListAppend(0,&yymsp[-1].minor.yy298,&yymsp[0].minor.yy298));
}
#line 3776 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TRIGGER */
        break;
      case 287:
#line 884 "parse.y"
{
  sqliteAttach(pParse, &yymsp[-3].minor.yy298, &yymsp[-1].minor.yy298, &yymsp[0].minor.yy298);
}
#line 3785 "parse.c"
        /* No destructor defined for ATTACH */
        /* No destructor defined for database_kw_opt */
        /* No destructor defined for AS */
        break;
      case 288:
#line 888 "parse.y"
{ yygotominor.yy298 = yymsp[0].minor.yy298; }
#line 3793 "parse.c"
        /* No destructor defined for USING */
        break;
      case 289:
#line 889 "parse.y"
{ yygotominor.yy298.z = 0; yygotominor.yy298.n = 0; }
#line 3799 "parse.c"
        break;
      case 290:
        /* No destructor defined for DATABASE */
        break;
      case 291:
        break;
      case 292:
#line 895 "parse.y"
{
  sqliteDetach(pParse, &yymsp[0].minor.yy298);
}
#line 3811 "parse.c"
        /* No destructor defined for DETACH */
        /* No destructor defined for database_kw_opt */
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqliteParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqliteParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqliteErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqliteErrorMsg(pParse, "incomplete SQL statement");
    }
  }

#line 3865 "parse.c"
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqliteParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqliteParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqliteParserTOKENTYPE yyminor       /* The value for the token */
  sqliteParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqliteParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
