/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class PushBackInputStream
extends PushbackInputStream {
    private int offset = 0;

    public PushBackInputStream(InputStream input, int size) throws IOException {
        super(input, size);
        if (input == null) {
            throw new IOException("Error: input was null");
        }
    }

    public int peek() throws IOException {
        int result = this.read();
        if (result != -1) {
            this.unread(result);
        }
        return result;
    }

    public int getOffset() {
        return this.offset;
    }

    public int read() throws IOException {
        int retval = super.read();
        if (retval != -1) {
            ++this.offset;
        }
        return retval;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int retval = super.read(b, off, len);
        if (retval != -1) {
            this.offset += retval;
        }
        return retval;
    }

    public void unread(int b) throws IOException {
        --this.offset;
        super.unread(b);
    }

    public void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            this.offset -= len;
            super.unread(b, off, len);
        }
    }

    public boolean isEOF() throws IOException {
        int peek = this.peek();
        return peek == -1;
    }

    public void fillBuffer() throws IOException {
        int bufferLength = this.buf.length;
        byte[] tmpBuffer = new byte[bufferLength];
        int amountRead = 0;
        int totalAmountRead = 0;
        while (amountRead != -1 && totalAmountRead < bufferLength) {
            amountRead = this.read(tmpBuffer, totalAmountRead, bufferLength - totalAmountRead);
            if (amountRead == -1) continue;
            totalAmountRead += amountRead;
        }
        this.unread(tmpBuffer, 0, totalAmountRead);
    }

    public byte[] readFully(int length) throws IOException {
        int amountRead;
        byte[] data = new byte[length];
        for (int pos = 0; pos < length; pos += amountRead) {
            amountRead = this.read(data, pos, length - pos);
            if (amountRead >= 0) continue;
            throw new EOFException("Premature end of file");
        }
        return data;
    }
}

