/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.document;

import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TextSegment
extends GenericSegment {
    protected boolean isUnderlined;
    protected int superSubscript = 0;
    protected String text;
    protected float fontSize;
    protected String fontName;

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public TextSegment(float x1, float x2, float y1, float y2, String text, String fontName, float fontSize) {
        super(x1, x2, y1, y2);
        this.text = text;
        this.fontName = fontName;
        this.setFontSize(fontSize);
    }

    public TextSegment(float x1, float x2, float y1, float y2) {
        super(x1, x2, y1, y2);
        this.text = "";
    }

    public TextSegment() {
        this.text = "";
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String cleanText;
        this.text = cleanText = text.replaceAll("\\p{Cntrl}", "");
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public boolean isEmpty() {
        if (this.text != null) {
            return this.text.trim().length() == 0;
        }
        return false;
    }

    @Override
    public String getAttributes() {
        return String.valueOf(super.getAttributes()) + " text: " + this.text + " " + " fontsize: " + this.fontSize + " font: " + this.fontName + " bold: " + this.isBold() + " italic: " + this.isItalic() + " hc: " + this.hashCode();
    }

    public boolean isBold() {
        if (this.fontName == null) {
            return false;
        }
        return Utils.containsSubstring(this.fontName, "Bold") || Utils.containsSubstring(this.fontName, "bold") || Utils.containsSubstring(this.fontName, "Black") || Utils.containsSubstring(this.fontName, "black") || Utils.containsSubstring(this.fontName, "Heavy") || Utils.containsSubstring(this.fontName, "heavy");
    }

    public boolean isItalic() {
        if (this.fontName == null) {
            return false;
        }
        return Utils.containsSubstring(this.fontName, "Italic") || Utils.containsSubstring(this.fontName, "italic") || Utils.containsSubstring(this.fontName, "Cursive") || Utils.containsSubstring(this.fontName, "cursive") || Utils.containsSubstring(this.fontName, "Kursiv") || Utils.containsSubstring(this.fontName, "kursiv");
    }

    public boolean isCapitals() {
        return false;
    }

    public boolean isNumeric() {
        return false;
    }

    @Override
    public void setElementAttributes(Document resultDocument, Element newSegmentElement, GenericSegment pageDim, float resolution) {
        newSegmentElement.setAttribute("font-name", this.getFontName());
        newSegmentElement.setAttribute("font-size", Float.toString(this.getFontSize()));
        newSegmentElement.setAttribute("bold", Boolean.toString(this.isBold()));
        newSegmentElement.setAttribute("italic", Boolean.toString(this.isItalic()));
        if (this.isEmpty()) {
            if (this.getText().length() > 0) {
                newSegmentElement.appendChild(resultDocument.createTextNode("[empty:spaces]"));
            } else {
                newSegmentElement.appendChild(resultDocument.createTextNode("[empty:empty]"));
            }
        } else {
            newSegmentElement.appendChild(resultDocument.createTextNode(Utils.removeInvalidXMLCharacters(this.getText())));
        }
        super.setElementAttributes(resultDocument, newSegmentElement, pageDim, resolution);
    }

    public boolean isUnderlined() {
        return this.isUnderlined;
    }

    public void setUnderlined(boolean isUnderlined) {
        this.isUnderlined = isUnderlined;
    }

    public int getSuperSubscript() {
        return this.superSubscript;
    }

    public void setSuperSubscript(int superSubscript) {
        this.superSubscript = superSubscript;
    }
}

