/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.registry;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Iterator;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderedOp;
import javax.media.jai.registry.JaiI18N;

public final class RIFRegistry {
    private static final String MODE_NAME = "rendered";

    public static void register(OperationRegistry operationRegistry, String string, String string2, RenderedImageFactory renderedImageFactory) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.registerFactory(MODE_NAME, string, string2, renderedImageFactory);
    }

    public static void unregister(OperationRegistry operationRegistry, String string, String string2, RenderedImageFactory renderedImageFactory) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.unregisterFactory(MODE_NAME, string, string2, renderedImageFactory);
    }

    public static void setPreference(OperationRegistry operationRegistry, String string, String string2, RenderedImageFactory renderedImageFactory, RenderedImageFactory renderedImageFactory2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.setFactoryPreference(MODE_NAME, string, string2, renderedImageFactory, renderedImageFactory2);
    }

    public static void unsetPreference(OperationRegistry operationRegistry, String string, String string2, RenderedImageFactory renderedImageFactory, RenderedImageFactory renderedImageFactory2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.unsetFactoryPreference(MODE_NAME, string, string2, renderedImageFactory, renderedImageFactory2);
    }

    public static void clearPreferences(OperationRegistry operationRegistry, String string, String string2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.clearFactoryPreferences(MODE_NAME, string, string2);
    }

    public static List getOrderedList(OperationRegistry operationRegistry, String string, String string2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        return operationRegistry.getOrderedFactoryList(MODE_NAME, string, string2);
    }

    public static Iterator getIterator(OperationRegistry operationRegistry, String string) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        return operationRegistry.getFactoryIterator(MODE_NAME, string);
    }

    public static RenderedImageFactory get(OperationRegistry operationRegistry, String string) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        return (RenderedImageFactory)operationRegistry.getFactory(MODE_NAME, string);
    }

    public static RenderedImage create(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        Object[] objectArray = new Object[]{parameterBlock, renderingHints};
        return (RenderedImage)operationRegistry.invokeFactory(MODE_NAME, string, objectArray);
    }

    public static PropertySource getPropertySource(RenderedOp renderedOp) {
        if (renderedOp == null) {
            throw new IllegalArgumentException("op - " + JaiI18N.getString("Generic0"));
        }
        return renderedOp.getRegistry().getPropertySource((OperationNode)renderedOp);
    }
}

