# Generated by default/object.tt
package Paws::Forecast::ErrorMetric;
  use Moose;
  has ForecastType => (is => 'ro', isa => 'Str');
  has RMSE => (is => 'ro', isa => 'Num');
  has WAPE => (is => 'ro', isa => 'Num');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Forecast::ErrorMetric

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Forecast::ErrorMetric object:

  $service_obj->Method(Att1 => { ForecastType => $value, ..., WAPE => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Forecast::ErrorMetric object:

  $result = $service_obj->Method(...);
  $result->Att1->ForecastType

=head1 DESCRIPTION

Provides detailed error metrics to evaluate the performance of a
predictor. This object is part of the Metrics object.

=head1 ATTRIBUTES


=head2 ForecastType => Str

The Forecast type used to compute WAPE and RMSE.


=head2 RMSE => Num

The root-mean-square error (RMSE).


=head2 WAPE => Num

The weighted absolute percentage error (WAPE).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Forecast>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

