
package Paws::Athena::ListDatabasesOutput;
  use Moose;
  has DatabaseList => (is => 'ro', isa => 'ArrayRef[Paws::Athena::Database]');
  has NextToken => (is => 'ro', isa => 'Str');

  has _request_id => (is => 'ro', isa => 'Str');

### main pod documentation begin ###

=head1 NAME

Paws::Athena::ListDatabasesOutput

=head1 ATTRIBUTES


=head2 DatabaseList => ArrayRef[L<Paws::Athena::Database>]

A list of databases from a data catalog.


=head2 NextToken => Str

A token generated by the Athena service that specifies where to
continue pagination if a previous request was truncated. To obtain the
next set of pages, pass in the NextToken from the response object of
the previous page call.


=head2 _request_id => Str


=cut

1;