use strict;
use warnings;
use Test::More tests => 3;
use XML::Enc;
use MIME::Base64 qw/decode_base64/;

my $base64 = <<'BASE64';
PD94bWwgdmVyc2lvbj0iMS4wIj8+CjxFbmNyeXB0ZWREYXRhIHhtbG5zPSJodHRwOi8vd3d3Lncz
Lm9yZy8yMDAxLzA0L3htbGVuYyMiIFR5cGU9Imh0dHA6Ly93d3cudzMub3JnLzIwMDEvMDQveG1s
ZW5jI0VsZW1lbnQiPgogPEVuY3J5cHRpb25NZXRob2QgQWxnb3JpdGhtPSJodHRwOi8vd3d3Lncz
Lm9yZy8yMDAxLzA0L3htbGVuYyN0cmlwbGVkZXMtY2JjIi8+CiA8S2V5SW5mbyB4bWxucz0iaHR0
cDovL3d3dy53My5vcmcvMjAwMC8wOS94bWxkc2lnIyI+CiAgPEVuY3J5cHRlZEtleSB4bWxucz0i
aHR0cDovL3d3dy53My5vcmcvMjAwMS8wNC94bWxlbmMjIj4KICAgPEVuY3J5cHRpb25NZXRob2Qg
QWxnb3JpdGhtPSJodHRwOi8vd3d3LnczLm9yZy8yMDAxLzA0L3htbGVuYyNyc2EtMV81Ii8+CiAg
IDxLZXlJbmZvIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwLzA5L3htbGRzaWcjIj4KICAg
IDxLZXlOYW1lLz4KICAgPC9LZXlJbmZvPgogICA8Q2lwaGVyRGF0YT4KICAgIDxDaXBoZXJWYWx1
ZT5sRDBpOFlwc2xNMDN2S1MwODNpMWRtc1BWZGlUeWJuVzRzR21GU2tXc1pvMS9xZmI4M2JpT05w
SU9LV2lheXZ2CjBobCt0QU5GZjU5NkRHV3B2ek96UGFCaVViWFh5MXRRWEJmem1ycTJBREkvaHUy
MWhuajl6eTJDSjREaTdhMlAKclNOazZZUEtKOUxHakQ5SU9mSk5lNHdsWFhldUh0VjU1Tk1CcGs0
Ui9iaWtWZnlNWkxVTm5lODJjN3lQeFgrawplcmJnTXZ5YnphR20zSWRVbXhlUmVJcm9wVVd4anhH
L2NEcU5LbmVodi9sZTRGb0plbjNlakR5QkNHVDRlc1JBClJvRExPbTVHSE5YVGRySlRnLzdzbVI1
b2QrNEQ2Z3BwN2FqN1phTy91SS84ZGcxSE1kbUprSUtrQU1aNmNwNlUKRHBPd1JBNGtRTUt1a3py
RVlnSVBuRlZxeHVLdC9kMFdCSkFabmFGSHNkMXZPN0tqTGxhUjd6aGhBT0xEeVFJVwpGZmJDRE0v
SHg0SmY5YmczbzhQcjdWQ25aMmhRdy9qaWxPTzZhT3p4aVBDYTJhVjVjenNKNTIzQW1iV2M0eDJo
Cml1VmUxMzJnMGVUdWdjM2Q3WmRYRTVmYmgzZWVVcVl6QmhWdUtqRVA1UkRrdExYbGJHN1Fhc05z
SmkyMEdFbDAKazlHR2RZUXpQUHVSc2lDVFVTUEV1UzkzRXVCVGVmNU44aWpZbzdMaHFwOUxiTXBs
M01NQVVTdW5zR3J4NEsrRgo3TFpLbFpiRlpQSG9hRW5zS2s1TFg5eXZWdldzR2hHb21VT05iQmcw
ZU43djBIVytUSXdvN2tEc0dJVkhXUDFoClRDWHphNVNTSDM3WnBtTFprWEp2ODlqSlA1TDVYWi83
N2svU0txbkE0ZFE9PC9DaXBoZXJWYWx1ZT4KICAgPC9DaXBoZXJEYXRhPgogIDwvRW5jcnlwdGVk
S2V5PgogPC9LZXlJbmZvPgogPENpcGhlckRhdGE+CiAgPENpcGhlclZhbHVlPkIrUzZJRzFtMUJw
d3pLRC9icE1qdDRJa203cDlBTUpLNWhUbUxwYXMyeDIxVG90RDUwb0hvcVg3UTBSd25wS0sKSHVy
bm9reGlacSsxZmx2K21OS2xpR0tKczZZZ3c4aXpLYUUrSW42NjJZRT08L0NpcGhlclZhbHVlPgog
PC9DaXBoZXJEYXRhPgo8L0VuY3J5cHRlZD4K
BASE64

my $xml = decode_base64($base64);

ok($xml, "Got encrypted XML");

my $decrypter = XML::Enc->new(
    {
        key                 => 't/sign-private.pem',
        no_xml_declaration  => 1
    }
);

my $ret;
eval {
    $ret = $decrypter->decrypt($xml);
};
ok($@ =~ /Opening and ending tag mismatch/,"Invalid XML");
ok(!$ret);
done_testing;
exit;
$base64 = << 'INVALIDBASE64';
PD94bWwgdmVyc2lvbj0iMS4wIj8+CjxFbmNyeXB0ZWREYXRhIHhtbG5zPSJodHRwOi8vd3d3Lncz
Lm9yZy8yMDAxLzA0L3htbGVuYyMiIFR5cGU9Imh0dHA6Ly93d3cudzMub3JnLzIwMDEvMDQveG1s
ZW5jI0VsZW1lbnQiPgogPEVuY3J5cHRpb25NZXRob2QgQWxnb3JpdGhtPSJodHRwOi8vd3d3Lncz
Lm9yZy8yMDAxLzA0L3htbGVuYyN0cmlwbGVkZXMtY2JjIi8+CiA8S2V5SW5mbyB4bWxucz0iaHR0
cDovL3d3dy53My5vcmcvMjAwMC8wOS94bWxkc2lnIyI+CiAgPEVuY3J5cHRlZEtleSB4bWxucz0i
aHR0cDovL3d3dy53My5vcmcvMjAwMS8wNC94bWxlbmMjIj4KICAgPEVuY3J5cHRpb25NZXRob2Qg
QWxnb3JpdGhtPSJodHRwOi8vd3d3LnczLm9yZy8yMDAxLzA0L3htbGVuYyNyc2EtMV81Ii8+CiAg
IDxLZXlJbmZvIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwLzA5L3htbGRzaWcjIj4KICAg
IDxLZXlOYW1lLz4KICAgPC9LZXlJbmZvPgogICA8Q2lwaGVyRGF0YT4KICAgIDxDaXBoZXJWYWx1
ZT5sRDBpOFlwc2xNMDN2S1MwODNpMWRtc1BWZGlUeWJuVzRzR21GU2tXc1pvMS9xZmI4M2JpT05w
SU9LV2lheXZ2CjBobCt0QU5GZjU5NkRHV3B2ek96UGFCaVViWFh5MXRRWEJmem1ycTJBREkvaHUy
MWhuajl6eTJDSjREaTdhMlAKclNOazZZUEtKOUxHakQ5SU9mSk5lNHdsWFhldUh0VjU1Tk1CcGs0
Ui9iaWtWZnlNWkxVTm5lODJjN3lQeFgrawplcmJnTXZ5YnphR20zSWRVbXhlUmVJcm9wVVd4anhH
L2NEcU5LbmVodi9sZTRGb0plbjNlakR5QkNHVDRlc1JBClJvRExPbTVHSE5YVGRySlRnLzdzbVI1
b2QrNEQ2Z3BwN2FqN1phTy91SS84ZGcxSE1kbUprSUtrQU1aNmNwNlUKRHBPd1JBNGtRTUt1a3py
RVlnSVBuRlZxeHVLdC9kMFdCSkFabmFGSHNkMXZPN0tqTGxhUjd6aGhBT0xEeVFJVwpGZmJDRE0v
SHg0SmY5YmczbzhQcjdWQ25aMmhRdy9qaWxPTzZhT3p4aVBDYTJhVjVjenNKNTIzQW1iV2M0eDJo
Cml1VmUxMzJnMGVUdWdjM2Q3WmRYRTVmYmgzZWVVcVl6QmhWdUtqRVA1UkRrdExYbGJHN1Fhc05z
SmkyMEdFbDAKazlHR2RZUXpQUHVSc2lDVFVTUEV1UzkzRXVCVGVmNU44aWpZbzdMaHFwOUxiTXBs
M01NQVVTdW5zR3J4NEsrRgo3TFpLbFpiRlpQSG9hRW5zS2s1TFg5eXZWdldzR2hHb21VT05iQmcw
ZU43djBIVytUSXdvN2tEc0dJVkhXUDFoClRDWHphNVNTSDM3WnBtTFprWEp2ODlqSlA1TDVYWi83
N2svU0txbkE0ZFFUaW09PC9DaXBoZXJWYWx1ZT4KICAgPC9DaXBoZXJEYXRhPgogIDwvRW5jcnlw
dGVkS2V5PgogPC9LZXlJbmZvPgogPENpcGhlckRhdGE+CiAgPENpcGhlclZhbHVlPkIrUzZJRzFt
MUJwd3pLRC9icE1qdDRJa203cDlBTUpLNWhUbUxwYXMyeDIxVG90RDUwb0hvcVg3UTBSd25wS0sK
SHVybm9reGlacSsxZmx2K21OS2xpR0tKczZZZ3c4aXpLYUUrSW42NjJZRT08L0NpcGhlclZhbHVl
PgogPC9DaXBoZXJEYXRhPgo8L0VuY3J5cHRlZERhdGE+Cg==
INVALIDBASE64

$xml = decode_base64($base64);

ok($xml, "Got encrypted XML");

$decrypter = XML::Enc->new(
    {
        key                 => 't/sign-private.pem',
        no_xml_declaration  => 1
    }
);

eval {
    $ret = $decrypter->decrypt($xml);
};

ok($@ =~ /Opening and ending tag mismatch/,"Invalid XML");
ok(!$ret);

done_testing;
