use 5.14.0;
use strict;
use warnings;

package Task::BeLike::CSSON;

our $VERSION = '0.0005';
# ABSTRACT: Be like...
our $AUTHORITY = 'cpan:CSSON'; # AUTHORITY

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Task::BeLike::CSSON - Be like...



=begin html

<p>
<img src="https://img.shields.io/badge/perl-5.14+-blue.svg" alt="Requires Perl 5.14+" />
<a href="https://travis-ci.org/Csson/p5-Task-BeLike-CSSON"><img src="https://api.travis-ci.org/Csson/p5-Task-BeLike-CSSON.svg?branch=master" alt="Travis status" /></a>
</p>

=end html

=head1 VERSION

Version 0.0005, released 2020-03-31.

=head1 TASK CONTENTS

=head2 Installs

=head3 L<Data::Printer>

=head3 L<Data::GUID>

=head3 L<DateTime>

=head3 L<Dist::Zilla>

=head3 L<Eponymous::Hash>

=head3 L<experimental>

=head3 L<List::Util>

=head3 L<List::MoreUtils>

=head3 L<Modern::Perl>

=head3 L<Mojolicious>

=head3 L<Moo>

=head3 L<Moose>

=head3 L<MooseX::App>

=head3 L<MooseX::AttributeShortcuts>

=head3 L<Path::Tiny>

=head3 L<PerlX::Maybe>

=head3 L<Pod::Weaver>

=head3 L<Regexp::Grammars>

=head3 L<String::Random>

=head3 L<String::Trim>

=head3 L<syntax>

=head3 L<Syntax::Feature::Junction>

=head3 L<Throwable::SugarFactory>

=head3 L<Time::Moment>

=head3 L<Type::Tiny>

=head2 Not installed

    # or equivalent
    $ sudo apt-get install libssl-dev
    $ sudo apt-get install libgd2-xpm-dev
    $ sudo apt-get install ncurses-dev
    $ sudo apt-get install libreadline6 libreadline6-dev

    # install mysql/mariadb, and
    $ export DBD_TESTUSER=...
    $ export DBD_TESTPASSWORD=...
    $ export DBD_TESTDB=...

    $ cpanm Class::Accessor
    $ cpanm Devel::Declare::MethodInstaller::Simple
    $ cpanm Compiler::Lexer
    $ cpanm Task::BeLike::CSSON

=over 4

=item *

DBD::mysql

=item *

DBI

=item *

DBIx::Class

=item *

DBIx::Class::Candy

=item *

DBIx::Class::Helpers

=item *

DBIx::Class::EncodedColumn

=item *

DBIx::Class::InflateColumn::DateTime::Duration

=item *

DBIx::Class::InflateColumn::DateTime::WithTimeZone

=item *

DBIx::Class::Migration

=back

=head1 SOURCE

L<https://github.com/Csson/p5-Task-BeLike-CSSON>

=head1 HOMEPAGE

L<https://metacpan.org/release/Task-BeLike-CSSON>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
