#include "stdafx.h"
#include <memory.h>
#include "CE_Common.h"

namespace CoreSync 
{
	bool ObjectStore::Init()
	{
		bool retval=true;
		if(ObjectStore::pvt_iInitCount==0)
			if(CeRapiInit()==E_FAIL)
				retval = false;
		ObjectStore::pvt_iInitCount++;
		return retval;
	}

	void ObjectStore::UnInit()
	{
		pvt_iInitCount--;
		if(ObjectStore::pvt_iInitCount==0)
			CeRapiUninit();
		if(ObjectStore::pvt_iInitCount<0)
			ObjectStore::pvt_iInitCount=0;
	}

	int ObjectStore::getContactsCount()
	{
		if(ObjectStore::Init()==false)
			throw gcnew System::Exception(L"Could not initialize RAPI. ObjectStore::Init() failed.");

		CEOID oid=0;
		HANDLE hDB=CeOpenDatabase(&oid, L"Contacts Database", 0, 0, NULL);
		if(hDB==INVALID_HANDLE_VALUE)
			throw gcnew System::Exception(L"Could not open Contacts Database. CeOpenDatabase returned INVALID_HANDLE_VALUE.");

		int iEnd=1;
		CEOIDINFO dbinfo;
		CeOidGetInfo(oid, &dbinfo);
		int iCount=(int)dbinfo.infDatabase.wNumRecords;

		CeCloseHandle(hDB);

		ObjectStore::UnInit();
		return iCount;
	}

	int ObjectStore::putContact(Contact ^oContact)
	{
		if(ObjectStore::Init()==false)
			throw gcnew System::Exception(L"Could not initialize RAPI. ObjectStore::Init() failed.");

		int retval=0;
		CEOID dboid=0;

		HANDLE hDB=CeOpenDatabase(&dboid, L"Contacts Database", 0, 0, NULL);
		if(hDB==INVALID_HANDLE_VALUE)
			throw gcnew System::Exception(L"Could not open Contacts Database. CeOpenDatabase returned INVALID_HANDLE_VALUE.");

		CEOID oid=oContact->OID;
		short iPropCount=48;
		short iTruePropCount=46;

		CEPROPVAL *properties=(CEPROPVAL*)malloc(sizeof(CEPROPVAL)*iPropCount);
		memset(properties, 0, sizeof(CEPROPVAL)*iPropCount);

		properties[0].propid=CONTACT_ASSISTANT;			properties[0].val.lpwstr=toLPWSTR(oContact->assistant);		if(oContact->assistant->Length==0) properties[0].wFlags=CEDB_PROPDELETE;
		properties[1].propid=CONTACT_ASSISTANT_TEL;		properties[1].val.lpwstr=toLPWSTR(oContact->assistantTel);	if(oContact->assistantTel->Length==0) properties[1].wFlags=CEDB_PROPDELETE;
		properties[2].propid=CONTACT_CAR_TEL;			properties[2].val.lpwstr=toLPWSTR(oContact->carTel);		if(oContact->carTel->Length==0) properties[2].wFlags=CEDB_PROPDELETE;
		properties[3].propid=CONTACT_CHILDREN;			properties[3].val.lpwstr=toLPWSTR(oContact->children);		if(oContact->children->Length==0) properties[3].wFlags=CEDB_PROPDELETE;
		properties[4].propid=CONTACT_EMAIL;				properties[4].val.lpwstr=toLPWSTR(oContact->email);			if(oContact->email->Length==0) properties[4].wFlags=CEDB_PROPDELETE;
		properties[5].propid=CONTACT_EMAIL2;			properties[5].val.lpwstr=toLPWSTR(oContact->email2);		if(oContact->email2->Length==0) properties[5].wFlags=CEDB_PROPDELETE;
		properties[6].propid=CONTACT_EMAIL3;			properties[6].val.lpwstr=toLPWSTR(oContact->email3);		if(oContact->email3->Length==0) properties[6].wFlags=CEDB_PROPDELETE;
		properties[7].propid=CONTACT_HOME_FAX;			properties[7].val.lpwstr=toLPWSTR(oContact->homeFax);		if(oContact->homeFax->Length==0) properties[7].wFlags=CEDB_PROPDELETE;
		properties[8].propid=CONTACT_HOME_TEL;			properties[8].val.lpwstr=toLPWSTR(oContact->homeTel);		if(oContact->homeTel->Length==0) properties[8].wFlags=CEDB_PROPDELETE;
		properties[9].propid=CONTACT_HOME_TEL2;			properties[9].val.lpwstr=toLPWSTR(oContact->homeTel2);		if(oContact->homeTel2->Length==0) properties[9].wFlags=CEDB_PROPDELETE;
		properties[10].propid=CONTACT_MOBILE_TEL;		properties[10].val.lpwstr=toLPWSTR(oContact->mobileTel);	if(oContact->mobileTel->Length==0) properties[10].wFlags=CEDB_PROPDELETE;
		properties[11].propid=CONTACT_BEEPER;			properties[11].val.lpwstr=toLPWSTR(oContact->beeper);		if(oContact->beeper->Length==0) properties[11].wFlags=CEDB_PROPDELETE;
		properties[12].propid=CONTACT_RADIO_TEL;		properties[12].val.lpwstr=toLPWSTR(oContact->radioTel);		if(oContact->radioTel->Length==0) properties[12].wFlags=CEDB_PROPDELETE;
		properties[13].propid=CONTACT_SPOUSE;			properties[13].val.lpwstr=toLPWSTR(oContact->spouse);		if(oContact->spouse->Length==0) properties[13].wFlags=CEDB_PROPDELETE;
		properties[14].propid=CONTACT_WEBPAGE;			properties[14].val.lpwstr=toLPWSTR(oContact->webpage);		if(oContact->webpage->Length==0) properties[14].wFlags=CEDB_PROPDELETE;
		properties[15].propid=CONTACT_OFFICE_FAX;		properties[15].val.lpwstr=toLPWSTR(oContact->officeFax);	if(oContact->officeFax->Length==0) properties[15].wFlags=CEDB_PROPDELETE;
		properties[16].propid=CONTACT_OFFICE_TEL;		properties[16].val.lpwstr=toLPWSTR(oContact->officeTel);	if(oContact->officeTel->Length==0) properties[16].wFlags=CEDB_PROPDELETE;
		properties[17].propid=CONTACT_OFFICE_TEL2;		properties[17].val.lpwstr=toLPWSTR(oContact->officeTel2);	if(oContact->officeTel2->Length==0) properties[17].wFlags=CEDB_PROPDELETE;
		properties[18].propid=CONTACT_FULLNAME;			properties[18].val.lpwstr=toLPWSTR(oContact->fullName);		if(oContact->fullName->Length==0) properties[18].wFlags=CEDB_PROPDELETE;
		properties[19].propid=CONTACT_SOCIETY;			properties[19].val.lpwstr=toLPWSTR(oContact->society);		if(oContact->society->Length==0) properties[19].wFlags=CEDB_PROPDELETE;
		properties[20].propid=CONTACT_UNIT;				properties[20].val.lpwstr=toLPWSTR(oContact->unit);			if(oContact->unit->Length==0) properties[20].wFlags=CEDB_PROPDELETE;
		properties[21].propid=CONTACT_FIRSTNAME;		properties[21].val.lpwstr=toLPWSTR(oContact->firstName);	if(oContact->firstName->Length==0) properties[21].wFlags=CEDB_PROPDELETE;
		properties[22].propid=CONTACT_LASTNAME;			properties[22].val.lpwstr=toLPWSTR(oContact->lastName);		if(oContact->lastName->Length==0) properties[22].wFlags=CEDB_PROPDELETE;
		properties[23].propid=CONTACT_MIDDLENAME;		properties[23].val.lpwstr=toLPWSTR(oContact->middleName);	if(oContact->middleName->Length==0) properties[23].wFlags=CEDB_PROPDELETE;
		properties[24].propid=CONTACT_TITLE;			properties[24].val.lpwstr=toLPWSTR(oContact->title);		if(oContact->title->Length==0) properties[24].wFlags=CEDB_PROPDELETE;
		properties[25].propid=CONTACT_OFFICE_LOCATION;	properties[25].val.lpwstr=toLPWSTR(oContact->officeLocation); if(oContact->officeLocation->Length==0) properties[25].wFlags=CEDB_PROPDELETE;
		properties[26].propid=CONTACT_SUFFIX;			properties[26].val.lpwstr=toLPWSTR(oContact->suffix);		if(oContact->suffix->Length==0) properties[26].wFlags=CEDB_PROPDELETE;
		properties[27].propid=CONTACT_JOB;				properties[27].val.lpwstr=toLPWSTR(oContact->job);			if(oContact->job->Length==0) properties[27].wFlags=CEDB_PROPDELETE;
		properties[28].propid=CONTACT_HOME_STREET;		properties[28].val.lpwstr=toLPWSTR(oContact->homeStreet);	if(oContact->homeStreet->Length==0) properties[28].wFlags=CEDB_PROPDELETE;
		properties[29].propid=CONTACT_HOME_CITY;		properties[29].val.lpwstr=toLPWSTR(oContact->homeCity);		if(oContact->homeCity->Length==0) properties[29].wFlags=CEDB_PROPDELETE;
		properties[30].propid=CONTACT_HOME_PROVINCE;	properties[30].val.lpwstr=toLPWSTR(oContact->homeProvince);	if(oContact->homeProvince->Length==0) properties[30].wFlags=CEDB_PROPDELETE;
		properties[31].propid=CONTACT_HOME_ZIPCODE;		properties[31].val.lpwstr=toLPWSTR(oContact->homeZipcode);	if(oContact->homeZipcode->Length==0) properties[31].wFlags=CEDB_PROPDELETE;
		properties[32].propid=CONTACT_HOME_COUNTRY;		properties[32].val.lpwstr=toLPWSTR(oContact->homeCountry);	if(oContact->homeCountry->Length==0) properties[32].wFlags=CEDB_PROPDELETE;
		properties[33].propid=CONTACT_OFFICE_STREET;	properties[33].val.lpwstr=toLPWSTR(oContact->officeStreet);	if(oContact->officeStreet->Length==0) properties[33].wFlags=CEDB_PROPDELETE;
		properties[34].propid=CONTACT_OFFICE_CITY;		properties[34].val.lpwstr=toLPWSTR(oContact->officeCity);	if(oContact->officeCity->Length==0) properties[34].wFlags=CEDB_PROPDELETE;
		properties[35].propid=CONTACT_OFFICE_PROVINCE;	properties[35].val.lpwstr=toLPWSTR(oContact->officeProvince); if(oContact->officeProvince->Length==0) properties[35].wFlags=CEDB_PROPDELETE;
		properties[36].propid=CONTACT_OFFICE_ZIPCODE;	properties[36].val.lpwstr=toLPWSTR(oContact->officeZipcode); if(oContact->officeZipcode->Length==0) properties[36].wFlags=CEDB_PROPDELETE;
		properties[37].propid=CONTACT_OFFICE_COUNTRY;	properties[37].val.lpwstr=toLPWSTR(oContact->officeCountry); if(oContact->officeCountry->Length==0) properties[37].wFlags=CEDB_PROPDELETE;
		properties[38].propid=CONTACT_OTHER_STREET;		properties[38].val.lpwstr=toLPWSTR(oContact->otherStreet);	if(oContact->otherStreet->Length==0) properties[38].wFlags=CEDB_PROPDELETE;
		properties[39].propid=CONTACT_OTHER_CITY;		properties[39].val.lpwstr=toLPWSTR(oContact->otherCity);	if(oContact->otherCity->Length==0) properties[39].wFlags=CEDB_PROPDELETE;
		properties[40].propid=CONTACT_OTHER_PROVINCE;	properties[40].val.lpwstr=toLPWSTR(oContact->otherProvince); if(oContact->otherProvince->Length==0) properties[40].wFlags=CEDB_PROPDELETE;
		properties[41].propid=CONTACT_OTHER_ZIPCODE;	properties[41].val.lpwstr=toLPWSTR(oContact->otherZipcode);	if(oContact->otherZipcode->Length==0) properties[41].wFlags=CEDB_PROPDELETE;
		properties[42].propid=CONTACT_OTHER_COUNTRY;	properties[42].val.lpwstr=toLPWSTR(oContact->otherCountry);	if(oContact->otherCountry->Length==0) properties[42].wFlags=CEDB_PROPDELETE;
		properties[43].propid=CONTACT_CUSTOM_ID;		properties[43].val.lpwstr=toLPWSTR(oContact->customID);		if(oContact->customID->Length==0) properties[43].wFlags=CEDB_PROPDELETE;
		properties[44].propid=CONTACT_CUSTOM_HASHVALUE;	properties[44].val.lpwstr=toLPWSTR(oContact->hashValue);	if(oContact->hashValue->Length==0) properties[44].wFlags=CEDB_PROPDELETE;
		properties[45].propid=CONTACT_CUSTOM_TIMESTAMP;	properties[45].val.filetime=toFILETIME(System::DateTime::Now);
		if(oContact->anniversary.Ticks!=0)
		{
			properties[46].propid=CONTACT_ANNIVERSARY;
			properties[46].val.filetime=toFILETIME(oContact->anniversary);
			iTruePropCount++;
		}
		else
			 properties[46].wFlags=CEDB_PROPDELETE;
		if(oContact->birthDate.Ticks!=0)
		{
			properties[47].propid=CONTACT_BIRTHDATE;
			properties[47].val.filetime=toFILETIME(oContact->birthDate);
			iTruePropCount++;
		}
		else
			 properties[47].wFlags=CEDB_PROPDELETE;

		retval=CeWriteRecordProps(hDB, oid, iPropCount, properties);

		for(int i=0;i<iPropCount;i++)
			if(LOWORD(properties[i].propid)==CEVT_LPWSTR)
				free(properties[i].val.lpwstr);
		free(properties);

		CeCloseHandle(hDB);
		ObjectStore::UnInit();
		return retval;
	}

	bool ObjectStore::removeContact(int OID)
	{
		if(ObjectStore::Init()==false)
			throw gcnew System::Exception(L"Could not initialize RAPI. ObjectStore::Init() failed.");

		int retval=0;
		CEOID dboid=0;

		HANDLE hDB=CeOpenDatabase(&dboid, L"Contacts Database", 0, 0, NULL);
		if(hDB==INVALID_HANDLE_VALUE)
			throw gcnew System::Exception(L"Could not open Contacts Database. CeOpenDatabase returned INVALID_HANDLE_VALUE.");

		retval = CeDeleteRecord(hDB, OID);

		CeCloseHandle(hDB);
		ObjectStore::UnInit();

		if(retval==TRUE)
			return true;
		else
			return false;
	}

	Contacts ^ObjectStore::getContacts()
	{
		if(ObjectStore::Init()==false)
			throw gcnew System::Exception(L"Could not initialize RAPI. ObjectStore::Init() failed.");
		Contacts ^retval = gcnew Contacts();
		Database ^db=gcnew Database("Contacts Database");
		Contact ^ct;
		Record ^rc;
		int recordCount=db->getRecordCount();
		for(int i=0;i<recordCount;i++)
		{
			ct=gcnew Contact();
			rc=db->getRecord(i);
			Field ^fld;
			fld=rc->getFieldByID(HIWORD(CONTACT_ANNIVERSARY));
			if(fld!=nullptr)
				ct->anniversary=fld->getDateValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_ASSISTANT));
			if(fld!=nullptr)
				ct->assistant=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_ASSISTANT_TEL));
			if(fld!=nullptr)
				ct->assistantTel=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_BEEPER));
			if(fld!=nullptr)
				ct->beeper=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_BIRTHDATE));
			if(fld!=nullptr)
				ct->birthDate=fld->getDateValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_CAR_TEL));
			if(fld!=nullptr)
				ct->carTel=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_CHILDREN));
			if(fld!=nullptr)
				ct->children=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_CUSTOM_ID));
			if(fld!=nullptr)
				ct->customID=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_EMAIL));
			if(fld!=nullptr)
				ct->email=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_EMAIL2));
			if(fld!=nullptr)
				ct->email2=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_EMAIL3));
			if(fld!=nullptr)
				ct->email3=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_FIRSTNAME));
			if(fld!=nullptr)
				ct->firstName=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_FULLNAME));
			if(fld!=nullptr)
				ct->fullName=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_CUSTOM_HASHVALUE));
			if(fld!=nullptr)
				ct->hashValue=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_HOME_CITY));
			if(fld!=nullptr)
				ct->homeCity=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_HOME_COUNTRY));
			if(fld!=nullptr)
				ct->homeCountry=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_HOME_FAX));
			if(fld!=nullptr)
				ct->homeFax=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_HOME_PROVINCE));
			if(fld!=nullptr)
				ct->homeProvince=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_HOME_STREET));
			if(fld!=nullptr)
				ct->homeStreet=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_HOME_TEL));
			if(fld!=nullptr)
				ct->homeTel=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_HOME_TEL2));
			if(fld!=nullptr)
				ct->homeTel2=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_HOME_ZIPCODE));
			if(fld!=nullptr)
				ct->homeZipcode=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_JOB));
			if(fld!=nullptr)
				ct->job=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_LASTNAME));
			if(fld!=nullptr)
				ct->lastName=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_MIDDLENAME));
			if(fld!=nullptr)
				ct->middleName=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_MOBILE_TEL));
			if(fld!=nullptr)
				ct->mobileTel=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OFFICE_CITY));
			if(fld!=nullptr)
				ct->officeCity=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OFFICE_COUNTRY));
			if(fld!=nullptr)
				ct->officeCountry=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OFFICE_FAX));
			if(fld!=nullptr)
				ct->officeFax=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OFFICE_LOCATION));
			if(fld!=nullptr)
				ct->officeLocation=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OFFICE_PROVINCE));
			if(fld!=nullptr)
				ct->officeProvince=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OFFICE_STREET));
			if(fld!=nullptr)
				ct->officeStreet=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OFFICE_TEL));
			if(fld!=nullptr)
				ct->officeTel=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OFFICE_TEL2));
			if(fld!=nullptr)
				ct->officeTel2=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OFFICE_ZIPCODE));
			if(fld!=nullptr)
				ct->officeZipcode=fld->getStringValue();
			//fld=rc->getFieldByID(HIWORD());
			ct->OID=rc->getOID();
			fld=rc->getFieldByID(HIWORD(CONTACT_OTHER_CITY));
			if(fld!=nullptr)
				ct->otherCity=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OTHER_COUNTRY));
			if(fld!=nullptr)
				ct->otherCountry=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OTHER_PROVINCE));
			if(fld!=nullptr)
				ct->otherProvince=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OTHER_STREET));
			if(fld!=nullptr)
				ct->otherStreet=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_OTHER_ZIPCODE));
			if(fld!=nullptr)
				ct->otherZipcode=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_RADIO_TEL));
			if(fld!=nullptr)
				ct->radioTel=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_SOCIETY));
			if(fld!=nullptr)
				ct->society=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_SPOUSE));
			if(fld!=nullptr)
				ct->spouse=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_SUFFIX));
			if(fld!=nullptr)
				ct->suffix=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_CUSTOM_TIMESTAMP));
			if(fld!=nullptr)
				ct->timeStamp=fld->getDateValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_TITLE));
			if(fld!=nullptr)
				ct->title=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_UNIT));
			if(fld!=nullptr)
				ct->unit=fld->getStringValue();
			fld=rc->getFieldByID(HIWORD(CONTACT_WEBPAGE));
			if(fld!=nullptr)
				ct->webpage=fld->getStringValue();
			//fld=rc->getFieldByID(HIWORD());
			retval->add(ct);
		}
		return retval;
	}

	/*
	Contacts ^ObjectStore::getContacts()
	{
		if(ObjectStore::Init()==false)
			throw gcnew System::Exception(L"Could not initialize RAPI. ObjectStore::Init() failed.");

		CEOID oid=0;

		HANDLE hDB=CeOpenDatabase(&oid, L"Contacts Database", 0, 0, NULL);
		if(hDB==INVALID_HANDLE_VALUE)
			throw gcnew System::Exception(L"Could not open Contacts Database. CeOpenDatabase returned INVALID_HANDLE_VALUE.");

		Contacts ^retval = gcnew Contacts();
		int recordSize=0;
		WORD lpcPropID=0;
		BYTE* lplpBuffer=(BYTE*)malloc(sizeof(BYTE));
		DWORD lpcbBuffer=0;
		int iEnd=1;

		while(iEnd!=0)
		{
			CeReadRecordProps(hDB, 0, &lpcPropID, NULL, &lplpBuffer, &lpcbBuffer);
			if(lplpBuffer!=NULL)
				free(lplpBuffer);
			lplpBuffer=(BYTE*)malloc(sizeof(BYTE)*lpcbBuffer);
			iEnd=CeReadRecordProps(hDB, 0, &lpcPropID, NULL, &lplpBuffer, &lpcbBuffer);
			if(iEnd!=0)
			{
				Contact ^ct = gcnew Contact();
				ct->OID=iEnd;
				ct->assistant=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_ASSISTANT, lpcPropID);
				ct->assistantTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_ASSISTANT_TEL, lpcPropID);
				ct->carTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_CAR_TEL, lpcPropID);
				ct->children=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_CHILDREN, lpcPropID);
				ct->email=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_EMAIL, lpcPropID);
				ct->email2=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_EMAIL2, lpcPropID);
				ct->email3=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_EMAIL3, lpcPropID);
				ct->homeFax=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_FAX, lpcPropID);
				ct->homeTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_TEL, lpcPropID);
				ct->homeTel2=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_TEL2, lpcPropID);
				ct->mobileTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_MOBILE_TEL, lpcPropID);
				ct->beeper=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_BEEPER, lpcPropID);
				ct->radioTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_RADIO_TEL, lpcPropID);
				ct->spouse=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_SPOUSE, lpcPropID);
				ct->webpage=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_WEBPAGE, lpcPropID);
				ct->officeFax=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_FAX, lpcPropID);
				ct->officeTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_TEL, lpcPropID);
				ct->officeTel2=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_TEL2, lpcPropID);
				ct->fullName=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_FULLNAME, lpcPropID);
				ct->society=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_SOCIETY, lpcPropID);
				ct->unit=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_UNIT, lpcPropID);
				ct->firstName=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_FIRSTNAME, lpcPropID);
				ct->lastName=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_LASTNAME, lpcPropID);
				ct->middleName=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_MIDDLENAME, lpcPropID);
				ct->title=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_TITLE, lpcPropID);
				ct->officeLocation=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_LOCATION, lpcPropID);
				ct->suffix=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_SUFFIX, lpcPropID);
				ct->job=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_JOB, lpcPropID);
				ct->homeStreet=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_STREET, lpcPropID);
				ct->homeCity=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_CITY, lpcPropID);
				ct->homeProvince=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_PROVINCE, lpcPropID);
				ct->homeZipcode=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_ZIPCODE, lpcPropID);
				ct->homeCountry=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_COUNTRY, lpcPropID);
				ct->officeStreet=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_STREET, lpcPropID);
				ct->officeCity=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_CITY, lpcPropID);
				ct->officeProvince=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_PROVINCE, lpcPropID);
				ct->officeZipcode=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_ZIPCODE, lpcPropID);
				ct->officeCountry=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_COUNTRY, lpcPropID);
				ct->otherStreet=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OTHER_STREET, lpcPropID);
				ct->otherCity=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OTHER_CITY, lpcPropID);
				ct->otherProvince=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OTHER_PROVINCE, lpcPropID);
				ct->otherZipcode=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OTHER_ZIPCODE, lpcPropID);
				ct->otherCountry=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OTHER_COUNTRY, lpcPropID);
				ct->birthDate=getDTPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_BIRTHDATE, lpcPropID);
				ct->anniversary=getDTPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_ANNIVERSARY, lpcPropID);
				ct->customID=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_CUSTOM_ID, lpcPropID);
				ct->hashValue=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_CUSTOM_HASHVALUE, lpcPropID);
				ct->timeStamp=getDTPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_CUSTOM_TIMESTAMP, lpcPropID);
				retval->add(ct);
			}
			free(lplpBuffer);
			lplpBuffer=NULL;
			if(CeSeekDatabase(hDB, CEDB_SEEK_CURRENT, 1, NULL)==0)
				iEnd=0;
		}
		CeCloseHandle(hDB);
		ObjectStore::UnInit();
		return retval;

		//CeReadRecordProps(hDB, 0, &lpcPropID, NULL, &lplpBuffer, &lpcbBuffer);

		//WORD cFindData;
		//CEDB_FIND_DATA** ppFindData;
		//CEDB_FIND_DATA *entries;
		//CEDB_FIND_DATA entry1;
		//ppFindData=(CEDB_FIND_DATA**)malloc(sizeof(CEDB_FIND_DATA));
		
		//CeFindAllDatabases(0, FAD_OID | FAD_NAME, &cFindData, ppFindData);

		//entries=ppFindData[0];

		//for(int i=0;i<cFindData;i++)
		//{
		//	entry1=entries[i];
		//}

		//CeRapiFreeBuffer(ppFindData);
	}
	*/

	Contact ^ObjectStore::getContact(int prm_oid)
	{
		if(ObjectStore::Init()==false)
			throw gcnew System::Exception(L"Could not initialize RAPI. ObjectStore::Init() failed.");

		CEOID oid=0;

		HANDLE hDB=CeOpenDatabase(&oid, L"Contacts Database", 0, 0, NULL);
		if(hDB==INVALID_HANDLE_VALUE)
			throw gcnew System::Exception(L"Could not open Contacts Database. CeOpenDatabase returned INVALID_HANDLE_VALUE.");

		Contact ^retval = gcnew Contact();
		int recordSize=0;
		WORD lpcPropID=0;
		BYTE* lplpBuffer=(BYTE*)malloc(sizeof(BYTE));
		DWORD lpcbBuffer=0;
		int iEnd=1;
		bool found=false;

		while(iEnd!=0)
		{
			CeReadRecordProps(hDB, 0, &lpcPropID, NULL, &lplpBuffer, &lpcbBuffer);
			if(lplpBuffer!=NULL)
				free(lplpBuffer);
			lplpBuffer=(BYTE*)malloc(sizeof(BYTE)*lpcbBuffer);
			iEnd=CeReadRecordProps(hDB, 0, &lpcPropID, NULL, &lplpBuffer, &lpcbBuffer);
			if(iEnd==prm_oid)
			{
				Contact ^ct = gcnew Contact();
				ct->OID=iEnd;
				ct->assistant=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_ASSISTANT, lpcPropID);
				ct->assistantTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_ASSISTANT_TEL, lpcPropID);
				ct->carTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_CAR_TEL, lpcPropID);
				ct->children=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_CHILDREN, lpcPropID);
				ct->email=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_EMAIL, lpcPropID);
				ct->email2=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_EMAIL2, lpcPropID);
				ct->email3=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_EMAIL3, lpcPropID);
				ct->homeFax=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_FAX, lpcPropID);
				ct->homeTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_TEL, lpcPropID);
				ct->homeTel2=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_TEL2, lpcPropID);
				ct->mobileTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_MOBILE_TEL, lpcPropID);
				ct->beeper=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_BEEPER, lpcPropID);
				ct->radioTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_RADIO_TEL, lpcPropID);
				ct->spouse=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_SPOUSE, lpcPropID);
				ct->webpage=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_WEBPAGE, lpcPropID);
				ct->officeFax=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_FAX, lpcPropID);
				ct->officeTel=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_TEL, lpcPropID);
				ct->officeTel2=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_TEL2, lpcPropID);
				ct->fullName=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_FULLNAME, lpcPropID);
				ct->society=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_SOCIETY, lpcPropID);
				ct->unit=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_UNIT, lpcPropID);
				ct->firstName=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_FIRSTNAME, lpcPropID);
				ct->lastName=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_LASTNAME, lpcPropID);
				ct->middleName=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_MIDDLENAME, lpcPropID);
				ct->title=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_TITLE, lpcPropID);
				ct->officeLocation=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_LOCATION, lpcPropID);
				ct->suffix=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_SUFFIX, lpcPropID);
				ct->job=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_JOB, lpcPropID);
				ct->homeStreet=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_STREET, lpcPropID);
				ct->homeCity=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_CITY, lpcPropID);
				ct->homeProvince=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_PROVINCE, lpcPropID);
				ct->homeZipcode=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_ZIPCODE, lpcPropID);
				ct->homeCountry=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_HOME_COUNTRY, lpcPropID);
				ct->officeStreet=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_STREET, lpcPropID);
				ct->officeCity=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_CITY, lpcPropID);
				ct->officeProvince=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_PROVINCE, lpcPropID);
				ct->officeZipcode=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_ZIPCODE, lpcPropID);
				ct->officeCountry=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OFFICE_COUNTRY, lpcPropID);
				ct->otherStreet=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OTHER_STREET, lpcPropID);
				ct->otherCity=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OTHER_CITY, lpcPropID);
				ct->otherProvince=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OTHER_PROVINCE, lpcPropID);
				ct->otherZipcode=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OTHER_ZIPCODE, lpcPropID);
				ct->otherCountry=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_OTHER_COUNTRY, lpcPropID);
				ct->birthDate=getDTPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_BIRTHDATE, lpcPropID);
				ct->anniversary=getDTPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_ANNIVERSARY, lpcPropID);
				ct->customID=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_CUSTOM_ID, lpcPropID);
				ct->hashValue=getPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_CUSTOM_HASHVALUE, lpcPropID);
				ct->timeStamp=getDTPropertyValue((CEPROPVAL*)lplpBuffer, CONTACT_CUSTOM_TIMESTAMP, lpcPropID);
				retval=ct;
				found=true;
			}
			free(lplpBuffer);
			lplpBuffer=NULL;
			if(CeSeekDatabase(hDB, CEDB_SEEK_CURRENT, 1, NULL)==0)
				iEnd=0;
			if(found==true)
				break;
		}
		CeCloseHandle(hDB);
		ObjectStore::UnInit();
		return retval;
	}

	Database ^ObjectStore::getDatabase(System::String ^sDBName)
	{
		//TODO: test
		CEOID dboid=0;
		Database ^retval;
		LPWSTR dbName=toLPWSTR(sDBName);
		HANDLE hDB=CeOpenDatabase(&dboid, dbName, 0, 0, NULL);	//CEDB_AUTOINCREMENT
		if(hDB!=INVALID_HANDLE_VALUE)
		{
			retval=gcnew Database(hDB, dboid);
			retval->setName(sDBName);
		}
		free(dbName);
		return retval;
	}
}
