/****** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Initial Developer of the Original Code is Eelco van Kuik.
   -
   - Contributor(s):
   - Several developers
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK *****/


var nsHistory = {
	ds : null,
	/**
	*	This routine adds the search terms to the history
	*/
	init : function () {
		var aUri = 'file:///' + nsRdfLocator.getHistory(true);
		document.getElementById('NeedleSearchSearchTermsPopup').datasources = aUri;
		nsHistory.ds = new nsRdfds.RDFDataSource(aUri);
	},
	
	/**
	*	This routine adds the search terms to the history
	*/
	add : function (searchterms) {
		if ( searchterms.replace(/\s+/, '').length == 0 ) {
			return
		}
		
		var rootNode = nsHistory.ds.getNode(nsRdfds.historyURI) ;
		var children	=	rootNode.getChildren()
		var child, aVal, n = 0
		
		while ( children.hasMoreElements() ) {
			child = children.getNext()
			aVal = child.getTarget(nsRdfds.aXMLPath + "searchterms")
			if ( aVal ) {
				if ( n < 25 ) {
					aVal = aVal.getValue()
					if (aVal == searchterms) {
						child.removeTarget( nsRdfds.aXMLPath + "searchterms", aVal )
					}
				} else {
					child.removeTarget( nsRdfds.aXMLPath + "searchterms", aVal )
					rootNode.removeChild( child );
				}
			} else {
				rootNode.removeChild( child );
			}
			n++;
		}

		//Now insert it at the top
		var newNode = nsHistory.ds.getAnonymousNode();
		newNode = rootNode.addChildAt(newNode, 1)
		
		newNode.addTarget(nsRdfds.aXMLPath + "searchterms", searchterms);
		nsHistory.ds.save();
	},
	/**
	*	This routine adds the search terms to the history
	*/
	add_deprecated : function (searchterms) {
		var NSsearchterms = document.getElementById('NeedleSearchSearchTerms')
		NSsearchterms.insertItemAt(0,searchterms,searchterms)
		try {
			NSsearchterms.removeItemAt(20)
		} catch(er) {
			//do nothing
		}
		
	
	},
	/*
	 * Clears the list of searchterms
	 */
	clear	: function () {
		
		var rootNode = nsHistory.ds.getNode(nsRdfds.historyURI) ;
		var children	=	rootNode.getChildren()
		var child, aVal, n = 0
		
		while ( children.hasMoreElements() ) {
			child = children.getNext()
			//aVal = child.getTarget(nsRdfds.aXMLPath + "searchterms")
			//child.removeTarget( nsRdfds.aXMLPath + "searchterms", aVal )
			nsHistory.ds.deleteRecursive( child );
		}
		
	}


}