/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import java.util.concurrent.Callable;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.UnsupportedException;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.interfaces.nsIDOMDOMConfiguration;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIVariant;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMStringList;

public class DOMConfigurationImpl
implements DOMConfiguration {
    protected nsISupports moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public nsIDOMDOMConfiguration getInstance() {
        return this.getInstanceAsnsIDOMDOMConfiguration();
    }

    protected DOMConfigurationImpl(nsISupports mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public DOMConfigurationImpl(nsIDOMDOMConfiguration mozInst) {
        this((nsISupports)mozInst);
    }

    public static DOMConfigurationImpl getDOMInstance(nsIDOMDOMConfiguration mozInst) {
        DOMConfigurationImpl node = (DOMConfigurationImpl)instances.get(mozInst);
        return node == null ? new DOMConfigurationImpl(mozInst) : node;
    }

    public nsIDOMDOMConfiguration getInstanceAsnsIDOMDOMConfiguration() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMDOMConfiguration)this.moz.queryInterface("{cfb5b821-9016-4a79-9d98-87b57c3ea0c7}");
    }

    public boolean canSetParameter(final String name, Object value) {
        final nsIVariant casted_value = (nsIVariant)value;
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = DOMConfigurationImpl.this.getInstanceAsnsIDOMDOMConfiguration().canSetParameter(name, casted_value);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public void setParameter(final String name, Object value) {
        final nsIVariant casted_value = (nsIVariant)value;
        Runnable r = new Runnable(){

            public void run() {
                DOMConfigurationImpl.this.getInstanceAsnsIDOMDOMConfiguration().setParameter(name, casted_value);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public DOMStringList getParameterNames() {
        throw new UnsupportedException();
    }

    public Object getParameter(final String name) {
        Callable<Object> c = new Callable<Object>(){

            @Override
            public Object call() {
                nsIVariant result = DOMConfigurationImpl.this.getInstanceAsnsIDOMDOMConfiguration().getParameter(name);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }
}

