/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom.traversal;

import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.NodeImpl;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.dom.traversal.NodeFilterImpl;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeFilter;
import org.mozilla.interfaces.nsIDOMTreeWalker;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class TreeWalkerImpl
implements TreeWalker {
    protected nsIDOMTreeWalker moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public TreeWalkerImpl(nsIDOMTreeWalker mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public static TreeWalkerImpl getDOMInstance(nsIDOMTreeWalker mozInst) {
        TreeWalkerImpl node = (TreeWalkerImpl)instances.get(mozInst);
        return node == null ? new TreeWalkerImpl(mozInst) : node;
    }

    public nsIDOMTreeWalker getInstance() {
        return this.moz;
    }

    public void setCurrentNode(Node currentNode) {
        nsIDOMNode mozCurrentnode = ((NodeImpl)currentNode).getInstance();
        this.getInstance().setCurrentNode(mozCurrentnode);
    }

    public NodeFilter getFilter() {
        nsIDOMNodeFilter result = this.getInstance().getFilter();
        return new NodeFilterImpl(result);
    }

    public Node nextNode() {
        nsIDOMNode result = this.getInstance().nextNode();
        return NodeFactory.getNodeInstance(result);
    }

    public Node nextSibling() {
        nsIDOMNode result = this.getInstance().nextSibling();
        return NodeFactory.getNodeInstance(result);
    }

    public Node parentNode() {
        nsIDOMNode result = this.getInstance().parentNode();
        return NodeFactory.getNodeInstance(result);
    }

    public Node firstChild() {
        nsIDOMNode result = this.getInstance().firstChild();
        return NodeFactory.getNodeInstance(result);
    }

    public Node getRoot() {
        nsIDOMNode result = this.getInstance().getRoot();
        return NodeFactory.getNodeInstance(result);
    }

    public Node getCurrentNode() {
        nsIDOMNode result = this.getInstance().getCurrentNode();
        return NodeFactory.getNodeInstance(result);
    }

    public Node previousNode() {
        nsIDOMNode result = this.getInstance().previousNode();
        return NodeFactory.getNodeInstance(result);
    }

    public Node lastChild() {
        nsIDOMNode result = this.getInstance().lastChild();
        return NodeFactory.getNodeInstance(result);
    }

    public Node previousSibling() {
        nsIDOMNode result = this.getInstance().previousSibling();
        return NodeFactory.getNodeInstance(result);
    }

    public boolean getExpandEntityReferences() {
        boolean result = this.getInstance().getExpandEntityReferences();
        return result;
    }

    public int getWhatToShow() {
        long result = this.getInstance().getWhatToShow();
        return (int)result;
    }
}

