/*** -*- Mode: Javascript; tab-width: 2;

The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is Mozdev Group, Inc. code.
The Initial Developer of the Original Code is Pete Collins.

Portions created by Mozdev Group, Inc. are
Copyright (C) 2003 Mozdev Group, Inc.  All
Rights Reserved.

Contributor(s): Pete Collins <pete@mozdev.org> (original author)

***/

/****************** Globals **********************/

if (typeof(JS_LIB_LOADED)=='boolean') {

/************* INCLUDE DIR *****************/
if (typeof(JS_DIR_LOADED)!='boolean')
  include(jslib_dir);
/************* INCLUDE DIR *****************/

const JS_COMMONFILEPICKER_FILE     = "commonFilePicker.js";
const JS_COMMONFILEPICKER_LOADED   = true;

const JS_CFP_CID = "@mozilla.org/filepicker;1";
const JS_I_CFP   = "nsIFilePicker";

/****************** Common File Picker Functions *********************/

function getFilePicker () {
  return jslibCreateInstance(JS_CFP_CID, JS_I_CFP);
}

/**********************************************
 *                                            *
 * Both arguments are optional                *
 *                                            *
 * aDir                                       *
 *      can be either directory path string   *
 *   eg: "/tmp"                               *
 *      or and nsIFile object                 *
 *                                            *
 * aNewFileName                               *
 *      a new file name string                *
 *   eg: "myfile.xul"                         *
 *                                            *
 **********************************************/
function saveAsXUL (aDir, aNewFileName) {
  var fp = getFilePicker();
  fp.init(window, "SaveAsXULFile", 1);
  fp.appendFilters(C.interfaces.nsIFilePicker.filterXUL);
  
  fp.defaultString= aNewFileName ? aNewFileName : "new_file.xul";
                                                                                                    
  if (aDir) {
    if (typeof(aDir)=="object" && aDir.toString().match("nsIFile")) {
      if (!aDir.exists()) {
        jslibDebug("Dir: "+aDir.path+" doesn't exist");
        return null;
      }
      if (!aDir.isDirectory()) {
        jslibDebug("Dir: "+aDir.path+" is not a directory");
        return null;
      }
      fp.displayDirectory = aDir;
    }
    if (typeof(aDir)=="string") {
      jslibPrint("here");
      var d = new Dir(aDir);
      if (!d.exists()) {
        jslibDebug("Dir: "+d.path+" doesn't exist");
        return null;
      }
      fp.displayDirectory = d.nsIFile;
    }
  }

  fp.show();
                                                                                                    
  return (fp.file.path.length > 0 ? fp.file.path : null);

}

jslibDebug('*** load: '+JS_COMMONFILEPICKER_FILE+' OK');

} // END BLOCK JS_LIB_LOADED CHECK

// If jslib base library is not loaded, dump this error.
else {
   dump("JS_BASE library not loaded:\n"
        + " \tTo load use: chrome://jslib/content/jslib.js\n" 

        + " \tThen: include(jslib_filepicker);\n\n");

}; // END FileSystem Class
