/*** -*- Mode: Javascript; tab-width: 2;
  
The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is jslib team code.  
The Initial Developer of the Original Code is jslib team.

Portions created by jslib team are
Copyright (C) 2000 jslib team.  All
Rights Reserved.
  
Original Author: Pete Collins <pete@mozdev.org>
Contributor(s):
    
***/


if (typeof(JS_LIB_LOADED) == 'boolean') 
{
  const JS_PREFS_LOADED   = true;
  const JS_PREFS_FILE     = 'prefs.js';
  const JS_PREFS_CID      = "@mozilla.org/preferences;1";
  const JS_PREFS_I_PREF   = "nsIPref";

  /*********** PREFS *******************/
  function Prefs () 
  {
    try {
      // create instance of prefs xpcom object
      this.prefInst = jslibCreateInstance(JS_PREFS_CID, JS_PREFS_I_PREF);
      this.prefInst = jslibQI(this.prefInst, "nsIPrefBranch");
    } catch (e) { jslibError(e); }
  }

  Prefs.prototype = 
  {
    prefInst : null,

    /*********** GET Type ****************/
    // pref type
    getType : function (aPrefString) 
    {
      var rv = undefined;
      try {
        rv = this.prefInst.GetPrefType(aPrefString)
      } catch (e) { jslibError(e); }

      return rv;
    },
  
    /*********** SET BOOL ****************/
    setBool : function (aPrefString, aInBool) 
    {
      if (!aPrefString)
        return false;
  
      var rv = JS_LIB_OK;
      try {
        this.prefInst.SetBoolPref(aPrefString, aInBool)
      } catch(e) { rv = jslibError(e); }
  
      return rv;
    },
  
    /*********** GET BOOL ****************/
    getBool : function (aPrefString) 
    {
      var rv = false;

      if (!aPrefString)
        return rv;
  
      try {
        rv = this.prefInst.GetBoolPref(aPrefString)
      } catch(e) { }
  
      return rv;
    },
  
    /*********** SET CHAR PREF ***********/
    setChar : function (aPrefName, aPrefString) 
    {
      if (!aPrefName && !aPrefString)
        return jslibErrorMsg("NS_ERROR_XPC_NOT_ENOUGH_ARGS");
  
      var rv = JS_LIB_OK;
      try {
        this.prefInst.SetCharPref(aPrefName, aPrefString)
      } catch(e) { rv = jslibError(e); }
  
      return rv;
    },
  
    /*********** GET CHAR PREF ***********/
    getChar : function (aPrefName) 
    {
      if (!aPrefName)
        return jslibErrorMsg("NS_ERROR_XPC_NOT_ENOUGH_ARGS");
  
      var rv = "";
      try {
        rv = this.prefInst.GetCharPref(aPrefName)
      } catch(e) { }
  
      return rv;
    },
  
    /*********** SET INT PREF ***********/
    setInt : function (aPrefName, aInt) 
    {
      if (!aPrefName && !aInt)
        return jslibErrorMsg("NS_ERROR_XPC_NOT_ENOUGH_ARGS");
  
      var rv = JS_LIB_OK;
      try {
        this.prefInst.SetIntPref(aPrefName, aInt)
      } catch(e) { rv = jslibError(e); }
  
      return rv;
    },
  
    /*********** GET INT PREF ***********/
    getInt : function (aPrefName) 
    {
      if (!aPrefName)
        return jslibErrorMsg("NS_ERROR_XPC_NOT_ENOUGH_ARGS");
  
      var rv;
      try {
        rv = this.prefInst.GetIntPref(aPrefName)
      } catch(e) { rv = -jslibRes.NS_ERROR_FAILURE; }
  
      return rv;
    },
  
    /*********** RESET PREF *************/
    reset : function () 
    {
      var rv = JS_LIB_OK;
      try {
        this.prefInst.ResetPrefs();
      } catch(e) { rv = jslibError(e); }
  
      return rv;
    },
  
    /*********** RESET USER PREF ********/
    resetUser : function () 
    {
      var rv = JS_LIB_OK;
      try {
        this.prefInst.ResetUserPrefs();
      } catch(e) { rv = jslibError(e); }
  
      return rv;
    },
  
    /*********** SAVE PREF **************/
    save : function (aFile) 
    {
      var file;
      switch (typeof(aFile)) 
      {
        case "object":
          // check object is an nsIFile object
          if (typeof(aFile.path) == "string")
          file = aFile;
          break;
  
        case "string":
          include (jslib_file);
          // path is a string, make it into an nsIFile
          file = (new File(aFile)).nsIFile;
          break;
      }
  
      var rv = JS_LIB_OK;
      try {
        this.prefInst.savePrefFile(file);
      } catch(e) { rv = jslibError(e); }
  
      return rv;
    },
  
    /*********** CLEAR USER PREF ********/
    clear : function (aPrefString) 
    {
      var rv = JS_LIB_OK;
      try {
        this.prefInst.ClearUserPref(aPrefString);
      } catch(e) { rv = jslibError(e); }
  
      return rv;
    },
  
    /*********** GET NSIPREF ********/
    get nsIPref () { return this.prefInst; }
  
  }; // END CLASS
  
  jslibLoadMsg(JS_PREFS_FILE);

} else { dump("load FAILURE: prefs.js\n"); }
  
