/*

The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is jslib team code.
The Initial Developer of the Original Code is jslib team.

Portions created by jslib team are
Copyright (C) 2000 jslib team.  All
Rights Reserved.

Original Author: Pete Collins <pete@mozdev.org>
Contributor(s):

*/

if (typeof(JS_LIB_LOADED)=='boolean') {

  const JS_SOUND_LOADED = true;
  const JS_SOUND_FILE   = "sound.js";

  function Sound (aURL) {
    this.init(aURL);
  }

  Sound.prototype = {

    mFile      : null,
    mURL       : null,
    mSND       : null,
    mLocalURL  : false,

    init  : function (aURL) {

      if (!this.mSND) {
        try {
          const SND_I_SOUND = "nsISound";
          const SND_CID     = "@mozilla.org/sound;1";
          var Sound         = new C.Constructor(SND_CID, SND_I_SOUND);
          this.mSND         = new Sound();
          jslibDebug("initializing nsISound component . . . \n");
        } catch (e) {
          jslibError(e, "(sound initialization error)", 
                      "NS_ERROR_UNEXPECTED", JS_SOUND_FILE+":init");
        }
      }

      if (aURL) {
        try {
          jslibDebug("URL in: ["+aURL+"]\n");
          const SND_NETWORK_STD_CID = "@mozilla.org/network/standard-url;1";
          const SND_I_URL           = "nsIURL";
          const SND_URL             = new  C.Constructor(SND_NETWORK_STD_CID, SND_I_URL);
          this.mURL                 = new SND_URL();
          this.mURL.spec            = aURL;
          if (this.mURL.scheme == 'resource' ||
              this.mURL.scheme == 'file') {
            jslibDebug("Play Local\n");
            this.mLocalURL = true;
          } else {
            this.mLocalURL = false;
          }
        } catch (e) {
          jslibError(e, "(sound url initialization error)", 
                      "NS_ERROR_UNEXPECTED", JS_SOUND_FILE+":init");
        }
      }
    },

    play  : function () {
       if (!this.mURL)
         jslibDebug("Please initialize with a file or url\n");
      try {
        if (this.mLocalURL) {
          jslibDebug("Playing Local Sound File: ["+this.mURL.spec+"]\n");
          this.mSND.play(this.mURL);
        } else {
          jslibDebug("Playing ["+this.mURL.scheme+"] Sound File: ["+this.mURL.spec+"]\n");
          this.mSND.play(this.mURL);
        }
      } catch (e) {
        jslibError(e, "(sound play error)", 
                    "NS_ERROR_UNEXPECTED", JS_SOUND_FILE+":play");
      }
    },
    beep  : function() {
      try {
        this.mSND.beep();
      } catch (e) {
        jslibError(e, "(sound beep error)", 
                    "NS_ERROR_UNEXPECTED", JS_SOUND_FILE+":beep");
      }
    }
  }
  jslibDebug('*** load: '+JS_SOUND_FILE+' OK');
} // END BLOCK JS_LIB_LOADED CHECK 
  else {
    dump("JS_FILE library not loaded:\n"                                +
         " \tTo load use: chrome://jslib/content/jslib.js\n"            +
         " \tThen: include('chrome://jslib/content/io/filesystem.js');\n\n");
}
