/*** -*- Mode: Javascript; tab-width: 2;

The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is Collabnet code.
The Initial Developer of the Original Code is Collabnet.

Portions created by Collabnet are Copyright (C) 2000 Collabnet.
All Rights Reserved.

Contributor(s): Pete Collins, Doug Turner, Brendan Eich, Warren Harris,
                Eric Plaster, Martin Kutschker


JS Directory Class API
  dir.js

Function List
    create(aPermissions); // permissions are optional
    files();              // returns an array listing all files of a dirs contents 
    dirs();               // returns an array listing all dirs of a dirs contents 
    list(aDirPath);       // returns an array listing of a dirs contents 
    help();               // currently dumps a list of available functions 

Instructions:

***************************************************/

if (typeof(JS_LIB_LOADED)=='boolean') 
{

/************* INCLUDE FILESYSTEM *****************/
if (typeof(JS_FILESYSTEM_LOADED)!='boolean')
  include(jslib_filesystem);


/****************** Globals **********************/
const JS_DIR_FILE                    = "dir.js";
const JS_DIR_LOADED                  = true;

const JS_DIR_LOCAL_CID               = "@mozilla.org/file/local;1";
const JS_DIR_LOCATOR_PROGID          = '@mozilla.org/filelocator;1';
const JS_DIR_CID                     = "@mozilla.org/file/directory_service;1";

const JS_DIR_I_LOCAL_FILE            = "nsILocalFile";
const JS_DIR_INIT_W_PATH             = "initWithPath";

const JS_DIR_PREFS_DIR               = 65539;

const JS_DIR_DIRECTORY               = 0x01;     // 1
const JS_DIR_OK                      = true;

const JS_DIR_DEFAULT_PERMS           = 0766;

const JS_DIR_FilePath                = new Components.Constructor(JS_DIR_LOCAL_CID, 
                                                   JS_DIR_I_LOCAL_FILE, 
                                                   JS_DIR_INIT_W_PATH);

/********************
 * Dir Object Class *
 ********************/
function Dir(aPath) 
{
  if (!aPath) 
    return jslibErrorMsg("NS_ERROR_XPC_NOT_ENOUGH_ARGS");

  var rv;
  if (jslibTypeIsObj(aPath))
    rv = aPath.path;
  else
    rv = arguments;

  return this.initPath(rv);
} // end constructor

Dir.prototype = new FileSystem;
Dir.prototype.fileInst = null;

/********************* CREATE ****************************/
Dir.prototype.create = function (aPermissions) 
{
  if (!this.mPath) 
    return jslibErrorMsg("NS_ERROR_NOT_INITIALIZED");

  if (this.exists()) 
    return jslibErrorMsg("NS_ERROR_FILE_ALREADY_EXISTS");

  if (typeof(aPermissions) == "number") {
    var checkPerms = this.validatePermissions(aPermissions);

    if (!checkPerms) 
      return jslibErrorMsg("NS_ERROR_INVALID_ARG");

    checkPerms = aPermissions;
  } else {
    checkPerms = this.mFileInst.parent.permissions;
  }

  var rv = JS_LIB_OK;
  try {
    rv = this.mFileInst.create(JS_DIR_DIRECTORY, checkPerms);
  } catch (e) { 
    rv = jslibError(e);
  }

  return rv;
};

/********************* READDIR **************************/
Dir.prototype.readDir = function ()
{
  if (!this.exists()) 
    return jslibErrorMsg("NS_ERROR_FILE_TARGET_DOES_NOT_EXIST");

  var rv = JS_LIB_OK;
  try {
    if (!this.isDir()) 
      return jslibErrorMsg("NS_ERROR_FILE_NOT_DIRECTORY");

    var files     = this.mFileInst.directoryEntries;
    var listings  = new Array();
    var file;

    include(jslib_file);
    while (files.hasMoreElements()) {
      file = files.getNext().QueryInterface(jslibI.nsILocalFile);
      if (file.isFile())
        listings.push(new File(file.path));

      if (file.isDirectory())
        listings.push(new Dir(file.path));
    }

    rv = listings;
  } catch(e) { rv = jslibError(e); }

  return rv;
};

/********************* CLONE ********************************/
Dir.prototype.clone = function ()
{
  if (!this.checkInst())
    return jslibErrorMsg("NS_ERROR_NOT_INITIALIZED");

  return new Dir(this.mPath);
},

/********************* REMOVE *******************************/
Dir.prototype.remove = function (aRecursive)
{
  if (typeof(aRecursive)!='boolean')
    aRecursive=false;

  if (!this.checkInst())
    return jslibErrorMsg("NS_ERROR_NOT_INITIALIZED");

  if (!this.mPath)
    return jslibErrorMsg("NS_ERROR_INVALID_ARG");

  var rv = JS_LIB_OK;
  try { 
    if (!this.exists()) 
      return jslibErrorMsg("NS_ERROR_FILE_TARGET_DOES_NOT_EXIST");

    if (!this.isDir()) 
      return jslibErrorMsg("NS_ERROR_FILE_NOT_DIRECTORY");

    rv = this.mFileInst.remove(aRecursive);
  } catch (e) { rv = jslibError(e); }

  return rv;
};

/********************* HELP *****************************/
Dir.prototype.super_help = FileSystem.prototype.help;

Dir.prototype.__defineGetter__('help', 
function () 
{
  var help = this.super_help()              +
    "   create(aPermissions);\n"            +
    "   remove(aRecursive);\n"              +
    "   readDir(aDirPath);\n";

  return help;
});

jslibLoadMsg(JS_DIR_FILE);

} else { dump("Load Failure: dir.js\n"); }

