/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * c:/builds/1813/mozilla/accessible/public/nsIAccessible.idl
 */

package org.mozilla.interfaces;

/**
 * A cross-platform interface that supports platform-specific 
 * accessibility APIs like MSAA and ATK. Contains the sum of what's needed
 * to support IAccessible as well as ATK's generic accessibility objects.
 * Can also be used by in-process accessibility clients to get information
 * about objects in the accessible tree. The accessible tree is a subset of 
 * nodes in the DOM tree -- such as documents, focusable elements and text.
 * Mozilla creates the implementations of nsIAccessible on demand.
 * See http://www.mozilla.org/projects/ui/accessibility for more information.
 *
 * @status UNDER_REVIEW
 */
public interface nsIAccessible extends nsISupports {

  String NS_IACCESSIBLE_IID =
    "{db717db4-37e9-42f1-a3b0-2579dd7c3814}";

  /**
   * Parent node in accessible tree.
   */
  nsIAccessible getParent();

  /**
   * Next sibling in accessible tree
   */
  nsIAccessible getNextSibling();

  /**
   * Previous sibling in accessible tree
   */
  nsIAccessible getPreviousSibling();

  /**
   * First child in accessible tree
   */
  nsIAccessible getFirstChild();

  /**
   * Last child in accessible tree
   */
  nsIAccessible getLastChild();

  /**
   * Number of accessible children
   */
  int getChildCount();

  /**
   * The 0-based index of this accessible in its parent's list of children,
   * or -1 if this accessible does not have a parent.
   */
  int getIndexInParent();

  /**
   * Accessible name -- the main text equivalent for this node
   */
  String getName();

  /**
   * Accessible name -- the main text equivalent for this node
   */
  void setName(String aName);

  /**
   * Accessible value -- a number or a secondary text equivalent for this node
   * Widgets that use a role attribute can force a value using the valuenow attribute
   */
  String getFinalValue();

  /**
   * Accessible description -- long text associated with this node
   */
  String getDescription();

  /**
   * Provides localized string of accesskey name, such as Alt+D.
   * The modifier may be affected by user and platform preferences.
   * Usually alt+letter, or just the letter alone for menu items. 
   */
  String getKeyboardShortcut();

  /**
   * Provides localized string of global keyboard accelerator, such
   * as Ctrl+O for Open file
   */
  String getKeyBinding();

  /**
   * Natural enumerated accessible role for the associated element.
   * The values depend on platform because of variations.
   * See the ROLE_* constants defined later in this file.
   * This does not take into account role attribute as the finalRole does.
   */
  long getRole();

  /**
   * Enumerated accessible role. The values depend on platform because of variations.
   * See the ROLE_* constants defined later in this file.
   * Widgets can use role attribute to force the final role
   */
  long getFinalRole();

  /**
   * Accessible states -- bit field which describes boolean properties of node. 
   * See the STATE_* constants defined later in this file.
   * Many states are only valid given a certain role attribute that supports them
   */
  long getFinalState();

  /**
   * Extended accessible states -- second bit field describing node
   */
  long getExtState();

  /**
   * Help text associated with node
   */
  String getHelp();

  /**
   * Focused accessible child of node
   */
  nsIAccessible getFocusedChild();

  /**
   * Accessible child which contains the coordinate at x,y
   */
  nsIAccessible getChildAtPoint(int x, int y);

  /**
   * Nth accessible child using zero-based index or last child if index less than zero
   */
  nsIAccessible getChildAt(int aChildIndex);

  /**
   * Accessible node geometrically to the right of this one
   */
  nsIAccessible getAccessibleToRight();

  /**
   * Accessible node geometrically to the left of this one
   */
  nsIAccessible getAccessibleToLeft();

  /**
   * Accessible node geometrically above this one
   */
  nsIAccessible getAccessibleAbove();

  /**
   * Accessible node geometrically below this one
   */
  nsIAccessible getAccessibleBelow();

  /**
   * Accessible node related to this one 
   */
  nsIAccessible getAccessibleRelated(long aRelationType);

  void getBounds(int[] x, int[] y, int[] width, int[] height);

  /**
   * Add this accessible to the current selection
   */
  void addSelection();

  /**
   * Remove this accessible from the current selection
   */
  void removeSelection();

  /**
   * Extend the current selection from its current accessible anchor node
   * to this accessible
   */
  void extendSelection();

  /**
   * Select this accessible node only
   */
  void takeSelection();

  /**
   * Focus this accessible node,
   * The state STATE_FOCUSABLE indicates whether this node is normally focusable.
   * It is the callers responsibility to determine whether this node is focusable.
   * accTakeFocus on a node that is not normally focusable (such as a table),
   * will still set focus on that node, although normally that will not be visually 
   * indicated in most style sheets.
   */
  void takeFocus();

  /**
   * The number of accessible actions associated with this accessible
   */
  short getNumActions();

  /**
   * The name of the accessible action at the given zero-based index
   */
  String getActionName(short index);

  /**
   * Perform the accessible action at the given zero-based index
   * Action number 0 is the default action
   */
  void doAction(short index);

  /**
   * MSAA State flags - used for bitfield. More than 1 allowed.
   */
  long STATE_UNAVAILABLE = 1L;

  long STATE_SELECTED = 2L;

  long STATE_FOCUSED = 4L;

  long STATE_PRESSED = 8L;

  long STATE_CHECKED = 16L;

  long STATE_MIXED = 32L;

  long STATE_READONLY = 64L;

  long STATE_HOTTRACKED = 128L;

  long STATE_DEFAULT = 256L;

  long STATE_EXPANDED = 512L;

  long STATE_COLLAPSED = 1024L;

  long STATE_BUSY = 2048L;

  long STATE_FLOATING = 4096L;

  long STATE_MARQUEED = 8192L;

  long STATE_ANIMATED = 16384L;

  long STATE_INVISIBLE = 32768L;

  long STATE_OFFSCREEN = 65536L;

  long STATE_SIZEABLE = 131072L;

  long STATE_MOVEABLE = 262144L;

  long STATE_SELFVOICING = 524288L;

  long STATE_FOCUSABLE = 1048576L;

  long STATE_SELECTABLE = 2097152L;

  long STATE_LINKED = 4194304L;

  long STATE_TRAVERSED = 8388608L;

  long STATE_MULTISELECTABLE = 16777216L;

  long STATE_EXTSELECTABLE = 33554432L;

  long STATE_ALERT_LOW = 67108864L;

  long STATE_ALERT_MEDIUM = 134217728L;

  long STATE_ALERT_HIGH = 268435456L;

  long STATE_PROTECTED = 536870912L;

  long STATE_HASPOPUP = 1073741824L;

  long STATE_REQUIRED = 67108864L;

  long STATE_IMPORTANT = 134217728L;

  long STATE_INVALID = 268435456L;

  long STATE_CHECKABLE = 8192L;

  /**
 * Extended state flags (for now non-MSAA, for Java and Gnome/ATK support)
 * "Extended state flags" has seperate value space from "MSAA State flags".
 */
  long EXT_STATE_EDITABLE = 2097152L;

  long EXT_STATE_ACTIVE = 4194304L;

  long EXT_STATE_EXPANDABLE = 8388608L;

  long EXT_STATE_MODAL = 16777216L;

  long EXT_STATE_MULTI_LINE = 33554432L;

  long EXT_STATE_SENSITIVE = 67108864L;

  long EXT_STATE_SHOWING = 268435456L;

  long EXT_STATE_SINGLE_LINE = 536870912L;

  long EXT_STATE_TRANSIENT = 1073741824L;

  long EXT_STATE_VERTICAL = 2147483648L;

  /**
 * Relation Types -- most of these come from ATK's atkrelationtype.h
 * RELATION_NULL:
 * RELATION_CONTROLLED_BY:    Controlled by one or more target objects.
 * RELATION_CONTROLLER_FOR:   Controller for one or more target objects.
 * RELATION_LABEL_FOR:        Label for one or more target objects.
 * RELATION_LABELLED_BY:      Labelled by one or more target objects.
 * RELATION_MEMBER_OF:        Member of a group of one or more target objects.
 * RELATION_NODE_CHILD_OF:    Cell in a treetable which is displayed because a
 *                            cell in the same col is expanded & identifies it.
 * RELATION_FLOWS_TO:         Has content that flows logically to another
 *                            object in a sequential way, e.g. text flow.
 * RELATION_FLOWS_FROM:       Has content that flows logically from another
 *                            object in a sequential way, e.g. text flow.
 * RELATION_SUBWINDOW_OF:     Subwindow attached to a component but otherwise 
 *                            not connected in the UI hierarchy to that component.
 * RELATION_EMBEDS:           Visually embeds another object's content, i.e.
 *                            this object's content flows around another's content.
 * RELATION_EMBEDDED_BY:      Inverse of RELATION_EMBEDS; this object's content
 *                            is visually embedded in another object.
 * RELATION_POPUP_FOR:        Popup for another object.
 * RELATION_PARENT_WINDOW_OF: Parent window of another object.
 * RELATION_DEFAULT_BUTTON:   Part of a form/dialog with a related default button.
 * RELATION_DESCRIBED_BY:     Described by one or more target objects.
 * RELATION_DESCRIPTION_FOR:  Description for one or more target objects.
 * RELATION_LAST_DEFINED:
 */
  long RELATION_NUL = 0L;

  long RELATION_CONTROLLED_BY = 1L;

  long RELATION_CONTROLLER_FOR = 2L;

  long RELATION_LABEL_FOR = 3L;

  long RELATION_LABELLED_BY = 4L;

  long RELATION_MEMBER_OF = 5L;

  long RELATION_NODE_CHILD_OF = 6L;

  long RELATION_FLOWS_TO = 7L;

  long RELATION_FLOWS_FROM = 8L;

  long RELATION_SUBWINDOW_OF = 9L;

  long RELATION_EMBEDS = 10L;

  long RELATION_EMBEDDED_BY = 11L;

  long RELATION_POPUP_FOR = 12L;

  long RELATION_PARENT_WINDOW_OF = 13L;

  long RELATION_DEFAULT_BUTTON = 16384L;

  long RELATION_DESCRIBED_BY = 16385L;

  long RELATION_DESCRIPTION_FOR = 16386L;

}