/**
 * HTLM header toolbar class
 * 
 * to prevent variable/function name conflicts, we pack all the 
 * stuff in our htmlHeader Object. Some properties are static!
 *
 * Todo for preview
 *  - insert befre/insert after's context menu disappears after the 1st usage.
 *  - select stylesheet in cascades (just opens by now)
 *  - firefox install.js + dialogs (config, about, etc.)
 *  - there are some js error's left (in init AFAIK) which don't affect the 
 *    toolbar. looks like init fires a bit early. clean up
 *  - test test test!
 *  - xpi
 *  
 * Bugs:
 *  - in the menu: View  Show/Hide  Customize Toolbar  HTML Header 
 *    toolbar opens the edit menu bar dialog which is not appropriate 
 *    for this tool bar (please let me know if you have a solution to 
 *    disable this automaticly created menu entry).
 *  - scrollgroupbox handles (darts) point vertical instead of horizontal
 *  
 * Fatures (Todo):
 *  - integrate url picker.
 *  - add "File  Properties" overlay. display a "OOo" alike document 
 *    properties dialog. these data are stored mostly in meta tags
 *  - click on comment node opens popup with textbox in a context menu
 *  - ? add rdf data files for pulldown option values/labels. make these 
 *    editable (rememberable) where applicable (ie. allow updates to 
 *    the rdf file)
 *  - drag move items.
 *  - ? some tags/attribute constalations may appear only once inside head 
 *    (like title, or base href=""). check for duplicates before insert 
 *    dialog is opened (depending on tag/attribute constalation) and 
 *    before actually inserting (depending on attributes)
 *  - check for compliance with a bunch of other dtd's like, 
 *    html 1.x-4.x, xhtml 1.x.
 *
 * Branding/Release
 *  - 16x16px icons alla classic theme (CI/CD)
 *  - credits (gimp icons at least!)
 * 
 * Extension id: {136c295a-4a5a-41cf-bf24-5cee526720d5}
 * NVu developer: daniel@glazman.org
 * http://www.glazman.org/nvu/releases/test/20041213/contribs/
 * 
 */
var htmlHeader = {
	currentTag: null,          // Object (ref) HTMLElement, static
	updateInProgress: false,   // Boolean, Static
	selectedEditorIndex: -1,    // Integer, static
	cascadesInitialized: false,// Boolean, static
	cascades: {},              // Object (ref) XULWindow, static
	insertBefore: false,       // Boolean, static
	insertAfter: false,        // Boolean, static
	initialized: false,        // Boolean, static
	prefService: {},           // Object nsIPrefServiceBranch, static
	
	toolbar : null,            // Object (ref) XULElement
	toolbarBox: null,          // Object (ref) XULElement
	tabBox: null,              // Object (ref) XULElement
	tabEditor: null,           // Object editor
	prefs: {displayIcons: true, displayLabels:true },
	
	init : function() {
		
		// we get triggered more than once, do it only once
		if(htmlHeader.initialized)
			return true;
		
		// assign references to commonly used objects
		this.tabEditor  = getById("tabeditor");
		this.tabBox     = this.tabEditor.mTabbox;
		this.toolbar    = getById("HtmlHeaderToolbar");
		this.toolbarBox = getById("htmlHeaderButtonsBox");
		
		// bail if we can't find an editor
		if (!this.tabEditor) 
			return false;
		
		// set eventHandlers
		this.tabBox.addEventListener("focus", htmlHeader.evDocumentChange, true);
		this.tabEditor.addEventListener("load", htmlHeader.evDocumentChange, true);
		getById("content-source").addEventListener("focus", 
		  htmlHeader.evDocumentChange, true);
//		htmlHeader.selectedEditorIndex = document.getElementById("tabeditor").selectedIndex;
		
		// init pref service
		htmlHeader.prefService = Components.classes["@mozilla.org/preferences;1"]
		                            .getService(Components.interfaces.nsIPrefBranch);
		
		// read configuration
		var n = HTMLHEADER_PREFBRANCH+"displayIcons";
		htmlHeader.prefs.displayIcons  = htmlHeader.getPrefValue(n , "bool", true);
//		p("cfg icons:" + htmlHeader.prefs.displayIcons);
		getById("htmlHeader.displayIcons").setAttribute("checked", htmlHeader.prefs.displayIcons);
		n = HTMLHEADER_PREFBRANCH+"displayLabels";
		htmlHeader.prefs.displayLabels = htmlHeader.getPrefValue(n , "bool", true);
//		p("cfg labels:" + htmlHeader.prefs.displayLabels);
		getById("htmlHeader.displayLabels").setAttribute("checked", htmlHeader.prefs.displayLabels);
		
		// initialize the scroll box
		//var arrowscrollBox = getById("htmlHeaderButtonsBox");
		htmlHeader.initialized = true;
		
		if(DEBUGGING) {
			p("htmlHeader.init: done.");
			p(htmlHeader.getPrefValue(HTMLHEADER_PREFBRANCH+"displayLabels", "bool", true));
		}
		
		return true;
	},

  // getteerr /////////////////////////////////////////////////////////////////
	// some object references may change during a session (ie when user 
	// changes tab). therefoew, some objects are refetched before usage, always.
	//
	// this could also be implemented with getters, but setter/getter doe "only"
	// work in the C++ implementation of moz's js, so we try to keep 
	// it compatible.
	document : function() {
		return GetCurrentEditor().document;
	}, 
	
	header : function () {
		return this.document().getElementsByTagName("HEAD").item(0);
	},

	evDocumentChange : function(ev) {
		if (!htmlHeader.initialized)
			return false;
		
		// 2 things to do: 
		//   1. if the target is source-editor, disable toolbar
		//   2. else update buttons deleayed and enable toolbar
		
		if (ev.currentTarget.id == "content-source" && ev.type == "focus") {
			document.getElementById("HtmlHeaderToolbox").setAttribute("collapsed", true);
			htmlHeader.selectedEditorIndex = -1;
			return true;
		}
		
		// sometimes we get more than one focus event triggered. we skip the rest
		if (htmlHeader.updateInProgress)
			return true;
		
		var handleFocusUpdate = false;
		var currentIndex = getById("tabeditor").selectedIndex;
		if (ev.type == "load")
			handleFocusUpdate = true;
		if (ev.type == "focus" && htmlHeader.selectedEditorIndex != currentIndex)
			handleFocusUpdate = true;

		//p(htmlHeader.selectedEditorIndex + " " + getById("tabeditor").selectedIndex + ", " + ev.type);
		//p("src:" + htmlHeader.document().location.href);
		
		// if it is a focus event, and the selected tab or the document's href has 
		// changed, update the toolbar
		if (handleFocusUpdate) {
			
			// display it again (in case we come from the source-window)
			document.getElementById("HtmlHeaderToolbox").setAttribute("collapsed", false);
			
			// scroll back to the start of the header (in case user scrolled)
			htmlHeader.toolbarBox.scrollByIndex(-1000);
			htmlHeader.selectedEditorIndex = currentIndex;
			
			/* it looks like we don't need the deleyed update anymore

			//htmlMetaConsole.consoleOut("Delayed update");
			// we delay the actual toolbar update to skip any subsequent 
			// triggered focus event. unfortunately we capture to many focus events
			htmlHeader.updateInProgress = true;
			document.getElementById("HtmlHeaderToolbox").setAttribute("collapsed", false);
			setTimeout('htmlHeader.updateToolbar()', 50); */

			htmlHeader.updateToolbar()
			
			return true;
		}
	
	},
	
	getHeadChildren : function() {
		// find header tag
		var header   = this.document().getElementsByTagName("HEAD").item(0);
		return header.childNodes; // ok i am lazy
	},
	
	updateToolbar : function() {
		htmlHeader.updateInProgress = false;

		this.clearButtons();
		
		// find header tag
		var tagName  = '';
		var header   = this.header();
		var children = header.childNodes; // ok i am lazy
		for(var i=0; i<children.length; i++) {
			e=children.item(i);
			if (e.nodeType == TEXT_NODE ) // skip whitespace, nodeType == 3
				continue; 
			
			// get the tag name for validation
			if (e.nodeType == COMMENT_NODE)
				tagName = "comment";
			else if (e.tagName)
				tagName = e.tagName.toLowerCase();
			else tagName = '';
			
			if (tagName in SUPPORTED_TAGS) {
				this.addButton(e);
				continue;
			}
			
			this.addAnonymousButton(e);
		}
		
		// all butons added by now. collaps the add button if we have at least 
		// one header button:
		var addHeader          = getById("addHeader");
		var addHeaderSeperator = getById("addHeaderSeperator");
		var collapsed          = false;
		
		if (this.toolbarBox.childNodes.length)
			collapsed = true;
		
		addHeader.setAttribute("collapsed", collapsed);
		addHeaderSeperator.setAttribute("collapsed", collapsed);
		
		if (DEBUGGING)
			p("toolbar updated");
	},
	
	addAnonymousButton: function(headerTag) {
		var tagName = "?";
		if(headerTag.tagName)
			tagName = headerTag.tagName.toLowerCase();
		tagName = "{" + tagName + "}";

		var newBtn = document.createElement("toolbarbutton");
		newBtn.setAttribute("id", tagName);
		
		// skip image if not configured
		if (htmlHeader.prefs.displayIcons) {
			var img = document.createElement("image");
			newBtn.appendChild(img);
			img.setAttribute("src", "chrome://htmlheader/content/images/icons/junk-16.png");
		}
		
		// skip label if empty
		if (tagName != '' && htmlHeader.prefs.displayLabels) {
			var lbl = document.createElement("label");
			newBtn.appendChild(lbl);
			lbl.setAttribute("value", tagName);
		}
		
		newBtn.associatedElement = headerTag;

		// attach context menu
		newBtn.setAttribute("context", "cxtHeaderMenu");
		this.toolbarBox.appendChild(newBtn);
		newBtn.addEventListener("contextmenu", htmlHeader.updateToolbarCxtMenu, true);

		return true;
	},
	
	addButton : function(headerTag) {

		// figure the image name
		var tagName = '';
		var imgName = "default";
		if(headerTag.tagName)
			tagName = headerTag.tagName.toLowerCase();
		if (headerTag.nodeType == COMMENT_NODE)
			imgName = "comment";
		// FIXME: use if (tagName in SUPPORTED_TAGS) if this works in js; RTFM
		else if (tagName == 'link' || tagName == 'meta' || tagName == 'script' || 
		         tagName == 'style' || tagName == 'title' || tagName == 'base')
			imgName = tagName;

		var newBtn = document.createElement("toolbarbutton");
		
		if (htmlHeader.prefs.displayIcons) {
			var img = document.createElement("image");
			img.setAttribute("src", "chrome://htmlheader/content/images/icons/"+imgName+"-16.png");
			newBtn.appendChild(img);
		}
		
		newBtn.setAttribute("id", headerTag.id);
		
		// Add a label to every button except comments
		var lblValue = "";
		// no label for comment nodes
		if (headerTag.nodeType != COMMENT_NODE)
			lblValue = headerTag.tagName.toUpperCase();
		else
			lblValue = "<!--";
		
//		p("display labels ? " + htmlHeader.prefs.displayLabels);
		// don't add the label if it's empty
		if (lblValue != '' && htmlHeader.prefs.displayLabels) {
			var lbl = document.createElement("label");
			lbl.setAttribute("value", lblValue);
			newBtn.appendChild(lbl);
		}

		newBtn.label = headerTag.tagName;
		newBtn.associatedElement = headerTag;
		
		// if the tag has a title, use it as tooltiptext
		var t = "";
		if (headerTag.getAttribute && typeof headerTag.getAttribute == "function") {
			t = headerTag.getAttribute("title");
		}
		if (t) newBtn.setAttribute("tooltiptext", t);

		// attach button to the toolbar
		this.toolbarBox.appendChild(newBtn);

		// attach context menu
		newBtn.setAttribute("context", "cxtHeaderMenu");
		newBtn.assiciatedElement = headerTag;
		
		// attach tooltip for comments
		if (headerTag.nodeType == COMMENT_NODE) {
			newBtn.setAttribute("tooltip", "commentHeaderMenu");
			newBtn.addEventListener("mouseover", 
			                        htmlHeader.updateToolbarCommentMenu, false);
			newBtn.addEventListener("mouseout", 
			                        htmlHeader.updateToolbarCommentMenuOut, false);
			
		}
		
		// attach events and data
		var cmd = (tagName == "style") ? htmlHeader.openCssEd : htmlHeader.editTag;
		newBtn.addEventListener("command", cmd, true);
		newBtn.addEventListener("contextmenu", 
		                        htmlHeader.updateToolbarCxtMenu, true);

		return true;
	},
	
	updateToolbarCommentMenu: function(Ev) {
		var tooltip = getById("commentHeaderMenuInput");
		
		// clear existing comment
		if (tooltip.firstChild)
			while(tooltip.firstChild)
				tooltip.removeChild(tooltip.firstChild);
		
		// add comment's content to the tooltip
		var text = Ev.target.associatedElement.nodeValue;
		if (!text) 
			text="&laquo;Empty&raquo;";
		tooltip.appendChild(document.createTextNode(text));
		// getById("commentHeaderMenu").showPopup(Ev.target, -1, -1, "tooltip");
		
		p("we should see a toolbar now!");
	},
	
	updateToolbarCommentMenuOut: function(Ev) {
		getById("commentHeaderMenu").hidePopup();
	},
	
	clearButtons : function() {
		while( (e=this.toolbarBox.firstChild) ) {
			this.toolbarBox.removeChild(e);
		}
		return true;
	},
	
	updateToolbarCxtMenu: function(e) {
		htmlHeader.currentTag = e.target.associatedElement;
		
		// tag name (lower case)
		var tag = '';
		if (htmlHeader.currentTag.nodeType != COMMENT_NODE && 
		    htmlHeader.currentTag.tagName)
			tag = htmlHeader.currentTag.tagName.toLowerCase();
		
		// check if we have a comment node and if the tag is supported
		var isComment = (htmlHeader.currentTag.nodeType == COMMENT_NODE) ? true : false;
		var isSupported = (tag in SUPPORTED_TAGS && SUPPORTED_TAGS[tag]) ? true : false;
		//p("supported: " + isSupported +", comment: " + isComment);
		
		// references to the variable menuitems in the contextitem
		var btnCxtRemove       = getById("btnCxtRemove");
		var btnCxtEdit         = getById("btnCxtEdit");
		var btnCxtEditAdvanced = getById("btnCxtEditAdvanced");
		var btnCxtCascades     = getById("btnCxtCascades");

		// comments have no advanced edit
		if(isComment) {
			btnCxtRemove.setAttribute("collapsed", false);
			btnCxtEdit.setAttribute("collapsed", false);
			btnCxtEditAdvanced.setAttribute("collapsed", true);
			btnCxtCascades.setAttribute("collapsed", false);
			return true;
		}
		
		// unsupported tags have only a remove button
		if(!isSupported) {
			btnCxtRemove.setAttribute("collapsed", false);
			btnCxtEdit.setAttribute("collapsed", true);
			btnCxtEditAdvanced.setAttribute("collapsed", true);
			btnCxtCascades.setAttribute("collapsed", true);
			return true;
		}
		
		// style tags have all buttons, ad edit opens cascades 
		if (tag == "style") {
			btnCxtRemove.setAttribute("collapsed", false);
			btnCxtEdit.setAttribute("collapsed", false);
			btnCxtEditAdvanced.setAttribute("collapsed", true);
			btnCxtCascades.setAttribute("collapsed", false);
			return true;
		}

		// all other supported tags have the css button disabled
		btnCxtRemove.setAttribute("collapsed", false);
		btnCxtEdit.setAttribute("collapsed", false);
		btnCxtEditAdvanced.setAttribute("collapsed", false);
		btnCxtCascades.setAttribute("collapsed", true);
		return true;
	},
	
  // button/toolbar event handlers ////////////////////////////////////////////
	
	unpdatePref: function(strPrefName, strType, value) {
//		p("updating pref: " + strPrefName+", "+strType+", "+value);
		htmlHeader.setPrefValue(HTMLHEADER_PREFBRANCH+strPrefName, strType, value); 
		htmlHeader.prefs[strPrefName] = value;
		htmlHeader.updateToolbar();	
	},

	editTag : function(e) {
	
		if (e.target)
			htmlHeader.currentTag = e.target.associatedElement;
		
		var arg1 = htmlHeader.currentTag.cloneNode(true);

		htmlHeader.editTagDialog(arg1);
	},
	
	editTagDialog: function(el) {
		var url = "chrome://htmlheader/content/editTag-";
		var options = 'all,dialog=yes,modal=yes';
		var tag = "";
		if (htmlHeader.currentTag.nodeType != COMMENT_NODE)
			tag = htmlHeader.currentTag.tagName.toLowerCase();
		else
			tag = "comment";
			
		url += tag+".xul";
		window.openDialog(url, '_blank', options, el);
	},

	advancedEdit: function() {
		var url = "chrome://editor/content/EdAdvancedEdit.xul";
		var options = 'all,dialog=yes,modal=yes';
		var w = window.openDialog(url, 'advancedEdit', options, null, htmlHeader.currentTag);
		return true;
	}, 

	createEmptyNode: function(el, insertAt) {
		if (el.label == "Comment")
			var tag = document.createComment("");
		else
			var tag = document.createElement(el.label.toLowerCase());

		tag.createNew = true;
		if (!insertAt)
			tag.insertAt = "";
		else
			tag.insertAt = insertAt;
		
		return tag;
	},
	
	addTag: function(el) {
		var tag = this.createEmptyNode(el, "");
		
		htmlHeader.currentTag = tag;
		htmlHeader.editTagDialog(tag);
	},
	
	addTagBefore: function(el) {
		var tag = this.createEmptyNode(el, "before");
		htmlHeader.insertBefore = htmlHeader.currentTag;
		
		htmlHeader.currentTag = tag;
		htmlHeader.editTagDialog(tag);
	},
	
	addTagAfter: function(el) {
		var tag = this.createEmptyNode(el, "after");
		htmlHeader.insertAfter = htmlHeader.currentTag;
		
		htmlHeader.currentTag = tag;
		htmlHeader.editTagDialog(tag);
	},
	
  // source tag manipulation //////////////////////////////////////////////////
	
	_setEditorChanged: function() {
		// mark document as edited.
		var ed = GetCurrentEditor();
		ed.incrementModificationCount(1);
	},
	
	removeTag: function() {
		htmlHeader.currentTag.parentNode.removeChild(htmlHeader.currentTag);
		this._setEditorChanged();
		this.updateToolbar();
	},
	
	insertTag : function(attr, tagBody) {
		
		var head = this.header();
		//htmlMetaConsole.dumpObject(currentTag);
		if (htmlHeader.currentTag.nodeType == COMMENT_NODE) {
			var newTag = document.createComment(htmlHeader.tagBody);
			if (tagBody) 
				newTag.nodeValue = tagBody;
		} else {
			var newTag = document.createElement(htmlHeader.currentTag.tagName.toLowerCase());
			
			for (e in attr) {
//				p(e);
				newTag.setAttribute(e, attr[e]);
			}
			
			if (tagBody) 
				newTag.appendChild(document.createTextNode(tagBody));
		}

		// check where we gonna insert the tag
		if (htmlHeader.insertBefore) {
			head.insertBefore(newTag, htmlHeader.insertBefore);
			htmlHeader.insertBefore = null;
		} else if (htmlHeader.insertAfter && htmlHeader.insertAfter.nextSibling) {
			head.insertBefore(newTag, htmlHeader.insertAfter.nextSibling);
			htmlHeader.insertAfter  = null;
		} else {
			head.appendChild(newTag);
		}
		
		this._setEditorChanged();
		
		// check if the tab title has changed
		if(htmlHeader.currentTag.tagName && 
		   htmlHeader.currentTag.tagName.toLowerCase() == "title") {
			ed.setDocumentTitle(tagBody);
		}
		
		// last but not least, update the toolbar
		this.updateToolbar();
		return true;
	},
	
	replaceTag : function(attr, tagBody) {
		var head = this.header();
		//htmlMetaConsole.dumpObject(currentTag);
		if (htmlHeader.currentTag.nodeType == COMMENT_NODE) {
			var newTag = document.createComment(htmlHeader.tagBody);
			if (tagBody) 
				newTag.nodeValue = tagBody;
		} else {
			var newTag = document.createElement(htmlHeader.currentTag.tagName.toLowerCase());
			
			for (e in attr) {
				newTag.setAttribute(e, attr[e]);
			}
			
			if (tagBody) 
				newTag.appendChild(document.createTextNode(tagBody));
		}

		head.replaceChild(newTag, htmlHeader.currentTag);
		this._setEditorChanged();

		var ed = GetCurrentEditor();
		// check if the tab title has changed
		if(htmlHeader.currentTag.tagName && 
		   htmlHeader.currentTag.tagName.toLowerCase() == "title") {
			ed.setDocumentTitle(tagBody);
		}
		
		// last but not least, update the toolbar
		this.updateToolbar();
		return true;
	},
	
	
  // cascades /////////////////////////////////////////////////////////////////
	/**
	 * when cascades is loaded, we need to open the stylesheet at the 
	 * clicked position. this object will open the tree
	 */
	cascadesLoadHandler: {
		handleEvent : function(Ev) {
			if (htmlHeader.cascadesInitialized)
				return;
			
			// stop any other focus event on this window
			htmlHeader.cascadesInitialized = true;
			
			var absoluteCount = 0; // abs position
			var selectedStylePos = 0; // pos of style/link tags
			var traveler = htmlHeader.currentTag; // temporary object 
			
			// where did we come from ?
			var w = Ev.target;
			
			// find pos of the style tag, we use the html element object 
			// in the header and travel back to the first element in the 
			// head tag. on the way there, whenever we hit a style tag or
			// a link href="blah" we increment the conuter. this should 
			// give us the position # inside cascade's stylesheets tree 
			// we would have to open.
			if(traveler.previousSibling) {
				selectedStylePos = -1;
				totalCount = 0;
			}
			while(traveler.previousSibling) {
				absoluteCount++;
				if (traveler.tagName && 
				    (traveler.tagName.toLowerCase() == "style" || 
				     traveler.tagName.toLowerCase() == "link" && 
				     traveler.getAttribute("href")))
					selectedStylePos++;
				traveler = traveler.previousSibling;
			} // we love[tm] the dom, don't we?
			
			// open style sheet at the clicked position. the tree's view object
			// seems to give us access to dynamic treeitem's children. 
			var view = w.getElementById("sheetsTree").view;
			var treeitem = view.getItemAtIndex(selectedStylePos);
			treeitem.setAttribute("open", true);
			// view.cycleCell(absoluteCount ,0);
			// stop forther focus events of reinitialization!
			return true;
/*
			var view = w.getElementById("sheetsTree").view;
			var styleCounter = 0;
			
			// loop over all entries in the tree and count internal stylesheets
			// close all but our selected stylesheet
			for(var i=0; i<view.rowCount; i++) {
				var treeitem = view.getItemAtIndex(i);
				var treecell = treeitem.firstChild.firstChild;
				var label    = treecell.getAttribute("label");
				//p(treeitem.tagName);
				
				if (label == CASCADES_STYLE_LABEL) {
					window.p("stylesheet at pos: " + i);
					if (i == selectedStylePos) {
						treeitem.setAttribute("open", true);
						window.p("open at: " + i);
					} else {
						window.p("close at: " + i);
						treeitem.setAttribute("open", false);
					}
					styleCounter++;
				} else {
					//window.p("closing at: " + i);
					treeitem.setAttribute("open", false);
					window.p("no style at: " + i);
				}
			} // end for */
		}
	},
	
	openCssEd: function(e) {
	
		if (e.target && e.target.associatedElement)
			htmlHeader.currentTag = e.target.associatedElement;
			
		var cascadesUrl = "chrome://cascades/content/EdCssProps.xul";
		this.cascades = window.openDialog(cascadesUrl, '_blank', '');
		//d(this.cascades.getElementById("sheetsTree").view);
		//d(this.cascades); //.contentDocument.getElementById("sheetsTree"));
		
		// attach an event listener to the cascades window to initialize it.
		// we will open the selected style sheet's treechildren. this event 
		// handler should be called once the cascades window  is fully 
		// initialized.
		//
		// FIXME: this is "il grande hack". the attached method will open
		// the selected stylesheet tree. when attached to (on)load of the 
		// cascades window this is why i attached it on focus. we make 
		// sure (however) that it is executed only one after the window
		// creation. this is controlled with htmlHeader.cascadesInitialized
		htmlHeader.cascadesInitialized = false;
		this.cascades.addEventListener("focus", 
		                               htmlHeader.cascadesLoadHandler, false);
	},
	
  // preferences //////////////////////////////////////////////////////////////

	setPrefValue : function(aPrefString, aPrefType, aValue) {
		var nsISupportsString = Components.interfaces.nsISupportsString;
		var xpPref = htmlHeader.prefService;

		var prefType = xpPref.getPrefType(aPrefString);

		try {
			switch(aPrefType) {
				case "wstr":
					var string = Components.classes['@mozilla.org/supports-string;1']
					               .createInstance(nsISupportsString);
					string.data = aValue;
					return xpPref.setComplexValue(aPrefString, nsISupportsString, string);
					break;
				case "str":
					return xpPref.setCharPref(aPrefString, aValue);
					break;
				case "int":
					aValue = parseInt(aValue);
					return xpPref.setIntPref(aPrefString, aValue);
					break;
				case "bool":
				default:
					if(typeof(aValue) == "string") {
						aValue = (aValue == "true");
					}
					return xpPref.setBoolPref(aPrefString, aValue);
					break;
			}
		} catch(e) {
		}
		return null;
	},

	getPrefValue : function(aPrefString, aPrefType, aDefault) {
		var nsISupportsString = Components.interfaces.nsISupportsString;
		var xpPref = htmlHeader.prefService;

		if(xpPref.getPrefType(aPrefString) == xpPref.PREF_INVALID) {
			return aDefault;
		}
		try {
			switch (aPrefType) {
				case "wstr":
					return xpPref.getComplexValue(aPrefString, nsISupportsString).data;
					break;
				case "str":
					return xpPref.getCharPref(aPrefString).toString();
					break;
				case "int":
					return xpPref.getIntPref(aPrefString);
					break;
				case "bool":
				default:
					return xpPref.getBoolPref(aPrefString);
					break;
			}
		} catch(e) {
		}
		return aDefault;
	},

	clearPref: function(aPrefString) {
		var xpPref = htmlHeader.prefService;

		try {
			xpPref.clearUserPref(aPrefString);
			return true;
		} catch(e) {
			return false;
		}
	},
	
};
