
/*
 * Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 * Copyright (C) 2005 Sourcefire,Inc.
 */

#include <sys/types.h>
#include <stdlib.h>
#include <ctype.h>

#include "str_search.h"
#include "acsmx.h"

typedef struct tag_search
{
	ACSM_STRUCT *acsm;
	unsigned int max_len;
} t_search;

static t_search *_acsm = NULL;
static unsigned int  _num_acsm;

int SearchInit(unsigned int num)
{
	unsigned int i;

	_num_acsm = num;

	_acsm = (t_search *)malloc(sizeof(t_search) * num);
	if ( _acsm == NULL )
		return -1;

	for ( i = 0; i < num; i++ )
		{
			_acsm[i].acsm = acsmNew();			
			if ( !_acsm[i].acsm )
				return -1;
			acsmCompile(_acsm[i].acsm);
			_acsm[i].max_len = 0;
		}
	return 0;
}

int SearchReInit(unsigned int i)
{
	if ( _acsm[i].acsm != NULL )
		acsmFree(_acsm[i].acsm);
	_acsm[i].acsm = acsmNew();
	_acsm[i].max_len = 0;
    
	if ( !_acsm[i].acsm )
		return -1;

	return 0;
}


void SearchFree()
{
	unsigned int i;

	if ( _acsm != NULL )
		{
			for ( i = 0; i < _num_acsm; i++ )
				{
					if ( _acsm[i].acsm != NULL )
						acsmFree(_acsm[i].acsm);
				}
			free(_acsm);
		}
}


/*  
    Do efficient search of data 
    @param   acsm_id    specify which engine to use to search
    @param   str        string to search
    @param   str_len    length of string to search
    @param   Match      function callback when string match found
*/
int SearchFindString(unsigned int acsm_id, unsigned char *str, unsigned int str_len, 
		     int (*Match) (void *, int, void *), void *ctx)
{

	int num = acsmSearch(_acsm[acsm_id].acsm, str, str_len, Match, ctx);
	return num;
}


void SearchAdd(unsigned int acsm_id, unsigned char *pat, unsigned int pat_len, 
	       int nocase, void* id)
{
	acsmAddPattern(_acsm[acsm_id].acsm, pat, pat_len, nocase, 0, 0, id, 0);
	acsmCompile(_acsm[acsm_id].acsm);
	
	if ( pat_len > _acsm[acsm_id].max_len )
		_acsm[acsm_id].max_len = pat_len;
}


/* API exported by this module */
static SearchAPI _searchAPI =
	{
		SearchInit,
		SearchReInit,
		SearchFree,
		SearchAdd,
		SearchFindString
	};

SearchAPI *searchAPI = &_searchAPI;

