/*$Id: fkHttpHandler.h,v 1.10 2006/08/20 16:39:54 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FKHTTPHANDLER_H
#define FKHTTPHANDLER_H

#include "nsIModule.h"
#include "nsIFactory.h"
#include "nsISupports.h"
#include "nsISupportsUtils.h"

#include "nsIObserver.h"
#include "nsIHttpProtocolHandler.h"
#include "nsIProtocolProxyService.h"

#include "nsIComponentManager.h"
#include "nsIComponentRegistrar.h"

#include "nsIGenericFactory.h"
 
#include "nsWeakReference.h"

#define FK_HTTPHANDLER_CID \
  {0x03183b3c, 0x1d91, 0x4a35,\
    { 0x9a, 0x75, 0x1e, 0x4f, 0x87, 0x44, 0x71, 0x5e}}

#define FK_HTTPSHANDLER_CID \
  {0xe3e26915, 0x4963, 0x42ef,\
    { 0xb0, 0x70, 0x47, 0xe0, 0x8b, 0x55, 0x31, 0x42}}

#define HTTPHANDLER_CONTRACTID  "@mozilla.org/network/protocol;1?name=http"
#define HTTPSHANDLER_CONTRACTID "@mozilla.org/network/protocol;1?name=https"


class fkHttpHandler : public nsIHttpProtocolHandler,
                      public nsIObserver,
                      public nsSupportsWeakReference
{
public:
	NS_DECL_ISUPPORTS
      //NS_DECL_NSISUPPORTSWEAKREFERENCE
	NS_DECL_NSIPROTOCOLHANDLER
	NS_DECL_NSIPROXIEDPROTOCOLHANDLER
	NS_DECL_NSIHTTPPROTOCOLHANDLER
	NS_DECL_NSIOBSERVER
	 
	fkHttpHandler();
	virtual ~fkHttpHandler();
	NS_IMETHODIMP init(nsIHttpProtocolHandler *origHttpHandler);
	
	void enableTracing(PRBool tracingEnabled);
	PRBool isTracingEnabled();
	
 private:
	nsCOMPtr<nsIProtocolHandler> origHandler;
	nsCOMPtr<nsIHttpProtocolHandler> origHttpHandler;
	nsCOMPtr<nsIProxiedProtocolHandler> origProxiedHandler;
	nsCOMPtr<nsIObserver> origObserver;
	bool tracingEnabled;
};

#endif
