/*$Id: firekeeper.js,v 1.11 2006/08/21 09:30:10 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */


function FirekeeperState(initState) {
	this.state = initState;
	
	this.changeState = function(state, msg){
		statusBar = document.getElementById('firekeeper-status');
		statusBar.setAttribute('status', state);
		statusBar.setAttribute('tooltiptext', msg);
		this.state = state;		
	}
}

function firekeeperInit(event)
{	
	getServices();
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService);		
	prefs = prefs.getBranch("extensions.firekeeper.");
	var enabled = prefs.getBoolPref("enabled");
	//debug.msg("setting " + enabled);
	firekeeper.enable(enabled);

	/*
	debug.init();
	firekeeperState = FirekeeperState("loading");

	var FIREKEEPER_CONTRACTID = "@firekeeper.mozdev.org/firekeeper"
	firekeeper  = Components.classes[FIREKEEPER_CONTRACTID];
	
	if (firekeeper == null){
		var errMsg = "Firekeeper load failed: " + 
			"component " + FIREKEEPER_CONTRACTID + 
			" not registered";
		firekeeperState.changeState("error", errMsg);
		throw(errMsg);
	}

	firekeeper = firekeeper.getService(Components.interfaces.fkIFirekeeper);
	if (firekeeper == null){
		var errMsg = "Firekeeper load failed: " +
			"can't obtain fkIFirekeeper interface";
		firekeeperState.changeState("error", errMsg);
		throw(errMsg);
	}
	try{
		debug.msg("what");
		fkRulesLoader = new RulesLoader();
		fkRulesLoader.init();
		fkJudge.init();
		firekeeper.setJudge(fkJudge);
		firekeeperState.changeState("loaded", "Firekeeper is enabled");
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].
			getService(Components.interfaces.nsIPrefService);		
			prefs = prefs.getBranch("extensions.firekeeper.");
		var enabled = prefs.getBoolPref("enabled");
		debug.msg("setting " + enabled);
		firekeeper.enable(enabled);
		
	}catch(e){
		errMsg = "Firekeeper initialization failed " + e;
		firekeeperState.
			changeState("error", errMsg);
		throw(errMsg);
	}
	*/
}


function openViewRulesWindow()
{
	window.open('chrome://firekeeper/content/config.xul', '_blank', 
		    'chrome,dialog=no,resizable,centerscreen');
}

window.addEventListener('load', firekeeperInit, false);

