
const HORIZONTAL = 1;
const LEFT = 2;
const TOP = 4;

var gSlideTime = 50;
var gOpenTime = 4000; // total time the alert should stay up once we are done animating.
var gAlertListener = null;
var gFadeIncrement = .05;
var gOrigin = 0;

function prefillAlertInfo() {
}

function onAlertLoad() {
  // read out our initial settings from prefs.
  try 
  {
    var prefBranch = Components.classes["@mozilla.org/preferences-service;1"]
                       .getService(Components.interfaces.nsIPrefService)
                       .getBranch("eMusic.");
    gSlideTime = prefBranch.getIntPref("alerts.slideIncrementTime");
    gOpenTime = prefBranch.getIntPref("alerts.totalOpenTime");

    if (window.arguments && window.arguments[0]) {
      document.getElementById("alertTitle").value = window.arguments[0]
    }
  } catch (ex) {
    edebug(ex)
  }

  // bogus call to make sure the window is moved offscreen until we are ready for it.
  resizeAlert(true);

  // if we aren't waiting to fetch preview text, then go ahead and 
  // start showing the alert.
  setTimeout(showAlert, 0); // let the JS thread unwind, to give layout 
                            // a chance to recompute the styles and widths for our alert text.
}

// If the user initiated the alert, show it right away, otherwise start opening the alert with
// the fade effect. 
function showAlert() {
  document.getElementById('alertContainer').style.opacity = 0;
  
  // resize the alert based on our current content  
  resizeAlert(false);
  
  setTimeout(fadeOpen, gSlideTime);
}

function resizeAlert(aMoveOffScreen) {
  // sizeToContent is not working. It isn't honoring the max widths we are attaching to our inner
  // objects like the folder summary element. While the folder summary element is cropping, 
  // sizeToContent ends up thinking the window needs to be much wider than it should be. 
  // use resizeTo and make up our measurements...
  //sizeToContent();
  
  var windowWidth = document.getBoxObjectFor(document.getElementById('alertTitle')).width;

  resizeTo(windowWidth + document.getBoxObjectFor(document.getElementById('alertImageBox')).width + 30, 
           document.getBoxObjectFor(document.getElementById('alertBox')).height + 5);                     
  
  // leftover hack to get the window properly hidden when we first open it
  if (aMoveOffScreen)
    window.outerHeight = 1;

  // Determine position and move window
  var x = gOrigin & LEFT ? screen.availLeft :
          (screen.availLeft + screen.availWidth - window.outerWidth);
  var y = gOrigin & TOP ? screen.availTop :
          (screen.availTop + screen.availHeight - window.outerHeight);
  window.moveTo(x, y);
}

function fadeOpen() {
  var alertContainer = document.getElementById('alertContainer');
  var newOpacity = parseFloat(window.getComputedStyle(alertContainer, "").opacity) + gFadeIncrement;
  alertContainer.style.opacity = newOpacity;
  
  if (newOpacity < 1.0) {
    setTimeout(fadeOpen, gSlideTime);
  } else {
    // switch gears and start closing the alert
    setTimeout(fadeClose, gOpenTime);  
  }
}

function fadeClose() {
  var alertContainer = document.getElementById('alertContainer');
  var newOpacity = parseFloat(window.getComputedStyle(alertContainer, "").opacity) - gFadeIncrement;
  alertContainer.style.opacity = newOpacity;
  
  if (newOpacity <= 0) {
    closeAlert();
  } else {
    setTimeout(fadeClose, gSlideTime);
  }
}

function closeAlert() {
  if (gAlertListener) {
    gAlertListener.observe(null, "alertfinished", ""); 
  }
  window.close();
}
