unit ManageUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CheckLst, Inifiles, CommicsUnit, AddEditUnit, Buttons;

type
  TFormManageComics = class(TForm)
    ListBoxComics: TCheckListBox;
    ButtonSave: TButton;
    Label1: TLabel;
    ButtonEditComic: TButton;
    ButtonNewComic: TButton;
    ButtonUp: TBitBtn;
    ButtonDown: TBitBtn;
    ButtonDeleteComic: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure ButtonSaveClick(Sender: TObject);
    procedure ButtonSaveGetClick(Sender: TObject);
    procedure ButtonNewComicClick(Sender: TObject);
    procedure ButtonEditComicClick(Sender: TObject);
    procedure ListBoxComicsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ListBoxComicsDragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure ButtonUpClick(Sender: TObject);
    procedure ButtonDownClick(Sender: TObject);
    procedure ButtonDeleteComicClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormManageComics: TFormManageComics;

implementation

{$R *.dfm}

procedure TFormManageComics.FormClose(Sender: TObject; var Action: TCloseAction);
var picks, allcomicstemp: tstrings;
    ctr: integer;
    checkedlist, allcomics, allcomicstemp2, checkedlisttemp: string;
    ini: TIniFile;
begin
  picks := TStringList.Create;
  for ctr := 0 to (ListBoxComics.Items.Count - 1) do
  begin
    if ListBoxComics.Checked[ctr] then
      picks.Add(ListBoxComics.Items[ctr]);
  end;
  ini := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  checkedlisttemp := picks.DelimitedText;
  allcomicstemp := TStringList.Create;
  allcomicstemp := ListBoxComics.Items;
  allcomicstemp2 := allcomicstemp.DelimitedText;
  for ctr := 1 to length(allcomicstemp2) do
  begin
    if allcomicstemp2[ctr] <> '"' then
      allcomics := allcomics+allcomicstemp2[ctr];
  end;
  for ctr := 1 to length(checkedlisttemp) do
  begin
    if checkedlisttemp[ctr] <> '"' then
      checkedlist := checkedlist+checkedlisttemp[ctr];
  end;
  try
    ini.WriteString('DailyComics','Picked',checkedlist);
    ini.WriteString('DailyComics','All Comics',allcomics);
  finally
    ini.Free;
  end;
  picks.Free;
//  allcomicstemp.Free;    This line of code is throwing an exception for some reason right now
end;

procedure TFormManageComics.FormCreate(Sender: TObject);
var ctr: integer;
    CheckedList, comicname, allcomics: string;
    picks: tstrings;
    ini: TIniFile;
begin
  ListBoxComics.Clear;
  picks := TStringList.create;
  ini := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  checkedList :=  ini.ReadString('DailyComics','Picked','');
  allcomics := ini.ReadString('DailyComics','All Comics','');
  for ctr := 1 to length(checkedList) do
  begin
    if checkedList[ctr] <> ',' then
    begin
      comicname := comicname+checkedList[ctr]
    end else
    begin
      picks.Add(comicname);
      comicname := '';
    end;
  end;
  picks.Add(comicname);
  comicname := '';
  
  for ctr := 1 to length(allcomics) do
  begin
    if allcomics[ctr] <> ',' then
    begin
      comicname := comicname+allcomics[ctr]
    end else
    begin
      ListBoxComics.Items.Add(comicname);
      comicname := '';
    end;
  end;
  ListBoxComics.Items.Add(comicname);


  for ctr := 0 to pred(ListBoxComics.Items.Count) do
  begin
    ListBoxComics.Checked[ctr] := picks.IndexOf(ListBoxComics.Items[ctr])>-1;
  end;
  picks.free;
  ini.Free;
end;

procedure TFormManageComics.ButtonSaveClick(Sender: TObject);
begin
  FormManageComics.Close;
end;

procedure TFormManageComics.ButtonSaveGetClick(Sender: TObject);
begin
  FormManageComics.Close;
  MainForm.ButtonComicsClick(FormManageComics);
end;

procedure TFormManageComics.ButtonNewComicClick(Sender: TObject);
begin
  editing := 0;
  FormAddEdit.ShowModal;
end;

procedure TFormManageComics.ButtonEditComicClick(Sender: TObject);
var idx: integer;
    selectedComic,stringholder: string;
    ini: TIniFile;
begin
  idx := ListBoxComics.ItemIndex;
  try
    selectedComic := ListBoxComics.Items.Strings[idx];
  except
    on EStringListError do
    begin
      MessageDlg('You must select a comic from the list first', mtError, [mbOK], 0);
      exit;
    end;
  end;
  FormAddEdit.EditName.Text := selectedComic;
  ini := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  stringholder := ini.ReadString(selectedComic,'URL','');
  FormAddEdit.EditURL.Text := stringholder;
  stringholder := ini.ReadString(selectedComic,'BegAnch','');
  FormAddEdit.EditBegAnch.Text := stringholder;
  stringholder := ini.ReadString(selectedComic,'EndAnch','');
  FormAddEdit.EditEndAnch.Text := stringholder;
  stringholder := ini.ReadString(selectedComic,'ImgURL','');
  FormAddEdit.EditImgURL.Text := stringholder;
  stringholder := ini.ReadString(selectedComic,'StartPoint','');
  if stringholder <> '' then
  begin
    FormAddEdit.EditStartPoint.Text := stringholder;
  end;
  ini.Free;
  editing := 1;
  FormAddEdit.ShowModal;
end;

//this event handler code allows the user to drag an item in the pick list
procedure TFormManageComics.ListBoxComicsDragOver(Sender, Source: TObject;
  X, Y: Integer; State: TDragState; var Accept: Boolean);
var 
  DropIndex: Integer; 
  TempStr  : String; 
begin 
  with TListBox(Sender) do 
  begin 
    DropIndex := ItemAtPos(Point(X,Y), True); 
    if (DropIndex > -1) and (DropIndex <> ItemIndex) then 
    begin 
      TempStr          := Items[DropIndex]; 
      Items[DropIndex] := Items[ItemIndex];
      Items[ItemIndex] := TempStr;
      ItemIndex        := DropIndex;
     end;
  end;
end;

//once the user is dragging an item in the pick list, this code allows them to drop it
//in the position they want it
procedure TFormManageComics.ListBoxComicsDragDrop(Sender, Source: TObject;
  X, Y: Integer);
var
  DropIndex: Integer;
begin
  DropIndex := TListBox(Sender).ItemAtPos(Point(X,Y),False);
  with TListBox(Source) do
  begin
    TListBox(Sender).Items.Insert(DropIndex, Items[ItemIndex]);
    Items.Delete(ItemIndex);
  end;
end;

procedure TFormManageComics.ButtonUpClick(Sender: TObject);
var NewIndex: integer;
begin
  try
    NewIndex := ListBoxComics.itemindex-1;
    if NewIndex = -1 then
    begin
      MessageDlg('Wo baby!  You''re breaking the rules!  You can''t move the first item higher than it already is!', mtError, [mbOK], 0);
      exit;
    end;
    ListBoxComics.items.move(ListBoxComics.itemindex,NewIndex);
    ListBoxComics.Selected[NewIndex] := true;
  except
    on EStringListError do
      MessageDlg('You must select a comic from the list first', mtError, [mbOK], 0);
  end;
end;

procedure TFormManageComics.ButtonDownClick(Sender: TObject);
var NewIndex,TotalItems: integer;
begin
  try
    TotalItems := listboxcomics.Count;
    NewIndex := ListBoxComics.itemindex+1;
    if NewIndex = TotalItems then
    begin
      MessageDlg('Wo baby!  You''re breaking the rules!  You can''t move the last item lower than it already is!', mtError, [mbOK], 0);
      exit;
    end;
    ListBoxComics.items.move(ListBoxComics.itemindex,NewIndex);
    ListBoxComics.Selected[NewIndex] := true;
  except
    on EStringListError do
      MessageDlg('You must select a comic from the list first', mtError, [mbOK], 0);
  end;
end;

procedure TFormManageComics.ButtonDeleteComicClick(Sender: TObject);
var idx,ctr,startpos,endpos,allcomicslen: integer;
    selectedComic,allcomics,comicname: string;
    ini: TIniFile;
begin
  idx := ListBoxComics.ItemIndex;
  try
    selectedComic := ListBoxComics.Items.Strings[idx];
  except
    on EStringListError do
    begin
      MessageDlg('You must select a comic from the list first', mtError, [mbOK], 0);
      exit;
    end;
  end;
  if MessageDlg('Are you sure you want to delete this comic?'+#13+#10+#13+#10+'   There is no undo if you say yes', mtConfirmation, [mbYes,mbNo], 0) = mrYes then
  begin
    ini := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
    ini.EraseSection(selectedComic);
    allcomics := ini.ReadString('DailyComics','All Comics','');
    //this for loop erases the comic's name from the allcomics list in the ini file
    allcomicslen := length(allcomics);
    endpos := 1;
    for ctr := 1 to allcomicslen+1 do
    begin
      if (allcomics[ctr] <> ',') and (ctr <= allcomicslen) then
      begin
        if allcomics[ctr] = selectedComic[endpos] then
        begin
          endpos := endpos+1;
          comicname := comicname+allcomics[ctr]
        end else
          endpos := 1;
      end else
      begin
        if ctr >= allcomicslen then
        begin
          if endpos > 1 then
          begin
            startpos := ctr-endpos;
            Delete(allcomics,startpos,endpos);
          end; //if endpos > 1 then
          comicname := '';
        end else
        begin
          if endpos > 1 then
          begin
            startpos := ctr-endpos+1;
            Delete(allcomics,startpos,endpos);
          end; //if endpos > 1 then
          comicname := '';
        end;
      end;
    end;
    ini.WriteString('DailyComics','All Comics',allcomics);
    ini.Free;
    FormManageComics.FormCreate(nil);
  end; // if MessageDlg('Are you sure you want to delete
end;

end.
