/*-*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
  Tab Switcher for Chatzilla. Lets you switch tabs using ALT-PgDn and ALT-PgUp. 
  Copyright (C) 2004  David Corry

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

initHandlers();

function initPlugin(glob) {
	plugin.id = "tabswitcher";
	plugin.major = 0;  // Major version number.
	plugin.minor = 1;  // Minor version number.
	plugin.version = plugin.major + "." + plugin.minor;
	plugin.description = "Lets you switch tabs using ALT-PgUp and ALT-PgDn.";
}

function initHandlers()
{
	var node;
	node = document.getElementById("input");
	node.addEventListener("keypress", onInputKeyPress, true);
}

function onInputKeyPress (e)
{
	if ((e.keyCode == 33) && (e.altKey))
	{
		goToNextTab(e);
	}
	else if ((e.keyCode == 34) && (e.altKey))
	{
		goToPrevTab(e);
	}
}
function goToNextTab(e){
	cycleView(1);
	e.stopPropagation()
}
function goToPrevTab(e){
	cycleView(-1);
	e.stopPropagation()
}