/* ****** BEGIN LICENSE BLOCK *****
Version: MPL 1.1/GPL 2.0/LGPL 2.1

The contents of this file are subject to the Mozilla Public License Version 
1.1 (the "License"); you may not use this file except in compliance with 
the License. You may obtain a copy of the License at 
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is Checky.

The Initial Developer of the Original Code is
Joachim Schreiber (yo@yos.biz).
Portions created by the Initial Developer are Copyright (C) 2002
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

The Checky plug-in is a simple Interface for Web Content and 
Web Page Developers to free and commercial Validator and Checker 
Services on the Web. We do not provide any support or guarantee. 
Any rights not expressly granted herein are reserved by their owners. 
Please visit the Web Sites of the Service owners for more informations 
about terms of usage before using Checky the first. Hyperlinks are 
located at http://checky.mozdev.org/services.html.

***** END LICENSE BLOCK ***** */

/*

----------
 Services
----------


serviceId - Service Name
-----------------------------------------------------
0  - W3C HTML MarkUp Validation Service
1  - W3C CSS Validaton Service
2  - W3C RDF Validation Service
3  - W3C Link Checker
4  - W3C HTML TIDY

5  - WDG HTML Validator
6  - WDG CSSCheck (only CSS files no HTML)
7  - WDG Link Valet

8  - WebThing Page Valet

9  - Delorie Lynx Viewer
10 - Delorie Web Page Purifier
11 - Delorie HTTP Header Viewer

12 - Watchfire Bobby

13 - T.a.w

14 - PIAT WAVE 2.01
15 - PIAT WAVE 2.2


16 - Redland RSS 1.0 Validator and Viewer

17 - Mark und Sam RSS Validator

99 - Checky Agent

not yet implemented


18 - STG XML Validation Form (only XML)
19 - Imagiware Doctor HTML Single-Page Analysis
20 - Lynx me


*/

var queryStart = [];
queryStart[0] = "http://validator.w3.org/check?";
queryStart[1] = "http://jigsaw.w3.org/css-validator/validator?";
queryStart[2] = "http://www.w3.org/RDF/Validator/ARPServlet?";
queryStart[3] = "http://validator.w3.org/checklink?"; 
queryStart[4] = "http://cgi.w3.org/cgi-bin/tidy?";
queryStart[5] = "http://www.htmlhelp.com/cgi-bin/validate.cgi?"; 
queryStart[6] = "http://www.htmlhelp.com/cgi-bin/csscheck.cgi?"; 
queryStart[7] = "http://www.htmlhelp.com/tools/valet/linktest.cgi?"; 
queryStart[8] = "http://valet.webthing.com/page/v3.1?"; 
queryStart[9] = "http://www.delorie.com/web/lynxview.cgi?"; 
queryStart[10] = "http://www.delorie.com/web/purify.cgi?"; 
queryStart[11] = "http://www.delorie.com/web/headers.cgi?"; 
queryStart[12] = "http://bobby.watchfire.com/bobby/bobbyServlet?"; 
queryStart[13] = "http://www.tawdis.net/servlets/taw?"; 
queryStart[14] = "http://pa-at-loan.org/cgi-bin/wave/wave.pl?"; 
queryStart[15] = "http://pa-at-loan.org/cgi-bin/ywave/wave.pl?"; 
queryStart[16] = "http://www.redland.opensource.ac.uk/rss?"; 
queryStart[17] = "http://feeds.archive.org/validator/check?"; 




var prefService = Components.classes["@mozilla.org/preferences-service;1"]
	                           .getService(Components.interfaces.nsIPrefService);
var pref = prefService.getBranch(null); // preferences root node



function checkyServiceDo(browserUri, serviceId){

	switch(serviceId){
		case 0 :
			checkyQuery_0(browserUri)
			break;
		case 1 :
			checkyQuery_1(browserUri)
			break;
		case 2 :
			checkyQuery_2(browserUri)
			break;
		case 3 :
			checkyQuery_3(browserUri)
			break;
		case 4 :
			checkyQuery_4(browserUri)
			break;
		case 5 :
			checkyQuery_5(browserUri)
			break;
		case 6 :
			checkyQuery_6(browserUri)
			break;
		case 7 :
			checkyQuery_7(browserUri)
			break;
		case 8 :
			checkyQuery_8(browserUri)
			break;
		case 9 :
			checkyQuery_9(browserUri)
			break;
		case 10 :
			checkyQuery_10(browserUri)
			break;
		case 11 :
			checkyQuery_11(browserUri)
			break;
		case 12 :
			checkyQuery_12(browserUri)
			break;
		case 13 :
			checkyQuery_13(browserUri)
			break;
		case 14 :
			checkyQuery_14(browserUri)
			break;
		case 15 :
			checkyQuery_15(browserUri)
			break;
		case 16 :
			checkyQuery_16(browserUri)
			break;
		case 17 :
			checkyQuery_17(browserUri)
			break;
		case 99 :
			checkyAgent(browserUri)
			break;
	}
}

function checkySubmitQuery(uri){

	var appearType =  pref.getIntPref("checky.global.appearType");
	
	var serviceUri = checkyPrepareUri(uri);
	
	switch(appearType){
		case 0 :
			getBrowser().addTab(serviceUri);
			break;
		
		case 1 :
			var checkyWindow;
			checkyWindow = window.open(serviceUri, "checkyWin");
			break;
		}	

}


function checkyPrepareUri(uri){
	var prepUri = encodeURI(uri);
	return prepUri;
}


function checkyAgent(uri){

	var isSet = false;
	
	var Pref0 = pref.getBoolPref("checky.agent.w3c.markup");
	var Pref1 = pref.getBoolPref("checky.agent.w3c.css");
	var Pref2 = pref.getBoolPref("checky.agent.w3c.rdf");
	var Pref3 = pref.getBoolPref("checky.agent.w3c.link");
	var Pref4 = pref.getBoolPref("checky.agent.w3c.tidy");
	var Pref5 = pref.getBoolPref("checky.agent.wdg.html");
	var Pref6 = pref.getBoolPref("checky.agent.wdg.css");
	var Pref7 = pref.getBoolPref("checky.agent.wdg.link");
	var Pref8 = pref.getBoolPref("checky.agent.thing.page");
	var Pref9 = pref.getBoolPref("checky.agent.del.lynx");
	var Pref10 = pref.getBoolPref("checky.agent.del.pur");
	var Pref11 = pref.getBoolPref("checky.agent.del.header");
	var Pref12 = pref.getBoolPref("checky.agent.bobby");
	var Pref13 = pref.getBoolPref("checky.agent.taw");
	var Pref14 = pref.getBoolPref("checky.agent.piat2");
	var Pref15 = pref.getBoolPref("checky.agent.piat22");
	var Pref16 = pref.getBoolPref("checky.agent.red");
	var Pref17 = pref.getBoolPref("checky.agent.mark");
	
	if(Pref0){
		checkyQuery_0(uri);
		isSet = true;
	}
	if(Pref1){
		checkyQuery_1(uri);
		isSet = true;
	}
	if(Pref2){
		checkyQuery_2(uri);
		isSet = true;
	}
	if(Pref3){
		checkyQuery_3(uri);
		isSet = true;
	}
	if(Pref4){
		checkyQuery_4(uri);
		isSet = true;
	}
	if(Pref5){
		checkyQuery_5(uri);
		isSet = true;
	}
	if(Pref6){
		checkyQuery_6(uri);
		isSet = true;
	}
	if(Pref7){
		checkyQuery_7(uri);
		isSet = true;
	}
	if(Pref8){
		checkyQuery_8(uri);
		isSet = true;
	}
	if(Pref9){
		checkyQuery_9(uri);
		isSet = true;
	}
	if(Pref10){
		checkyQuery_10(uri);
		isSet = true;
	}
	if(Pref11){
		checkyQuery_11(uri);
		isSet = true;
	}
	if(Pref12){
		checkyQuery_12(uri);
		isSet = true;
	}
	if(Pref13){
		checkyQuery_13(uri);
		isSet = true;
	}
	if(Pref14){
		checkyQuery_14(uri);
		isSet = true;
	}
	if(Pref15){
		checkyQuery_15(uri);
		isSet = true;
	}
	if(Pref16){
		checkyQuery_16(uri);
		isSet = true;
	}
	if(Pref17){
		checkyQuery_17(uri);
		isSet = true;
	}

	if(!isSet){
		var checkyBundle = document.getElementById("bundle_checky");
		alert(checkyBundle.getString("agentMsg"));
	}

}



function checkyQuery_0(uri){

	var charsetList = [];
	charsetList[0] = "(detect automatically)";
	charsetList[1] = "utf-8 (Unicode, worldwide)";
	charsetList[2] = "utf-16 (Unicode, worldwide)";
	charsetList[3] = "iso-8859-1 (Western Europe)";
	charsetList[4] = "iso-8859-2 (Central Europe)";
	charsetList[5] = "iso-8859-3 (Southern Europe)";
	charsetList[6] = "iso-8859-4 (Baltic Rim)";
	charsetList[7] = "iso-8859-5 (Cyrillic)";
	charsetList[8] = "iso-8859-6-i (Arabic)";
	charsetList[9] = "iso-8859-7 (Greek)";
	charsetList[10] = "iso-8859-8-i (Hebrew)";
	charsetList[11] = "iso-8859-9 (Turkish)";
	charsetList[12] = "iso-8859-10 (Latin 6)";
	charsetList[13] = "iso-8859-13 (Latin 7)";
	charsetList[14] = "iso-8859-14 (Celtic)";
	charsetList[15] = "iso-8859-15 (Latin 9)";
	charsetList[16] = "us-ascii (basic English)";
	charsetList[17] = "euc-jp (Japanese, Unix)";
	charsetList[18] = "shift_jis (Japanese, Win/Mac)";
	charsetList[19] = "iso-2022-jp (Japanese, email)";
	charsetList[20] = "euc-kr (Korean)";
	charsetList[21] = "gb2312 (Chinese, simplified)";
	charsetList[22] = "gb18030 (Chinese, simplified)";
	charsetList[23] = "big5 (Chinese, traditional)";
	charsetList[24] = "tis-620 (Thai)";
	charsetList[25] = "koi8-r (Russian)";
	charsetList[26] = "koi8-u (Ukrainian)";
	charsetList[27] = "macintosh (MacRoman)";
	charsetList[28] = "windows-1250 (Central Europe)";
	charsetList[29] = "windows-1251 (Cyrillic)";
	charsetList[30] = "windows-1252 (Western Europe)";
	charsetList[31] = "windows-1253 (Greek)";
	charsetList[32] = "windows-1254 (Turkish)";
	charsetList[33] = "windows-1255 (Hebrew)";
	charsetList[34] = "windows-1256 (Arabic)";
	charsetList[35] = "windows-1257 (Baltic Rim)";
	
	
	var doctypeList = [];
	doctypeList[0] = "(detect automatically)";
	doctypeList[1] = "XHTML 1.1";
	doctypeList[2] = "XHTML Basic 1.0";
	doctypeList[3] = "XHTML 1.0 Strict";
	doctypeList[4] = "XHTML 1.0 Transitional";
	doctypeList[5] = "XHTML 1.0 Frameset";
	doctypeList[6] = "HTML 4.01 Strict";
	doctypeList[7] = "HTML 4.01 Transitional";
	doctypeList[8] = "HTML 4.01 Frameset";
	doctypeList[9] = "HTML 3.2";
	doctypeList[10] = "HTML 2.0";
	
	
	var charset = "";
	var doctype = ""; 
	var ss = "";
	var sp = "";
	var outline = "";
	var noatt = "";
	var No200 = "";
	var verbose = "";
	
	var charsetPref = pref.getIntPref("checky.w3c.markup.charset");
	var doctypePref = pref.getIntPref("checky.w3c.markup.doctype"); 
	var ssPref = pref.getBoolPref("checky.w3c.markup.ss");
	var spPref = pref.getBoolPref("checky.w3c.markup.sp");
	var outlinePref = pref.getBoolPref("checky.w3c.markup.outline");
	var noattPref = pref.getBoolPref("checky.w3c.markup.noatt");
	var No200Pref = pref.getBoolPref("checky.w3c.markup.No200");
	var verbosePref = pref.getBoolPref("checky.w3c.markup.verbose");
	
	
	var queryString = queryStart[0] 
		+ "uri=" + uri
		+ "&charset=" + charsetList[charsetPref] 
		+ "&doctype=" + doctypeList[doctypePref];
	
	if(ssPref)
		queryString = queryString + "&ss=1";
	
	if(spPref)
		queryString = queryString + "&sp=1";
	
	if(outlinePref)
		queryString = queryString + "&outline=1";
	
	if(noattPref)
		queryString = queryString + "&noatt=1";
	
	if(No200Pref)
		queryString = queryString + "&No200=1";
	
	if(verbosePref)
		queryString = queryString + "&verbose=1";
	
	
	checkySubmitQuery(queryString);

}


function checkyQuery_1(uri){

	var warningList = [];
	warningList[0] = "2";
	warningList[1] = "1";
	warningList[2] = "0";
	warningList[3] = "no";

	var profileList = [];
	profileList[0] = "none";
	profileList[1] = "css1";
	profileList[2] = "css2";
	profileList[3] = "mobile";


	var warningPref = pref.getIntPref("checky.w3c.css.warning");
	var profilePref = pref.getIntPref("checky.w3c.css.profile");

	var queryString = queryStart[1] 
		+ "uri=" + uri
		+ "&warning=" + warningList[warningPref] 
		+ "&profile=" + profileList[profilePref];

	checkySubmitQuery(queryString);

}

function checkyQuery_2(uri){

	var TRIPLES_AND_GRAPHList = [];
	TRIPLES_AND_GRAPHList[0] = "PRINT_BOTH";
	TRIPLES_AND_GRAPHList[1] = "PRINT_TRIPLES";
	TRIPLES_AND_GRAPHList[2] = "PRINT_GRAPH";

	var NODE_COLORList = [];
	NODE_COLORList[0] = "Black";
	NODE_COLORList[1] = "Blue";
	NODE_COLORList[2] = "Darkgreen";
	NODE_COLORList[3] = "Red";

	var NODE_TEXT_COLORList = [];
	NODE_TEXT_COLORList[0] = "Blue";
	NODE_TEXT_COLORList[1] = "Black";
	NODE_TEXT_COLORList[2] = "Darkgreen";
	NODE_TEXT_COLORList[3] = "Red";

	var EDGE_COLORList = [];
	EDGE_COLORList[0] = "Darkgreen";
	EDGE_COLORList[1] = "Black";
	EDGE_COLORList[2] = "Blue";
	EDGE_COLORList[3] = "Red";

	var EDGE_TEXT_COLORList = [];
	EDGE_TEXT_COLORList[0] = "Red";
	EDGE_TEXT_COLORList[1] = "Black";
	EDGE_TEXT_COLORList[2] = "Blue";
	EDGE_TEXT_COLORList[3] = "Darkgreen";

	var FONT_SIZEList = [];
	FONT_SIZEList[0] = "10";
	FONT_SIZEList[1] = "12";
	FONT_SIZEList[2] = "14";
	FONT_SIZEList[3] = "16";
	FONT_SIZEList[4] = "20";

	var ORIENTATIONList = [];
	ORIENTATIONList[0] = "LR";
	ORIENTATIONList[1] = "TB";

	var FORMATList = [];
	FORMATList[0] = "PNG_EMBED";
	FORMATList[1] = "PNG_LINK";
	FORMATList[2] = "GIF_EMBED";
	FORMATList[3] = "GIF_LINK";
	FORMATList[4] = "SVG_LINK";
	FORMATList[5] = "PS_LINK";
	FORMATList[6] = "HP_PCL_LINK";
	FORMATList[7] = "HP_GL_LINK";

	var TRIPLES_AND_GRAPHPref = pref.getIntPref("checky.w3c.rdf.TRIPLES_AND_GRAPH");
	var NODE_COLORPref = pref.getIntPref("checky.w3c.rdf.NODE_COLOR"); 
	var NODE_TEXT_COLORPref = pref.getIntPref("checky.w3c.rdf.NODE_TEXT_COLOR");
	var EDGE_COLORPref = pref.getIntPref("checky.w3c.rdf.EDGE_COLOR");
	var EDGE_TEXT_COLORPref = pref.getIntPref("checky.w3c.rdf.EDGE_TEXT_COLOR");
	var FONT_SIZEPref = pref.getIntPref("checky.w3c.rdf.FONT_SIZE");
	var ORIENTATIONPref = pref.getIntPref("checky.w3c.rdf.ORIENTATION");
	var FORMATPref = pref.getIntPref("checky.w3c.rdf.FORMAT");

	var SAVE_DOT_FILEPref = pref.getBoolPref("checky.w3c.rdf.SAVE_DOT_FILE");
	var NTRIPLESPref = pref.getBoolPref("checky.w3c.rdf.NTRIPLES");
	var EMBEDDED_RDFPref = pref.getBoolPref("checky.w3c.rdf.EMBEDDED_RDF");
	var SAVE_RDFPref = pref.getBoolPref("checky.w3c.rdf.SAVE_RDF");
	var ANON_NODES_EMPTYPref = pref.getBoolPref("checky.w3c.rdf.ANON_NODES_EMPTY");

	var queryString = queryStart[2] 
		+ "URI=" + uri
		+ "&TRIPLES_AND_GRAPH=" + TRIPLES_AND_GRAPHList[TRIPLES_AND_GRAPHPref] 
		+ "&NODE_COLOR=" + NODE_COLORList[NODE_COLORPref] 
		+ "&NODE_TEXT_COLOR=" + NODE_TEXT_COLORList[NODE_TEXT_COLORPref] 
		+ "&EDGE_COLOR=" + EDGE_COLORList[EDGE_COLORPref] 
		+ "&EDGE_TEXT_COLOR=" + EDGE_TEXT_COLORList[EDGE_TEXT_COLORPref] 
		+ "&FONT_SIZE=" + FONT_SIZEList[FONT_SIZEPref] 
		+ "&ORIENTATION=" + ORIENTATIONList[ORIENTATIONPref] 
		+ "&FORMAT=" + FORMATList[FORMATPref];
	
	if(SAVE_DOT_FILEPref)
		queryString = queryString + "&SAVE_DOT_FILE=1";

	if(NTRIPLESPref)
		queryString = queryString + "&NTRIPLES=1";

	if(EMBEDDED_RDFPref)
		queryString = queryString + "&EMBEDDED_RDF=1";

	if(SAVE_RDFPref)
		queryString = queryString + "&SAVE_RDF=1";

	if(ANON_NODES_EMPTYPref)
		queryString = queryString + "&ANON_NODES_EMPTY=1";

	checkySubmitQuery(queryString);

}


function checkyQuery_3(uri){

	var hide_typeList = [];
	hide_typeList[0] = "all";
	hide_typeList[1] = "dir";

	var hide_typePref = pref.getIntPref("checky.w3c.link.hide_type");

	var depthPref = pref.getCharPref("checky.w3c.link.depth");

	var summaryPref = pref.getBoolPref("checky.w3c.link.summary");
	var hide_redirectsPref = pref.getBoolPref("checky.w3c.link.hide_redirects");
	var no_accept_languagePref = pref.getBoolPref("checky.w3c.link.no_accept_language");
	var recursivePref = pref.getBoolPref("checky.w3c.link.recursive");
	var cookiePref = pref.getBoolPref("checky.w3c.link.cookie");

	var queryString = queryStart[3] 
		+ "uri=" + uri
		+ "&hide_type=" + hide_typeList[hide_typePref]
		+ "&depth=" + depthPref; 
	
	if(summaryPref)
		queryString = queryString + "&summary=on";

	if(hide_redirectsPref)
		queryString = queryString + "&hide_redirects=on";

	if(no_accept_languagePref)
		queryString = queryString + "&no_accept_language=on";

	if(recursivePref)
		queryString = queryString + "&recursive=on";

	if(cookiePref)
		queryString = queryString + "&cookiePref=set";

	checkySubmitQuery(queryString);

}


function checkyQuery_4(uri){

	var indentPref = pref.getBoolPref("checky.w3c.tidy.indent");

	var queryString = queryStart[4] 
		+ "docAddr=" + uri;
	
	if(indentPref)
		queryString = queryString + "&indent=1";

	checkySubmitQuery(queryString);

}



function checkyQuery_5(uri){

	var warningsPref = pref.getBoolPref("checky.wdg.html.warnings");
	var inputPref = pref.getBoolPref("checky.wdg.html.input");
	var spiderPref = pref.getBoolPref("checky.wdg.html.spider");
	var hidevalidPref = pref.getBoolPref("checky.wdg.html.hidevalid");

	var queryString = queryStart[5] 
		+ "url=" + uri;
	
	if(warningsPref)
		queryString = queryString + "&warnings=yes";

	if(inputPref)
		queryString = queryString + "&input=yes";

	if(spiderPref)
		queryString = queryString + "&spider=yes";

	if(hidevalidPref)
		queryString = queryString + "&hidevalid=yes";

	checkySubmitQuery(queryString);

}


function checkyQuery_6(uri){

	var warningsPref = pref.getBoolPref("checky.wdg.css.warnings");
	var inputPref = pref.getBoolPref("checky.wdg.css.input");

	var queryString = queryStart[6] 
		+ "url=" + uri;
	
	if(warningsPref)
		queryString = queryString + "&warnings=yes";

	if(inputPref)
		queryString = queryString + "&input=yes";


	checkySubmitQuery(queryString);

}



function checkyQuery_7(uri){

	var typeList = [];
	typeList[0] = "Full";
	typeList[1] = "Brief";

	var datePref = pref.getCharPref("checky.wdg.link.date");
	var typePref = pref.getIntPref("checky.wdg.link.type");

	var queryString = queryStart[7] 
		+ "url=" + uri 
		+ "&date=" + datePref 
		+ "&type=" + typeList[typePref];
	
	checkySubmitQuery(queryString);

}


function checkyQuery_8(uri){

	var wcagList = [];
	wcagList[0] = "0";
	wcagList[1] = "1";
	wcagList[2] = "2";
	wcagList[3] = "3";
	wcagList[4] = "508";


	var fmtList = [];
	fmtList[0] = "HTML";
	fmtList[1] = "XML";
	fmtList[2] = "WYSIWYG";

	var xslList = [];
	xslList[0] = "wcag";
	xslList[1] = "wcag2";
	xslList[2] = "earl";

	var parseList = [];
	parseList[0] = "SGML";
	parseList[1] = "XML";
	parseList[2] = "W3C";
	parseList[3] = "HTML";

	var wcagPref = pref.getIntPref("checky.thing.page.wcag");
	var fmtPref = pref.getIntPref("checky.thing.page.fmt");
	var xslPref = pref.getIntPref("checky.thing.page.xsl");
	var parsePref = pref.getIntPref("checky.thing.page.parse");

	var realQuery = "";
	
	if(fmtPref == 2){
		realQuery = "http://valet.webthing.com//page/jim.html?";
	}
	else{
		realQuery = queryStart[8];
	}


	var queryString = realQuery 
		+ "url=" + uri 
		+ "&wcag=" + wcagList[wcagPref]
		+ "&fmt=" + fmtList[fmtPref]
		+ "&xsl=" + xslList[xslPref]
		+ "&parse=" + parseList[parsePref];
	
	checkySubmitQuery(queryString);

}


function checkyQuery_9(uri){

	var queryString = queryStart[9] 
		+ "url=" + uri;
	
	checkySubmitQuery(queryString);

}


function checkyQuery_10(uri){

	var purityList = [];
	purityList[0] = "html20";
	purityList[1] = "html20t";
	purityList[2] = "html32";
	purityList[3] = "html40l";
	purityList[4] = "html40s";
	purityList[5] = "webtv11";

	var purityPref = pref.getIntPref("checky.del.pur.purity");
	var textPref = pref.getBoolPref("checky.del.pur.text");

	var queryString = queryStart[10] 
		+ "url=" + uri 
		+ "&purity=" + purityList[purityPref];

	if(textPref)
		queryString = queryString + "&text=y";
	
	checkySubmitQuery(queryString);

}


function checkyQuery_11(uri){

	var queryString = queryStart[11] 
		+ "url=" + uri;
	
	checkySubmitQuery(queryString);

}


function checkyQuery_12(uri){

	var glList = [];
	glList[0] = "wcag1-a";
	glList[1] = "wcag1-aa";
	glList[2] = "wcag1-aaa";
	glList[3] = "sec508";

	var stealthList = [];
	stealthList[0] = "Bobby/3.3";
	stealthList[1] = "Mozilla/6.0 [en] (WinNT; I)";
	stealthList[2] = "Mozilla/4.7 [en] (WinNT; I)";
	stealthList[3] = "Mozilla/4.02 [en] (WinNT; I)";
	stealthList[4] = "Mozilla/3.0 (Win95; I)";
	stealthList[5] = "Mozilla/2.0 (Win95; I)";
	stealthList[6] = "Mozilla/1.1N (Windows; I; 16bit)";
	stealthList[7] = "Mozilla/4.0 (compatible; MSIE 5.0; Windows 98)";
	stealthList[8] = "Mozilla/4.0 (compatible; MSIE 4.01; Windows NT)";
	stealthList[9] = "Mozilla/2.0 (compatible; MSIE 3.0; Windows 95)";
	stealthList[10] = "Mozilla/1.22 (compatible: MSIE 2.0; Windows 95)";
	stealthList[11] = "Mozilla/4.73 (Windows 98; U) Opera 4.01 [en]";
	stealthList[12] = "Lynx/2.71f libwww-FM/2.14";
	stealthList[13] = "Lynx/2.6 libwww-FM/2.14";
	stealthList[14] = "Lynx/2.5 libwww-FM/2.14";
	stealthList[15] = "Mozilla/2.0 (compatible; AOL 3.0; Windows 95)";
	stealthList[16] = "aolbrowser/1.1 InterCon-Web-Library/1.2 (Macintosh; 68K)";
	stealthList[17] = "IWENG/1.2.003";
	stealthList[18] = "Mozilla/3.0 WebTV/2.5 (Compatible; MSIE 2.0)";
	stealthList[19] = "Mozilla/3.0 WebTV/1.2 (compatible; MSIE 2.0)";

	var glPref = pref.getIntPref("checky.bobby.gl");
	var stealthPref = pref.getIntPref("checky.bobby.stealth");

	var textPref = pref.getBoolPref("checky.bobby.text");
	var linePref = pref.getBoolPref("checky.bobby.line");
	var an_errsPref = pref.getBoolPref("checky.bobby.an_errs");

	var queryString = queryStart[12] 
		+ "advanced=true&url=" + uri 
		+ "&gl=" + glList[glPref]
		+ "&stealth=" + stealthList[stealthPref];

	if(textPref)
		queryString = queryString + "&Text=text";
	
	if(linePref)
		queryString = queryString + "&line=line";

	if(an_errsPref)
		queryString = queryString + "&an_errs=an_errs";

	checkySubmitQuery(queryString);

}



function checkyQuery_13(uri){

	var tipoList = [];
	tipoList[0] = "1";
	tipoList[1] = "2";
	tipoList[2] = "3";


	var tipoPref = pref.getIntPref("checky.taw.tipo");
	var iPref = pref.getBoolPref("checky.taw.i");


	var queryString = queryStart[13] 
		+ "url=" + uri 
		+ "&tipo=" + tipoList[tipoPref];

	if(iPref)
		queryString = queryString + "&i=1";
	

	checkySubmitQuery(queryString);

}




function checkyQuery_14(uri){

	var usestylePref = pref.getBoolPref("checky.piat2.usestyle");
	var is_noframesPref = pref.getBoolPref("checky.piat2.is_noframes");


	var queryString = queryStart[14] 
		+ "uri=" + uri;

	if(usestylePref)
		queryString = queryString + "&usestyle=yes";
	
	if(is_noframesPref)
		queryString = queryString + "&is_noframes=yes";

	checkySubmitQuery(queryString);

}



function checkyQuery_15(uri){

	var usestylePref = pref.getBoolPref("checky.piat22.usestyle");
	var is_noframesPref = pref.getBoolPref("checky.piat22.is_noframes");


	var queryString = queryStart[15] 
		+ "uri=" + uri;

	if(usestylePref)
		queryString = queryString + "&usestyle=yes";
	
	if(is_noframesPref)
		queryString = queryString + "&is_noframes=yes";

	checkySubmitQuery(queryString);

}


function checkyQuery_16(uri){

	var boxList = [];
	boxList[0] = "yes";
	boxList[1] = "no";

	var boxPref = pref.getIntPref("checky.red.box");

	var queryString = queryStart[16] 
		+ "uri=" + uri
		+ "&box=" + boxList[boxPref];

	checkySubmitQuery(queryString);

}

function checkyQuery_17(uri){

	var queryString = queryStart[17] 
		+ "url=" + uri;
	
	checkySubmitQuery(queryString);

}

