/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import sun.awt.im.CompositionArea;
import sun.awt.im.InputMethodContext;

class CompositionAreaHandler
implements InputMethodListener,
InputMethodRequests {
    private static CompositionArea compositionArea;
    private static CompositionAreaHandler compositionAreaOwner;
    private AttributedCharacterIterator composedText;
    private TextHitInfo caret = null;
    private Component clientComponent = null;
    private InputMethodContext inputMethodContext;
    private static final AttributedCharacterIterator.Attribute[] IM_ATTRIBUTES;
    private static final AttributedCharacterIterator EMPTY_TEXT;
    static /* synthetic */ Class class$sun$awt$im$CompositionAreaHandler;

    CompositionAreaHandler(InputMethodContext inputMethodContext) {
        Class clazz = class$sun$awt$im$CompositionAreaHandler == null ? (class$sun$awt$im$CompositionAreaHandler = CompositionAreaHandler.class$("sun.awt.im.CompositionAreaHandler")) : class$sun$awt$im$CompositionAreaHandler;
        synchronized (clazz) {
            if (compositionArea == null) {
                compositionArea = new CompositionArea();
            }
        }
        this.inputMethodContext = inputMethodContext;
    }

    void setClientComponent(Component component) {
        this.clientComponent = component;
    }

    void grabCompositionArea(boolean bl) {
        CompositionArea compositionArea = CompositionAreaHandler.compositionArea;
        synchronized (compositionArea) {
            if (compositionAreaOwner != this) {
                compositionAreaOwner = this;
                CompositionAreaHandler.compositionArea.setHandlerInfo(this, this.inputMethodContext);
                if (bl) {
                    CompositionAreaHandler.compositionArea.setText(this.composedText, this.caret);
                }
            }
        }
    }

    void releaseCompositionArea() {
        CompositionArea compositionArea = CompositionAreaHandler.compositionArea;
        synchronized (compositionArea) {
            if (compositionAreaOwner == this) {
                compositionAreaOwner = null;
                CompositionAreaHandler.compositionArea.setHandlerInfo(null, null);
                CompositionAreaHandler.compositionArea.setText(null, null);
            }
        }
    }

    static void closeCompositionArea() {
        if (compositionArea != null) {
            CompositionArea compositionArea = CompositionAreaHandler.compositionArea;
            synchronized (compositionArea) {
                compositionAreaOwner = null;
                CompositionAreaHandler.compositionArea.setHandlerInfo(null, null);
                CompositionAreaHandler.compositionArea.setText(null, null);
            }
        }
    }

    boolean isCompositionAreaVisible() {
        return compositionArea.getParent().isVisible();
    }

    void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (inputMethodEvent.getID() == 1100) {
            this.inputMethodTextChanged(inputMethodEvent);
        } else {
            this.caretPositionChanged(inputMethodEvent);
        }
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        int n = inputMethodEvent.getCommittedCharacterCount();
        this.composedText = null;
        this.caret = null;
        if (attributedCharacterIterator != null && n < attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex()) {
            AttributedString attributedString = new AttributedString(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex() + n, attributedCharacterIterator.getEndIndex(), IM_ATTRIBUTES);
            attributedString.addAttribute(TextAttribute.FONT, compositionArea.getFont());
            this.composedText = attributedString.getIterator();
            this.caret = inputMethodEvent.getCaret();
        }
        compositionArea.setText(this.composedText, this.caret);
        if (n > 0) {
            this.inputMethodContext.dispatchCommittedText((Component)inputMethodEvent.getSource(), attributedCharacterIterator, n);
            if (this.isCompositionAreaVisible()) {
                compositionArea.updateWindowLocation();
            }
        }
        inputMethodEvent.consume();
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        compositionArea.setCaret(inputMethodEvent.getCaret());
        inputMethodEvent.consume();
    }

    InputMethodRequests getClientInputMethodRequests() {
        return this.clientComponent.getInputMethodRequests();
    }

    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        CompositionArea compositionArea = CompositionAreaHandler.compositionArea;
        synchronized (compositionArea) {
            if (compositionAreaOwner == this && this.isCompositionAreaVisible()) {
                Rectangle rectangle = CompositionAreaHandler.compositionArea.getTextLocation(textHitInfo);
                return rectangle;
            }
            if (this.composedText != null) {
                Rectangle rectangle = new Rectangle(0, 0, 0, 10);
                return rectangle;
            }
            InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
            if (inputMethodRequests != null) {
                Rectangle rectangle = inputMethodRequests.getTextLocation(textHitInfo);
                return rectangle;
            }
            Rectangle rectangle = new Rectangle(0, 0, 0, 10);
            return rectangle;
        }
    }

    public TextHitInfo getLocationOffset(int n, int n2) {
        CompositionArea compositionArea = CompositionAreaHandler.compositionArea;
        synchronized (compositionArea) {
            if (compositionAreaOwner == this && this.isCompositionAreaVisible()) {
                TextHitInfo textHitInfo = CompositionAreaHandler.compositionArea.getLocationOffset(n, n2);
                return textHitInfo;
            }
            TextHitInfo textHitInfo = null;
            return textHitInfo;
        }
    }

    public int getInsertPositionOffset() {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getInsertPositionOffset();
        }
        return 0;
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getCommittedText(n, n2, attributeArray);
        }
        return EMPTY_TEXT;
    }

    public int getCommittedTextLength() {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getCommittedTextLength();
        }
        return 0;
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.cancelLatestCommittedText(attributeArray);
        }
        return null;
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        InputMethodRequests inputMethodRequests = this.getClientInputMethodRequests();
        if (inputMethodRequests != null) {
            return inputMethodRequests.getSelectedText(attributeArray);
        }
        return EMPTY_TEXT;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        IM_ATTRIBUTES = new AttributedCharacterIterator.Attribute[]{TextAttribute.INPUT_METHOD_HIGHLIGHT};
        EMPTY_TEXT = new AttributedString("").getIterator();
    }
}

